/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.digests;

import org.bouncycastle.crypto.Xof;
import org.bouncycastle.crypto.digests.AsconBaseDigest;
import org.bouncycastle.util.Pack;

public class AsconXof
extends AsconBaseDigest
implements Xof {
    AsconParameters asconParameters;
    private final String algorithmName;
    private boolean m_squeezing = false;

    public AsconXof(AsconParameters asconParameters) {
        this.asconParameters = asconParameters;
        switch (asconParameters) {
            case AsconXof: {
                this.ASCON_PB_ROUNDS = 12;
                this.algorithmName = "Ascon-Xof";
                break;
            }
            case AsconXofA: {
                this.ASCON_PB_ROUNDS = 8;
                this.algorithmName = "Ascon-XofA";
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid parameter settings for Ascon Hash");
            }
        }
        this.reset();
    }

    public void update(byte by) {
        if (this.m_squeezing) {
            throw new IllegalArgumentException("attempt to absorb while squeezing");
        }
        super.update(by);
    }

    public void update(byte[] byArray, int n, int n2) {
        if (this.m_squeezing) {
            throw new IllegalArgumentException("attempt to absorb while squeezing");
        }
        super.update(byArray, n, n2);
    }

    protected void padAndAbsorb() {
        this.m_squeezing = true;
        super.padAndAbsorb();
    }

    protected long pad(int n) {
        return 128L << 56 - (n << 3);
    }

    protected long loadBytes(byte[] byArray, int n) {
        return Pack.bigEndianToLong(byArray, n);
    }

    protected long loadBytes(byte[] byArray, int n, int n2) {
        return Pack.bigEndianToLong(byArray, n, n2);
    }

    protected void setBytes(long l, byte[] byArray, int n) {
        Pack.longToBigEndian(l, byArray, n);
    }

    protected void setBytes(long l, byte[] byArray, int n, int n2) {
        Pack.longToBigEndian(l, byArray, n, n2);
    }

    public String getAlgorithmName() {
        return this.algorithmName;
    }

    public int doOutput(byte[] byArray, int n, int n2) {
        return this.hash(byArray, n, n2);
    }

    public int doFinal(byte[] byArray, int n, int n2) {
        int n3 = this.doOutput(byArray, n, n2);
        this.reset();
        return n3;
    }

    public int getByteLength() {
        return 8;
    }

    public void reset() {
        super.reset();
        this.m_squeezing = false;
        switch (this.asconParameters) {
            case AsconXof: {
                this.x0 = -5368810569253202922L;
                this.x1 = 3121280575360345120L;
                this.x2 = 7395939140700676632L;
                this.x3 = 6533890155656471820L;
                this.x4 = 5710016986865767350L;
                break;
            }
            case AsconXofA: {
                this.x0 = 4940560291654768690L;
                this.x1 = -3635129828240960206L;
                this.x2 = -597534922722107095L;
                this.x3 = 2623493988082852443L;
                this.x4 = -6283826724160825537L;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum AsconParameters {
        AsconXof,
        AsconXofA;

    }
}

