/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.charts.fill;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.charts.JRTimePeriodDataset;
import net.sf.jasperreports.charts.JRTimePeriodSeries;
import net.sf.jasperreports.charts.fill.JRFillTimePeriodSeries;
import net.sf.jasperreports.charts.util.TimePeriodDatasetLabelGenerator;
import net.sf.jasperreports.engine.JRExpressionCollector;
import net.sf.jasperreports.engine.JRPrintHyperlink;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.design.JRVerifier;
import net.sf.jasperreports.engine.fill.JRCalculator;
import net.sf.jasperreports.engine.fill.JRExpressionEvalException;
import net.sf.jasperreports.engine.fill.JRFillChartDataset;
import net.sf.jasperreports.engine.fill.JRFillObjectFactory;
import org.jfree.data.general.Dataset;
import org.jfree.data.time.SimpleTimePeriod;
import org.jfree.data.time.TimePeriod;
import org.jfree.data.time.TimePeriodValues;
import org.jfree.data.time.TimePeriodValuesCollection;

public class JRFillTimePeriodDataset
extends JRFillChartDataset
implements JRTimePeriodDataset {
    protected JRFillTimePeriodSeries[] timePeriodSeries;
    private List<Comparable<?>> seriesNames;
    private Map<Comparable<?>, TimePeriodValues> seriesMap;
    private Map<Comparable<?>, Map<TimePeriod, String>> labelsMap;
    private Map<Comparable<?>, Map<TimePeriod, JRPrintHyperlink>> itemHyperlinks;

    public JRFillTimePeriodDataset(JRTimePeriodDataset timePeriodDataset, JRFillObjectFactory factory) {
        super(timePeriodDataset, factory);
        JRTimePeriodSeries[] srcTimePeriodSeries = timePeriodDataset.getSeries();
        if (srcTimePeriodSeries != null && srcTimePeriodSeries.length > 0) {
            this.timePeriodSeries = new JRFillTimePeriodSeries[srcTimePeriodSeries.length];
            int i = 0;
            while (i < this.timePeriodSeries.length) {
                this.timePeriodSeries[i] = (JRFillTimePeriodSeries)factory.getTimePeriodSeries(srcTimePeriodSeries[i]);
                ++i;
            }
        }
    }

    @Override
    public JRTimePeriodSeries[] getSeries() {
        return this.timePeriodSeries;
    }

    @Override
    protected void customInitialize() {
        this.seriesNames = null;
        this.seriesMap = null;
        this.labelsMap = null;
        this.itemHyperlinks = null;
    }

    @Override
    protected void customEvaluate(JRCalculator calculator) throws JRExpressionEvalException {
        if (this.timePeriodSeries != null && this.timePeriodSeries.length > 0) {
            int i = 0;
            while (i < this.timePeriodSeries.length) {
                this.timePeriodSeries[i].evaluate(calculator);
                ++i;
            }
        }
    }

    @Override
    protected void customIncrement() {
        if (this.timePeriodSeries != null && this.timePeriodSeries.length > 0) {
            if (this.seriesNames == null) {
                this.seriesNames = new ArrayList();
                this.seriesMap = new HashMap();
                this.labelsMap = new HashMap();
                this.itemHyperlinks = new HashMap();
            }
            int i = 0;
            while (i < this.timePeriodSeries.length) {
                JRFillTimePeriodSeries crtTimePeriodSeries = this.timePeriodSeries[i];
                Comparable<?> seriesName = crtTimePeriodSeries.getSeries();
                if (seriesName == null) {
                    throw new JRRuntimeException("Time period series name is null.");
                }
                TimePeriodValues timePeriodValues = this.seriesMap.get(seriesName);
                if (timePeriodValues == null) {
                    timePeriodValues = new TimePeriodValues(seriesName.toString());
                    this.seriesNames.add(seriesName);
                    this.seriesMap.put(seriesName, timePeriodValues);
                }
                SimpleTimePeriod stp = new SimpleTimePeriod(crtTimePeriodSeries.getStartDate(), crtTimePeriodSeries.getEndDate());
                timePeriodValues.add((TimePeriod)stp, crtTimePeriodSeries.getValue());
                if (crtTimePeriodSeries.getLabelExpression() != null) {
                    Map<TimePeriod, String> seriesLabels = this.labelsMap.get(seriesName);
                    if (seriesLabels == null) {
                        seriesLabels = new HashMap<TimePeriod, String>();
                        this.labelsMap.put(seriesName, seriesLabels);
                    }
                    seriesLabels.put((TimePeriod)stp, crtTimePeriodSeries.getLabel());
                }
                if (crtTimePeriodSeries.hasItemHyperlink()) {
                    Map<TimePeriod, JRPrintHyperlink> seriesLinks = this.itemHyperlinks.get(seriesName);
                    if (seriesLinks == null) {
                        seriesLinks = new HashMap<TimePeriod, JRPrintHyperlink>();
                        this.itemHyperlinks.put(seriesName, seriesLinks);
                    }
                    seriesLinks.put((TimePeriod)stp, crtTimePeriodSeries.getPrintItemHyperlink());
                }
                ++i;
            }
        }
    }

    @Override
    public Dataset getCustomDataset() {
        TimePeriodValuesCollection dataset = new TimePeriodValuesCollection();
        if (this.seriesNames != null) {
            int i = 0;
            while (i < this.seriesNames.size()) {
                Comparable<?> seriesName = this.seriesNames.get(i);
                dataset.addSeries(this.seriesMap.get(seriesName));
                ++i;
            }
        }
        return dataset;
    }

    @Override
    public byte getDatasetType() {
        return 5;
    }

    @Override
    public Object getLabelGenerator() {
        return new TimePeriodDatasetLabelGenerator(this.labelsMap);
    }

    @Override
    public void collectExpressions(JRExpressionCollector collector) {
        collector.collect(this);
    }

    public boolean hasItemHyperlinks() {
        boolean foundLinks = false;
        if (this.timePeriodSeries != null && this.timePeriodSeries.length > 0) {
            int i = 0;
            while (i < this.timePeriodSeries.length && !foundLinks) {
                foundLinks = this.timePeriodSeries[i].hasItemHyperlink();
                ++i;
            }
        }
        return foundLinks;
    }

    public Map<Comparable<?>, Map<TimePeriod, JRPrintHyperlink>> getItemHyperlinks() {
        return this.itemHyperlinks;
    }

    @Override
    public void validate(JRVerifier verifier) {
        verifier.verify(this);
    }
}

