/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.data.cache;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import net.sf.jasperreports.data.cache.ColumnValues;
import net.sf.jasperreports.data.cache.ColumnValuesIterator;
import net.sf.jasperreports.data.cache.IndexColumnValueIterator;

public class ByteArrayValues
implements ColumnValues,
Serializable {
    private static final long serialVersionUID = 10200L;
    private byte[] values;
    private long linearFactor;
    private long linearOffset;

    public ByteArrayValues(byte[] values, long linearFactor, long linearOffset) {
        this.values = values;
        this.linearFactor = linearFactor;
        this.linearOffset = linearOffset;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeLong(this.linearFactor);
        out.writeLong(this.linearOffset);
        out.writeInt(this.values.length);
        int i = 0;
        while (i < this.values.length) {
            out.writeByte(this.values[i]);
            ++i;
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.linearFactor = in.readLong();
        this.linearOffset = in.readLong();
        int size = in.readInt();
        this.values = new byte[size];
        int i = 0;
        while (i < size) {
            this.values[i] = in.readByte();
            ++i;
        }
    }

    @Override
    public int size() {
        return this.values.length;
    }

    @Override
    public ColumnValuesIterator iterator() {
        return new ValuesIterator();
    }

    protected class ValuesIterator
    extends IndexColumnValueIterator {
        public ValuesIterator() {
            super(ByteArrayValues.this.values.length);
        }

        @Override
        public Object get() {
            return (long)(ByteArrayValues.this.values[this.currentIndex] & 0xFF) * ByteArrayValues.this.linearFactor + ByteArrayValues.this.linearOffset;
        }
    }
}

