/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.data.cache;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.Map;
import net.sf.jasperreports.data.cache.ColumnCacheData;
import net.sf.jasperreports.data.cache.ColumnValues;
import net.sf.jasperreports.data.cache.ColumnValuesDataSource;
import net.sf.jasperreports.engine.data.IndexedDataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class StandardColumnCacheData
implements Serializable,
ColumnCacheData {
    private static final long serialVersionUID = 10200L;
    private static final Log log = LogFactory.getLog(StandardColumnCacheData.class);
    private String[] fieldNames;
    private int size;
    private ColumnValues[] values;
    private LinkedHashMap<String, Object> parameters;

    public StandardColumnCacheData(String[] fieldNames, int size, ColumnValues[] values, LinkedHashMap<String, Object> parameters) {
        if (fieldNames == null || values == null || fieldNames.length != values.length) {
            throw new IllegalArgumentException();
        }
        this.fieldNames = fieldNames;
        this.size = size;
        this.values = values;
        this.parameters = parameters;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        int paramsCount = this.parameters == null ? 0 : this.parameters.size();
        out.writeInt(paramsCount);
        if (this.parameters != null) {
            for (Map.Entry<String, Object> entry : this.parameters.entrySet()) {
                out.writeObject(entry.getKey());
                out.writeObject(entry.getValue());
            }
        }
        out.writeInt(this.size);
        out.writeInt(this.fieldNames.length);
        int i = 0;
        while (i < this.fieldNames.length) {
            out.writeObject(this.fieldNames[i]);
            out.writeObject(this.values[i]);
            ++i;
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        int paramsCount = in.readInt();
        if (paramsCount > 0) {
            this.parameters = new LinkedHashMap(paramsCount * 4 / 3);
            int i = 0;
            while (i < paramsCount) {
                String key = (String)in.readObject();
                Object value = in.readObject();
                this.parameters.put(key, value);
                ++i;
            }
        }
        this.size = in.readInt();
        int fieldCount = in.readInt();
        this.fieldNames = new String[fieldCount];
        this.values = new ColumnValues[fieldCount];
        int i = 0;
        while (i < fieldCount) {
            this.fieldNames[i] = (String)in.readObject();
            this.values[i] = (ColumnValues)in.readObject();
            ++i;
        }
    }

    @Override
    public boolean isSerializable() {
        boolean serializable = true;
        if (this.parameters != null) {
            for (Map.Entry<String, Object> parameter : this.parameters.entrySet()) {
                Object value = parameter.getValue();
                if (value == null || value instanceof Serializable) continue;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("parameter " + parameter.getKey() + " has unserializable value of type " + value.getClass().getName()));
                }
                serializable = false;
                break;
            }
        }
        return serializable;
    }

    @Override
    public IndexedDataSource createDataSource() {
        return new ColumnValuesDataSource(this.fieldNames, this.size, this.values);
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public Map<String, Object> getParameters() {
        return this.parameters;
    }
}

