/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.export;

import java.util.List;
import net.sf.jasperreports.engine.JRAbstractExporter;
import net.sf.jasperreports.engine.JRPrintElement;
import net.sf.jasperreports.engine.JRPrintElementIndex;
import net.sf.jasperreports.engine.JRPrintFrame;
import net.sf.jasperreports.engine.JRPrintImage;
import net.sf.jasperreports.engine.JRPrintPage;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.export.HtmlResourceHandler;
import net.sf.jasperreports.engine.export.JRHtmlExporterContext;
import net.sf.jasperreports.export.HtmlExporterConfiguration;
import net.sf.jasperreports.export.HtmlExporterOutput;
import net.sf.jasperreports.export.HtmlReportConfiguration;

public abstract class AbstractHtmlExporter<RC extends HtmlReportConfiguration, C extends HtmlExporterConfiguration>
extends JRAbstractExporter<RC, C, HtmlExporterOutput, JRHtmlExporterContext> {
    protected static final String CSS_TEXT_ALIGN_LEFT = "left";
    protected static final String CSS_TEXT_ALIGN_RIGHT = "right";
    protected static final String CSS_TEXT_ALIGN_CENTER = "center";
    protected static final String CSS_TEXT_ALIGN_JUSTIFY = "justify";
    protected static final String HTML_VERTICAL_ALIGN_TOP = "top";
    protected static final String HTML_VERTICAL_ALIGN_MIDDLE = "middle";
    protected static final String HTML_VERTICAL_ALIGN_BOTTOM = "bottom";
    protected static final String JR_PAGE_ANCHOR_PREFIX = "JR_PAGE_ANCHOR_";
    protected static final String JR_BOOKMARK_ANCHOR_PREFIX = "JR_BKMRK_";
    protected static final float DEFAULT_ZOOM = 1.0f;
    public static final String IMAGE_NAME_PREFIX = "img_";
    protected static final int IMAGE_NAME_PREFIX_LEGTH = "img_".length();
    protected HtmlResourceHandler imageHandler;
    protected HtmlResourceHandler fontHandler;
    protected HtmlResourceHandler resourceHandler;

    public AbstractHtmlExporter(JasperReportsContext jasperReportsContext) {
        super(jasperReportsContext);
    }

    public HtmlResourceHandler getImageHandler() {
        return this.imageHandler;
    }

    public void setImageHandler(HtmlResourceHandler imageHandler) {
        this.imageHandler = imageHandler;
    }

    public HtmlResourceHandler getFontHandler() {
        return this.fontHandler;
    }

    public void setFontHandler(HtmlResourceHandler fontHandler) {
        this.fontHandler = fontHandler;
    }

    public HtmlResourceHandler getResourceHandler() {
        return this.resourceHandler;
    }

    public void setResourceHandler(HtmlResourceHandler resourceHandler) {
        this.resourceHandler = resourceHandler;
    }

    public static JRPrintImage getImage(List<JasperPrint> jasperPrintList, String imageName) {
        return AbstractHtmlExporter.getImage(jasperPrintList, AbstractHtmlExporter.getPrintElementIndex(imageName));
    }

    public static String getImageName(JRPrintElementIndex printElementIndex) {
        return IMAGE_NAME_PREFIX + printElementIndex.toString();
    }

    public static JRPrintImage getImage(List<JasperPrint> jasperPrintList, JRPrintElementIndex imageIndex) {
        JasperPrint report = jasperPrintList.get(imageIndex.getReportIndex());
        JRPrintPage page = report.getPages().get(imageIndex.getPageIndex());
        Integer[] elementIndexes = imageIndex.getAddressArray();
        JRPrintElement element = page.getElements().get(elementIndexes[0]);
        int i = 1;
        while (i < elementIndexes.length) {
            JRPrintFrame frame = (JRPrintFrame)element;
            element = frame.getElements().get(elementIndexes[i]);
            ++i;
        }
        return (JRPrintImage)element;
    }

    public static JRPrintElementIndex getPrintElementIndex(String imageName) {
        if (!imageName.startsWith(IMAGE_NAME_PREFIX)) {
            throw new JRRuntimeException("Invalid image name: " + imageName);
        }
        return JRPrintElementIndex.parsePrintElementIndex(imageName.substring(IMAGE_NAME_PREFIX_LEGTH));
    }
}

