/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.fill;

import net.sf.jasperreports.engine.fill.JRAbstractExtendedIncrementerFactory;
import net.sf.jasperreports.engine.fill.JRByteAverageIncrementer;
import net.sf.jasperreports.engine.fill.JRByteCountIncrementer;
import net.sf.jasperreports.engine.fill.JRByteDistinctCountIncrementer;
import net.sf.jasperreports.engine.fill.JRByteStandardDeviationIncrementer;
import net.sf.jasperreports.engine.fill.JRByteSumIncrementer;
import net.sf.jasperreports.engine.fill.JRByteVarianceIncrementer;
import net.sf.jasperreports.engine.fill.JRComparableIncrementerFactory;
import net.sf.jasperreports.engine.fill.JRDefaultIncrementerFactory;
import net.sf.jasperreports.engine.fill.JRExtendedIncrementer;
import net.sf.jasperreports.engine.type.CalculationEnum;

public final class JRByteIncrementerFactory
extends JRAbstractExtendedIncrementerFactory {
    protected static final Byte ZERO = new Byte(0);
    private static JRByteIncrementerFactory mainInstance = new JRByteIncrementerFactory();

    private JRByteIncrementerFactory() {
    }

    public static JRByteIncrementerFactory getInstance() {
        return mainInstance;
    }

    @Override
    public JRExtendedIncrementer getExtendedIncrementer(CalculationEnum calculation) {
        JRExtendedIncrementer incrementer = null;
        switch (calculation) {
            case COUNT: {
                incrementer = JRByteCountIncrementer.getInstance();
                break;
            }
            case SUM: {
                incrementer = JRByteSumIncrementer.getInstance();
                break;
            }
            case AVERAGE: {
                incrementer = JRByteAverageIncrementer.getInstance();
                break;
            }
            case LOWEST: 
            case HIGHEST: {
                incrementer = JRComparableIncrementerFactory.getInstance().getExtendedIncrementer(calculation);
                break;
            }
            case STANDARD_DEVIATION: {
                incrementer = JRByteStandardDeviationIncrementer.getInstance();
                break;
            }
            case VARIANCE: {
                incrementer = JRByteVarianceIncrementer.getInstance();
                break;
            }
            case DISTINCT_COUNT: {
                incrementer = JRByteDistinctCountIncrementer.getInstance();
                break;
            }
            default: {
                incrementer = JRDefaultIncrementerFactory.getInstance().getExtendedIncrementer(calculation);
            }
        }
        return incrementer;
    }
}

