/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.fill;

import java.util.HashMap;
import java.util.Map;
import net.sf.jasperreports.engine.DefaultJasperReportsContext;
import net.sf.jasperreports.engine.JRDataset;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRGroup;
import net.sf.jasperreports.engine.JRParameter;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.fill.JRBaseFiller;
import net.sf.jasperreports.engine.fill.JRFillDataset;
import net.sf.jasperreports.engine.fill.JRFillExpressionEvaluator;
import net.sf.jasperreports.engine.fill.JRFillGroup;
import net.sf.jasperreports.engine.fill.JRFillObjectFactory;
import net.sf.jasperreports.engine.fill.JRResourcesFillUtil;
import net.sf.jasperreports.engine.util.LocalJasperReportsContext;

public final class JRParameterDefaultValuesEvaluator {
    public static Map<String, Object> evaluateParameterDefaultValues(JasperReport report, Map<String, Object> initialParameters) throws JRException {
        return JRParameterDefaultValuesEvaluator.evaluateParameterDefaultValues(DefaultJasperReportsContext.getInstance(), report, initialParameters);
    }

    public static Map<String, Object> evaluateParameterDefaultValues(JasperReportsContext jasperReportsContext, JasperReport report, Map<String, Object> initialParameters) throws JRException {
        HashMap<String, Object> valuesMap = initialParameters == null ? new HashMap<String, Object>() : new HashMap<String, Object>(initialParameters);
        valuesMap.put("JASPER_REPORT", report);
        ObjectFactory factory = new ObjectFactory();
        JRDataset reportDataset = report.getMainDataset();
        JRFillDataset fillDataset = factory.getDataset(reportDataset);
        fillDataset.setJasperReportsContext(LocalJasperReportsContext.getLocalContext(jasperReportsContext, initialParameters));
        fillDataset.createCalculator(report);
        fillDataset.initCalculator();
        JRResourcesFillUtil.ResourcesFillContext resourcesContext = JRResourcesFillUtil.setResourcesFillContext(valuesMap);
        try {
            fillDataset.setParameterValues(valuesMap);
            HashMap<String, Object> parameterValues = new HashMap<String, Object>();
            JRParameter[] parameters = reportDataset.getParameters();
            int i = 0;
            while (i < parameters.length) {
                JRParameter param = parameters[i];
                if (!param.isSystemDefined()) {
                    String name = param.getName();
                    Object value = fillDataset.getParameterValue(name);
                    parameterValues.put(name, value);
                }
                ++i;
            }
            HashMap<String, Object> hashMap = parameterValues;
            return hashMap;
        }
        finally {
            fillDataset.disposeParameterContributors();
            JRResourcesFillUtil.revertResourcesFillContext(resourcesContext);
        }
    }

    private JRParameterDefaultValuesEvaluator() {
    }

    protected static class ObjectFactory
    extends JRFillObjectFactory {
        protected ObjectFactory() {
            super((JRBaseFiller)null, (JRFillExpressionEvaluator)null);
        }

        @Override
        protected JRFillGroup getGroup(JRGroup group) {
            return super.getGroup(null);
        }
    }
}

