/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.olap;

import antlr.ANTLRException;
import java.io.StringReader;
import java.math.BigDecimal;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRDataset;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRField;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.olap.mapping.Axis;
import net.sf.jasperreports.olap.mapping.AxisPosition;
import net.sf.jasperreports.olap.mapping.DataMapping;
import net.sf.jasperreports.olap.mapping.Mapping;
import net.sf.jasperreports.olap.mapping.MappingLexer;
import net.sf.jasperreports.olap.mapping.MappingMetadata;
import net.sf.jasperreports.olap.mapping.MappingParser;
import net.sf.jasperreports.olap.mapping.Member;
import net.sf.jasperreports.olap.mapping.MemberDepth;
import net.sf.jasperreports.olap.mapping.MemberMapping;
import net.sf.jasperreports.olap.mapping.MemberProperty;
import net.sf.jasperreports.olap.mapping.Tuple;
import net.sf.jasperreports.olap.mapping.TuplePosition;
import net.sf.jasperreports.olap.result.JROlapCell;
import net.sf.jasperreports.olap.result.JROlapHierarchy;
import net.sf.jasperreports.olap.result.JROlapHierarchyLevel;
import net.sf.jasperreports.olap.result.JROlapMember;
import net.sf.jasperreports.olap.result.JROlapMemberTuple;
import net.sf.jasperreports.olap.result.JROlapResult;
import net.sf.jasperreports.olap.result.JROlapResultAxis;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JROlapDataSource
implements JRDataSource,
MappingMetadata {
    private static final Log log = LogFactory.getLog(JROlapDataSource.class);
    protected final JROlapResult olapResult;
    protected JROlapResultAxis[] axes;
    protected final JROlapHierarchy[][] queryHierarchies;
    protected final int hierarchiesCount;
    protected Map<Object, FieldMatcher> fieldMatchers;
    protected int[][] fieldsMaxDepths;
    protected boolean[] iteratePositions;
    protected boolean iterate;
    protected boolean dataField;
    protected Map<Object, Object> fieldValues;
    protected int[] axisPositions;
    protected boolean first;
    protected int[][] maxDepths;
    private DateFormat dateFormat = new SimpleDateFormat();
    private boolean noTuples;

    public JROlapDataSource(JRDataset dataset, JROlapResult result) {
        this.olapResult = result;
        this.axes = result.getAxes();
        this.queryHierarchies = new JROlapHierarchy[this.axes.length][];
        this.fieldsMaxDepths = new int[this.axes.length][];
        this.maxDepths = new int[this.axes.length][];
        int hCount = 0;
        this.noTuples = false;
        int i = 0;
        while (i < this.axes.length) {
            this.noTuples = this.noTuples || this.axes[i].getTupleCount() == 0;
            this.queryHierarchies[i] = this.axes[i].getHierarchiesOnAxis();
            hCount += this.queryHierarchies[i].length;
            this.fieldsMaxDepths[i] = new int[this.queryHierarchies[i].length];
            this.maxDepths[i] = new int[this.queryHierarchies[i].length];
            ++i;
        }
        this.hierarchiesCount = hCount;
        this.axisPositions = new int[this.axes.length];
        if (!this.noTuples) {
            this.init(dataset);
        }
    }

    @Override
    public boolean next() throws JRException {
        boolean next;
        boolean matchMaxLevel;
        if (this.noTuples) {
            return false;
        }
        block0: do {
            if (this.iterate) {
                next = this.nextPositions();
            } else {
                next = this.first;
                this.first = false;
            }
            if (!next) break;
            this.resetMaxDepths();
            for (Map.Entry<Object, FieldMatcher> entry : this.fieldMatchers.entrySet()) {
                Object fieldName = entry.getKey();
                FieldMatcher matcher = entry.getValue();
                if (!matcher.matches()) continue;
                Object value = matcher.value();
                this.fieldValues.put(fieldName, value);
            }
            matchMaxLevel = true;
            int i = 0;
            while (i < this.axes.length) {
                if (this.iteratePositions[i]) {
                    int j = 0;
                    while (j < this.fieldsMaxDepths[i].length) {
                        if (this.maxDepths[i][j] < this.fieldsMaxDepths[i][j]) {
                            matchMaxLevel = false;
                            continue block0;
                        }
                        ++j;
                    }
                }
                ++i;
            }
        } while (!matchMaxLevel);
        return next;
    }

    private void resetMaxDepths() {
        int i = 0;
        while (i < this.axes.length) {
            if (this.iteratePositions[i]) {
                int j = 0;
                while (j < this.maxDepths[i].length) {
                    this.maxDepths[i][j] = 0;
                    ++j;
                }
            }
            ++i;
        }
    }

    protected boolean nextPositions() {
        int i = 0;
        while (i < this.axes.length) {
            if (this.iteratePositions[i]) {
                int n = i;
                this.axisPositions[n] = this.axisPositions[n] + 1;
                if (this.axisPositions[i] < this.axes[i].getTupleCount()) break;
                this.axisPositions[i] = 0;
            }
            ++i;
        }
        boolean next = i < this.axes.length;
        return next;
    }

    @Override
    public Object getFieldValue(JRField jrField) throws JRException {
        String fieldValue;
        Class<?> valueClass;
        block20: {
            valueClass = jrField.getValueClass();
            Object value = this.fieldValues.get(jrField.getName());
            try {
                if (valueClass.equals(mondrian.olap.Member.class)) {
                    if (!(value instanceof mondrian.olap.Member)) {
                        throw new JRException("Field '" + jrField.getName() + "' is of class '" + value.getClass() + "' and can not be converted to class " + valueClass.getName());
                    }
                    return value;
                }
                fieldValue = (String)value;
                if (fieldValue != null) break block20;
                return null;
            }
            catch (Exception e) {
                throw new JRException("Unable to get value for field '" + jrField.getName() + "' of class '" + valueClass.getName() + "'", e);
            }
        }
        if (Number.class.isAssignableFrom(valueClass)) {
            fieldValue = fieldValue.trim();
        }
        if (fieldValue.length() == 0) {
            fieldValue = "0";
        }
        if (valueClass.equals(String.class)) {
            return fieldValue;
        }
        if (valueClass.equals(Boolean.class)) {
            return fieldValue.equalsIgnoreCase("true") ? Boolean.TRUE : Boolean.FALSE;
        }
        if (valueClass.equals(Byte.class)) {
            return new Byte(fieldValue);
        }
        if (valueClass.equals(Integer.class)) {
            return Integer.valueOf(fieldValue);
        }
        if (valueClass.equals(Long.class)) {
            return new Long(fieldValue);
        }
        if (valueClass.equals(Short.class)) {
            return new Short(fieldValue);
        }
        if (valueClass.equals(Double.class)) {
            return new Double(fieldValue);
        }
        if (valueClass.equals(Float.class)) {
            return new Float(fieldValue);
        }
        if (valueClass.equals(BigDecimal.class)) {
            return new BigDecimal(fieldValue);
        }
        if (valueClass.equals(Date.class)) {
            return this.dateFormat.parse(fieldValue);
        }
        if (valueClass.equals(Timestamp.class)) {
            return new Timestamp(this.dateFormat.parse(fieldValue).getTime());
        }
        if (valueClass.equals(Time.class)) {
            return new Time(this.dateFormat.parse(fieldValue).getTime());
        }
        if (valueClass.equals(Number.class)) {
            return new Double(fieldValue);
        }
        throw new JRException("Field '" + jrField.getName() + "', string value '" + fieldValue + "' is of class '" + this.fieldValues.get(jrField.getName()).getClass() + "' and can not be converted to class " + valueClass.getName());
    }

    private void init(JRDataset dataset) {
        this.iteratePositions = new boolean[this.axes.length];
        this.fieldMatchers = new HashMap<Object, FieldMatcher>();
        this.dataField = false;
        JRField[] fields = dataset.getFields();
        if (fields != null) {
            int i = 0;
            while (i < fields.length) {
                Mapping mapping;
                JRField field = fields[i];
                String fieldMapping = this.getFieldMapping(field);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Mapping field: " + field.getName() + " - description: " + fieldMapping));
                }
                MappingLexer lexer = new MappingLexer(new StringReader(fieldMapping));
                MappingParser parser = new MappingParser(lexer);
                parser.setMappingMetadata(this);
                try {
                    mapping = parser.mapping();
                }
                catch (ANTLRException e) {
                    log.error((Object)"Error parsing field mapping", (Throwable)e);
                    throw new JRRuntimeException(e);
                }
                if (mapping == null) {
                    throw new JRRuntimeException("Invalid field mapping \"" + fieldMapping + "\".");
                }
                this.processMappingMembers(mapping);
                FieldMatcher fieldMatcher = this.createFieldMatcher(field, mapping);
                this.fieldMatchers.put(field.getName(), fieldMatcher);
                ++i;
            }
        }
        if (!this.dataField) {
            Arrays.fill(this.iteratePositions, true);
        }
        this.initIterate();
    }

    private void processMappingMembers(Mapping mapping) {
        Iterator it = mapping.memberMappings();
        while (it.hasNext()) {
            Member member = (Member)it.next();
            this.processMemberInfo(member);
        }
    }

    private FieldMatcher createFieldMatcher(JRField field, Mapping mapping) {
        FieldMatcher fieldMatcher;
        if (mapping instanceof MemberMapping) {
            fieldMatcher = new MemberFieldMatcher((MemberMapping)mapping);
        } else if (mapping instanceof DataMapping) {
            this.dataField = true;
            fieldMatcher = new DataFieldMatcher(field, (DataMapping)mapping);
        } else {
            throw new JRRuntimeException("internal error");
        }
        return fieldMatcher;
    }

    protected String getFieldMapping(JRField field) {
        return field.getDescription();
    }

    private void initIterate() {
        int firstPos = 0;
        while (firstPos < this.axes.length && !this.iteratePositions[firstPos]) {
            ++firstPos;
        }
        if (firstPos < this.axes.length) {
            this.iterate = true;
            this.axisPositions[firstPos] = -1;
        } else {
            this.iterate = false;
            this.first = true;
        }
        this.fieldValues = new HashMap<Object, Object>();
    }

    protected void processMemberInfo(Member member) {
        int idx;
        int axis;
        int depth;
        MemberDepth memberDepth = member.getDepth();
        if (memberDepth != null && (depth = memberDepth.getDepth()) > this.fieldsMaxDepths[axis = member.getAxis().getIdx()][idx = member.getPosition().getIdx()]) {
            this.fieldsMaxDepths[axis][idx] = depth;
        }
    }

    @Override
    public int getDimensionIndex(Axis axis, String dimension) {
        JROlapHierarchy[] hierarchies = this.axes[axis.getIdx()].getHierarchiesOnAxis();
        int dimensionIndex = -1;
        int i = 0;
        while (dimensionIndex == -1 && i < hierarchies.length) {
            JROlapHierarchy hierarchy = hierarchies[i];
            if (this.matchesDimensionName(hierarchy, dimension)) {
                dimensionIndex = i;
            }
            ++i;
        }
        if (dimensionIndex == -1) {
            throw new JRRuntimeException("Could not find dimension \"" + dimension + "\" on axis " + axis.getIdx() + ".");
        }
        return dimensionIndex;
    }

    protected boolean matchesDimensionName(JROlapHierarchy hierarchy, String dimensionName) {
        if (dimensionName.equals(hierarchy.getDimensionName()) || dimensionName.equals(hierarchy.getHierarchyUniqueName())) {
            return true;
        }
        String hierName = "[" + dimensionName + "]";
        return hierName.equals(hierarchy.getHierarchyUniqueName());
    }

    @Override
    public int getLevelDepth(TuplePosition pos, String levelName) {
        JROlapHierarchy hierarchy = this.axes[pos.getAxis().getIdx()].getHierarchiesOnAxis()[pos.getIdx()];
        JROlapHierarchyLevel[] levels = hierarchy.getLevels();
        int levelIndex = -1;
        int i = 0;
        while (i < levels.length) {
            JROlapHierarchyLevel level = levels[i];
            if (level != null && level.getName().equals(levelName)) {
                levelIndex = level.getDepth();
                break;
            }
            ++i;
        }
        if (levelIndex == -1) {
            throw new JRRuntimeException("Could not find level \"" + levelName + "\" on hierarchy #" + pos.getIdx() + " (dimension " + hierarchy.getDimensionName() + ") on axis #" + pos.getAxis().getIdx());
        }
        return levelIndex;
    }

    protected void setMatchMemberDepth(Member memberInfo, JROlapMember member) {
        int pos;
        int memberDepth = member.getDepth();
        int axis = memberInfo.getAxis().getIdx();
        if (this.maxDepths[axis][pos = memberInfo.getPosition().getIdx()] < memberDepth) {
            this.maxDepths[axis][pos] = memberDepth;
        }
    }

    @Override
    public int getTuplePosition(int axisIndex, Tuple tuple) {
        if (axisIndex > this.axes.length) {
            throw new JRRuntimeException("OLAP result doesn't contain Axis(" + axisIndex + ").");
        }
        String[] memberUniqueNames = tuple.getMemberUniqueNames();
        JROlapResultAxis axis = this.axes[axisIndex];
        int tupleCount = axis.getTupleCount();
        int pos = -1;
        int i = 0;
        while (i < tupleCount) {
            JROlapMemberTuple memberTuple = axis.getTuple(i);
            JROlapMember[] resMembers = memberTuple.getMembers();
            if (resMembers.length == memberUniqueNames.length) {
                boolean eq = true;
                int j = 0;
                while (eq && j < resMembers.length) {
                    if (!memberUniqueNames[j].equals(resMembers[j].getUniqueName())) {
                        eq = false;
                    }
                    ++j;
                }
                if (eq) {
                    pos = i;
                    break;
                }
            }
            ++i;
        }
        if (pos == -1) {
            StringBuffer sb = new StringBuffer();
            sb.append('(');
            int i2 = 0;
            while (i2 < memberUniqueNames.length) {
                if (i2 > 0) {
                    sb.append(',');
                }
                sb.append(memberUniqueNames[i2]);
                ++i2;
            }
            throw new JRRuntimeException("No such tuple " + sb + " on axis " + axisIndex + ".");
        }
        return pos;
    }

    protected class DataFieldMatcher
    extends FieldMatcher {
        private final boolean formatted;
        private final int[] dataPositions;
        private final Member[] members;
        private int[] positions;

        public DataFieldMatcher(JRField field, DataMapping mapping) {
            this.formatted = mapping.isFormatted() && String.class.equals(field.getValueClass());
            List mappingPositions = mapping.getPositions();
            if (mappingPositions == null) {
                this.dataPositions = null;
                this.positions = JROlapDataSource.this.axisPositions;
            } else {
                if (mappingPositions.size() != JROlapDataSource.this.axes.length) {
                    throw new JRRuntimeException("Incorrect data mapping: the number of positions doesn't match the number of axes.");
                }
                this.dataPositions = new int[JROlapDataSource.this.axes.length];
                int c = 0;
                for (AxisPosition position : mappingPositions) {
                    int pos;
                    if (position.isSpecified()) {
                        pos = position.getPosition();
                    } else {
                        pos = -1;
                        JROlapDataSource.this.iteratePositions[c] = true;
                    }
                    this.dataPositions[c] = pos;
                    ++c;
                }
            }
            List filter = mapping.getFilter();
            if (filter == null || filter.isEmpty()) {
                this.members = null;
            } else {
                this.members = new Member[filter.size()];
                filter.toArray(this.members);
            }
        }

        @Override
        public boolean matches() {
            if (this.dataPositions != null) {
                this.setPositions();
            }
            boolean matches = true;
            if (this.members != null) {
                int i = 0;
                while (i < this.members.length) {
                    Member memberInfo = this.members[i];
                    JROlapMember member = this.member(memberInfo, this.positions);
                    JROlapDataSource.this.setMatchMemberDepth(memberInfo, member);
                    if (!memberInfo.matches(member)) {
                        matches = false;
                        break;
                    }
                    ++i;
                }
            }
            return matches;
        }

        @Override
        public Object value() {
            JROlapCell cell = JROlapDataSource.this.olapResult.getCell(this.positions);
            if (cell != null && cell.isError()) {
                throw new JRRuntimeException("OLAP cell calculation returned error.");
            }
            String value = cell == null || cell.isNull() ? null : (this.formatted ? cell.getFormattedValue() : cell.getValue().toString());
            return value;
        }

        void setPositions() {
            this.positions = new int[JROlapDataSource.this.axes.length];
            int i = 0;
            while (i < JROlapDataSource.this.axes.length) {
                int dataPosition = this.dataPositions[i];
                this.positions[i] = dataPosition == -1 ? JROlapDataSource.this.axisPositions[i] : dataPosition;
                ++i;
            }
        }
    }

    protected abstract class FieldMatcher {
        protected FieldMatcher() {
        }

        public abstract boolean matches();

        public abstract Object value();

        public final JROlapMember member(Member memberInfo, int[] positions) {
            int axisIdx = memberInfo.getAxis().getIdx();
            JROlapResultAxis axis = JROlapDataSource.this.axes[axisIdx];
            JROlapMemberTuple tuple = axis.getTuple(positions[axisIdx]);
            JROlapMember[] members = tuple.getMembers();
            int pos = memberInfo.getPosition().getIdx();
            return members[pos];
        }
    }

    protected class MemberFieldMatcher
    extends FieldMatcher {
        final Member memberInfo;
        final MemberProperty property;
        JROlapMember member;

        MemberFieldMatcher(MemberMapping mapping) {
            this.memberInfo = mapping.getMember();
            this.property = mapping.getProperty();
        }

        @Override
        public boolean matches() {
            this.member = this.member(this.memberInfo, JROlapDataSource.this.axisPositions);
            JROlapDataSource.this.setMatchMemberDepth(this.memberInfo, this.member);
            this.member = this.memberInfo.ancestorMatch(this.member);
            return this.member != null;
        }

        @Override
        public Object value() {
            if (this.memberInfo.getDepth() == null) {
                return this.member.getMember();
            }
            Object value = this.property != null ? this.member.getPropertyValue(this.property.getName()) : this.member.getName();
            return value.toString();
        }
    }
}

