/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.data.cache;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import net.sf.jasperreports.data.cache.ColumnValues;
import net.sf.jasperreports.data.cache.ColumnValuesIterator;
import net.sf.jasperreports.data.cache.IndexColumnValueIterator;

public class DoubleArrayValues
implements ColumnValues,
Serializable {
    private static final long serialVersionUID = 10200L;
    private double[] values;

    public DoubleArrayValues(double[] values) {
        this.values = values;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeInt(this.values.length);
        int i = 0;
        while (i < this.values.length) {
            out.writeDouble(this.values[i]);
            ++i;
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        int size = in.readInt();
        this.values = new double[size];
        int i = 0;
        while (i < size) {
            this.values[i] = in.readDouble();
            ++i;
        }
    }

    @Override
    public int size() {
        return this.values.length;
    }

    @Override
    public ColumnValuesIterator iterator() {
        return new ValuesIterator();
    }

    protected class ValuesIterator
    extends IndexColumnValueIterator {
        public ValuesIterator() {
            super(DoubleArrayValues.this.values.length);
        }

        @Override
        public Object get() {
            return DoubleArrayValues.this.values[this.currentIndex];
        }
    }
}

