/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.data.cache;

import net.sf.jasperreports.data.cache.ArrayStore;
import net.sf.jasperreports.data.cache.ColumnValues;
import net.sf.jasperreports.data.cache.NumberValuesUtils;
import net.sf.jasperreports.data.cache.ValueLength;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RunLengthStore {
    private static final Log log = LogFactory.getLog(RunLengthStore.class);
    protected static final int MAX_RUN_LENGTH = 65535;
    private static final int RUN_LENGTH_PENALTY = 32;
    private final ArrayStore store;
    private int runStart;
    private int runCount;
    private int maxRunLength;

    public RunLengthStore(ArrayStore store) {
        this.store = store;
        if (log.isDebugEnabled()) {
            log.debug((Object)("created " + this + " for " + store));
        }
    }

    public void reset() {
        this.runStart = -1;
        this.runCount = 0;
        this.maxRunLength = 1;
    }

    public void valueAdded() {
        int count = this.store.count();
        if (this.runStart >= 0 && this.store.valuesEqual(this.runStart, count - 1) && count - this.runStart < 65535) {
            if (count - this.runStart > this.maxRunLength) {
                this.maxRunLength = count - this.runStart;
            }
        } else {
            this.runStart = count - 1;
            ++this.runCount;
        }
    }

    public ColumnValues applyRunLengths(ValueLength valueLength) {
        ValueLength runLength = ValueLength.getNumberLength(this.maxRunLength - 1);
        ColumnValues runLengthValues = null;
        int originalCount = this.store.count();
        if (this.useRunLength(originalCount, valueLength, runLength)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)(this + ": using run lengths count " + this.runCount + ", original count " + originalCount));
            }
            long[] runLengths = new long[this.runCount];
            int runIdx = 0;
            runLengths[runIdx] = 0L;
            int i = 1;
            while (i < originalCount) {
                if (this.store.valuesEqual(i, runIdx) && runLengths[runIdx] < 65535L) {
                    int n = runIdx;
                    runLengths[n] = runLengths[n] + 1L;
                } else {
                    runLengths[++runIdx] = 0L;
                    this.store.copyValue(runIdx, i);
                }
                ++i;
            }
            this.store.updateCount(this.runCount);
            if (log.isDebugEnabled()) {
                log.debug((Object)(this + ": creating run lengths of count " + this.runCount + ", value length " + (Object)((Object)runLength)));
            }
            runLengthValues = NumberValuesUtils.instance().toValues(this.runCount, runLengths, runLength, 1L, 1L);
        }
        return runLengthValues;
    }

    protected boolean useRunLength(int count, ValueLength valueLength, ValueLength runLength) {
        return count * valueLength.byteLength() > this.runCount * (valueLength.byteLength() + runLength.byteLength()) + 32;
    }

    public int getRunStart() {
        return this.runStart;
    }

    public int getRunCount() {
        return this.runCount;
    }

    public int getMaxRunLength() {
        return this.maxRunLength;
    }

    public String toString() {
        return "RunLengthStore@" + this.hashCode();
    }
}

