/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.data.xls;

import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Map;
import net.sf.jasperreports.data.AbstractDataAdapterService;
import net.sf.jasperreports.data.xls.XlsDataAdapter;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.data.AbstractXlsDataSource;

public abstract class AbstractXlsDataAdapterService
extends AbstractDataAdapterService {
    public static final String PROPERTY_DATA_ADAPTER_USE_LEGACY_JEXCELAPI = "net.sf.jasperreports.data.adapter.xls.use.legacy.jexcelapi";

    public AbstractXlsDataAdapterService(JasperReportsContext jasperReportsContext, XlsDataAdapter xlsDataAdapter) {
        super(jasperReportsContext, xlsDataAdapter);
    }

    public XlsDataAdapter getXlsDataAdapter() {
        return (XlsDataAdapter)this.getDataAdapter();
    }

    @Override
    public void contributeParameters(Map<String, Object> parameters) throws JRException {
        XlsDataAdapter xlsDataAdapter = this.getXlsDataAdapter();
        if (xlsDataAdapter != null) {
            String datePattern = xlsDataAdapter.getDatePattern();
            String numberPattern = xlsDataAdapter.getNumberPattern();
            String sheetSelection = xlsDataAdapter.getSheetSelection();
            if (xlsDataAdapter.isQueryExecuterMode()) {
                parameters.put("net.sf.jasperreports.xls.source", xlsDataAdapter.getFileName());
                if (datePattern != null && datePattern.length() > 0) {
                    parameters.put("XLS_DATE_FORMAT", new SimpleDateFormat(datePattern));
                }
                if (numberPattern != null && numberPattern.length() > 0) {
                    parameters.put("XLS_NUMBER_FORMAT", new DecimalFormat(numberPattern));
                }
                parameters.put("XLS_USE_FIRST_ROW_AS_HEADER", new Boolean(xlsDataAdapter.isUseFirstRowAsHeader()));
                if (sheetSelection != null && sheetSelection.length() > 0) {
                    parameters.put("net.sf.jasperreports.xls.sheet.selection", sheetSelection);
                }
                if (!xlsDataAdapter.isUseFirstRowAsHeader()) {
                    String[] names = new String[xlsDataAdapter.getColumnNames().size()];
                    Integer[] indexes = new Integer[xlsDataAdapter.getColumnNames().size()];
                    this.setupColumns(xlsDataAdapter, names, indexes);
                    parameters.put("XLS_COLUMN_NAMES_ARRAY", names);
                    parameters.put("XLS_COLUMN_INDEXES_ARRAY", indexes);
                }
            } else {
                AbstractXlsDataSource ds = this.getXlsDataSource();
                if (datePattern != null && datePattern.length() > 0) {
                    ds.setDateFormat(new SimpleDateFormat(datePattern));
                }
                if (numberPattern != null && numberPattern.length() > 0) {
                    ds.setNumberFormat(new DecimalFormat(numberPattern));
                }
                ds.setUseFirstRowAsHeader(xlsDataAdapter.isUseFirstRowAsHeader());
                if (sheetSelection != null && sheetSelection.length() > 0) {
                    ds.setSheetSelection(sheetSelection);
                }
                if (!xlsDataAdapter.isUseFirstRowAsHeader()) {
                    String[] names = new String[xlsDataAdapter.getColumnNames().size()];
                    int[] indexes = new int[xlsDataAdapter.getColumnNames().size()];
                    this.setupColumns(xlsDataAdapter, names, indexes);
                    ds.setColumnNames(names, indexes);
                }
                parameters.put("REPORT_DATA_SOURCE", ds);
            }
        }
    }

    protected abstract AbstractXlsDataSource getXlsDataSource() throws JRException;

    protected void setupColumns(XlsDataAdapter xlsDataAdapter, String[] names, int[] indexes) {
        int i = 0;
        while (i < names.length) {
            names[i] = xlsDataAdapter.getColumnNames().get(i);
            indexes[i] = xlsDataAdapter.getColumnIndexes().size() > i ? xlsDataAdapter.getColumnIndexes().get(i) : i;
            ++i;
        }
    }

    protected void setupColumns(XlsDataAdapter xlsDataAdapter, String[] names, Integer[] indexes) {
        int i = 0;
        while (i < names.length) {
            names[i] = xlsDataAdapter.getColumnNames().get(i);
            indexes[i] = xlsDataAdapter.getColumnIndexes().size() > i ? xlsDataAdapter.getColumnIndexes().get(i) : i;
            ++i;
        }
    }
}

