/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.base;

import java.io.Serializable;
import net.sf.jasperreports.engine.JRCloneable;
import net.sf.jasperreports.engine.JRQuery;
import net.sf.jasperreports.engine.JRQueryChunk;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.base.JRBaseObjectFactory;
import net.sf.jasperreports.engine.util.JRCloneUtils;
import net.sf.jasperreports.engine.util.JRQueryParser;

public class JRBaseQuery
implements JRQuery,
Serializable {
    private static final long serialVersionUID = 10200L;
    private JRQueryChunk[] chunks;
    protected String language = "sql";

    protected JRBaseQuery() {
    }

    protected JRBaseQuery(JRQuery query, JRBaseObjectFactory factory) {
        factory.put(query, this);
        JRQueryChunk[] jrChunks = query.getChunks();
        if (jrChunks != null && jrChunks.length > 0) {
            this.chunks = new JRQueryChunk[jrChunks.length];
            int i = 0;
            while (i < this.chunks.length) {
                this.chunks[i] = factory.getQueryChunk(jrChunks[i]);
                ++i;
            }
        }
        this.language = query.getLanguage();
    }

    @Override
    public JRQueryChunk[] getChunks() {
        return this.chunks;
    }

    @Override
    public String getText() {
        return JRQueryParser.instance().asText(this.getChunks());
    }

    @Override
    public String getLanguage() {
        return this.language;
    }

    @Override
    public Object clone() {
        JRBaseQuery clone = null;
        try {
            clone = (JRBaseQuery)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new JRRuntimeException(e);
        }
        clone.chunks = (JRQueryChunk[])JRCloneUtils.cloneArray((JRCloneable[])this.chunks);
        return clone;
    }
}

