/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.export;

import java.io.IOException;
import java.io.Writer;
import java.util.Arrays;
import java.util.List;
import java.util.StringTokenizer;
import net.sf.jasperreports.engine.DefaultJasperReportsContext;
import net.sf.jasperreports.engine.JRAbstractExporter;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRPrintElement;
import net.sf.jasperreports.engine.JRPrintFrame;
import net.sf.jasperreports.engine.JRPrintPage;
import net.sf.jasperreports.engine.JRPrintText;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.export.JRExportProgressMonitor;
import net.sf.jasperreports.engine.export.JRTextExporterContext;
import net.sf.jasperreports.engine.util.JRStyledText;
import net.sf.jasperreports.export.ExporterInputItem;
import net.sf.jasperreports.export.TextExporterConfiguration;
import net.sf.jasperreports.export.TextReportConfiguration;
import net.sf.jasperreports.export.WriterExporterOutput;
import net.sf.jasperreports.export.parameters.ParametersWriterExporterOutput;

public class JRTextExporter
extends JRAbstractExporter<TextReportConfiguration, TextExporterConfiguration, WriterExporterOutput, JRTextExporterContext> {
    private static final String TXT_EXPORTER_PROPERTIES_PREFIX = "net.sf.jasperreports.export.txt.";
    protected Writer writer;
    char[][] pageData;
    protected int pageWidthInChars;
    protected int pageHeightInChars;
    protected float charWidth;
    protected float charHeight;
    protected String pageSeparator;
    protected String lineSeparator;
    protected static final String systemLineSeparator = System.getProperty("line.separator");

    public JRTextExporter() {
        this(DefaultJasperReportsContext.getInstance());
    }

    public JRTextExporter(JasperReportsContext jasperReportsContext) {
        super(jasperReportsContext);
        this.exporterContext = new ExporterContext();
    }

    @Override
    protected Class<TextExporterConfiguration> getConfigurationInterface() {
        return TextExporterConfiguration.class;
    }

    @Override
    protected Class<TextReportConfiguration> getItemConfigurationInterface() {
        return TextReportConfiguration.class;
    }

    @Override
    protected void ensureOutput() {
        if (this.exporterOutput == null) {
            this.exporterOutput = new ParametersWriterExporterOutput(this.getJasperReportsContext(), this.getParameters(), this.getCurrentJasperPrint());
        }
    }

    @Override
    public void exportReport() throws JRException {
        this.ensureJasperReportsContext();
        this.ensureInput();
        this.initExport();
        this.ensureOutput();
        this.writer = ((WriterExporterOutput)this.getExporterOutput()).getWriter();
        try {
            try {
                this.exportReportToWriter();
            }
            catch (IOException e) {
                throw new JRException("Error writing to output writer : " + this.jasperPrint.getName(), e);
            }
        }
        finally {
            ((WriterExporterOutput)this.getExporterOutput()).close();
        }
    }

    @Override
    protected void initExport() {
        super.initExport();
        TextExporterConfiguration configuration = (TextExporterConfiguration)this.getCurrentConfiguration();
        this.lineSeparator = configuration.getLineSeparator();
        if (this.lineSeparator == null) {
            this.lineSeparator = systemLineSeparator;
        }
        this.pageSeparator = configuration.getPageSeparator();
        if (this.pageSeparator == null) {
            this.pageSeparator = String.valueOf(systemLineSeparator) + systemLineSeparator;
        }
    }

    @Override
    protected void initReport() {
        super.initReport();
        TextReportConfiguration configuration = (TextReportConfiguration)this.getCurrentItemConfiguration();
        Float charWidthValue = configuration.getCharWidth();
        float f = this.charWidth = charWidthValue == null ? 0.0f : charWidthValue.floatValue();
        if (this.charWidth < 0.0f) {
            throw new JRRuntimeException("Character width in pixels must be greater than zero.");
        }
        if (this.charWidth == 0.0f) {
            Integer pageWidthInCharsValue = configuration.getPageWidthInChars();
            int n = this.pageWidthInChars = pageWidthInCharsValue == null ? 0 : pageWidthInCharsValue;
            if (this.pageWidthInChars <= 0) {
                throw new JRRuntimeException("Character width in pixels or page width in characters must be specified and must be greater than zero.");
            }
            this.charWidth = (float)this.jasperPrint.getPageWidth() / (float)this.pageWidthInChars;
        } else {
            this.pageWidthInChars = (int)((float)this.jasperPrint.getPageWidth() / this.charWidth);
        }
        Float charHeightValue = configuration.getCharHeight();
        float f2 = this.charHeight = charHeightValue == null ? 0.0f : charHeightValue.floatValue();
        if (this.charHeight < 0.0f) {
            throw new JRRuntimeException("Character height in pixels must be greater than zero.");
        }
        if (this.charHeight == 0.0f) {
            Integer pageHeightInCharsValue = configuration.getPageHeightInChars();
            int n = this.pageHeightInChars = pageHeightInCharsValue == null ? 0 : pageHeightInCharsValue;
            if (this.pageHeightInChars <= 0) {
                throw new JRRuntimeException("Character height in pixels or page height in characters must be specified and must be greater than zero.");
            }
            this.charHeight = (float)this.jasperPrint.getPageHeight() / (float)this.pageHeightInChars;
        } else {
            this.pageHeightInChars = (int)((float)this.jasperPrint.getPageHeight() / this.charHeight);
        }
    }

    protected void exportReportToWriter() throws JRException, IOException {
        List<ExporterInputItem> items = this.exporterInput.getItems();
        int reportIndex = 0;
        while (reportIndex < items.size()) {
            ExporterInputItem item = items.get(reportIndex);
            this.setCurrentExporterInputItem(item);
            List<JRPrintPage> pages = this.jasperPrint.getPages();
            if (pages != null && pages.size() > 0) {
                JRAbstractExporter.PageRange pageRange = this.getPageRange();
                int startPageIndex = pageRange == null || pageRange.getStartPageIndex() == null ? 0 : pageRange.getStartPageIndex();
                int endPageIndex = pageRange == null || pageRange.getEndPageIndex() == null ? pages.size() - 1 : pageRange.getEndPageIndex();
                int i = startPageIndex;
                while (i <= endPageIndex) {
                    if (Thread.interrupted()) {
                        throw new JRException("Current thread interrupted.");
                    }
                    JRPrintPage page = pages.get(i);
                    this.exportPage(page);
                    ++i;
                }
            }
            ++reportIndex;
        }
        this.writer.flush();
    }

    protected void exportPage(JRPrintPage page) throws IOException {
        List<JRPrintElement> elements = page.getElements();
        this.pageData = new char[this.pageHeightInChars][];
        int i = 0;
        while (i < this.pageHeightInChars) {
            this.pageData[i] = new char[this.pageWidthInChars];
            Arrays.fill(this.pageData[i], ' ');
            ++i;
        }
        this.exportElements(elements);
        i = 0;
        while (i < this.pageHeightInChars) {
            this.writer.write(this.pageData[i]);
            this.writer.write(this.lineSeparator);
            ++i;
        }
        this.writer.write(this.pageSeparator);
        JRExportProgressMonitor progressMonitor = ((TextReportConfiguration)this.getCurrentItemConfiguration()).getProgressMonitor();
        if (progressMonitor != null) {
            progressMonitor.afterPageExport();
        }
    }

    protected void exportElements(List<JRPrintElement> elements) {
        int i = 0;
        while (i < elements.size()) {
            JRPrintElement element = elements.get(i);
            if (element instanceof JRPrintText) {
                this.exportText((JRPrintText)element);
            } else if (element instanceof JRPrintFrame) {
                JRPrintFrame frame = (JRPrintFrame)element;
                this.setFrameElementsOffset(frame, false);
                try {
                    this.exportElements(frame.getElements());
                }
                finally {
                    this.restoreElementOffsets();
                }
            }
            ++i;
        }
    }

    protected void exportText(JRPrintText element) {
        JRStyledText styledText;
        int colSpan = this.getWidthInChars(element.getWidth());
        int rowSpan = this.getHeightInChars(element.getHeight());
        int col = this.getWidthInChars(element.getX() + this.getOffsetX());
        int row = this.getHeightInChars(element.getY() + this.getOffsetY());
        if (col + colSpan > this.pageWidthInChars) {
            colSpan = this.pageWidthInChars - col;
        }
        String allText = (styledText = this.getStyledText(element)) == null ? "" : styledText.getText();
        if (rowSpan <= 0 || colSpan <= 0) {
            return;
        }
        if (allText != null && allText.length() == 0) {
            return;
        }
        StringBuffer[] rows = new StringBuffer[rowSpan];
        rows[0] = new StringBuffer();
        int rowIndex = 0;
        int rowPosition = 0;
        boolean isFirstLine = true;
        StringTokenizer lfTokenizer = new StringTokenizer(allText, "\n", true);
        block9: while (lfTokenizer.hasMoreTokens()) {
            String line = lfTokenizer.nextToken();
            if (isFirstLine && line.equals("\n")) {
                rows[rowIndex].append("");
                if (++rowIndex == rowSpan || !lfTokenizer.hasMoreTokens()) break;
                rowPosition = 0;
                rows[rowIndex] = new StringBuffer();
                line = lfTokenizer.nextToken();
            }
            isFirstLine = false;
            int emptyLinesCount = 0;
            while (line.equals("\n") && lfTokenizer.hasMoreTokens()) {
                ++emptyLinesCount;
                line = lfTokenizer.nextToken();
            }
            if (emptyLinesCount > 1) {
                int i = 0;
                while (i < emptyLinesCount - 1) {
                    rows[rowIndex].append("");
                    if (++rowIndex == rowSpan) break block9;
                    rowPosition = 0;
                    rows[rowIndex] = new StringBuffer();
                    if (!lfTokenizer.hasMoreTokens() && line.equals("\n")) {
                        rows[rowIndex].append("");
                        break block9;
                    }
                    ++i;
                }
            }
            if (line.equals("\n")) continue;
            StringTokenizer spaceTokenizer = new StringTokenizer(line, " ", true);
            while (spaceTokenizer.hasMoreTokens()) {
                String word = spaceTokenizer.nextToken();
                while (word.length() > colSpan) {
                    rows[rowIndex].append(word.substring(0, colSpan - rowPosition));
                    word = word.substring(colSpan - rowPosition, word.length());
                    if (++rowIndex == rowSpan) break block9;
                    rowPosition = 0;
                    rows[rowIndex] = new StringBuffer();
                }
                if (rowPosition + word.length() > colSpan) {
                    if (++rowIndex == rowSpan) break block9;
                    rowPosition = 0;
                    rows[rowIndex] = new StringBuffer();
                }
                if (rowIndex > 0 && rowPosition == 0 && word.equals(" ")) continue;
                rows[rowIndex].append(word);
                rowPosition += word.length();
            }
            if (++rowIndex == rowSpan) break;
            rowPosition = 0;
            rows[rowIndex] = new StringBuffer();
        }
        int colOffset = 0;
        int rowOffset = 0;
        switch (element.getVerticalAlignmentValue()) {
            case BOTTOM: {
                rowOffset = rowSpan - rowIndex;
                break;
            }
            case MIDDLE: {
                rowOffset = (rowSpan - rowIndex) / 2;
            }
        }
        int i = 0;
        while (i < rowIndex) {
            String line = rows[i].toString();
            int pos = line.length() - 1;
            while (pos >= 0 && line.charAt(pos) == ' ') {
                --pos;
            }
            line = line.substring(0, pos + 1);
            switch (element.getHorizontalAlignmentValue()) {
                case RIGHT: {
                    colOffset = colSpan - line.length();
                    break;
                }
                case CENTER: {
                    colOffset = (colSpan - line.length()) / 2;
                    break;
                }
                case JUSTIFIED: {
                    if (i >= rowIndex - 1) break;
                    line = this.justifyText(line, colSpan);
                }
            }
            char[] chars = line.toCharArray();
            System.arraycopy(chars, 0, this.pageData[row + rowOffset + i], col + colOffset, chars.length);
            ++i;
        }
    }

    private String justifyText(String s, int width) {
        StringBuffer justified = new StringBuffer();
        StringTokenizer t = new StringTokenizer(s, " ");
        int tokenCount = t.countTokens();
        if (tokenCount <= 1) {
            return s;
        }
        String[] words = new String[tokenCount];
        int i = 0;
        while (t.hasMoreTokens()) {
            words[i++] = t.nextToken();
        }
        int emptySpace = width - s.length() + (words.length - 1);
        int spaceCount = emptySpace / (words.length - 1);
        int remainingSpace = emptySpace % (words.length - 1);
        char[] spaces = new char[spaceCount];
        Arrays.fill(spaces, ' ');
        i = 0;
        while (i < words.length - 1) {
            justified.append(words[i]);
            justified.append(spaces);
            if (i < remainingSpace) {
                justified.append(' ');
            }
            ++i;
        }
        justified.append(words[words.length - 1]);
        return justified.toString();
    }

    protected int getHeightInChars(int height) {
        return Math.round((float)height / this.charHeight);
    }

    protected int getWidthInChars(int width) {
        return Math.round((float)width / this.charWidth);
    }

    @Override
    protected JRStyledText getStyledText(JRPrintText textElement) {
        return this.styledTextUtil.getStyledText(textElement, this.noneSelector);
    }

    @Override
    public String getExporterKey() {
        return null;
    }

    @Override
    public String getExporterPropertiesPrefix() {
        return TXT_EXPORTER_PROPERTIES_PREFIX;
    }

    protected class ExporterContext
    extends JRAbstractExporter.BaseExporterContext
    implements JRTextExporterContext {
        protected ExporterContext() {
        }
    }
}

