/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.export.draw;

import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Dimension2D;
import net.sf.jasperreports.engine.DefaultJasperReportsContext;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRPrintImage;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.Renderable;
import net.sf.jasperreports.engine.RenderableUtil;
import net.sf.jasperreports.engine.export.draw.ElementDrawer;
import net.sf.jasperreports.engine.type.ModeEnum;
import net.sf.jasperreports.engine.type.RenderableTypeEnum;

public class ImageDrawer
extends ElementDrawer<JRPrintImage> {
    public ImageDrawer() {
        this(DefaultJasperReportsContext.getInstance());
    }

    public ImageDrawer(JasperReportsContext jasperReportsContext) {
        super(jasperReportsContext);
    }

    @Override
    public void draw(Graphics2D grx, JRPrintImage printImage, int offsetX, int offsetY) throws JRException {
        if (printImage.getModeValue() == ModeEnum.OPAQUE) {
            grx.setColor(printImage.getBackcolor());
            grx.fillRect(printImage.getX() + offsetX, printImage.getY() + offsetY, printImage.getWidth(), printImage.getHeight());
        }
        int topPadding = printImage.getLineBox().getTopPadding();
        int leftPadding = printImage.getLineBox().getLeftPadding();
        int bottomPadding = printImage.getLineBox().getBottomPadding();
        int rightPadding = printImage.getLineBox().getRightPadding();
        int availableImageWidth = printImage.getWidth() - leftPadding - rightPadding;
        availableImageWidth = availableImageWidth < 0 ? 0 : availableImageWidth;
        int availableImageHeight = printImage.getHeight() - topPadding - bottomPadding;
        availableImageHeight = availableImageHeight < 0 ? 0 : availableImageHeight;
        Renderable renderer = printImage.getRenderable();
        if (renderer != null && availableImageWidth > 0 && availableImageHeight > 0) {
            if (renderer.getTypeValue() == RenderableTypeEnum.IMAGE && (renderer = RenderableUtil.getInstance(this.getJasperReportsContext()).getOnErrorRendererForImageData(renderer, printImage.getOnErrorTypeValue())) != null) {
                renderer = RenderableUtil.getInstance(this.getJasperReportsContext()).getOnErrorRendererForDimension(renderer, printImage.getOnErrorTypeValue());
            }
        } else {
            renderer = null;
        }
        if (renderer != null) {
            int normalWidth = availableImageWidth;
            int normalHeight = availableImageHeight;
            Dimension2D dimension = renderer.getDimension(this.getJasperReportsContext());
            if (dimension != null) {
                normalWidth = (int)dimension.getWidth();
                normalHeight = (int)dimension.getHeight();
            }
            float xalignFactor = 0.0f;
            switch (printImage.getHorizontalAlignmentValue()) {
                case RIGHT: {
                    xalignFactor = 1.0f;
                    break;
                }
                case CENTER: {
                    xalignFactor = 0.5f;
                    break;
                }
                default: {
                    xalignFactor = 0.0f;
                }
            }
            float yalignFactor = 0.0f;
            switch (printImage.getVerticalAlignmentValue()) {
                case BOTTOM: {
                    yalignFactor = 1.0f;
                    break;
                }
                case MIDDLE: {
                    yalignFactor = 0.5f;
                    break;
                }
                default: {
                    yalignFactor = 0.0f;
                }
            }
            switch (printImage.getScaleImageValue()) {
                case CLIP: {
                    int xoffset = (int)(xalignFactor * (float)(availableImageWidth - normalWidth));
                    int yoffset = (int)(yalignFactor * (float)(availableImageHeight - normalHeight));
                    Shape oldClipShape = grx.getClip();
                    grx.clip(new Rectangle(printImage.getX() + leftPadding + offsetX, printImage.getY() + topPadding + offsetY, availableImageWidth, availableImageHeight));
                    try {
                        renderer.render(this.getJasperReportsContext(), grx, new Rectangle(printImage.getX() + leftPadding + offsetX + xoffset, printImage.getY() + topPadding + offsetY + yoffset, normalWidth, normalHeight));
                        break;
                    }
                    finally {
                        grx.setClip(oldClipShape);
                    }
                }
                case FILL_FRAME: {
                    renderer.render(this.getJasperReportsContext(), grx, new Rectangle(printImage.getX() + leftPadding + offsetX, printImage.getY() + topPadding + offsetY, availableImageWidth, availableImageHeight));
                    break;
                }
                default: {
                    if (printImage.getHeight() <= 0) break;
                    double ratio = (double)normalWidth / (double)normalHeight;
                    if (ratio > (double)availableImageWidth / (double)availableImageHeight) {
                        normalWidth = availableImageWidth;
                        normalHeight = (int)((double)availableImageWidth / ratio);
                    } else {
                        normalWidth = (int)((double)availableImageHeight * ratio);
                        normalHeight = availableImageHeight;
                    }
                    int xoffset = (int)(xalignFactor * (float)(availableImageWidth - normalWidth));
                    int yoffset = (int)(yalignFactor * (float)(availableImageHeight - normalHeight));
                    renderer.render(this.getJasperReportsContext(), grx, new Rectangle(printImage.getX() + leftPadding + offsetX + xoffset, printImage.getY() + topPadding + offsetY + yoffset, normalWidth, normalHeight));
                }
            }
        }
        if (printImage.getLineBox().getTopPen().getLineWidth().floatValue() <= 0.0f && printImage.getLineBox().getLeftPen().getLineWidth().floatValue() <= 0.0f && printImage.getLineBox().getBottomPen().getLineWidth().floatValue() <= 0.0f && printImage.getLineBox().getRightPen().getLineWidth().floatValue() <= 0.0f) {
            if (printImage.getLinePen().getLineWidth().floatValue() != 0.0f) {
                this.drawPen(grx, printImage.getLinePen(), printImage, offsetX, offsetY);
            }
        } else {
            this.drawBox(grx, printImage.getLineBox(), printImage, offsetX, offsetY);
        }
    }
}

