/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.export.parameters;

import java.util.List;
import java.util.Map;
import net.sf.jasperreports.engine.JRExporterParameter;
import net.sf.jasperreports.engine.JRPropertiesUtil;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.export.parameters.ParameterResolver;

public class ParameterOverrideResolver
implements ParameterResolver {
    private final JRPropertiesUtil propertiesUtil;
    private final JasperPrint jasperPrint;
    private final Map<JRExporterParameter, Object> parameters;

    public ParameterOverrideResolver(JasperReportsContext jasperReportsContext, JasperPrint jasperPrint, Map<JRExporterParameter, Object> parameters) {
        this.propertiesUtil = JRPropertiesUtil.getInstance(jasperReportsContext);
        this.jasperPrint = jasperPrint;
        this.parameters = parameters;
    }

    @Override
    public String getStringParameter(JRExporterParameter parameter, String property) {
        if (this.parameters.containsKey(parameter)) {
            return (String)this.parameters.get(parameter);
        }
        return this.getPropertiesUtil().getProperty(this.jasperPrint.getPropertiesMap(), property);
    }

    @Override
    public String[] getStringArrayParameter(JRExporterParameter parameter, String propertyPrefix) {
        String[] values = null;
        if (this.parameters.containsKey(parameter)) {
            values = (String[])this.parameters.get(parameter);
        } else {
            List<JRPropertiesUtil.PropertySuffix> properties = JRPropertiesUtil.getProperties(this.jasperPrint.getPropertiesMap(), propertyPrefix);
            if (properties != null && !properties.isEmpty()) {
                values = new String[properties.size()];
                int i = 0;
                while (i < values.length) {
                    values[i] = properties.get(i).getValue();
                    ++i;
                }
            }
        }
        return values;
    }

    @Override
    public String getStringParameterOrDefault(JRExporterParameter parameter, String property) {
        if (this.parameters.containsKey(parameter)) {
            String value = (String)this.parameters.get(parameter);
            if (value == null) {
                return this.getPropertiesUtil().getProperty(property);
            }
            return value;
        }
        return this.getPropertiesUtil().getProperty(this.jasperPrint.getPropertiesMap(), property);
    }

    @Override
    public boolean getBooleanParameter(JRExporterParameter parameter, String property, boolean defaultValue) {
        if (this.parameters.containsKey(parameter)) {
            Boolean booleanValue = (Boolean)this.parameters.get(parameter);
            if (booleanValue == null) {
                return this.getPropertiesUtil().getBooleanProperty(property);
            }
            return booleanValue;
        }
        return this.getPropertiesUtil().getBooleanProperty(this.jasperPrint.getPropertiesMap(), property, defaultValue);
    }

    @Override
    public int getIntegerParameter(JRExporterParameter parameter, String property, int defaultValue) {
        if (this.parameters.containsKey(parameter)) {
            Integer integerValue = (Integer)this.parameters.get(parameter);
            if (integerValue == null) {
                return this.getPropertiesUtil().getIntegerProperty(property);
            }
            return integerValue;
        }
        return this.getPropertiesUtil().getIntegerProperty(this.jasperPrint.getPropertiesMap(), property, defaultValue);
    }

    @Override
    public float getFloatParameter(JRExporterParameter parameter, String property, float defaultValue) {
        if (this.parameters.containsKey(parameter)) {
            Float floatValue = (Float)this.parameters.get(parameter);
            if (floatValue == null) {
                return this.getPropertiesUtil().getFloatProperty(property);
            }
            return floatValue.floatValue();
        }
        return this.getPropertiesUtil().getFloatProperty(this.jasperPrint.getPropertiesMap(), property, defaultValue);
    }

    @Override
    public Character getCharacterParameter(JRExporterParameter parameter, String property) {
        if (this.parameters.containsKey(parameter)) {
            return (Character)this.parameters.get(parameter);
        }
        return this.getPropertiesUtil().getCharacterProperty(this.jasperPrint.getPropertiesMap(), property);
    }

    private JRPropertiesUtil getPropertiesUtil() {
        return this.propertiesUtil;
    }
}

