/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.functions.annotations;

import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.util.MessageProvider;
import net.sf.jasperreports.engine.util.MessageUtil;
import net.sf.jasperreports.functions.FunctionsBundle;
import net.sf.jasperreports.functions.FunctionsUtil;
import net.sf.jasperreports.functions.annotations.Function;
import net.sf.jasperreports.functions.annotations.FunctionBean;
import net.sf.jasperreports.functions.annotations.FunctionCategories;
import net.sf.jasperreports.functions.annotations.FunctionCategory;
import net.sf.jasperreports.functions.annotations.FunctionCategoryBean;
import net.sf.jasperreports.functions.annotations.FunctionMessagesBundle;
import net.sf.jasperreports.functions.annotations.FunctionParameter;
import net.sf.jasperreports.functions.annotations.FunctionParameterBean;
import net.sf.jasperreports.functions.annotations.FunctionParameters;

public class FunctionsInfo {
    public static final String DEFAULT_MESSAGES_BUNDLE = "jasperreports_messages";
    public static final String PROPERTY_SUFFIX_NAME = "name";
    public static final String PROPERTY_SUFFIX_DESCRIPTION = "description";
    public static final String PROPERTY_SUFFIX_TYPE = "type";
    public static final String PROPERTY_PARAMETER_REQUIRED = "net.sf.jasperreports.extension.functions.parameter.required";
    public static final String PROPERTY_PARAMETER_OPTIONAL = "net.sf.jasperreports.extension.functions.parameter.optional";
    private final JasperReportsContext jasperReportsContext;
    private final Locale locale;
    private final MessageUtil messageUtil;
    private final Map<String, FunctionCategoryBean> categories = new HashMap<String, FunctionCategoryBean>();

    private FunctionsInfo(JasperReportsContext jasperReportsContext, Locale locale) {
        this.jasperReportsContext = jasperReportsContext;
        this.locale = locale;
        this.messageUtil = MessageUtil.getInstance(jasperReportsContext);
        this.addFunctions();
    }

    public static FunctionsInfo getInstance(JasperReportsContext jasperReportsContext, Locale locale) {
        return new FunctionsInfo(jasperReportsContext, locale);
    }

    public Collection<FunctionCategoryBean> getCategories() {
        return this.categories.values();
    }

    protected void addFunctions() {
        List<FunctionsBundle> bundles = FunctionsUtil.getInstance(this.jasperReportsContext).getAllFunctionBundles();
        for (FunctionsBundle bundle : bundles) {
            List<Class<?>> functionClasses = bundle.getFunctionClasses();
            if (functionClasses == null || functionClasses.isEmpty()) continue;
            for (Class<?> functionClass : functionClasses) {
                this.addFunctionClass(functionClass);
            }
        }
    }

    protected void addFunctionClass(Class<?> functionClass) {
        FunctionCategories categories = functionClass.getAnnotation(FunctionCategories.class);
        Set<String> defaultCategories = this.addCategories(categories);
        MessageProvider provider = this.getMessageProvider(functionClass);
        Method[] methods = functionClass.getMethods();
        if (methods != null && methods.length > 0) {
            Method[] methodArray = methods;
            int n = methods.length;
            int n2 = 0;
            while (n2 < n) {
                Method method = methodArray[n2];
                this.addFunction(method, provider, defaultCategories, this.getBoundaryMethods(method, methods));
                ++n2;
            }
        }
    }

    protected Set<String> addCategories(FunctionCategories categories) {
        HashSet<String> categoryIds = null;
        if (categories != null) {
            categoryIds = new HashSet<String>();
            Class<?>[] classArray = categories.value();
            int n = classArray.length;
            int n2 = 0;
            while (n2 < n) {
                Class<?> categoryClass = classArray[n2];
                String categoryId = this.addCategoryClass(categoryClass);
                categoryIds.add(categoryId);
                ++n2;
            }
        }
        return categoryIds;
    }

    protected void addFunction(Method functionMethod, MessageProvider provider, Set<String> categoryIds, Method[] boundaryMethods) {
        Function function = functionMethod.getAnnotation(Function.class);
        if (function != null) {
            FunctionCategories functionCategories;
            Set<String> functionCategoryIds;
            FunctionParameter functionParameter;
            String functionId = String.valueOf(functionMethod.getDeclaringClass().getName()) + "." + function.value();
            FunctionBean functionBean = new FunctionBean(functionId, this.getName(functionId, provider), this.getDescription(functionId, provider), functionMethod.getReturnType());
            FunctionParameters functionParameters = functionMethod.getAnnotation(FunctionParameters.class);
            Class<?>[] minParameters = boundaryMethods[0].getParameterTypes();
            Class<?>[] maxParameters = boundaryMethods[1].getParameterTypes();
            int params = 0;
            int requiredParams = minParameters.length;
            if (functionParameters != null && functionParameters.value().length > 0) {
                FunctionParameter[] functionParameterArray = functionParameters.value();
                int n = functionParameterArray.length;
                int n2 = 0;
                while (n2 < n) {
                    functionParameter = functionParameterArray[n2];
                    this.addFunctionParameter(functionBean, functionParameter, provider, maxParameters[params], params < requiredParams);
                    ++params;
                    ++n2;
                }
            }
            if ((functionParameter = functionMethod.getAnnotation(FunctionParameter.class)) != null) {
                this.addFunctionParameter(functionBean, functionParameter, provider, maxParameters[params], params < requiredParams);
            }
            if ((functionCategoryIds = this.addCategories(functionCategories = functionMethod.getAnnotation(FunctionCategories.class))) != null && functionCategoryIds.size() > 0) {
                categoryIds = functionCategoryIds;
            }
            for (String categoryId : categoryIds) {
                FunctionCategoryBean categoryBean = this.categories.get(categoryId);
                categoryBean.addFunction(functionBean);
            }
        }
    }

    protected void addFunctionParameter(FunctionBean functionBean, FunctionParameter functionParameter, MessageProvider provider, Class<?> type, boolean isRequired) {
        String parameterId = String.valueOf(functionBean.getId()) + "." + functionParameter.value();
        FunctionParameterBean functionParameterBean = new FunctionParameterBean(parameterId, this.getName(parameterId, provider), this.getDescription(parameterId, provider), type, isRequired);
        functionBean.addParameter(functionParameterBean);
    }

    protected String addCategoryClass(Class<?> categoryClass) {
        MessageProvider provider = this.getMessageProvider(categoryClass);
        String categoryId = categoryClass.getName();
        FunctionCategory category = categoryClass.getAnnotation(FunctionCategory.class);
        if (category != null && category.value() != null && category.value().trim().length() > 0) {
            categoryId = category.value();
        }
        FunctionCategoryBean categoryBean = new FunctionCategoryBean(categoryId, this.getName(categoryId, provider), this.getDescription(categoryId, provider));
        this.categories.put(categoryId, categoryBean);
        return categoryId;
    }

    private MessageProvider getMessageProvider(Class<?> clazz) {
        FunctionMessagesBundle functionMessagesBundle = clazz.getAnnotation(FunctionMessagesBundle.class);
        String messagesBundle = functionMessagesBundle == null ? this.getDefaultMessageBundle(clazz) : functionMessagesBundle.value();
        return this.messageUtil.getMessageProvider(messagesBundle);
    }

    private String getDefaultMessageBundle(Class<?> clazz) {
        return String.valueOf(clazz.getPackage().getName()) + "." + DEFAULT_MESSAGES_BUNDLE;
    }

    private String getName(String key, MessageProvider provider) {
        return provider.getMessage(String.valueOf(key) + "." + PROPERTY_SUFFIX_NAME, null, this.locale);
    }

    private String getDescription(String key, MessageProvider provider) {
        return provider.getMessage(String.valueOf(key) + "." + PROPERTY_SUFFIX_DESCRIPTION, null, this.locale);
    }

    private Method[] getBoundaryMethods(Method method, Method[] methods) {
        Method minMethod = method;
        Method maxMethod = method;
        int minParams = method.getParameterTypes().length;
        int maxParams = method.getParameterTypes().length;
        String name = method.getName();
        Method[] methodArray = methods;
        int n = methods.length;
        int n2 = 0;
        while (n2 < n) {
            Method m = methodArray[n2];
            if (name.equals(m.getName())) {
                int params = m.getParameterTypes().length;
                if (params < minParams) {
                    minParams = params;
                    minMethod = m;
                } else if (params > maxParams) {
                    maxParams = params;
                    maxMethod = m;
                }
            }
            ++n2;
        }
        return new Method[]{minMethod, maxMethod};
    }
}

