package com.tin.etabf.annexure2;
import java.awt.Component;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.text.DecimalFormat;
import java.util.EventObject;

import javax.swing.*;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.text.JTextComponent;

import com.tin.etbaf.rpu.*;
// Referenced classes of package com.tin.etbaf.rpu:
//            Chk_LengthOnly, GRPU, GrpuUtil
import com.tin.etbaf.validations.SecondaryValidations;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
public class GRPUTableCellEditorProfitsInLieuOfSalaryAsPerSec17_3 extends AbstractCellEditor
    implements TableCellEditor
{

    JComponent component;
    int rowTable;
    int colTable;

    public GRPUTableCellEditorProfitsInLieuOfSalaryAsPerSec17_3()
    {
        component = new JTextField();
 component.addFocusListener(new FocusListener() {
			
			@Override
			public void focusLost(FocusEvent arg0) {
				JButton eventOwner;
				if(arg0.getOppositeComponent() instanceof JButton)
				{
					eventOwner =  (JButton) arg0.getOppositeComponent();
					if("Create File".equalsIgnoreCase(eventOwner.getText().trim()) ){
						GRPU.grpu.isCreateFileFocusOut = true;
					}					
				}
				else{
					GRPU.grpu.isCreateFileFocusOut = false;
				}
			}
			
			@Override
			public void focusGained(FocusEvent arg0) {
				// TODO Auto-generated method stub
				
			}
		});
        rowTable = 0;
        colTable = 0;
    }

    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int rowIndex, int vColIndex)
    {
        ((JTextField)component).setDocument(new Chk_LengthOnly(15));
        new SecondaryValidations().numericValidation(component,"(c) Profits in lieu of salary [section 17(3)] should be valid.For e.g. 1000.00 for record number "+(rowIndex -1));
        if(value == null  || value.equals(""))
            ((JTextField)component).setText("0.00");
        else
            ((JTextField)component).setText(String.valueOf(value));
        
        ((JTextField)component).setHorizontalAlignment(SwingConstants.RIGHT);
        rowTable = rowIndex;
        colTable = vColIndex;
        return component;
    }

    
    
    
    public Object getCellEditorValue()
    {
       
    	       Object tds=((JTextField)component).getText().toString();
    	       DecimalFormatSymbols sf = new DecimalFormatSymbols(Locale.ENGLISH);DecimalFormat df = new DecimalFormat("0.00",sf);
    			df.setMaximumFractionDigits(2);
    	    
    			
    	       if(!((JTextField)component).getText().toString().equals(""))
    	       {
    	    	   
    	    	if(((JTextField)component).getText().toString().trim().length() <= 15)
		        {  
    	    	   if(GrpuUtil.isDecimalNonZero(((JTextField)component).getText().toString().trim(),2))
   		            {
   		            
    	    		   	GRPU.grpu.getMessage("(c) Profits in lieu of salary [section 17(3)] should be valid.For e.g. 1000.00");
   		            	GRPU.grpu.setErrorAt(rowTable, colTable);
   		            	
   		            	return "0.00";
   		            }
    	    	       
    	    	   
    	    	   
    	    	   if(!tds.toString().contains("."))
    	           {
    	    		 
    	    		   if(tds.equals("0"))
    	    		     {
    	    		    	 String tdamount=tds.toString()+".000.00";
    	    	    		 ((JTextField)component).setText(tdamount); 
    	    		    	 
    	    		     }
    	    		     else
    	    		     { 
    	    		    	 String tdamount=tds.toString()+".00";
    	    		         ((JTextField)component).setText(tdamount);
    	    		     }
    	    		 
    	              if(((JTextField)component).getText().toString().length()> 15)
    	              { GRPU.grpu.getMessage("Length of Income other than head salary should not exceed 15 digits");
     		            GRPU.grpu.setErrorAt(rowTable, colTable);
     		           /****************** Added for 2.7 Start ********************/
      		           GRPU.grpu.setTotalAmountGrossSal("0.00", rowTable, colTable);
      		           /****************** Added for 2.7 End ********************/
      	              
      		           GRPU.grpu.setTotalAmountSalaryvalue("0.00",rowTable,colTable);
      		           GRPU.grpu.setIncmChargblHeadSal("0.00",rowTable,colTable);
      		           GRPU.grpu.setGrossTotalIncome("0.00",rowTable,colTable);
      		           GRPU.grpu.settotalTaxIncm("0.00",rowTable,colTable);
      		          
       		            return "0.00";
    	              }
    	              else
    	              {
    	            	GRPU.grpu.setNoErrorAt(rowTable, colTable);
    	            	/****************** Added for 2.7 Start ********************/
    	            	GRPU.grpu.setTotalAmountGrossSal( ((JTextField)component).getText().trim().toString(),rowTable,colTable);
    	            	/****************** Added for 2.7 End ********************/
   	                    GRPU.grpu.setTotalAmountSalaryvalue( ((JTextField)component).getText().trim().toString(),rowTable,colTable);
   	                    GRPU.grpu.setIncmChargblHeadSal(((JTextField)component).getText().trim().toString(),rowTable,colTable);
   	                    GRPU.grpu.setGrossTotalIncome(((JTextField)component).getText().trim().toString(),rowTable,colTable);
   	                    GRPU.grpu.settotalTaxIncm(((JTextField)component).getText().trim().toString(),rowTable,colTable);
   	                    //newly added for FRD1.6 by akansha
 		               GRPU.grpu.setGrossTotalSA(((JTextField)component).getText().trim().toString(), rowTable, colTable);
   	                    return df.format(Double.parseDouble(((JTextField)component).getText().trim()+"0" ));  
    	              }
    	           
    	           }
    	           else
    	        	   {
    	        		   GRPU.grpu.setNoErrorAt(rowTable, colTable);
    	        		   /****************** Added for 2.7 Start ********************/
    	        		   GRPU.grpu.setTotalAmountGrossSal(  ((JTextField)component).getText().trim().toString(),rowTable,colTable);
    	        		   /****************** Added for 2.7 End ********************/
    	        		   GRPU.grpu.setTotalAmountSalaryvalue(  ((JTextField)component).getText().trim().toString(),rowTable,colTable);
    	        		   GRPU.grpu.setIncmChargblHeadSal(((JTextField)component).getText().trim().toString(),rowTable,colTable);
    	        		   GRPU.grpu.setGrossTotalIncome(((JTextField)component).getText().trim().toString(),rowTable,colTable);
    	        		   GRPU.grpu.settotalTaxIncm(((JTextField)component).getText().trim().toString(),rowTable,colTable);
    	        		   //newly added for FRD1.6 by akansha
    		               GRPU.grpu.setGrossTotalSA(((JTextField)component).getText().trim().toString(), rowTable, colTable);
    	        		    return df.format(Double.parseDouble(((JTextField)component).getText().trim()+"0" ));
    	        	   }
    	           
    	        }
    	      
    	    	else
    	    	{  GRPU.grpu.getMessage("Length of Income other than head salary should not exceed 15 digits");
		           GRPU.grpu.setErrorAt(rowTable, colTable);
		           /****************** Added for 2.7 Start ********************/
		           GRPU.grpu.setTotalAmountGrossSal("0.00", rowTable, colTable);
		           /****************** Added for 2.7 End ********************/
	              
		           GRPU.grpu.setTotalAmountSalaryvalue("0.00",rowTable,colTable);
		           GRPU.grpu.setIncmChargblHeadSal("0.00",rowTable,colTable);
		           GRPU.grpu.setGrossTotalIncome("0.00",rowTable,colTable);
		           GRPU.grpu.settotalTaxIncm("0.00",rowTable,colTable);
		          
		           return "0.00";
    	    		
    	    	}
    	       
    	       
    	       }
    	
    	       else
    	       {
    	    	 //  GRPU.grpu.getMessage("Length of Income other than head salary should not exceed 15 digits");
		           GRPU.grpu.setErrorAt(rowTable, colTable);
		           /****************** Added for 2.7 Start ********************/
		           GRPU.grpu.setTotalAmountGrossSal("0.00", rowTable, colTable);
		           /****************** Added for 2.7 End ********************/
	              
		           GRPU.grpu.setTotalAmountSalaryvalue("0.00",rowTable,colTable);
		           GRPU.grpu.setIncmChargblHeadSal("0.00",rowTable,colTable);
		           GRPU.grpu.setGrossTotalIncome("0.00",rowTable,colTable);
		           GRPU.grpu.settotalTaxIncm("0.00",rowTable,colTable);
		      return "0.00";
    	    	   
    	       } 
     // return ((JTextField)component).getText().trim() ;  --- by akansha
    }

    public boolean isCellEditable(EventObject evt)
    {
        if(evt instanceof MouseEvent)
        {
            int clickCount = 2;
            return ((MouseEvent)evt).getClickCount() >= clickCount;
        } else
        {
            return true;
        }
    
    }  
}
