
package com.tin.etabf.annexure2;
import java.awt.Component;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.text.DecimalFormat;
import java.util.EventObject;

import javax.swing.*;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.text.JTextComponent;

import com.tin.etbaf.rpu.*;
// Referenced classes of package com.tin.etbaf.rpu:
//            Chk_LengthOnly, GRPU, GrpuUtil
import com.tin.etbaf.validations.SecondaryValidations;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
public class GRPUTableCellEditorTdsDedCurrnetEmpAnx2 extends AbstractCellEditor
    implements TableCellEditor
{

    JComponent component;
    int rowTable;
    int colTable;

    public GRPUTableCellEditorTdsDedCurrnetEmpAnx2()
    {
        component = new JTextField();
        component.addFocusListener(new FocusListener() {
			
			@Override
			public void focusLost(FocusEvent arg0) {
				JButton eventOwner;
				if(arg0.getOppositeComponent() instanceof JButton)
				{
					eventOwner =  (JButton) arg0.getOppositeComponent();
					if("Create File".equalsIgnoreCase(eventOwner.getText().trim()) ){
						GRPU.grpu.isCreateFileFocusOut = true;
					}					
				}
				else{
					GRPU.grpu.isCreateFileFocusOut = false;
				}
			}
			
			@Override
			public void focusGained(FocusEvent arg0) {
				// TODO Auto-generated method stub
				
			}
		});
        rowTable = 0;
        colTable = 0;
    }

    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int rowIndex, int vColIndex)
    {
        ((JTextField)component).setDocument(new Chk_LengthOnly(15));
        //Added newly on 09/07/2015 ---- R&D by Akansha
        new SecondaryValidations().numericValidation(component,"Total Tds Dedcuted by the current employer should be valid.For e.g. 1000.00");
        if(value == null)
            ((JTextField)component).setText("0.00");
        else
            ((JTextField)component).setText(String.valueOf(value));
        
        ((JTextField)component).setHorizontalAlignment(SwingConstants.RIGHT);
        rowTable = rowIndex;
        colTable = vColIndex;
        return component;
    }

    
    
    
    public Object getCellEditorValue()
    {
    	DecimalFormatSymbols sf = new DecimalFormatSymbols(Locale.ENGLISH);DecimalFormat df = new DecimalFormat("0.00",sf);
		df.setMaximumFractionDigits(2);
    	       Object tds=((JTextField)component).getText().toString();
    	        if(!((JTextField)component).getText().toString().equals(""))
    	       {
    	    	   
    	    	if(((JTextField)component).getText().toString().trim().length() <= 15)
		        {  
    	    	   if(GrpuUtil.isDecimalNonZero(((JTextField)component).getText().toString().trim(),2))
   		            {
   		            
    	    		   	GRPU.grpu.getMessage("Total Tds Dedcuted by the current employer should be valid.For e.g. 1000.00");
   		            	GRPU.grpu.setErrorAt(rowTable, colTable);
   			         return "0.00";
   		            }
    	    	       
    	    	   
    	    	   
    	    	   if(!tds.toString().contains("."))
    	           {
    	    		 
    	    		   if(tds.equals("0"))
    	    		     {
    	    		    	 String tdamount=tds.toString()+".000.00";
    	    	    		 ((JTextField)component).setText(tdamount); 
    	    		    	 
    	    		     }
    	    		     else
    	    		     { 
    	    		    	 String tdamount=tds.toString()+".00";
    	    		         ((JTextField)component).setText(tdamount);
    	    		     }
    	    		 
    	              if(((JTextField)component).getText().toString().length()> 15)
    	              { GRPU.grpu.getMessage("Total Tds Dedcuted by the current employer should not exceed 15 digits");
     		            GRPU.grpu.setErrorAt(rowTable, colTable);
     		         return "0.00";
    	              }
    	              else
    	              {
    	            	GRPU.grpu.setNoErrorAt(rowTable, colTable);
   	                    
   	                    GRPU.grpu.setTotalAmntDedSrcWholeYear(((JTextField)component).getText().trim().toString(),rowTable,colTable);
   	                    
   	                    GRPU.grpu.setShortFallTaxDedctn(((JTextField)component).getText().trim().toString(),rowTable,colTable);
   	                 return df.format(Double.parseDouble(((JTextField)component).getText().trim()+"0" ));  
    	              }
    	           
    	           }
    	           else
    	        	   {
    	        		   GRPU.grpu.setNoErrorAt(rowTable, colTable);
    	        		   
    	        		   GRPU.grpu.setTotalAmntDedSrcWholeYear(((JTextField)component).getText().trim().toString(),rowTable,colTable);
    	        		   
    	        		   GRPU.grpu.setShortFallTaxDedctn(((JTextField)component).getText().trim().toString(),rowTable,colTable);
    	        		 return df.format(Double.parseDouble(((JTextField)component).getText().trim()+"0" ));
    	        	   }
    	           
    	        }
    	      
    	    	else
    	    	{  GRPU.grpu.getMessage("Length of Total Tds Dedcuted by the current employer should not exceed 15 digits");
		           GRPU.grpu.setErrorAt(rowTable, colTable);
		         
		           return "0.00";
    	    		
    	    	}
    	       
    	       
    	       }
    	
    	       else
    	       {
    	    	//   GRPU.grpu.getMessage("<html>Total amount of TDS by current employer for whole year (Aggregate amount in Column 21-Annexure I for all quarters in respect of  each employee) <br> can not be blank for record number "+(rowTable-1)+" in Annexure II details.</html>");
		           GRPU.grpu.setErrorAt(rowTable, colTable);
		           
		           GRPU.grpu.setTotalAmntDedSrcWholeYear("0.00",rowTable,colTable);
		           GRPU.grpu.setShortFallTaxDedctn("0.00",rowTable,colTable);
		           //newly added for FRD1.6 by akansha
	               GRPU.grpu.setGrossTotalSA("0.00", rowTable, colTable);
		           return "0.00";
    	    	   
    	       }
    }

    public boolean isCellEditable(EventObject evt)
    {
        if(evt instanceof MouseEvent)
        {
            int clickCount = 2;
            return ((MouseEvent)evt).getClickCount() >= clickCount;
        } else
        {
            return true;
        }
    
    }  
}

