/**
 * Created By Akansha
 * This file provides the necessary methods for validating the entries in various tabs of the application
 * *******************************************************************************************************************************
 * Sr No.  		Date			Name						New Addition
 * *******************************************************************************************************************************
 * 1.			25/06/2015		Latish						Addition of new methods _BHAppender, _CDAppender, _DDAppender, _SDAppender  
 * 2. 			30/08/2016		Akansha						Modification in method _BHAppender, _CDAppender, _DDAppender, _SDAppender
 */
package com.tin.etabf.filecreator;

import java.lang.reflect.Array;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;

import javax.swing.JComboBox;
import javax.swing.table.DefaultTableModel;

import com.tin.etbaf.rpu.GRPU;
import com.tin.etbaf.rpu.GrpuUtil;
public class FileAppender {

	private GRPU rpu = null;
	DefaultTableModel model = null;
	DefaultTableModel model1 = null;
	DefaultTableModel model2 = null;
	DefaultTableModel model3 = null;  //Changes for CR82186 Create file .txt Regular for AnnexureIII
	List<Integer> li = null;

	Integer DDCount = 0;

	List<Integer> S16Count = new ArrayList<Integer>();
	List<Integer> c6ACount = new ArrayList<Integer>();
	
	List<Integer> AnnexIII94P_S16Count = new ArrayList<Integer>(); //Changes for CR82186 Create file .txt Regular for AnnexureIII
	List<Integer> AnnexIII_c6ACount = new ArrayList<Integer>();  //Changes for CR82186 Create file .txt Regular for AnnexureIII
	
	
	//RPU 2.9 start
	String[] c6aString = new String[]{"80CCE","80CCF","80CCG","OTHERS","80C","80CCC","80CCD(1)","80CCD(1B)","80CCD(2)","80D","80E","80G","80TTA","80CCH","80CCH(1)"}; //rahul CR84532 24Q added 80CCH and 80CCH(1) 
	public static int c6aCount=0;
	public static int c6ACount_counter=0,c6aString_counter=0;
	//RPU 2.9 end
	
	String[] c6a_94PString = new String[]{"80C","80CCC","80CCD(1)","80CCD(1B)","80D","80E","80G","80TTB","80DD","80EE","80EEA","80GG","80GGC","80U","OTHERS"};
	
	public static int c6A_94PCount_counter=0,c6a_94PString_counter=0;
	
	public static int C6A_94P_Count=0;
	FHBean fh = null;
	
	/*********************************************************/				
	//FRD 2.3 added 16(ia)
	public double ded16II = 0;
	public double ded16III = 0;
	public double ded16IA = 0;
	public double totalDed16 = 0;
	public double temp80C80CCCand80CCD=0;
	
	public double ded16IIIAnne3 = 0;
	public double ded16IAAnne3 = 0;
	public double totalDed16Anne3 = 0;
	public double temp80C80CCCand80CCDAnne3 = 0;
	/*********************************************************/

/**
 * Assigns static objects associated with various tabs in the Application
 * @param CreateFileRpu
 * @param CreateFileModel
 * @param CreateFileModel1
 * @param CreateFileModel2
 */
	public FileAppender(GRPU CreateFileRpu, DefaultTableModel CreateFileModel,
			DefaultTableModel CreateFileModel1,
			DefaultTableModel CreateFileModel2,
			DefaultTableModel CreateFileModel3) {
		// TODO Auto-generated constructor stub
		this.rpu = CreateFileRpu;
		this.model = CreateFileModel;
		this.model1 = CreateFileModel1;
		this.model2 = CreateFileModel2;
		this.model3 = CreateFileModel3;

	}

	/**
	 * Method used for setting values to FH Bean
	 * @return
	 */
	public FHBean _FHAppenderRegular() {

		fh = new FHBean();
		//DateTimeFormatter dtf = DateTimeFormatter.ofPattern("ddMMyyyy");
	   // LocalDateTime local =LocalDateTime.now();
	   // String CreationDate = dtf.format(local);
	    //fh.setCreationDate(CreationDate);
	    fh.setCreationDate(new SimpleDateFormat("ddMMyyyy",Locale.ENGLISH).format(new Date()));
		fh.setSequenceNum("1");
		fh.setEmployerTAN(rpu.tan);
		if (rpu.formNumber.equalsIgnoreCase("24Q")) {
			fh.setFileType("SL1");
		} else if (rpu.formNumber.equalsIgnoreCase("26Q")
				|| rpu.formNumber.equalsIgnoreCase("27Q")) {
			fh.setFileType("NS1");
		} else if (rpu.formNumber.equalsIgnoreCase("27EQ")) {
			fh.setFileType("TC1");
		}
		fh.setUploadType("R");
		// fh.setSequenceNum(GenerateSequence());
		fh.setUploaderType("D");
		fh.setNo_of_Batches("1");
		fh.setRPU_Name("Protean RPU 5.7"); //RPU 3.8 VersionChange Production problem
		                                //RPU 3.9 VersionChange Chatbot
		                                // NSDL Changed to Protean RPU 3.9 
		                                //RPU 4.0 Changes for CR82186 Version Change FVU 7.5
		                                //RPU 4.1 Changes for CR82683 Version Change FVU 7.6
		                                //RPU 4.2 Changes for CR82937 Version Change FVU 7.7
		                                //RPU 4.3 Changes for CR82937 Version Change FVU 7.8
		                                //RPU 4.4 Changes for CR83190 Version Change FVU 7.9
		                                //RPU 4.5 Changes for CR83677 Version Change FVU 8.0
		                                //RPU 4.6 Changes for CR76613 Version Change FVU 8.1 Only Bug Fix
		                                //RPU 4.7 Changes for CR84532 Version Change FVU 8.2
		                                //RPU 4.8 Changes for CR85831 Version Change FVU 8.3
										//RPU 4.9 Changes for CR85567 Version Change FVU 8.4
		                                //RPU 5.0 Changes for CR85881 Version Change FVU 8.5
		                                //RPU 5.1 Changes for CR86668 Version Change FVU 8.6
		                                //RPU 5.2 Changes for CR86827 Version Change FVU 8.7
		                                //RPU 5.3 Changes for CR87566 Version Change FVU 8.8
		                                //RPU 5.4 Changes for CR88008 Version Change FVU 8.9
		                                //RPU 5.5 Changes for CR88360 Version Change FVU 9.0
		                                //RPU 5.6 Changes for CR88828 Version Change FVU 9.1
		                                //RPU 5.7 Changes for CR88828 Version Change FVU 9.2
		 return fh;
	}


	/**
	 * Method used for assigning values to BH Bean
	 * @param ls
	 * @param bhCounter
	 * @param correctionType
	 * @return
	 */
	
	
	
	public BHBean _BHAppender(List ls, int bhCounter, String correctionType) {

		BHBean bh = new BHBean();
		DecimalFormatSymbols sf = new DecimalFormatSymbols(Locale.ENGLISH);DecimalFormat df = new DecimalFormat("0.00",sf);
		df.setMaximumFractionDigits(2);
		bh.setLineNumber("" + (ls.size() + 1));
		bh.setRecordType("BH");
		
		

		// Integer BHNumber = CountOccurence(sb.toString(),"^BH^") + 1 ;
		bh.setBatchNumber("" + bhCounter);

		if (!rpu.ChallanCount.equalsIgnoreCase("0")) {
			bh.setCountofChallantransfervoucherRecords(rpu.ChallanCount);
		}
		bh.setFormNumber(rpu.formNumber);

		if (correctionType != null && !correctionType.equals("R")) {

			bh.setTransactionType(correctionType); // for Correction

		}

		bh.setOriginalTokenNumberofthestatement(rpu.orgtoken);
		bh.setTokennoofpreviousregularstatement(rpu.prevtoken);
		bh.setTANofDeductorEmployer(rpu.tan);
		bh.setPANofDeductorEmployer(rpu.pan);
		bh.setAssessmentYr(rpu.assyear.substring(0, 4)
				+ rpu.assyear.substring(7, 9));
		bh.setFinancialYr(rpu.finyear.substring(0, 4)
				+ rpu.finyear.substring(7, 9));
		bh.setPeriod(rpu.quarter);
		bh.setNameofEmployerDeductor(rpu.dedname);
		bh.setEmployerDeductorBranchDivision(rpu.dedbranch);
		bh.setEmployerDeductorAddress1(rpu.flatno);
		bh.setEmployerDeductorAddress2(rpu.dedbldgname);
		bh.setEmployerDeductorAddress3(rpu.road);
		bh.setEmployerDeductorAddress4(rpu.area);
		bh.setEmployerDeductorAddress5(rpu.dedtown);
		bh.setEmployerDeductorState(rpu.dedstatetwo);
		bh.setEmployerDeductorPIN(rpu.dedpin);
		bh.setEmployerDeductorEmailID(rpu.dedemail);

		if (rpu.dedtel != null && rpu.dedtel.length() != 0) {
			bh.setEmployerDeductorSTDcode(rpu.dedtelstd);
			bh.setEmployerDeductorTelPhoneNo(rpu.dedtel);
		}
		if (rpu.hasaddchanged.equals("1")) {
			bh.setChangeofAddressofemployerDeductorsincelastReturn("Y");
		} else if (rpu.hasaddchanged.equals("2")) {
			bh.setChangeofAddressofemployerDeductorsincelastReturn("N");
		}
		bh.setDeductorType(GrpuUtil
				.getDeductorCode(rpu.JComboBox_Form_Sub1_Type_of_Deductor
						.getSelectedItem().toString()));
		bh.setNameofPersonresponsibleforpayingsalaryDeduction(rpu.rpname);
		bh.setDesignationofthePersonresponsibleforpayingsalaryDeduction(rpu.rpdesig);
		bh.setResponsiblePersonAddress1(rpu.rpflatno);
		bh.setResponsiblePersonAddress2(rpu.rpbuldg);
		bh.setResponsiblePersonAddress3(rpu.rproad);
		bh.setResponsiblePersonAddress4(rpu.rparea);
		bh.setResponsiblePersonAddress5(rpu.rptown);
		bh.setResponsiblePersonState(rpu.rpstate);
		bh.setResponsiblePersonPIN(rpu.rppin);
		bh.setResponsiblePersonEmailID(rpu.rpemail);

		bh.setMobilenumber(rpu.rpmobile);
		bh.setResponsiblePersonSTDCode(rpu.rptelnumstd);
		bh.setResponsiblePersonTelPhoneNo(rpu.rptelnum);

		if (rpu.rpisaddresschng.equals("1")) {
			bh.setChangeofAddressofResponsiblepersonsincelastReturn("Y");
		} else if (rpu.rpisaddresschng.equals("2")) {
			bh.setChangeofAddressofResponsiblepersonsincelastReturn("N");
		}

		// Code for setting total Deposit amount -- start

		int count = new Integer(rpu.ChallanCount) + 1;
		Double BatchTotal = 0.00;
		for (int i = 2; i <= count; i++) {
			if (model.getValueAt(i, 10) != null
					&& !model.getValueAt(i, 10).toString().equalsIgnoreCase("")) {
				Double temp = Double.parseDouble(model.getValueAt(i, 10)
						.toString());
				BatchTotal = BatchTotal + temp;
			}
		}

		// System.out.println("HELLLLLLLLLLLLLLLLLLLOOOOOOOOOOOOOOOOOOOOOO MRRRRRRRRRRRRRRR the BATCH TOTAL is "+BatchTotal.toString());
		// System.out.println(rpu.valueOfTypeOfStmt);

		// Code for setting total Deposit amount -- End
		if (!BatchTotal.toString().equalsIgnoreCase("0.0")) {
			bh.setBatchTotalofTotalofDepositAmountasperChallan(df
					.format(BatchTotal));
		}

		// Added by Akansha
		// Added for regular creation of file wherein if batch total is empty
		// then print '0.00'
		if (BatchTotal.toString().equalsIgnoreCase("0.0")
				&& "Regular".equalsIgnoreCase(rpu.valueOfTypeOfStmt)) {
			bh.setBatchTotalofTotalofDepositAmountasperChallan("0.00");
		}
		// **************
		// Code for Setting Total Salary cound from annexure 2 -- Start
		if (rpu.formNumber.equalsIgnoreCase("24Q")) {
			bh.setCountofSalaryDetailsRecords(String.valueOf("0")); // added so
																	// that it
																	// doesnt go
																	// null
		}

		if (rpu.formNumber.equalsIgnoreCase("24Q")
				&& rpu.quarter.equalsIgnoreCase("Q4")) {

			Integer SalaryCount = (new Integer(model2.getRowCount() - 2));

			if ("Regular".equalsIgnoreCase(rpu.valueOfTypeOfStmt)) {
				bh.setCountofSalaryDetailsRecords(String.valueOf(SalaryCount));
			}

			SalaryCount = SalaryCount + 1;
			Double SalaryTotal = 0.00;
			Double temp = 0.00;

			for (int i = 2; i <= SalaryCount; i++) {
				if (model2.getValueAt(i, 16) != null
						&& !model2.getValueAt(i, 16).toString()
								.equalsIgnoreCase("")) {
					temp = Double.parseDouble(model2.getValueAt(i, 16)
							.toString());
				} else {
					temp = 0.00;
				}

				SalaryTotal = SalaryTotal + temp;
			}
		
			if ("Regular".equalsIgnoreCase(rpu.valueOfTypeOfStmt)) {
				
				bh.setBatchTotalofGrossTotalIncomeasperSalaryDetail(df
						.format(SalaryTotal));

			}

		}

		// Code for Setting Total Salary cound from annexure 2 -- END

		bh.setAOApproval("N");
		if ("Regular".equalsIgnoreCase(rpu.valueOfTypeOfStmt)) {

			if (rpu.rpisregstatement.equals("1")) {
				bh.setWhetherregularstatementforForm24Qfiledforearlierperiod("Y");
				// Added by Akansha
				// In case if earlier return is filed then populate previous
				// token number
				bh.setTokennoofpreviousregularstatement(rpu.rprecieptnm);
				// *******************************
			} else if (rpu.rpisregstatement.equals("2")) {
				bh.setWhetherregularstatementforForm24Qfiledforearlierperiod("N");
			}

		}
		bh.setLastDeductorType(rpu.lastDD);
		if (!rpu.dedstateone.equals("0")) {
			bh.setStateName(rpu.dedstateone);
		}
		bh.setPAOCode(rpu.paocode);
		bh.setDDOCode(rpu.ddocode);
		if (!rpu.dedminstrydept.equalsIgnoreCase("0")) // added for observation
														// in 26Q
		{
			bh.setMinistryName(GrpuUtil
					.getSubMinistryCode(rpu.JComboBox_Form_Sub2_MinistryName
							.getSelectedItem().toString()));
		}

		if (!rpu.dedminstrydeptothers.equalsIgnoreCase("0")) // added for
																// observation
																// in 26Q
		{
			bh.setMinistryNameOther(rpu.dedminstrydeptothers);
		}
		bh.setTANRegistrationNumber(rpu.tanregnm);
		bh.setPAORegistrationNo(rpu.paoregnm);
		bh.setDDORegistrationNo(rpu.ddoregnm);

		if ("Regular".equalsIgnoreCase(rpu.valueOfTypeOfStmt)) {

			bh.setEmployerDeductorSTDcode_alt(rpu.dedalttelstd);
			bh.setEmployerDeductorTelPhoneNo_alt(rpu.dedalttel);
			bh.setEmployerDeductorEmailID_alt(rpu.dedemailalt);
			bh.setResponsiblePersonSTDCode_alt(rpu.rptelnumaltstd);
			bh.setResponsiblePersonTelPhoneNo_alt(rpu.rptelnumalt);
			bh.setResponsiblePersonEmailID_alt(rpu.rpemailalt);
			
			// String typeofDD =
			// GrpuUtil.getDeductorCode(rpu.JComboBox_Form_Sub1_Type_of_Deductor.toString())
			// ;
			String typeofDD = GrpuUtil
					.getDeductorCode(rpu.JComboBox_Form_Sub1_Type_of_Deductor
							.getSelectedItem().toString());
			if (typeofDD.equalsIgnoreCase("A")
					|| typeofDD.equalsIgnoreCase("S")) {
				

				bh.setAccountOfficeIdentificationNumber(rpu.dedain);
			}

		}
		
		

		if ("Correction".equalsIgnoreCase(rpu.valueOfTypeOfStmt)) {

			if (rpu.lasttan != null && !rpu.lasttan.equals("")) {
				bh.setLastTANofDeductorEmployerCollector(rpu.lasttan);
			}

			if (rpu.lastDD != null && !rpu.lastDD.equals("")) {
				bh.setLastDeductorType(rpu.lastDD);
			}

		}
		/***************************************************************/
		//For FRD2.1, added by Sadhana, append new four fillers.
		if (rpu.gstn != null && rpu.gstn.length() != 0 && rpu.gstn != "LINEHASH") {
			bh.setGstn(rpu.gstn);
		}
		
		// Code for Setting Section 194P Details  Records count from annexure 3  -- Start  //Changes for CR82186 Create file .txt Regular for AnnexureIII
		/*if (rpu.formNumber.equalsIgnoreCase("24Q")) {
			bh.setCountofSection194PDetailsRecords(String.valueOf("0")); // added so
																	// that it
																	// doesnt go
																	// null
		}*/

		
		
		
		
		
		
		if (rpu.formNumber.equalsIgnoreCase("24Q")
				&& rpu.quarter.equalsIgnoreCase("Q4") &&  Integer.parseInt(rpu.finyear.substring(0, 4)) >= 2021 ) {

			Integer AnnexIIISalaryCount = (new Integer(model3.getRowCount() - 2));

			if ("Regular".equalsIgnoreCase(rpu.valueOfTypeOfStmt)) {
				bh.setCountofSection194PDetailsRecords(String.valueOf(AnnexIIISalaryCount));
			}

			AnnexIIISalaryCount = AnnexIIISalaryCount + 1;
			Double GrossTotalIncome = 0.00;
			Double temp = 0.00;

			for (int i = 2; i <= AnnexIIISalaryCount; i++) {
				if (model3.getValueAt(i, 13) != null
						&& !model3.getValueAt(i, 13).toString()
								.equalsIgnoreCase("")) {
					temp = Double.parseDouble(model3.getValueAt(i, 13)
							.toString());
				} else {
					temp = 0.00;
				}

				GrossTotalIncome = GrossTotalIncome + temp;
			}
		
			if ("Regular".equalsIgnoreCase(rpu.valueOfTypeOfStmt)) {
				
				bh.setTotalofGrossTotalIncome(df
						.format(GrossTotalIncome));

			}

		}

		//Code for Setting Section 194P Details  Records count from annexure 3 -- END
		
		
		/*if (rpu.filler71 != null && rpu.filler71.length() != 0) {
			bh.setFiller71(rpu.filler71);
		}
		if (rpu.filler72 != null && rpu.filler72.length() != 0) {
			bh.setFiller72(rpu.filler72);
		}
		if (rpu.filler73 != null && rpu.filler73.length() != 0) {
			bh.setFiller73(rpu.filler73);
		}*/
		/***************************************************************/
		return bh;
	}


	/**
	 * Method used for assigning values to CD Bean
	 * @param ls
	 * @param bhCounter
	 * @param i
	 * @return
	 */
	public CDBean _CDAppender(List ls, int bhCounter, int i) {

		CDBean cd = new CDBean();
		DecimalFormatSymbols sf = new DecimalFormatSymbols(Locale.ENGLISH);DecimalFormat df = new DecimalFormat("0.00",sf);
		df.setMaximumFractionDigits(2);
		cd.setLineNumber("" + (ls.size() + 1));
		cd.setRecordType("CD");
		cd.setBatchNumber("" + bhCounter);
		cd.setChallanDetailRecordNumber(new Integer(i - 1).toString());

		// For obtaining Deductee detail record Number //

		Integer DeducteeCount = (new Integer(model1.getRowCount() - 2));

		li = deducteeDetails(DeducteeCount, i - 1);

		// END //

		// Validating NIL Challan on basis of other values //
		String TDS_Fees;
		String TDS_Others;
		String TDS_Interest;
		String TDS_CESS;
		String TDS_SurCharge;
		String TDS_Income_Tax;

		if (model.getValueAt(i, 3) != null
				&& !model.getValueAt(i, 3).toString().equals("")
				&& !model.getValueAt(i, 3).toString().equals("0")
				&& !model.getValueAt(i, 3).toString().equals("0.0")) {
			TDS_Income_Tax = model.getValueAt(i, 3).toString();
		} else {
			TDS_Income_Tax = "0.00";
		}

		if (model.getValueAt(i, 4) != null
				&& !model.getValueAt(i, 4).toString().equals("")
				&& !model.getValueAt(i, 4).toString().equals("0")
				&& !model.getValueAt(i, 4).toString().equals("0.0")) {
			TDS_SurCharge = model.getValueAt(i, 4).toString();
		} else {
			TDS_SurCharge = "0.00";
		}

		if (model.getValueAt(i, 5) != null
				&& !model.getValueAt(i, 5).toString().equals("")
				&& !model.getValueAt(i, 5).toString().equals("0")
				&& !model.getValueAt(i, 5).toString().equals("0.0")) {
			TDS_CESS = model.getValueAt(i, 5).toString();
		} else {
			TDS_CESS = "0.00";
		}

		if (model.getValueAt(i, 6) != null
				&& !model.getValueAt(i, 6).toString().equals("")
				&& !model.getValueAt(i, 6).toString().equals("0")
				&& !model.getValueAt(i, 6).toString().equals("0.0")) {
			TDS_Interest = model.getValueAt(i, 6).toString();
		} else {
			TDS_Interest = "0.00";
		}

		if (model.getValueAt(i, 8) != null
				&& !model.getValueAt(i, 8).toString().equals("")
				&& !model.getValueAt(i, 8).toString().equals("0")
				&& !model.getValueAt(i, 8).toString().equals("0.0")) {
			TDS_Others = model.getValueAt(i, 8).toString();
		} else {
			TDS_Others = "0.00";
		}

		if (model.getValueAt(i, 7) != null
				&& !model.getValueAt(i, 7).toString().equals("")
				&& !model.getValueAt(i, 7).toString().equals("0")
				&& !model.getValueAt(i, 7).toString().equals("0.0")) {
			TDS_Fees = model.getValueAt(i, 7).toString();
		} else {
			TDS_Fees = "0.00";
		}

		if (TDS_Income_Tax.equalsIgnoreCase("0.00")
				&& TDS_SurCharge.equalsIgnoreCase("0.00")
				&& TDS_CESS.equalsIgnoreCase("0.00")
				&& TDS_Interest.equalsIgnoreCase("0.00")
				&& TDS_Others.equalsIgnoreCase("0.00")
				&& TDS_Fees.equalsIgnoreCase("0.00")) {
			cd.setNILChallanIndicator("Y");
		} else {
			cd.setNILChallanIndicator("N");
		}

		// cd.setCountofDeducteePartyRecords(DeducteeCount.toString());

		cd.setCountofDeducteePartyRecords(new Integer(li.size()).toString());

		if (cd.getNILChallanIndicator().equals("N")) {

			if (model.getValueAt(i, 17) != null
					&& !model.getValueAt(i, 17).toString().equals("")
					&& model.getValueAt(i, 18).toString().substring(0, 1)
							.equalsIgnoreCase("N")) {
				cd.setChallanSerialNo(model.getValueAt(i, 17).toString()); // column
																			// 17
																			// for
																			// each
																			// row
			} else {
				if (model.getValueAt(i, 17) != null
						&& !model.getValueAt(i, 17).toString().equals("")
						&& model.getValueAt(i, 18).toString().substring(0, 1)
								.equalsIgnoreCase("Y")) {
					cd.setDDOSerialNo(model.getValueAt(i, 17).toString());
				}
			}

		}

		// Log.tbaf_log.info("Chalan Serial Number is " +
		// cd.getChallanSerialNo());

		if (model.getValueAt(i, 13) != null
				&& !model.getValueAt(i, 13).toString().equals("")
				&& model.getValueAt(i, 18).toString().substring(0, 1)
						.equalsIgnoreCase("N")) // Changed on 03/03/2015 --
												// Defect FIx for 27Q
												// Observation NO 23 -
												// questionable
		{
			if (cd.getNILChallanIndicator().equals("N")) {
				cd.setBankBranchCode(model.getValueAt(i, 13).toString());
			}

		} else if (model.getValueAt(i, 13) != null
				&& !model.getValueAt(i, 13).toString().equals("")
				&& Integer.parseInt(rpu.finyear.substring(0, 4)) >= 2010) {
			if (cd.getNILChallanIndicator().equals("N")) {
				cd.setBankBranchCode(model.getValueAt(i, 13).toString());
			}
		}

		if (model.getValueAt(i, 15) != null
				&& !model.getValueAt(i, 15).toString().equals("")) {
			cd.setDateofBankChallanTransferVoucher(model.getValueAt(i, 15)
					.toString().replaceAll("/", ""));
		}

		if (!model.getValueAt(i, 2).toString().contains("Select")) {
			cd.setSection(model.getValueAt(i, 2).toString());
		}

		cd.setOltasTDSTCSIncomeTax(TDS_Income_Tax);
		cd.setOltasTDSTCSSurcharge(TDS_SurCharge);
		cd.setOltasTDSTCSCess(TDS_CESS);
		cd.setOltasTDSTCSInterestAmount(TDS_Interest);
		cd.setOltasTDSTCSOthers(TDS_Others);

		if (cd.getNILChallanIndicator().equals("N")) {
			if (model.getValueAt(i, 10) != null
					&& !model.getValueAt(i, 10).toString().equals("")) {
				cd.setTotal_DepositAmount_ChallanTransferVoucherNumber(model
						.getValueAt(i, 10).toString());
			}
		} else {
			cd.setTotal_DepositAmount_ChallanTransferVoucherNumber("0.00");
		}

		Double TotalTaxDeposited = 0.00;

		Double DDSurcharge = 0.00;
		Double DDCess = 0.00;
		Double DDIncomeTax = 0.00;
		Double TotalTaxDeducted = 0.00;

		for (Integer j : li) {
			if (model1.getValueAt(j, 23) != null
					&& !model1.getValueAt(j, 23).toString()
							.equalsIgnoreCase("")) {
				TotalTaxDeposited = TotalTaxDeposited
						+ Double.parseDouble(model1.getValueAt(j, 23)
								.toString());

			} else {
				TotalTaxDeposited = TotalTaxDeposited + 0.00;
			}

			if (model1.getValueAt(j, 21) != null
					&& !model1.getValueAt(j, 21).toString()
							.equalsIgnoreCase("")) {
				TotalTaxDeducted = TotalTaxDeducted
						+ Double.parseDouble(model1.getValueAt(j, 21)
								.toString());

			} else {
				TotalTaxDeducted = TotalTaxDeducted + 0.00;
			}

			if (model1.getValueAt(j, 19) != null
					&& !model1.getValueAt(j, 19).toString()
							.equalsIgnoreCase("")) {
				DDSurcharge = DDSurcharge
						+ Double.parseDouble(model1.getValueAt(j, 19)
								.toString());
			} else {
				DDSurcharge = DDSurcharge + 0.00;
			}

			if (model1.getValueAt(j, 20) != null
					&& !model1.getValueAt(j, 20).toString()
							.equalsIgnoreCase("")) {
				DDCess = DDCess
						+ Double.parseDouble(model1.getValueAt(j, 20)
								.toString());
			} else {
				DDCess = DDCess + 0.00;
			}

			if (model1.getValueAt(j, 18) != null
					&& !model1.getValueAt(j, 18).toString()
							.equalsIgnoreCase("")) {
				DDIncomeTax = DDIncomeTax
						+ Double.parseDouble(model1.getValueAt(j, 18)
								.toString());
			} else {
				DDIncomeTax = DDIncomeTax + 0.00;
			}

			if (cd.getNILChallanIndicator().equals("N")) {

				if (model1.getValueAt(j, 25) != null
						&& !"".equals(model1.getValueAt(j, 25).toString()))
					if (!GrpuUtil
							.isDate(model1.getValueAt(j, 25).toString()
									.substring(0, 1), model1.getValueAt(j, 25)
									.toString().substring(3, 4),
									model1.getValueAt(j, 25).toString()
											.substring(6, 9))) {
						rpu.pointToCell_New_Annex1(
								"Not a Valid Date of Deduction", j, 25);

						return null;
					}
			}

		}

		cd.setTDSTCSIncomeTax(df.format(DDIncomeTax));
		cd.setTDSTCSCess(df.format(DDCess));
		cd.setTDSTCSSurcharge(df.format(DDSurcharge));
		cd.setSumofTotalIncomeTaxDeductedatSource(df.format(TotalTaxDeducted));

		if (cd.getNILChallanIndicator().equals("N")) {
			cd.setTotalTaxDepositAmountasperdeducteeannexure(df
					.format(TotalTaxDeposited));
		} else {
			cd.setTotalTaxDepositAmountasperdeducteeannexure("0.00");
		}

		if (model.getValueAt(i, 19) != null
				&& !model.getValueAt(i, 19).toString().equalsIgnoreCase("")) {
			cd.setTDSTCSInterestAmount(model.getValueAt(i, 19).toString());
		}

		if (model.getValueAt(i, 20) != null
				&& !model.getValueAt(i, 20).toString().equalsIgnoreCase("")) {
			cd.setTDSTCSOthers(model.getValueAt(i, 20).toString());
		}

		cd.setTDSTCSInterestAmount(TDS_Interest);
		cd.setTDSTCSOthers(TDS_Others);

		if (!(model.getValueAt(i, 11) == null)
				&& !(model.getValueAt(i, 11).toString().equalsIgnoreCase(""))) {
			cd.setChequeDDNo(model.getValueAt(i, 11).toString());
		}

		if (cd.getNILChallanIndicator().equals("N")) {

			if (cd.getChallanSerialNo() == null
					|| cd.getChallanSerialNo().equals("")) {

				cd.setByBookentryCash("Y");
			} else if (cd.getChallanSerialNo() != null
					|| !cd.getChallanSerialNo().equals("")) {

				cd.setByBookentryCash("N");
			}
		}

		if (Integer.parseInt(rpu.finyear.substring(0, 4)) >= 2012) {
			cd.setFee(TDS_Fees);
		}

		if (cd.getNILChallanIndicator().equals("N")) {
			if (Integer.parseInt(rpu.finyear.substring(0, 4)) >= 2013) {
				if (!model.getValueAt(i, 21).toString().contains("Select")) {
					cd.setMinorHeadChallan(model.getValueAt(i, 21).toString());
				}
			}
		}

		// ================================================ For Correction Setup
		// -- Start ===========================================================

		if ("Correction".equals(rpu.valueOfTypeOfStmt)) {

			if (model.getValueAt(i, 9) != null
					&& !model.getValueAt(i, 9).toString().equals("")) {
				cd.setLastTotal_DepositAmount_Challan(model.getValueAt(i, 9)
						.toString());
			}
			if (model.getValueAt(i, 12) != null
					&& !model.getValueAt(i, 12).toString().equals("")) {
				cd.setLastBankBranchCode(model.getValueAt(i, 12).toString());
			}
			if (model.getValueAt(i, 14) != null
					&& !model.getValueAt(i, 14).toString().equals("")) {
				cd.setLastDate_BankChallanNo_TransferVoucherNo(model
						.getValueAt(i, 14).toString().replaceAll("/", ""));
			}
			if (model.getValueAt(i, 16) != null
					&& !model.getValueAt(i, 16).toString().equals("")
					&& rpu.LastModeofDeposit.get(i - 2).substring(0, 1)
							.equalsIgnoreCase("Y")) {
				cd.setLastDDOSerialNo(model.getValueAt(i, 16).toString());
			} else if (model.getValueAt(i, 16) != null
					&& !model.getValueAt(i, 16).toString().equals("")
					&& rpu.LastModeofDeposit.get(i - 2).substring(0, 1)
							.equalsIgnoreCase("N")) {
				cd.setLastChallanSerialNumber(model.getValueAt(i, 16)
						.toString());
			}
		}

		// ================================================ For Correction Setup
		// -- END =============================================================

		return cd;
	}


	/**
	 * Method used for assigning values to DD Bean
	 * @param ls
	 * @param bhCounter
	 * @param inneri
	 * @param cd
	 * @return
	 */
	public DDBean _DDAppender(List ls, int bhCounter, int inneri, CDBean cd) {

		DDBean dd = new DDBean();
		DecimalFormatSymbols sf = new DecimalFormatSymbols(Locale.ENGLISH);DecimalFormat df = new DecimalFormat("0.00",sf);
		df.setMaximumFractionDigits(2);
		dd.setLine_Number("" + (ls.size() + 1));
		dd.setRecordType("DD");
		dd.setBatchNumber("" + bhCounter);

		if (!(model1.getValueAt(inneri, 1).toString().contains("Select"))) {

			dd.setChallan_DetailRecordNumber(model1.getValueAt(inneri, 1)
					.toString());

		}

		if (model1.getValueAt(inneri, 11) != null
				&& model1.getValueAt(inneri, 11).toString().length() != 0) {

			dd.setDeducteePartyDetailRecordNo(model1.getValueAt(inneri, 11)
					.toString());

		}

		if ("Correction".equals(rpu.valueOfTypeOfStmt)) {

			dd.setMode(model1.getValueAt(inneri, 2).toString().substring(0, 1));

		} else {
			dd.setMode("O");
		}

		/*
		 * if(model1.getValueAt(i, 2).toString().equalsIgnoreCase("ADD")) {
		 * dd.setMode("A"); }
		 * 
		 * if(model1.getValueAt(i, 2).toString().equalsIgnoreCase("UPDATE")) {
		 * dd.setMode("U"); }
		 */
		if (model1.getValueAt(inneri, 12) != null
				&& model1.getValueAt(inneri, 12).toString().length() != 0
				&& rpu.formNumber.equalsIgnoreCase("24Q")) {
			dd.setEmployeeSerialNo(model1.getValueAt(inneri, 12).toString());
		}

		if (!rpu.formNumber.equalsIgnoreCase("24Q")
				&& model1.getValueAt(inneri, 27) != null
				&& model1.getValueAt(inneri, 27).toString().length() != 0
				&& !(model1.getValueAt(inneri, 27).toString()
						.contains("Select"))) {
			dd.setDeducteePartyCode(Integer.valueOf(model1.getValueAt(inneri, 27).toString()).toString());
		}

		if (model1.getValueAt(inneri, 14) != null
				&& model1.getValueAt(inneri, 14).toString().length() != 0) {
			dd.setEmployeePartyPAN(model1.getValueAt(inneri, 14).toString());
		}

		if (!rpu.formNumber.equalsIgnoreCase("24Q")
				&& model1.getValueAt(inneri, 12) != null
				&& model1.getValueAt(inneri, 12).toString().length() != 0) {
			dd.setPANRefNo(model1.getValueAt(inneri, 12).toString());
		}
		if (model1.getValueAt(inneri, 15) != null
				&& model1.getValueAt(inneri, 15).toString().length() != 0) {
			dd.setNameofEmployeeParty(model1.getValueAt(inneri, 15).toString());
		}

		if (model1.getValueAt(inneri, 18) != null
				&& model1.getValueAt(inneri, 18).toString().length() != 0) {
			dd.setTDSTCS_IncomeTaxfortheperiod(model1.getValueAt(inneri, 18)
					.toString());
		}

		if (model1.getValueAt(inneri, 19) != null
				&& model1.getValueAt(inneri, 19).toString().length() != 0) {
			dd.setTDSTCS_Surchargefortheperiod(model1.getValueAt(inneri, 19)
					.toString());
		}

		if (model1.getValueAt(inneri, 20) != null
				&& model1.getValueAt(inneri, 20).toString().length() != 0) {
			dd.setTDSTCS_Cess(model1.getValueAt(inneri, 20).toString());
		}

		if (model1.getValueAt(inneri, 21) != null
				&& model1.getValueAt(inneri, 21).toString().length() != 0) {
			dd.setTotalIncomeTaxDeductedatSource(model1.getValueAt(inneri, 21)
					.toString());
		}

		if (model1.getValueAt(inneri, 23) != null
				&& model1.getValueAt(inneri, 23).toString().length() != 0
				&& cd.getNILChallanIndicator().equals("N")) {
			dd.setTotalTaxDeposited(model1.getValueAt(inneri, 23).toString());
		} else {
			dd.setTotalTaxDeposited("0.00");
		}

		if (model1.getValueAt(inneri, 17) != null
				&& model1.getValueAt(inneri, 17).toString().length() != 0) {
			dd.setAmountofPaymentCredit(model1.getValueAt(inneri, 17)
					.toString());
		}

		if (model1.getValueAt(inneri, 16) != null
				&& model1.getValueAt(inneri, 16).toString().length() != 0) {
			dd.setDateonwhichAmountpaidCredited(model1.getValueAt(inneri, 16)
					.toString().replaceAll("/", ""));
		}

		if (model1.getValueAt(inneri, 25) != null
				&& model1.getValueAt(inneri, 25).toString().length() != 0) {
			dd.setDateonwhichtaxDeducted(model1.getValueAt(inneri, 25)
					.toString().replaceAll("/", ""));
		}

		/* NA For 26Q */

		if (rpu.formNumber.equalsIgnoreCase("24Q")
				&& model1.getValueAt(inneri, 4) != null
				&& model1.getValueAt(inneri, 4).toString().length() != 0) {
			dd.setDateofDeposit(model1.getValueAt(inneri, 4).toString()
					.replaceAll("/", ""));
		}

		/* NA For 24Q and 27EQ */

		if (!rpu.formNumber.equalsIgnoreCase("24Q")
				&& !rpu.formNumber.equalsIgnoreCase("27EQ")
				&& model1.getValueAt(inneri, 28) != null
				&& model1.getValueAt(inneri, 28).toString().length() != 0) {
			dd.setRateatwhichTaxDeductedCollected(model1.getValueAt(inneri, 28)
					.toString());
		}

		/* For 27EQ */

		if (rpu.formNumber.equalsIgnoreCase("27EQ")
				&& model1.getValueAt(inneri, 29) != null
				&& model1.getValueAt(inneri, 29).toString().length() != 0) {
			dd.setRateatwhichTaxDeductedCollected(model1.getValueAt(inneri, 29)
					.toString());
		}

		/* NA For 26Q or 24Q */

		if (rpu.formNumber.equalsIgnoreCase("27Q")
				&& model1.getValueAt(inneri, 35) != null
				&& model1.getValueAt(inneri, 35).toString().length() != 0
				&& !(model1.getValueAt(inneri, 35).toString()
						.contains("Select"))) {
			dd.setGrossingupIndicator(model1.getValueAt(inneri, 35).toString()
					.substring(0, 1));
		}

		/* NA For 24Q */

		if (!rpu.formNumber.equalsIgnoreCase("24Q")
				&& !rpu.formNumber.equalsIgnoreCase("27EQ")
				&& model1.getValueAt(inneri, 29) != null
				&& model1.getValueAt(inneri, 29).toString().length() != 0
				&& !(model1.getValueAt(inneri, 29).toString()
						.contains("Select"))) {
			dd.setBookEntryCashIndicator(model1.getValueAt(inneri, 29)
					.toString().substring(0, 1));
		}

		/* For 27EQ */
		if (rpu.formNumber.equalsIgnoreCase("27EQ")
				&& model1.getValueAt(inneri, 30) != null
				&& model1.getValueAt(inneri, 30).toString().length() != 0
				&& !(model1.getValueAt(inneri, 30).toString()
						.contains("Select"))) {
			dd.setBookEntryCashIndicator(model1.getValueAt(inneri, 30)
					.toString().substring(0, 1));
		}
		
		/***********************************************************************/
		//Added by sadhana, FRD 2.2
		if (rpu.formNumber.equalsIgnoreCase("27EQ")
				&& model1.getValueAt(inneri, 32) != null
				&& model1.getValueAt(inneri, 32).toString().length() != 0
				&& !(model1.getValueAt(inneri, 32).toString()
						.contains("Select"))) {
			dd.setDeducteeIsPermanentResident(model1.getValueAt(inneri, 32)
					.toString().substring(0, 1));
		}
		
		if (rpu.formNumber.equalsIgnoreCase("27EQ")
				&& model1.getValueAt(inneri, 33) != null
				&& model1.getValueAt(inneri, 33).toString().length() != 0
				&& !(model1.getValueAt(inneri, 33).toString()
						.contains("Select"))) {
			dd.setDeducteeIsPermanentResidentEstablishment(model1.getValueAt(inneri, 33)
					.toString().substring(0, 1));
		}
		if (rpu.formNumber.equalsIgnoreCase("27EQ") //RPU 3.5 Addition of new columns
				&& model1.getValueAt(inneri, 34) != null
				&& model1.getValueAt(inneri, 34).toString().length() != 0
				&& !(model1.getValueAt(inneri, 34).toString()
						.contains("Select"))) {
			dd.setWhetherPymntisLiable(model1.getValueAt(inneri, 34)
					.toString().substring(0, 1));
		}
		if (rpu.formNumber.equalsIgnoreCase("27EQ") //RPU 3.5 Addition of new columns
				&& model1.getValueAt(inneri, 35) != null
				&& model1.getValueAt(inneri, 35).toString().length() != 0
				&& model1.getValueAt(inneri, 34).toString()
				.equals("Yes")) {
			dd.setChallanNumber(model1.getValueAt(inneri, 35)
					.toString());
		}
		if (rpu.formNumber.equalsIgnoreCase("27EQ") //RPU 3.5 Addition of new columns
				&& model1.getValueAt(inneri, 36) != null
				&& model1.getValueAt(inneri, 36).toString().length() != 0
				&& model1.getValueAt(inneri, 34).toString()
						.equals("Yes")) {
			dd.setDateofPymntofTDStoCG(model1.getValueAt(inneri, 36).toString()
					.replaceAll("/", ""));
		}
		
		
		//rahul CR84532 27EQ Addition of column 37 start
		if (rpu.formNumber.equalsIgnoreCase("27EQ")
				&& model1.getValueAt(inneri, 37) != null
				&& model1.getValueAt(inneri, 37).toString().length() != 0 
				&& !(model1.getValueAt(inneri, 37).toString()
						.contains("Select"))){
			dd.setWhetherDedOptingOutOfTaxRegime27EQ(model1.getValueAt(inneri, 37)
					.toString().substring(0, 1));
		}
		
		//rahul CR84532 27EQ Addition of column 37 end
		/***********************************************************************/

		if (!(model1.getValueAt(inneri, 26).toString().contains("Select"))) {
			if("B - In case of 15G/15H".equals(model1.getValueAt(inneri, 26).toString()))
				dd.setRemarks1("B"); // new development for FRD1.5 by akansha
			else	
				dd.setRemarks1(model1.getValueAt(inneri, 26).toString());
		}

		if (Integer.parseInt(rpu.finyear.substring(0, 4)) >= 2013
				&& model1.getValueAt(inneri, 6) != null
				&& model1.getValueAt(inneri, 6).toString().length() != 0
				&& !model1.getValueAt(inneri, 6).toString().contains("Select")) {
				//dd.setSectionCodePaymentMade(model1.getValueAt(inneri, 6).toString());
				if("194IC".equals(model1.getValueAt(inneri, 6).toString())){
					dd.setSectionCodePaymentMade("4IC");
				}else{
					dd.setSectionCodePaymentMade(model1.getValueAt(inneri, 6).toString());
				}
		}	
			
						
//		if (Integer.parseInt(rpu.finyear.substring(0, 4)) >= 2013			
//				&& model1.getValueAt(inneri, 6) != null
//				&& model1.getValueAt(inneri, 6).toString().length() != 0
//				&& !model1.getValueAt(inneri, 6).toString().contains("Select")) {
//				//dd.setSectionCodePaymentMade(model1.getValueAt(inneri, 6).toString());
//			if("194IC".equals(model1.getValueAt(inneri, 6).toString())){
//				dd.setSectionCodePaymentMade("4IC");
//				}else{
//					dd.setSectionCodePaymentMade(model1.getValueAt(inneri, 6).toString());
//				}
//		}

		/* For 24Q */

		if (Integer.parseInt(rpu.finyear.substring(0, 4)) >= 2013
				&& rpu.formNumber.equalsIgnoreCase("24Q")
				&& model1.getValueAt(inneri, 27) != null
				&& model1.getValueAt(inneri, 27).toString().length() != 0) {
			dd.setCertificateNumberAssessingOfficer(model1.getValueAt(inneri,
					27).toString());
			// System.out.println("My VALUE IS : "+ model1.getValueAt(inneri,
			// 27).toString());
		}

		/* For 26Q */

		if (Integer.parseInt(rpu.finyear.substring(0, 4)) >= 2013
				&& !rpu.formNumber.equalsIgnoreCase("24Q")
				&& !rpu.formNumber.equalsIgnoreCase("27EQ")
				&& model1.getValueAt(inneri, 30) != null
				&& model1.getValueAt(inneri, 30).toString().length() != 0) {
			dd.setCertificateNumberAssessingOfficer(model1.getValueAt(inneri,
					30).toString());
			// System.out.println("My VALUE IS : "+ model1.getValueAt(inneri,
			// 27).toString());
		}
		//RPU 3.1 start updated
		/* For 26Q */
		if ((Integer.parseInt(rpu.finyear.substring(0, 4)) == 2019
				&& rpu.formNumber.equalsIgnoreCase("26Q")
				&& model1.getValueAt(inneri, 31) != null
				&& model1.getValueAt(inneri, 31).toString().length() != 0
				&& !(rpu.quarter.equalsIgnoreCase("Q1")))||
				(Integer.parseInt(rpu.finyear.substring(0, 4)) > 2019
						&& rpu.formNumber.equalsIgnoreCase("26Q")
						&& model1.getValueAt(inneri, 31) != null
						&& model1.getValueAt(inneri, 31).toString().length() != 0
						)) {
			dd.setAmtOfCshWdrawInExcessOfRs1CrS194N(model1.getValueAt(inneri,
					31).toString());
			//System.out.println("My VALUE IS : column 31"+ model1.getValueAt(inneri, 31).toString());
		}
		//RPU 3.4 Addition of new column
		if ((Integer.parseInt(rpu.finyear.substring(0, 4)) == 2020
				&& rpu.formNumber.equalsIgnoreCase("26Q")
				&& model1.getValueAt(inneri, 32) != null
				&& model1.getValueAt(inneri, 32).toString().length() != 0
				&& !(rpu.quarter.equalsIgnoreCase("Q1")))||
				(Integer.parseInt(rpu.finyear.substring(0, 4)) > 2020
						&& rpu.formNumber.equalsIgnoreCase("26Q")
						&& model1.getValueAt(inneri, 32) != null
						&& model1.getValueAt(inneri, 32).toString().length() != 0
						)) {
			dd.setAmtOfCshWdrawInExcessOfRs20lkhSbclause_a_194N(model1.getValueAt(inneri,
					32).toString());
			System.out.println("My VALUE IS : column 32"+ model1.getValueAt(inneri, 32).toString());
		}
		
		if ((Integer.parseInt(rpu.finyear.substring(0, 4)) == 2020
				&& rpu.formNumber.equalsIgnoreCase("26Q")
				&& model1.getValueAt(inneri, 33) != null
				&& model1.getValueAt(inneri, 33).toString().length() != 0
				&& !(rpu.quarter.equalsIgnoreCase("Q1")))||
				(Integer.parseInt(rpu.finyear.substring(0, 4)) > 2020
						&& rpu.formNumber.equalsIgnoreCase("26Q")
						&& model1.getValueAt(inneri, 33) != null
						&& model1.getValueAt(inneri, 33).toString().length() != 0
						)) {
			dd.setAmtOfCshWdrawInExcessOfRs20lkhSbclause_b_194N(model1.getValueAt(inneri,
					33).toString());
			System.out.println("My VALUE IS : column 33"+ model1.getValueAt(inneri, 33).toString());
		}
		
		//rahul CR84532 26Q Column Addition 419D
		if ((Integer.parseInt(rpu.finyear.substring(0, 4)) >= 2023
				&& rpu.formNumber.equalsIgnoreCase("26Q")
				&& model1.getValueAt(inneri, 34) != null
				&& model1.getValueAt(inneri, 34).toString().length() != 0)) {
			dd.setAmtOfCshWdrawInExcessOfRs3Cr_Society_194N(model1.getValueAt(inneri,
					34).toString());
		}
		//rahul CR84532 26Q Column Addition 419D 
		
		// CR 84532 26Q Column Addition 419E - Start by Khalid
				if ((Integer.parseInt(rpu.finyear.substring(0, 4)) >= 2023
						&& rpu.formNumber.equalsIgnoreCase("26Q")
						&& model1.getValueAt(inneri, 35) != null
						&& model1.getValueAt(inneri, 35).toString().length() != 0)) {
					dd.setAmtCshWdrawRs20lkhSbcleThrdProvsnSec194N(model1.getValueAt(inneri,
							35).toString());
				}
		// CR 84532 26Q Column Addition 419E - End by Khalid
				//renuka CR84532 26Q Column Addition 419F
				if ((Integer.parseInt(rpu.finyear.substring(0, 4)) >= 2023
						&& rpu.formNumber.equalsIgnoreCase("26Q")
						&& model1.getValueAt(inneri, 36) != null
						&& model1.getValueAt(inneri, 36).toString().length() != 0)) {
					dd.setAmtCshWdrawRs3Crsbclause_b_194N_419F(model1.getValueAt(inneri,
							36).toString());
				}
				//renuka CR84532 26Q Column Addition 419F
		/* For 27EQ */

		if (Integer.parseInt(rpu.finyear.substring(0, 4)) >= 2013
				&& rpu.formNumber.equalsIgnoreCase("27EQ")
				&& model1.getValueAt(inneri, 31) != null
				&& model1.getValueAt(inneri, 31).toString().length() != 0) {
			dd.setCertificateNumberAssessingOfficer(model1.getValueAt(inneri,
					31).toString());
			// System.out.println("My VALUE IS : "+ model1.getValueAt(inneri,
			// 27).toString());
		}

		/* For 27Q */

		if (Integer.parseInt(rpu.finyear.substring(0, 4)) >= 2013
				&& rpu.formNumber.equalsIgnoreCase("27Q")
				&& model1.getValueAt(inneri, 31) != null
				&& model1.getValueAt(inneri, 31).toString().length() != 0
				&& !(model1.getValueAt(inneri, 31).toString()
						.contains("Select"))) {
			dd.setWhetherTDSrateisTDS_ITactandDTAA(model1
					.getValueAt(inneri, 31).toString());
		}

		/* For 27Q */

		if (Integer.parseInt(rpu.finyear.substring(0, 4)) >= 2013
				&& rpu.formNumber.equalsIgnoreCase("27Q")
				&& model1.getValueAt(inneri, 32) != null
				&& model1.getValueAt(inneri, 32).toString().length() != 0
				&& !(model1.getValueAt(inneri, 32).toString()
						.contains("Select"))) {
			dd.setNatureOfRemittance(GrpuUtil.getRemittanceCodeReverse(model1
					.getValueAt(inneri, 32).toString()));
		}

		/* For 27Q */

		if (Integer.parseInt(rpu.finyear.substring(0, 4)) >= 2013
				&& rpu.formNumber.equalsIgnoreCase("27Q")
				&& model1.getValueAt(inneri, 33) != null
				&& model1.getValueAt(inneri, 33).toString().length() != 0) {
			dd.setUniqueAcknowledgementOfForm15CA(model1.getValueAt(inneri, 33)
					.toString());
		}

		/* For 27Q */

		if (Integer.parseInt(rpu.finyear.substring(0, 4)) >= 2013
				&& rpu.formNumber.equalsIgnoreCase("27Q")
				&& model1.getValueAt(inneri, 34) != null
				&& model1.getValueAt(inneri, 34).toString().length() != 0
				&& !(model1.getValueAt(inneri, 34).toString()
						.contains("Select"))) {
			dd.setCountryofDeductee(GrpuUtil.getCountryCodeReverse(model1
					.getValueAt(inneri, 34).toString().trim()));
		}

		if (rpu.formNumber.equalsIgnoreCase("27EQ")
				&& model1.getValueAt(inneri, 28) != null
				&& model1.getValueAt(inneri, 28).toString().length() != 0) {
			dd.setTotalValueofPurchase(model1.getValueAt(inneri, 28).toString());
		}

		if ("Correction".equals(rpu.valueOfTypeOfStmt)) {

			if (model1.getValueAt(inneri, 13) != null
					&& !model1.getValueAt(inneri, 13).toString().equals("")) {
				dd.setLastEmployeePartyPAN(model.getValueAt(inneri, 13)
						.toString());
			}

			if (dd.getMode().equalsIgnoreCase("U")) {
				if (model1.getValueAt(inneri, 22) != null) {
					dd.setLastTotalIncomeTaxDeductedatSource(model1.getValueAt(
							inneri, 22).toString());
				}

				if (model1.getValueAt(inneri, 24) != null) {
					dd.setLastTotalTaxDeposited(model1.getValueAt(inneri, 24)
							.toString());
				}
			}

		}
		
		//newly added for FRD1.7 by akansha
		/*if(rpu.formNumber.equalsIgnoreCase("27Q") && 
				"C".equalsIgnoreCase(model1.getValueAt(inneri, 26).toString()) &&
		Integer.parseInt(model1.getValueAt(inneri, 28).toString()
				.substring(0,model1.getValueAt(inneri, 28).toString().length()-5))>20){
			
			
			
		}*/
		//**********************************************************
		
		//newly added for FRD1.6 by akansha
		//System.out.println("Form Number: "+ rpu.formNumber + " Fin year: "+rpu.finyear);
		
		if (rpu.formNumber.equalsIgnoreCase("27Q")){
			
			if(Integer.parseInt(rpu.finyear.substring(0, 4)) >= 2016){
				
				if(model1.getValueAt(inneri,36)!=null && !"".equalsIgnoreCase(model1.getValueAt(inneri,36).toString().trim())){
					dd.setEmailIdofDeductee(model1.getValueAt(inneri,36).toString());
				}
				
				if(model1.getValueAt(inneri,37)!=null && !"".equalsIgnoreCase(model1.getValueAt(inneri,37).toString().trim())){
					dd.setContactNumberofDeductee(model1.getValueAt(inneri,37).toString());
				}
				
				if(model1.getValueAt(inneri,38)!=null && !"".equalsIgnoreCase(model1.getValueAt(inneri,38).toString().trim())){
					dd.setAddressofDeductee(model1.getValueAt(inneri,38).toString());
				}
				if(model1.getValueAt(inneri,39)!=null && !"".equalsIgnoreCase(model1.getValueAt(inneri,39).toString().trim())){
					dd.setTaxIdentificationNumber(model1.getValueAt(inneri,39).toString());
				}
			}
		}
		//RPU 3.1 start
				/* For 27Q */
				if ((Integer.parseInt(rpu.finyear.substring(0, 4)) == 2019
						&& rpu.formNumber.equalsIgnoreCase("27Q")
						&& model1.getValueAt(inneri, 40) != null
						&& model1.getValueAt(inneri, 40).toString().length() != 0
						&& !(rpu.quarter.equalsIgnoreCase("Q1"))) ||
						(Integer.parseInt(rpu.finyear.substring(0, 4)) > 2019
						&& rpu.formNumber.equalsIgnoreCase("27Q")
						&& model1.getValueAt(inneri, 40) != null
						&& model1.getValueAt(inneri, 40).toString().length() != 0)) 
				{
					dd.setAmtOfCshWdrawInExcessOfRs1CrS194N(model1.getValueAt(inneri,40).toString());
					//System.out.println("My VALUE IS : column 40"+ model1.getValueAt(inneri,40).toString());
					
				}
				//RPU 3.4 Addition of new column
				if ((Integer.parseInt(rpu.finyear.substring(0, 4)) == 2020
						&& rpu.formNumber.equalsIgnoreCase("27Q")
						&& model1.getValueAt(inneri, 41) != null
						&& model1.getValueAt(inneri, 41).toString().length() != 0
						&& !(rpu.quarter.equalsIgnoreCase("Q1"))) ||
						(Integer.parseInt(rpu.finyear.substring(0, 4)) > 2020
						&& rpu.formNumber.equalsIgnoreCase("27Q")
						&& model1.getValueAt(inneri, 41) != null
						&& model1.getValueAt(inneri, 41).toString().length() != 0)) 
				{
					dd.setAmtOfCshWdrawInExcessOfRs20lkhSbclause_a_194N(model1.getValueAt(inneri,41).toString());
					System.out.println("My VALUE IS : column 41"+ model1.getValueAt(inneri,41).toString());
					
				}
				
				if ((Integer.parseInt(rpu.finyear.substring(0, 4)) == 2020
						&& rpu.formNumber.equalsIgnoreCase("27Q")
						&& model1.getValueAt(inneri, 42) != null
						&& model1.getValueAt(inneri, 42).toString().length() != 0
						&& !(rpu.quarter.equalsIgnoreCase("Q1"))) ||
						(Integer.parseInt(rpu.finyear.substring(0, 4)) > 2020
						&& rpu.formNumber.equalsIgnoreCase("27Q")
						&& model1.getValueAt(inneri, 42) != null
						&& model1.getValueAt(inneri, 42).toString().length() != 0)) 
				{
					dd.setAmtOfCshWdrawInExcessOfRs20lkhSbclause_b_194N(model1.getValueAt(inneri,42).toString());
					System.out.println("My VALUE IS : column 42"+ model1.getValueAt(inneri,42).toString());
					
				}
				
				//rahul CR84532 27Q Column Addition 720D start
				if ((Integer.parseInt(rpu.finyear.substring(0, 4)) >= 2023
						&& rpu.formNumber.equalsIgnoreCase("27Q")
						&& model1.getValueAt(inneri, 43) != null
						&& model1.getValueAt(inneri, 43).toString().length() != 0)) {
					dd.setAmtOfCshWdrawInExcessOfRs3Cr_Society_194N(model1.getValueAt(inneri,
							43).toString());
				}
				//rahul CR84532 27Q Column Addition 720D end
				
				//Renuka CR84532 27Q column addition 720E,720F starts
				if ((Integer.parseInt(rpu.finyear.substring(0, 4)) >= 2023
						&& rpu.formNumber.equalsIgnoreCase("27Q")
						&& model1.getValueAt(inneri, 44) != null
						&& model1.getValueAt(inneri, 44).toString().length() != 0)) {
					dd.setAmtCshWdrawRs20lkhSbcleThrdProvsnSec194N(model1.getValueAt(inneri,
							44).toString());
				}
				if ((Integer.parseInt(rpu.finyear.substring(0, 4)) >= 2023
						&& rpu.formNumber.equalsIgnoreCase("27Q")
						&& model1.getValueAt(inneri, 45) != null
						&& model1.getValueAt(inneri, 45).toString().length() != 0)) {
					dd.setAmtCshWdrawRs3Crsbclause_b_194N_419F(model1.getValueAt(inneri,
							45).toString());
				}
				//Renuka CR84532 27Q column addition 720E,720F ends
				
				//rahul CR84532 27Q Addition of column 719B
				if (rpu.formNumber.equalsIgnoreCase("27Q")
						&& model1.getValueAt(inneri, 46) != null
						&& model1.getValueAt(inneri, 46).toString().length() != 0 
					&& !(model1.getValueAt(inneri, 46).toString()
							.contains("Select"))){
					dd.setWhetherDedOptingOutOfTaxRegime27Q(model1.getValueAt(inneri, 46)
							.toString().substring(0, 1));;
				}
				
				
				//rahul CR84532 27Q Addition of column 719B
		//*********************************************************

		return dd;
	}

	/**
	 * Method used for assigning values to SD Bean
	 * @param ls
	 * @param bhCounter
	 * @param i
	 * @return
	 */
	public SDBean _SDAppender(List ls, int bhCounter, int i) {
		
		S16Count.clear();
		c6ACount.clear();

		SDBean sd = new SDBean();
		
		// newly added for FRD1.6 by akansha
		int countPANLandLord = 0;
		int countPANLender = 0;
		
		totalDed16 = 0; //RPU 3.6 Observation fix
	     ded16II = 0;
		 ded16III = 0;
		 ded16IA = 0;
		 temp80C80CCCand80CCD=0; //RPU 3.6 Observation 22 fix
		// *******************************************
		
		/****************** Added for 2.7 Start ********************/
		double temp80C80CCCand80CCD = 0;
		/****************** Added for 2.7 End ********************/
		
		sd.setLineNumber("" + (ls.size() + 1));
		sd.setRecordType("SD");
		sd.setBatchNumber("" + bhCounter);

		if (model2.getValueAt(i, 1) != null
				&& model2.getValueAt(i, 1).toString().length() != 0) {
			sd.setSalaryDetailsRecordNo(model2.getValueAt(i, 1).toString());
		}

		/*
		 * if(model2.getValueAt(i, 2) != null && model2.getValueAt(i,
		 * 2).toString().length() != 0 && !(model2.getValueAt(i,
		 * 2).toString().contains("Select"))) {
		 */
		sd.setMode("A");

		/* } */

		if (model2.getValueAt(i, 3) != null
				&& model2.getValueAt(i, 3).toString().length() != 0) {
			sd.setEmployeePAN(model2.getValueAt(i, 3).toString());
		}

		if (model2.getValueAt(i, 4) != null
				&& model2.getValueAt(i, 4).toString().length() != 0) {
			sd.setNameofEmployee(model2.getValueAt(i, 4).toString());
		}

		if (model2.getValueAt(i, 5) != null
				&& model2.getValueAt(i, 5).toString().length() != 0
				&& !(model2.getValueAt(i, 5).toString().contains("Select"))) {

			sd.setCategoryofEmployee(GrpuUtil.getEmployeeCode(model2
					.getValueAt(i, 5).toString()));

		}

		if (model2.getValueAt(i, 6) != null
				&& model2.getValueAt(i, 6).toString().length() != 0) {
			sd.setPeriodofEmploymentFromDate(model2.getValueAt(i, 6).toString()
					.replaceAll("/", ""));
		}

		if (model2.getValueAt(i, 7) != null
				&& model2.getValueAt(i, 7).toString().length() != 0) {
			sd.setPeriodofEmploymentToDate(model2.getValueAt(i, 7).toString()
					.replaceAll("/", ""));
		}

		if (model2.getValueAt(i, 10) != null
				&& model2.getValueAt(i, 10).toString().length() != 0) {
			sd.setTotalamountofsalary(model2.getValueAt(i, 10).toString());
		}

		if (model2.getValueAt(i, 11) != null
				&& !model2.getValueAt(i, 11).toString().equalsIgnoreCase("0")
				&& !model2.getValueAt(i, 11).toString().equalsIgnoreCase("0.0")
				&& !model2.getValueAt(i, 11).toString()
						.equalsIgnoreCase("0.00")
				&& model2.getValueAt(i, 11).toString().length() != 0) {

			S16Count.add(11);

		}

		if (model2.getValueAt(i, 12) != null
				&& !model2.getValueAt(i, 12).toString().equalsIgnoreCase("0")
				&& !model2.getValueAt(i, 12).toString().equalsIgnoreCase("0.0")
				&& !model2.getValueAt(i, 12).toString()
						.equalsIgnoreCase("0.00")
				&& model2.getValueAt(i, 12).toString().length() != 0) {
			S16Count.add(12);

		}
		
		/*********************************************************/				
		//FRD 2.3 added 16(ia)		
		if (model2.getValueAt(i, 13) != null
				&& !model2.getValueAt(i, 13).toString().equalsIgnoreCase("0")
				&& !model2.getValueAt(i, 13).toString().equalsIgnoreCase("0.0")
				&& !model2.getValueAt(i, 13).toString()
						.equalsIgnoreCase("0.00")
				&& model2.getValueAt(i, 13).toString().length() != 0) {
			S16Count.add(13);

		}
		/*********************************************************/

		sd.setCountofSalaryDetailsSection16DetailRecordsassociatedwiththisDeductee(new Integer(
				S16Count.size()).toString());

		/*********************************************************/				
		//FRD 2.3 added 16(ia)
		/*if (model2.getValueAt(i, 13) != null
				&& model2.getValueAt(i, 13).toString().length() != 0) {
			sd.setGrossTotalofTotalDeductionundersection16underassociatedSalaryDetailsSection16Detail(model2
					.getValueAt(i, 13).toString());
		}*/
		
		if (model2.getValueAt(i, 11) != null && model2.getValueAt(i, 11).toString().length() != 0) {
			ded16II = Double.parseDouble(model2.getValueAt(i, 11).toString());
		}
		
		if (model2.getValueAt(i, 12) != null && model2.getValueAt(i, 12).toString().length() != 0) {
			ded16III = Double.parseDouble(model2.getValueAt(i, 12).toString());
		}
		
		if (model2.getValueAt(i, 13) != null && model2.getValueAt(i, 13).toString().length() != 0) {
			ded16IA = Double.parseDouble(model2.getValueAt(i, 13).toString());
		}
		
		totalDed16 = ded16II + ded16III + ded16IA;
		sd.setGrossTotalofTotalDeductionundersection16underassociatedSalaryDetailsSection16Detail(Double.toString(totalDed16));
		/*********************************************************/
		

		if (model2.getValueAt(i, 14) != null
				&& model2.getValueAt(i, 14).toString().length() != 0) {
			sd.setIncomechargeableundertheheadSalaries(model2.getValueAt(i, 14)
					.toString());
		}

		if (model2.getValueAt(i, 15) != null
				&& model2.getValueAt(i, 15).toString().length() != 0) {
			sd.setIncomeUnderanyheadotherthanincomeundertheheadSalariesofferedforTDS(model2
					.getValueAt(i, 15).toString());

		}

		if (model2.getValueAt(i, 16) != null
				&& model2.getValueAt(i, 16).toString().length() != 0) {
			sd.setGrossTotalIncome(model2.getValueAt(i, 16).toString());
		}
		//RPU 2.9 start
		if (model2.getValueAt(i, 17) != null
				&& model2.getValueAt(i, 17).toString().length() != 0) {
			c6ACount.add(17);
		}else
			c6ACount.add(0);
		
		c6ACount.add(0); //for 80CCE gross
		c6ACount.add(0); //for 80CCE qualifying

		if (model2.getValueAt(i, 18) != null
				&& model2.getValueAt(i, 18).toString().length() != 0) {
			c6ACount.add(18);
		}else
			c6ACount.add(0);

		c6ACount.add(0); //for 80CCF gross
		c6ACount.add(0); //for 80CCF qualifying
		
		if (model2.getValueAt(i, 19) != null
				&& model2.getValueAt(i, 19).toString().length() != 0) {
			c6ACount.add(19);
		}else
			c6ACount.add(0);

		c6ACount.add(0); //for 80CCG gross
		c6ACount.add(0); //for 80CCG qualifying
		
		if (model2.getValueAt(i, 20) != null
				&& model2.getValueAt(i, 20).toString().length() != 0) {
			c6ACount.add(20);
		}else
			c6ACount.add(0);
		
		if (model2.getValueAt(i, 91) != null
				&& model2.getValueAt(i, 91).toString().length() != 0) {
			c6ACount.add(91);
		}else
			c6ACount.add(0);
		
		if (model2.getValueAt(i, 92) != null
				&& model2.getValueAt(i, 92).toString().length() != 0) {
			c6ACount.add(92);
		}else
			c6ACount.add(0);
		
		
		if (model2.getValueAt(i, 71) != null
				&& model2.getValueAt(i, 71).toString().length() != 0) {
			c6ACount.add(71);
		}else
			c6ACount.add(0);
		
		if (model2.getValueAt(i, 70) != null
				&& model2.getValueAt(i, 70).toString().length() != 0) {
			c6ACount.add(70);
		}else
			c6ACount.add(0);
		
		c6ACount.add(0); //for 80C qualifying
		
		if (model2.getValueAt(i, 73) != null
				&& model2.getValueAt(i, 73).toString().length() != 0) {
			c6ACount.add(73);
		}else
			c6ACount.add(0);
		
		if (model2.getValueAt(i, 72) != null
				&& model2.getValueAt(i, 72).toString().length() != 0) {
			c6ACount.add(72);
		}else
			c6ACount.add(0);
		
		c6ACount.add(0); //for 80CCC qualifying
		
		if (model2.getValueAt(i, 75) != null
				&& model2.getValueAt(i, 75).toString().length() != 0) {
			c6ACount.add(75);
		}else
			c6ACount.add(0);
	
		if (model2.getValueAt(i, 74) != null
				&& model2.getValueAt(i, 74).toString().length() != 0) {
			c6ACount.add(74);
		}else
			c6ACount.add(0);
		
		c6ACount.add(0); //for 80CCD(1) qualifying
		
		if (model2.getValueAt(i, 77) != null
				&& model2.getValueAt(i, 77).toString().length() != 0) {
			c6ACount.add(77);
		}else
			c6ACount.add(0);
		
		if (model2.getValueAt(i, 76) != null
				&& model2.getValueAt(i, 76).toString().length() != 0) {
			c6ACount.add(76);
		}else
			c6ACount.add(0);
		
		c6ACount.add(0); //for 80CCD(1B) qualifying

		if (model2.getValueAt(i, 79) != null
				&& model2.getValueAt(i, 79).toString().length() != 0) {
			c6ACount.add(79);
		}else
			c6ACount.add(0);
		
		if (model2.getValueAt(i, 78) != null
				&& model2.getValueAt(i, 78).toString().length() != 0) {
			c6ACount.add(78);
		}else
			c6ACount.add(0);
		
		c6ACount.add(0); //for 80CCD(2) qualifying
		
		if (model2.getValueAt(i, 81) != null
				&& model2.getValueAt(i, 81).toString().length() != 0) {
			c6ACount.add(81);
		}else
			c6ACount.add(0);
		
		if (model2.getValueAt(i, 80) != null
				&& model2.getValueAt(i, 80).toString().length() != 0) {
			c6ACount.add(80);
		}else
			c6ACount.add(0);
		
		c6ACount.add(0); //for 80D qualifying
		
		if (model2.getValueAt(i, 83) != null
				&& model2.getValueAt(i, 83).toString().length() != 0) {
			c6ACount.add(83);

		}else
			c6ACount.add(0);
		
		if (model2.getValueAt(i, 82) != null
				&& model2.getValueAt(i, 82).toString().length() != 0) {
			c6ACount.add(82);
		}else
			c6ACount.add(0);
		
		c6ACount.add(0); //for 80E qualifying
		
		if (model2.getValueAt(i, 86) != null
				&& model2.getValueAt(i, 86).toString().length() != 0) {
			c6ACount.add(86);
		}else
			c6ACount.add(0);
		
		if (model2.getValueAt(i, 84) != null
				&& model2.getValueAt(i, 84).toString().length() != 0) {
			c6ACount.add(84);
		}else
			c6ACount.add(0);
		
		if (model2.getValueAt(i, 85) != null
				&& model2.getValueAt(i, 85).toString().length() != 0) {
			c6ACount.add(85);
		}else
			c6ACount.add(0);
		
		if (model2.getValueAt(i, 89) != null
				&& model2.getValueAt(i, 89).toString().length() != 0) {
			c6ACount.add(89);

		}else
			c6ACount.add(0);
		
		if (model2.getValueAt(i, 87) != null
				&& model2.getValueAt(i, 87).toString().length() != 0) {
			c6ACount.add(87);
		}
		else
			c6ACount.add(0);
		
		if (model2.getValueAt(i, 88) != null
				&& model2.getValueAt(i, 88).toString().length() != 0) {
			c6ACount.add(88);
		}else
			c6ACount.add(0);
		
		//rahul CR84532 24Q added 80CCH and 80CCH(1) start
		if (model2.getValueAt(i, 96) != null
				&& model2.getValueAt(i, 96).toString().length() != 0) {
			c6ACount.add(96);
		}else
			c6ACount.add(0);
		
		if (model2.getValueAt(i, 95) != null
				&& model2.getValueAt(i, 95).toString().length() != 0) {
			c6ACount.add(95);
		}else
			c6ACount.add(0);
		
		c6ACount.add(0); //for 80CCH qualifying
		
		if (model2.getValueAt(i, 98) != null
				&& model2.getValueAt(i, 98).toString().length() != 0) {
			c6ACount.add(98);
		}else
			c6ACount.add(0);
		
		if (model2.getValueAt(i, 97) != null
				&& model2.getValueAt(i, 97).toString().length() != 0) {
			c6ACount.add(97);
		}else
			c6ACount.add(0);
		
		c6ACount.add(0); //for 80CCH(1) qualifying
		//rahul CR84532 24Q added 80CCH and 80CCH(1) end
					
	    c6aCount=0;
	    if(model2.getValueAt(i, 17) != null && !model2.getValueAt(i, 17).toString().isEmpty() && !model2.getValueAt(i, 17).toString().trim().equals("0.00")) 						{
		
			c6aCount++;
					
		}
		
		if(model2.getValueAt(i, 18) != null && !model2.getValueAt(i, 18).toString().isEmpty() && !model2.getValueAt(i, 18).toString().trim().equals("0.00"))
		{
			c6aCount++;
					
		}
		
		if(model2.getValueAt(i, 19) != null && !model2.getValueAt(i, 19).toString().isEmpty() && !model2.getValueAt(i, 19).toString().trim().equals("0.00"))
		{
			c6aCount++;
					
		}
		
		if((model2.getValueAt(i, 20) != null && !model2.getValueAt(i, 20).toString().isEmpty() &&  !model2.getValueAt(i, 20).toString().trim().equals("0.00")) 
				|| (model2.getValueAt(i, 91) != null && !model2.getValueAt(i, 91).toString().isEmpty() &&  !model2.getValueAt(i, 91).toString().trim().equals("0.00")) 
				|| (model2.getValueAt(i, 92) != null && !model2.getValueAt(i, 92).toString().isEmpty() && !model2.getValueAt(i, 92).toString().trim().equals("0.00")))

		{
			c6aCount++;
					
		}
		
		if((model2.getValueAt(i, 70) != null && !model2.getValueAt(i, 70).toString().isEmpty() && !model2.getValueAt(i, 70).toString().trim().equals("0.00")) 
				|| (model2.getValueAt(i, 71) != null && !model2.getValueAt(i, 71).toString().isEmpty() && !model2.getValueAt(i, 71).toString().trim().equals("0.00")) )

		{
			c6aCount++;
					
		}
		

		if((model2.getValueAt(i, 72) != null && !model2.getValueAt(i, 72).toString().isEmpty() && !model2.getValueAt(i, 72).toString().trim().equals("0.00")) 
				|| (model2.getValueAt(i, 73) != null && !model2.getValueAt(i, 73).toString().isEmpty() && !model2.getValueAt(i, 73).toString().trim().equals("0.00")) )

		{
			c6aCount++;
					
		}
		

		if((model2.getValueAt(i, 74) != null && !model2.getValueAt(i, 74).toString().isEmpty() && !model2.getValueAt(i, 74).toString().trim().equals("0.00")) 
				|| (model2.getValueAt(i, 75) != null && !model2.getValueAt(i, 75).toString().isEmpty() && !model2.getValueAt(i, 75).toString().trim().equals("0.00")) )								
		{
			c6aCount++;
					
		}
		

		if((model2.getValueAt(i, 76) != null && !model2.getValueAt(i, 76).toString().isEmpty() && !model2.getValueAt(i, 76).toString().trim().equals("0.00")) 
				|| (model2.getValueAt(i, 77) != null && !model2.getValueAt(i, 77).toString().isEmpty() && !model2.getValueAt(i, 77).toString().trim().equals("0.00")) )
		{
			c6aCount++;
					
		}
		
		if((model2.getValueAt(i, 78) != null && !model2.getValueAt(i, 78).toString().isEmpty() && !model2.getValueAt(i, 78).toString().trim().equals("0.00")) 
				|| (model2.getValueAt(i, 79) != null && !model2.getValueAt(i, 79).toString().isEmpty() && !model2.getValueAt(i, 79).toString().trim().equals("0.00")) )
		{
			c6aCount++;
					
		}
		if((model2.getValueAt(i, 80) != null && !model2.getValueAt(i, 80).toString().isEmpty() && !model2.getValueAt(i, 80).toString().trim().equals("0.00")) 
				|| (model2.getValueAt(i, 81) != null && !model2.getValueAt(i, 81).toString().isEmpty() && !model2.getValueAt(i, 81).toString().trim().equals("0.00")) )
		{
			c6aCount++;
					
		}
		if((model2.getValueAt(i, 82) != null && !model2.getValueAt(i, 82).toString().isEmpty() && !model2.getValueAt(i, 82).toString().trim().equals("0.00")) 
				|| (model2.getValueAt(i, 83) != null && !model2.getValueAt(i, 83).toString().isEmpty() && !model2.getValueAt(i, 83).toString().trim().equals("0.00")) )
		{
			c6aCount++;
					
		}

		if((model2.getValueAt(i, 84) != null && !model2.getValueAt(i, 84).toString().isEmpty() && !model2.getValueAt(i, 84).toString().trim().equals("0.00")) 
				|| (model2.getValueAt(i, 85) != null && !model2.getValueAt(i, 85).toString().isEmpty() && !model2.getValueAt(i, 85).toString().trim().equals("0.00")) 
				|| (model2.getValueAt(i, 86) != null && !model2.getValueAt(i, 86).toString().isEmpty() && !model2.getValueAt(i, 86).toString().trim().equals("0.00")))
		{
			c6aCount++;
					
		}
		
		if((model2.getValueAt(i, 87) != null && !model2.getValueAt(i, 87).toString().isEmpty() && !model2.getValueAt(i, 87).toString().trim().equals("0.00")) 
				|| (model2.getValueAt(i, 88) != null && !model2.getValueAt(i, 88).toString().isEmpty() && !model2.getValueAt(i, 88).toString().trim().equals("0.00")) 
				|| (model2.getValueAt(i, 89) != null && !model2.getValueAt(i, 89).toString().isEmpty() &&  !model2.getValueAt(i, 89).toString().trim().equals("0.00")))

		{
			c6aCount++;
					
		}
		
		//rahul CR84532 24Q added 80CCH and 80CCH(1) start
		if((model2.getValueAt(i, 95) != null && !model2.getValueAt(i, 95).toString().isEmpty() && !model2.getValueAt(i, 95).toString().trim().equals("0.00")) 
				|| (model2.getValueAt(i, 96) != null && !model2.getValueAt(i, 96).toString().isEmpty() && !model2.getValueAt(i, 96).toString().trim().equals("0.00")) )
		{
			c6aCount++;
					
		}
		
		if((model2.getValueAt(i, 97) != null && !model2.getValueAt(i, 97).toString().isEmpty() && !model2.getValueAt(i, 97).toString().trim().equals("0.00")) 
				|| (model2.getValueAt(i, 98) != null && !model2.getValueAt(i, 98).toString().isEmpty() && !model2.getValueAt(i, 98).toString().trim().equals("0.00")) )
		{
			c6aCount++;
					
		}
		//rahul CR84532 24Q added 80CCH and 80CCH(1) end
		
		
		/*sd.setCountofSalaryDetails_ChapterVIA_Detail(new Integer(c6ACount
				.size()).toString());*/
		
		System.out.println("c6aCount:" +c6aCount);
		sd.setCountofSalaryDetails_ChapterVIA_Detail(""+c6aCount);
		//RPU 2.9 end
		
		if (model2.getValueAt(i, 21) != null
				&& model2.getValueAt(i, 21).toString().length() != 0) {
			sd.setGrossTotalofAmountdeductibleunderprovisionsofchapterVI_A(model2
					.getValueAt(i, 21).toString());
		}

		if (model2.getValueAt(i, 22) != null
				&& model2.getValueAt(i, 22).toString().length() != 0) {
			sd.setTotalTaxableIncome(model2.getValueAt(i, 22).toString());
		}

		if (model2.getValueAt(i, 23) != null
				&& model2.getValueAt(i, 23).toString().length() != 0) {
			sd.setIncomeTaxonTotalIncome(model2.getValueAt(i, 23).toString());
		}

		if (model2.getValueAt(i, 24) != null
				&& model2.getValueAt(i, 24).toString().length() != 0) {
			sd.setSurcharge(model2.getValueAt(i, 24).toString());
		}

		if (model2.getValueAt(i, 25) != null
				&& model2.getValueAt(i, 25).toString().length() != 0) {
			sd.setEducationCess(model2.getValueAt(i, 25).toString());
		}

		if (model2.getValueAt(i, 26) != null
				&& model2.getValueAt(i, 26).toString().length() != 0) {
			sd.setIncomeTaxRelief(model2.getValueAt(i, 26).toString());
		}

		if (model2.getValueAt(i, 27) != null
				&& model2.getValueAt(i, 27).toString().length() != 0) {
			sd.setNetIncomeTaxpayable(model2.getValueAt(i, 27).toString());
		}

		if (model2.getValueAt(i, 30) != null
				&& model2.getValueAt(i, 30).toString().length() != 0) {
			sd.setTotalamountoftaxdeductedatsourceforthewholeyear(model2
					.getValueAt(i, 30).toString());
		}

		if (model2.getValueAt(i, 31) != null
				&& model2.getValueAt(i, 31).toString().length() != 0) {
			sd.setShortfallintaxdeductionExcesstaxdeduction(model2.getValueAt(
					i, 31).toString());
		}

		if (model2.getValueAt(i, 8) != null
				&& model2.getValueAt(i, 8).toString().length() != 0) {
			sd.setTaxableAmountonwhichtaxisdeductedbythecurrentemployer(model2
					.getValueAt(i, 8).toString());
		}

		if (model2.getValueAt(i, 9) != null
				&& model2.getValueAt(i, 9).toString().length() != 0) {
			sd.setReportedTaxableAmountonwhichtaxisdeductedbypreviousemployer(model2
					.getValueAt(i, 9).toString());
		}

		if (model2.getValueAt(i, 28) != null
				&& model2.getValueAt(i, 28).toString().length() != 0) {
			sd.setTotalAmountoftaxdeductedatsourcebythecurrentemployerforthewholeyear(model2
					.getValueAt(i, 28).toString());
		}

		if (model2.getValueAt(i, 29) != null
				&& model2.getValueAt(i, 29).toString().length() != 0) {
			sd.setReportedamountofTaxdeductedatsourcebypreviousemployer(model2
					.getValueAt(i, 29).toString());
		}

		if ((model2.getValueAt(i, 32) != null && !model2.getValueAt(i, 32).toString().contains("Select") && !model2.getValueAt(i, 32).toString().equals(""))
				&& !(Integer.parseInt(rpu.finyear.substring(0, 4)) < 2013)) {
			sd.setWhethertaxdeductedatHigherrate(model2.getValueAt(i, 32)
					.toString().substring(0,1));
		}
		
		//newly added for FRD1.6 by akansha
		//System.out.println("Fin year:"+rpu.finyear+" Mode:"+sd.getMode());
		if(Integer.parseInt(rpu.finyear.substring(0, 4)) >= 2016){
			
			if(model2.getValueAt(i,33)!=null && !model2.getValueAt(i,33).toString().contains("Select")){
				sd.setWhetherhouserentallowanceclaim(model2.getValueAt(i,33).toString().substring(0,1));
			}
			

			if(model2.getValueAt(i,33)!=null && !model2.getValueAt(i,33).toString().contains("Select")
					&& !model2.getValueAt(i,33).toString().contains("No")){
				
				
				
				if (model2.getValueAt(i, 34) != null
						&& model2.getValueAt(i, 34).toString().length() != 0) {

					// newly changed for taking column value, FRD1.9 on 19/01/17
					//System.out.println("File appender ka value hai :"+ model2.getValueAt(i, 34));
					if(model2.getValueAt(i, 34).toString().equals("--Select--") || 
							model2.getValueAt(i, 34).toString().equals("--SELECT--") || 
							model2.getValueAt(i, 34).toString().equals("")){
						sd.setPanofLandlord1(null);
					}else{
						if (model2
								.getValueAt(i, 34)
								.toString()
								.equals("Payment made to Government organization (Central/State only)")) {
							sd.setPanofLandlord1("GOVERNMENT");

							System.out.println("File appender ka value hai :");

						} else if (model2.getValueAt(i, 34).toString()
								.equals("Payment made to Non-resident")) {
							sd.setPanofLandlord1("NONRESDENT");

						} else if (model2
								.getValueAt(i, 34)
								.toString()
								.equals("Payment made to Other than Government organization and Non-resident")) {
							sd.setPanofLandlord1("OTHERVALUE");
						}

						else {
							sd.setPanofLandlord1(model2.getValueAt(i, 34).toString());
						}
						countPANLandLord++;
					}
				}
				
				
				
				if(model2.getValueAt(i,35)!=null && model2.getValueAt(i,35).toString().length() != 0){
					sd.setNameofLandlord1(model2.getValueAt(i, 35).toString());
					
				}
				
				
				if(model2.getValueAt(i,36)!=null && model2.getValueAt(i,36).toString().length() != 0){
					
					//newly changed for taking column value, FRD1.9 on 19/01/17
					if(model2.getValueAt(i, 36).toString().equals("--Select--") || 
							model2.getValueAt(i, 36).toString().equals("--SELECT--") || 
							model2.getValueAt(i, 36).toString().equals("")){
						sd.setPanofLandlord2(null);
					}else{
						if (model2
								.getValueAt(i, 36)
								.toString()
								.equals("Payment made to Government organization (Central/State only)")) {
							sd.setPanofLandlord2("GOVERNMENT");

						} else if (model2.getValueAt(i, 36).toString()
								.equals("Payment made to Non-resident")) {
							sd.setPanofLandlord2("NONRESDENT");

						} else if (model2
								.getValueAt(i, 36)
								.toString()
								.equals("Payment made to Other than Government organization and Non-resident")) {
							sd.setPanofLandlord2("OTHERVALUE");
						}

						else {
							sd.setPanofLandlord2(model2.getValueAt(i, 36)
									.toString());
						}
						countPANLandLord++;
					}
					/*if (model2
							.getValueAt(i, 36)
							.toString()
							.equals("Payment made to Government organization (Central/State only)")) {
						sd.setPanofLandlord2("GOVERNMENT");

					} else if (model2.getValueAt(i, 36).toString()
							.equals("Payment made to Non-resident")) {
						sd.setPanofLandlord2("NONRESDENT");

					} else if (model2
							.getValueAt(i, 36)
							.toString()
							.equals("Payment made to Other than Government organization and Non-resident")) {
						sd.setPanofLandlord2("OTHERVALUE");
					}

					else {
						sd.setPanofLandlord2(model2.getValueAt(i, 36)
								.toString());
					}*/
					//**********************************************
					//sd.setPanofLandlord2(model2.getValueAt(i, 36).toString());
					//countPANLandLord++;
				}
				
				if(model2.getValueAt(i,37)!=null && model2.getValueAt(i,37).toString().length() != 0){
					sd.setNameofLandlord2(model2.getValueAt(i, 37).toString());
					
				}
				
				
				if(model2.getValueAt(i,38)!=null && model2.getValueAt(i,38).toString().length() != 0){
					
					//newly changed for taking column value, FRD1.9 on 19/01/17
					if(model2.getValueAt(i, 38).toString().equals("--Select--") || 
							model2.getValueAt(i, 38).toString().equals("--SELECT--") || 
							model2.getValueAt(i, 38).toString().equals("")){
						sd.setPanofLandlord3(null);
					}else{
						if (model2
								.getValueAt(i, 38)
								.toString()
								.equals("Payment made to Government organization (Central/State only)")) {
							sd.setPanofLandlord3("GOVERNMENT");

						} else if (model2.getValueAt(i, 38).toString()
								.equals("Payment made to Non-resident")) {
							sd.setPanofLandlord3("NONRESDENT");

						} else if (model2
								.getValueAt(i, 38)
								.toString()
								.equals("Payment made to Other than Government organization and Non-resident")) {
							sd.setPanofLandlord3("OTHERVALUE");
						}

						else {
							sd.setPanofLandlord3(model2.getValueAt(i, 38)
									.toString());
						}
						countPANLandLord++;
					}
					/*if (model2
							.getValueAt(i, 38)
							.toString()
							.equals("Payment made to Government organization (Central/State only)")) {
						sd.setPanofLandlord3("GOVERNMENT");

					} else if (model2.getValueAt(i, 38).toString()
							.equals("Payment made to Non-resident")) {
						sd.setPanofLandlord3("NONRESDENT");

					} else if (model2
							.getValueAt(i, 38)
							.toString()
							.equals("Payment made to Other than Government organization and Non-resident")) {
						sd.setPanofLandlord3("OTHERVALUE");
					}

					else {
						sd.setPanofLandlord3(model2.getValueAt(i, 38)
								.toString());
					}
					countPANLandLord++;*/
				}
				
				if(model2.getValueAt(i,39)!=null && model2.getValueAt(i,39).toString().length() != 0){
					sd.setNameofLandlord3(model2.getValueAt(i, 39).toString());
					
				}
				
				if(model2.getValueAt(i,40)!=null && model2.getValueAt(i,40).toString().length() != 0){
					
					//newly changed for taking column value, FRD1.9 on 19/01/17
					if(model2.getValueAt(i, 40).toString().equals("--Select--") || 
							model2.getValueAt(i, 40).toString().equals("--SELECT--") || 
							model2.getValueAt(i, 40).toString().equals("")){
						sd.setPanofLandlord4(null);
					}else{
						if (model2
								.getValueAt(i, 40)
								.toString()
								.equals("Payment made to Government organization (Central/State only)")) {
							sd.setPanofLandlord4("GOVERNMENT");

						} else if (model2.getValueAt(i, 40).toString()
								.equals("Payment made to Non-resident")) {
							sd.setPanofLandlord4("NONRESDENT");

						} else if (model2
								.getValueAt(i, 40)
								.toString()
								.equals("Payment made to Other than Government organization and Non-resident")) {
							sd.setPanofLandlord4("OTHERVALUE");
						}

						else {
							sd.setPanofLandlord4(model2.getValueAt(i, 40)
									.toString());
						}
						countPANLandLord++;
					}
					/*if (model2
							.getValueAt(i, 40)
							.toString()
							.equals("Payment made to Government organization (Central/State only)")) {
						sd.setPanofLandlord4("GOVERNMENT");

					} else if (model2.getValueAt(i, 40).toString()
							.equals("Payment made to Non-resident")) {
						sd.setPanofLandlord4("NONRESDENT");

					} else if (model2
							.getValueAt(i, 40)
							.toString()
							.equals("Payment made to Other than Government organization and Non-resident")) {
						sd.setPanofLandlord4("OTHERVALUE");
					}

					else {
						sd.setPanofLandlord4(model2.getValueAt(i, 40)
								.toString());
					}
					countPANLandLord++;*/
				}
				
				if(model2.getValueAt(i,41)!=null && model2.getValueAt(i,41).toString().length() != 0){
					sd.setNameofLandlord4(model2.getValueAt(i, 41).toString());
					
				}
				
				
					
			}
			sd.setCountofPANoftheLandLord(String.valueOf(countPANLandLord));
			
			if(model2.getValueAt(i,42)!=null && !model2.getValueAt(i,42).toString().contains("Select")){
				sd.setWhetherInterestPaidtotheLender(model2.getValueAt(i,42).toString().substring(0,1));
			}
			
			if(model2.getValueAt(i,42)!=null && !model2.getValueAt(i,42).toString().contains("Select")
					&& !model2.getValueAt(i,42).toString().contains("No")){
			
				if(model2.getValueAt(i,43)!=null && model2.getValueAt(i,43).toString().length() != 0){
					//newly changed for taking column value, Added by Sadhana, FRD2.0 on 04/10/2017
					if(model2.getValueAt(i, 43).toString().equals("--Select--") || 
							model2.getValueAt(i, 43).toString().equals("--SELECT--") || 
							model2.getValueAt(i, 43).toString().equals("")){
						sd.setDeductionOfInterestUnderHeadIncomePANofLender1(null);
					}else{
						if (model2
								.getValueAt(i, 43)
								.toString()
								.equals("Payment made to Government organization (Central/State only)")) {
							sd.setDeductionOfInterestUnderHeadIncomePANofLender1("GOVERNMENT");

						} else if (model2.getValueAt(i, 43).toString()
								.equals("Payment made to Non-resident")) {
							sd.setDeductionOfInterestUnderHeadIncomePANofLender1("NONRESDENT");

						} else if (model2
								.getValueAt(i, 43)
								.toString()
								.equals("Payment made to Other than Government organization and Non-resident")) {
							sd.setDeductionOfInterestUnderHeadIncomePANofLender1("OTHERVALUE");
						}

						else {
							sd.setDeductionOfInterestUnderHeadIncomePANofLender1(model2.getValueAt(i, 43)
									.toString());
						}
						countPANLender++;
					}
				}
				
				if(model2.getValueAt(i,44)!=null && model2.getValueAt(i,44).toString().length() != 0){
					sd.setDeductionOfInterestUnderHeadIncomeNameofLender1(model2.getValueAt(i, 44).toString());
					
				}
				
				
				
				if(model2.getValueAt(i,45)!=null && model2.getValueAt(i,45).toString().length() != 0){
					//newly changed for taking column value, Added by Sadhana, FRD2.0 on 04/10/2017
					if(model2.getValueAt(i, 45).toString().equals("--Select--") || 
							model2.getValueAt(i, 45).toString().equals("--SELECT--") || 
							model2.getValueAt(i, 45).toString().equals("")){
						sd.setDeductionOfInterestUnderHeadIncomePANofLender2(null);
					}else{
						if (model2
								.getValueAt(i, 45)
								.toString()
								.equals("Payment made to Government organization (Central/State only)")) {
							sd.setDeductionOfInterestUnderHeadIncomePANofLender2("GOVERNMENT");

						} else if (model2.getValueAt(i, 45).toString()
								.equals("Payment made to Non-resident")) {
							sd.setDeductionOfInterestUnderHeadIncomePANofLender2("NONRESDENT");

						} else if (model2
								.getValueAt(i, 45)
								.toString()
								.equals("Payment made to Other than Government organization and Non-resident")) {
							sd.setDeductionOfInterestUnderHeadIncomePANofLender2("OTHERVALUE");
						}

						else {
							sd.setDeductionOfInterestUnderHeadIncomePANofLender2(model2.getValueAt(i, 45)
									.toString());
						}
						countPANLender++;
					}
					/*if (model2
							.getValueAt(i, 45)
							.toString()
							.equals("Payment made to Government organization (Central/State only)")) {
						sd.setDeductionOfInterestUnderHeadIncomePANofLender2("GOVERNMENT");

					} else if (model2.getValueAt(i, 45).toString()
							.equals("Payment made to Non-resident")) {
						sd.setDeductionOfInterestUnderHeadIncomePANofLender2("NONRESDENT");

					} else if (model2
							.getValueAt(i, 45)
							.toString()
							.equals("Payment made to Other than Government organization and Non-resident")) {
						sd.setDeductionOfInterestUnderHeadIncomePANofLender2("OTHERVALUE");
					}

					else {
						sd.setDeductionOfInterestUnderHeadIncomePANofLender2(model2.getValueAt(i, 45)
								.toString());
					}
					//sd.setDeductionOfInterestUnderHeadIncomePANofLender2(model2.getValueAt(i, 45).toString());
					countPANLender++;*/
				}
				
				if(model2.getValueAt(i,46)!=null && model2.getValueAt(i,46).toString().length() != 0){
					sd.setDeductionOfInterestUnderHeadIncomeNameofLender2(model2.getValueAt(i, 46).toString());
					
				}
				
				
				if(model2.getValueAt(i,47)!=null && model2.getValueAt(i,47).toString().length() != 0){
					//newly changed for taking column value, Added by Sadhana, FRD2.0 on 04/10/2017
					if(model2.getValueAt(i, 47).toString().equals("--Select--") || 
							model2.getValueAt(i, 47).toString().equals("--SELECT--") || 
							model2.getValueAt(i, 47).toString().equals("")){
						sd.setDeductionOfInterestUnderHeadIncomePANofLender3(null);
					}else{
						if (model2
								.getValueAt(i, 47)
								.toString()
								.equals("Payment made to Government organization (Central/State only)")) {
							sd.setDeductionOfInterestUnderHeadIncomePANofLender3("GOVERNMENT");

						} else if (model2.getValueAt(i, 47).toString()
								.equals("Payment made to Non-resident")) {
							sd.setDeductionOfInterestUnderHeadIncomePANofLender3("NONRESDENT");

						} else if (model2
								.getValueAt(i, 47)
								.toString()
								.equals("Payment made to Other than Government organization and Non-resident")) {
							sd.setDeductionOfInterestUnderHeadIncomePANofLender3("OTHERVALUE");
						}

						else {
							sd.setDeductionOfInterestUnderHeadIncomePANofLender3(model2.getValueAt(i, 47)
									.toString());
						}
						countPANLender++;
					}
				}
				
				if(model2.getValueAt(i,48)!=null && model2.getValueAt(i,48).toString().length() != 0){
					sd.setDeductionOfInterestUnderHeadIncomeNameofLender3(model2.getValueAt(i, 48).toString());
					
				}
				
				if(model2.getValueAt(i,49)!=null && model2.getValueAt(i,49).toString().length() != 0){
					//newly changed for taking column value, Added by Sadhana, FRD2.0 on 04/10/2017
					if(model2.getValueAt(i, 49).toString().equals("--Select--") || 
							model2.getValueAt(i, 49).toString().equals("--SELECT--") || 
							model2.getValueAt(i, 49).toString().equals("")){
						sd.setDeductionOfInterestUnderHeadIncomePANofLender4(null);
					}else{
						if (model2
								.getValueAt(i, 49)
								.toString()
								.equals("Payment made to Government organization (Central/State only)")) {
							sd.setDeductionOfInterestUnderHeadIncomePANofLender4("GOVERNMENT");

						} else if (model2.getValueAt(i, 49).toString()
								.equals("Payment made to Non-resident")) {
							sd.setDeductionOfInterestUnderHeadIncomePANofLender4("NONRESDENT");

						} else if (model2
								.getValueAt(i, 49)
								.toString()
								.equals("Payment made to Other than Government organization and Non-resident")) {
							sd.setDeductionOfInterestUnderHeadIncomePANofLender4("OTHERVALUE");
						}

						else {
							sd.setDeductionOfInterestUnderHeadIncomePANofLender4(model2.getValueAt(i, 49)
									.toString());
						}
						countPANLender++;
					}
				}
				
				if(model2.getValueAt(i,50)!=null && model2.getValueAt(i,50).toString().length() != 0){
					sd.setDeductionOfInterestUnderHeadIncomeNameofLender4(model2.getValueAt(i, 50).toString());
				}
			}
			sd.setCountofPANoftheLender(String.valueOf(countPANLender));
		}
		
		//newly added for revised FRD1.6 by akansha
		if(Integer.parseInt(rpu.finyear.substring(0, 4)) >= 2013){
			if(model2.getValueAt(i,51)!=null && !model2.getValueAt(i,51).toString().contains("Select")){
				sd.setWhetherContributionsPaidByTrustees(model2.getValueAt(i,51).toString().substring(0,1));
			}
			
			if(model2.getValueAt(i,51)!=null && !model2.getValueAt(i,51).toString().contains("Select")
					&& !model2.getValueAt(i,51).toString().contains("No")){
				if(model2.getValueAt(i,52)!=null && model2.getValueAt(i,52).toString().length()!=0){
					sd.setNameOfSuperAnnuationFund(model2.getValueAt(i,52).toString());
				}
				
				if(model2.getValueAt(i,53)!=null && model2.getValueAt(i,53).toString().length()!=0){
					sd.setDateFromWhichEmpContrSuperAnnFund(model2.getValueAt(i,53).toString().replaceAll("/", ""));
				}
				
				if(model2.getValueAt(i,54)!=null && model2.getValueAt(i,54).toString().length()!=0){
					sd.setDateToWhichEmpContrSuperAnnFund(model2.getValueAt(i,54).toString().replaceAll("/", ""));
				}
				
				if(model2.getValueAt(i,55)!=null && model2.getValueAt(i,55).toString().length()!=0){
					sd.setAmountOfContrRepaidPI(model2.getValueAt(i,55).toString());
				}
				if(model2.getValueAt(i,56)!=null && model2.getValueAt(i,56).toString().length()!=0){
					sd.setAvgRateOfDedTaxPrecedingThreeYears(model2.getValueAt(i,56).toString());
				}
				if(model2.getValueAt(i,57)!=null && model2.getValueAt(i,57).toString().length()!=0){
					sd.setAmountOfTaxDeductedRepayment(model2.getValueAt(i,57).toString());
				}
				if(model2.getValueAt(i,58)!=null && model2.getValueAt(i,58).toString().length()!=0){
					sd.setGrossTotalIncomeContrPISuperAnnuation(model2.getValueAt(i,58).toString());
				}
			}
		}
		/****************** Added for 2.7 Start ********************/
		
		if(Integer.parseInt(rpu.finyear.substring(0, 4)) >= 2018){
			
			if (model2.getValueAt(i, 71) != null
					&& model2.getValueAt(i, 71).toString().length() != 0) {
				temp80C80CCCand80CCD = Double.parseDouble(model2.getValueAt(
						i, 71).toString());
			}
			
			if (model2.getValueAt(i, 73) != null
					&& model2.getValueAt(i, 73).toString().length() != 0) {
				temp80C80CCCand80CCD = temp80C80CCCand80CCD + Double.parseDouble(model2.getValueAt(
						i, 73).toString());
			}
			
			if (model2.getValueAt(i, 75) != null
					&& model2.getValueAt(i, 75).toString().length() != 0) {
				temp80C80CCCand80CCD = temp80C80CCCand80CCD + Double.parseDouble(model2.getValueAt(
						i, 75).toString());
			}
			
			sd.setAggregateamountofdeductionsadmissibleundersection80C80CCCand80CCD(Double.toString(temp80C80CCCand80CCD));
			
			if(model2.getValueAt(i,59)!=null && model2.getValueAt(i,59).toString().length()!=0){
				sd.setGrossSalaryAsPerSec17_1(model2.getValueAt(i,59).toString());
			}
			if(model2.getValueAt(i,60)!=null && model2.getValueAt(i,60).toString().length()!=0){
				sd.setValueOfPerquisiteAsPerSec17_2(model2.getValueAt(i,60).toString());
			}
			if(model2.getValueAt(i,61)!=null && model2.getValueAt(i,61).toString().length()!=0){
				sd.setProfitsInLieuOfSalaryAsPerSec17_3(model2.getValueAt(i,61).toString());
			}
			if(model2.getValueAt(i,62)!=null && model2.getValueAt(i,62).toString().length()!=0){
				sd.setTravelConcession(model2.getValueAt(i,62).toString());
			}
			if(model2.getValueAt(i,63)!=null && model2.getValueAt(i,63).toString().length()!=0){
				sd.setDeathCumRetirementGratuity(model2.getValueAt(i,63).toString());
			}
			if(model2.getValueAt(i,64)!=null && model2.getValueAt(i,64).toString().length()!=0){
				sd.setCommutedValueOfPension(model2.getValueAt(i,64).toString());
			}
			if(model2.getValueAt(i,65)!=null && model2.getValueAt(i,65).toString().length()!=0){
				sd.setCashEquivalentOfLeaveSalary(model2.getValueAt(i,65).toString());
			}
			if(model2.getValueAt(i,66)!=null && model2.getValueAt(i,66).toString().length()!=0){
				sd.setHRA(model2.getValueAt(i,66).toString());
			}
			if(model2.getValueAt(i,67)!=null && model2.getValueAt(i,67).toString().length()!=0){
				sd.setAmountOfAnyOtherExemption(model2.getValueAt(i,67).toString());
			}
			if(model2.getValueAt(i,68)!=null && model2.getValueAt(i,68).toString().length()!=0){
				sd.setTotalAmountOfExemption(model2.getValueAt(i,68).toString());
			}
			if(model2.getValueAt(i,69)!=null && model2.getValueAt(i,69).toString().length()!=0){
				sd.setIncomeUnderTheHead(model2.getValueAt(i,69).toString());
			}
			
			if(model2.getValueAt(i,90)!=null && model2.getValueAt(i,90).toString().length()!=0){
				sd.setRebateUnderSection87A(model2.getValueAt(i,90).toString());
			}
			if(model2.getValueAt(i,93)!=null && !model2.getValueAt(i,93).toString().contains("Select")){
				sd.setWhetheroptingfornewtax(model2.getValueAt(i,93).toString().substring(0,1));//RPU 3.6 changes to set value Y N for column 93 regular
			}
			//rahul CR84532 24Q Addition of column 346A start
			if(model2.getValueAt(i,94)!=null && model2.getValueAt(i,94).toString().length()!=0){
				sd.setOtherSpecialAllowancesUnderSection10_14(model2.getValueAt(i,94).toString());
			}
			//rahul CR84532 24Q Addition of column 346A end
			
			// rahul CR 88008 new column added for Annex 2 start
			if(model2.getValueAt(i,99)!=null && model2.getValueAt(i,99).toString().length()!=0){
				sd.setAmtReportedAsperSec1922B(model2.getValueAt(i,99).toString());
			}
			// rahul CR 88008 new column added for Annex 2 end
			
			/*//Added by renuka for CR84532 addition of column 365A
			if(model2.getValueAt(i,95)!=null && model2.getValueAt(i,95).toString().length()!=0){
				sd.setOtherSpecialAllowancesUnderSection10_14(model2.getValueAt(i,95).toString());
			}
			//Added by renuka for CR84532 addition of column 365A
			//Added by renuka for CR84532 addition of column 365B
			if(model2.getValueAt(i,96)!=null && model2.getValueAt(i,96).toString().length()!=0){
				sd.setOtherSpecialAllowancesUnderSection10_14(model2.getValueAt(i,96).toString());
			}
			//Added by renuka for CR84532 addition of column 365B
			//Added by renuka for CR84532 addition of column 366A
			if(model2.getValueAt(i,97)!=null && model2.getValueAt(i,97).toString().length()!=0){
				sd.setOtherSpecialAllowancesUnderSection10_14(model2.getValueAt(i,97).toString());
			}
			//Added by renuka for CR84532 addition of column 366A
			//Added by renuka for CR84532 addition of column 366B
			if(model2.getValueAt(i,98)!=null && model2.getValueAt(i,98).toString().length()!=0){
				sd.setOtherSpecialAllowancesUnderSection10_14(model2.getValueAt(i,98).toString());
			}
			//Added by renuka for CR84532 addition of column 366B
*/		
		}
		/****************** Added for 2.7 End ********************/
		//**************************************************************
		
		//*********************************************************************
		
		return sd;

	}

	/**
	 * Deprecated Method initially used for assigning values to S16 Bean
	 * @param sb
	 * @param sd
	 * @param inneri
	 * @param i
	 * @param serialnumber
	 * @return
	 */
	public S16Bean _S16Appender(StringBuilder sb, SDBean sd, int inneri, int i,
			int serialnumber) {

		S16Bean s16 = new S16Bean();

		s16.setLineNumber(CountOccurence(sb.toString(), "\n").toString());
		s16.setRecordType("S16");
		s16.setBatchNumber(CountOccurence(sb.toString(), "^BH^").toString());
		s16.setSalaryDetailRecordNo(sd.getSalaryDetailsRecordNo());
		s16.setSalaryDetailSection16DetailsRecordNo(new Integer(serialnumber)
				.toString());

		if (inneri == 11) {
			s16.setSection16sectionID("16(ii)");
		} else if (inneri == 12) {
			s16.setSection16sectionID("16(iii)");
		}

		if (model2.getValueAt(i, inneri) != null
				&& model2.getValueAt(i, inneri).toString().length() != 0) {
			s16.setTotalDeductionunderSection16(model2.getValueAt(i, inneri)
					.toString());
		}

		return s16;

	}

	/**
	 * Method currently used for assigning values to S16 Bean inorder for fast processing
	 * @param ls
	 * @param bhCounter
	 * @param sd
	 * @param inneri
	 * @param i
	 * @param serialnumber
	 * @return
	 */
	public S16Bean _S16Appender(ArrayList<Object> ls, int bhCounter, SDBean sd,
			int inneri, int i, int serialnumber) {

		S16Bean s16 = new S16Bean();

		s16.setLineNumber("" + (ls.size() + 1));
		s16.setRecordType("S16");
		s16.setBatchNumber("" + bhCounter);
		s16.setSalaryDetailRecordNo(sd.getSalaryDetailsRecordNo());
		s16.setSalaryDetailSection16DetailsRecordNo(new Integer(serialnumber)
				.toString());

		if (inneri == 11) {
			s16.setSection16sectionID("16(ii)");
		} else if (inneri == 12) {
			s16.setSection16sectionID("16(iii)");
		}
		/*********************************************************/				
		//FRD 2.3 added 16(ia)
		else if (inneri == 13) {
			s16.setSection16sectionID("16(ia)");
		}
		/*********************************************************/
		

		if (model2.getValueAt(i, inneri) != null
				&& model2.getValueAt(i, inneri).toString().length() != 0) {
			s16.setTotalDeductionunderSection16(model2.getValueAt(i, inneri)
					.toString());
		}

		return s16;

	}



	/**
	 *  Method currently used for assigning values to C6A Bean for fast processing
	 * @param ls
	 * @param bhCounter
	 * @param sd
	 * @param c6a
	 * @param i
	 * @param serialnumber
	 * @return
	 */
	//RPU 2.9 start
	public C6ABean _C6Appender(List ls, int bhCounter, SDBean sd, 
			int i, int serialnumber) {
		
		C6ABean c6A = new C6ABean();

		c6A.setLineNumber("" + (ls.size() + 1));
		c6A.setRecordType("C6A");
		c6A.setBatchNumber("" + bhCounter);
		c6A.setSalaryDetailRecordNo(sd.getSalaryDetailsRecordNo());
		c6A.setSalaryDetailChapterVIADetailsRecordNo(new Integer(serialnumber)
				.toString());
		c6A.setChapterVIASectionID((String)Array.get(c6aString,c6aString_counter));
		
		if(!(c6ACount.get(c6ACount_counter)==0))
		{
			c6A.setDedamountunderChapterVIA(model2.getValueAt(i, c6ACount.get(c6ACount_counter)).toString());		
		}
		else
		c6A.setDedamountunderChapterVIA("");
		c6ACount_counter++;
		
		if(!(c6ACount.get(c6ACount_counter)==0))
		{
			c6A.setGrsamountunderChapterVIA(model2.getValueAt(i, c6ACount.get(c6ACount_counter)).toString());			
		}
		else
		c6A.setGrsamountunderChapterVIA("");
		c6ACount_counter++;
		
		if(!(c6ACount.get(c6ACount_counter)==0))
		{
			c6A.setQuaamountunderChapterVIA(model2.getValueAt(i, c6ACount.get(c6ACount_counter)).toString());
		}
		else
		c6A.setQuaamountunderChapterVIA("");
		c6ACount_counter++;
		
		
		return c6A;
	}
	
public Annex3_94PBean _94PAppender(List ls, int bhCounter, int i) {
		
	AnnexIII94P_S16Count.clear();
	AnnexIII_c6ACount.clear();
	

	Annex3_94PBean anneIII94P = new Annex3_94PBean();
	
	 totalDed16Anne3 = 0; 
    
	 ded16IIIAnne3 = 0;
	 ded16IAAnne3 = 0;
	 temp80C80CCCand80CCDAnne3=0;
	
	
		
		
	anneIII94P.setLineNumber("" + (ls.size() + 1));
	anneIII94P.setRecordType("94P");
	anneIII94P.setBatchNumber("" + bhCounter);

		if (model3.getValueAt(i, 1) != null
				&& model3.getValueAt(i, 1).toString().length() != 0) {
			anneIII94P.setDetailsRecordNo194P(model3.getValueAt(i, 1).toString());
		}

		anneIII94P.setMode("A");
		
		if (model3.getValueAt(i, 3) != null
				&& model3.getValueAt(i, 3).toString().length() != 0) {
			anneIII94P.setPANNo(model3.getValueAt(i, 3).toString());
		}

		if (model3.getValueAt(i, 4) != null
				&& model3.getValueAt(i, 4).toString().length() != 0) {
			anneIII94P.setNameofSeniorCitizen(model3.getValueAt(i, 4).toString());
		}

		if (model3.getValueAt(i, 5) != null
				&& model3.getValueAt(i, 5).toString().length() != 0
				&& !(model3.getValueAt(i, 5).toString().contains("Select"))) {

			anneIII94P.setCategoryofSeniorCitizen(GrpuUtil.getAnnex3EmployeeCode(model3
					.getValueAt(i, 5).toString()));
			
		}
			
			if(model3.getValueAt(i, 6)!=null && !model3.getValueAt(i, 6).toString().contains("Select")){
				anneIII94P.setWhetheroptingfornewtax(model3.getValueAt(i, 6).toString().substring(0,1));
			}
			
			if (model3.getValueAt(i, 7) != null
					&& model3.getValueAt(i, 7).toString().length() != 0) {
				anneIII94P.setGrossPensionSection17_1(model3
						.getValueAt(i, 7).toString());

			}
			
			if (model3.getValueAt(i, 8) != null
					&& !model3.getValueAt(i, 8).toString().equalsIgnoreCase("0")
					&& !model3.getValueAt(i, 8).toString().equalsIgnoreCase("0.0")
					&& !model3.getValueAt(i, 8).toString()
							.equalsIgnoreCase("0.00")
					&& model3.getValueAt(i, 8).toString().length() != 0) {

				AnnexIII94P_S16Count.add(8);

			}

			if (model3.getValueAt(i, 9) != null
					&& !model3.getValueAt(i, 9).toString().equalsIgnoreCase("0")
					&& !model3.getValueAt(i, 9).toString().equalsIgnoreCase("0.0")
					&& !model3.getValueAt(i, 9).toString()
							.equalsIgnoreCase("0.00")
					&& model3.getValueAt(i, 9).toString().length() != 0) {
				AnnexIII94P_S16Count.add(9);

			}
			
			anneIII94P.setCountofSection194PSection16DetailRecordsassociatedwithDeductee(new Integer(
					AnnexIII94P_S16Count.size()).toString());
			
			
			/*if (model3.getValueAt(i, 10) != null
					&& model3.getValueAt(i, 10).toString().length() != 0) {
				anneIII94P.setGrossTotalofTotalDeductionundersection16(model3
						.getValueAt(i, 10).toString());

			}*/
			
			if (model3.getValueAt(i, 8) != null && model3.getValueAt(i, 8).toString().length() != 0) {
				ded16IAAnne3 = Double.parseDouble(model3.getValueAt(i, 8).toString());
			}
			
			if (model3.getValueAt(i, 9) != null && model3.getValueAt(i, 9).toString().length() != 0) {
				ded16IIIAnne3 = Double.parseDouble(model3.getValueAt(i, 9).toString());
			}
			
			totalDed16Anne3 =  ded16IAAnne3 + ded16IIIAnne3;
			anneIII94P.setGrossTotalofTotalDeductionundersection16(Double.toString(totalDed16Anne3));
			
			
			if (model3.getValueAt(i, 11) != null
					&& model3.getValueAt(i, 11).toString().length() != 0) {
				anneIII94P.setIncomeundertheheadSalaries(model3
						.getValueAt(i, 11).toString());

			}
			
			if (model3.getValueAt(i, 12) != null
					&& model3.getValueAt(i, 12).toString().length() != 0) {
				anneIII94P.setInterestIncomeundertheothersourcespaidbythespecifiedbank(model3
						.getValueAt(i, 12).toString());

			}
			
			if (model3.getValueAt(i, 13) != null
					&& model3.getValueAt(i, 13).toString().length() != 0) {
				anneIII94P.setGrossTotalIncome(model3
						.getValueAt(i, 13).toString());

			}
			
			if (model3.getValueAt(i, 15) != null
					&& model3.getValueAt(i, 15).toString().length() != 0) {
				temp80C80CCCand80CCDAnne3 = Double.parseDouble(model3.getValueAt(
						i, 15).toString());
			}
			
			if (model3.getValueAt(i, 17) != null
					&& model3.getValueAt(i, 17).toString().length() != 0) {
				temp80C80CCCand80CCDAnne3 = temp80C80CCCand80CCDAnne3 + Double.parseDouble(model3.getValueAt(
						i, 17).toString());
			}
			
			if (model3.getValueAt(i, 19) != null
					&& model3.getValueAt(i, 19).toString().length() != 0) {
				temp80C80CCCand80CCDAnne3 = temp80C80CCCand80CCDAnne3 + Double.parseDouble(model3.getValueAt(
						i, 19).toString());
			}
			
			
			anneIII94P.setTotalDeductionus80C80CCCand80CCD1(Double.toString(temp80C80CCCand80CCDAnne3));
			
			/*if (model3.getValueAt(i, 20) != null
					&& model3.getValueAt(i, 20).toString().length() != 0) {
				anneIII94P.setTotalDeductionus80C80CCCand80CCD1(model3
						.getValueAt(i, 20).toString());

			}*/
			
			
			
//////////////////////////////////////P6A Start/////////////////////////////////////////////////////////
			
			int C6A_94P_Count = 0;
			
			
			if (model3.getValueAt(i, 14) != null
					&& model3.getValueAt(i, 14).toString().length() != 0
							&& !model3.getValueAt(i, 14).toString().equalsIgnoreCase("0")
							&& !model3.getValueAt(i, 14).toString().equalsIgnoreCase("0.0")
							&& !model3.getValueAt(i, 14).toString()
											.equalsIgnoreCase("0.00") || (model3.getValueAt(i, 15) != null
											&& model3.getValueAt(i, 15).toString().length() != 0
											&& !model3.getValueAt(i, 15).toString().equalsIgnoreCase("0")
											&& !model3.getValueAt(i, 15).toString().equalsIgnoreCase("0.0")
											&& !model3.getValueAt(i, 15).toString()
															.equalsIgnoreCase("0.00"))){
				
				C6A_94P_Count++;
			}
			
			
			
			if (model3.getValueAt(i, 16) != null
					&& model3.getValueAt(i, 16).toString().length() != 0
							&& !model3.getValueAt(i, 16).toString().equalsIgnoreCase("0")
							&& !model3.getValueAt(i, 16).toString().equalsIgnoreCase("0.0")
							&& !model3.getValueAt(i, 16).toString()
											.equalsIgnoreCase("0.00") || (model3.getValueAt(i, 17) != null
													&& model3.getValueAt(i, 17).toString().length() != 0
													&& !model3.getValueAt(i, 17).toString().equalsIgnoreCase("0")
													&& !model3.getValueAt(i, 17).toString().equalsIgnoreCase("0.0")
													&& !model3.getValueAt(i, 17).toString()
																	.equalsIgnoreCase("0.00"))){
				
				C6A_94P_Count++;
			}
			
			if (model3.getValueAt(i, 18) != null
					&& model3.getValueAt(i, 18).toString().length() != 0
							&& !model3.getValueAt(i, 18).toString().equalsIgnoreCase("0")
							&& !model3.getValueAt(i, 18).toString().equalsIgnoreCase("0.0")
							&& !model3.getValueAt(i, 18).toString()
											.equalsIgnoreCase("0.00") || (model3.getValueAt(i, 19) != null
													&& model3.getValueAt(i, 19).toString().length() != 0
													&& !model3.getValueAt(i, 19).toString().equalsIgnoreCase("0")
													&& !model3.getValueAt(i, 19).toString().equalsIgnoreCase("0.0")
													&& !model3.getValueAt(i, 19).toString()
																	.equalsIgnoreCase("0.00"))){
				
				C6A_94P_Count++;
			}
			
			
			if (model3.getValueAt(i, 21) != null
					&& model3.getValueAt(i, 21).toString().length() != 0
							&& !model3.getValueAt(i, 21).toString().equalsIgnoreCase("0")
							&& !model3.getValueAt(i, 21).toString().equalsIgnoreCase("0.0")
							&& !model3.getValueAt(i, 21).toString()
											.equalsIgnoreCase("0.00") || (model3.getValueAt(i, 22) != null
													&& model3.getValueAt(i, 22).toString().length() != 0
													&& !model3.getValueAt(i, 22).toString().equalsIgnoreCase("0")
													&& !model3.getValueAt(i, 22).toString().equalsIgnoreCase("0.0")
													&& !model3.getValueAt(i, 22).toString()
																	.equalsIgnoreCase("0.00"))){
				
				C6A_94P_Count++;
			}
			
			if (model3.getValueAt(i, 23) != null
					&& model3.getValueAt(i, 23).toString().length() != 0
							&& !model3.getValueAt(i, 23).toString().equalsIgnoreCase("0")
							&& !model3.getValueAt(i, 23).toString().equalsIgnoreCase("0.0")
							&& !model3.getValueAt(i, 23).toString()
											.equalsIgnoreCase("0.00") || (model3.getValueAt(i, 24) != null
													&& model3.getValueAt(i, 24).toString().length() != 0
													&& !model3.getValueAt(i, 24).toString().equalsIgnoreCase("0")
													&& !model3.getValueAt(i, 24).toString().equalsIgnoreCase("0.0")
													&& !model3.getValueAt(i, 24).toString()
																	.equalsIgnoreCase("0.00"))){
				
				C6A_94P_Count++;
			}
			
			if (model3.getValueAt(i, 25) != null
					&& model3.getValueAt(i, 25).toString().length() != 0
							&& !model3.getValueAt(i, 25).toString().equalsIgnoreCase("0")
							&& !model3.getValueAt(i, 25).toString().equalsIgnoreCase("0.0")
							&& !model3.getValueAt(i, 25).toString()
											.equalsIgnoreCase("0.00") || (model3.getValueAt(i, 26) != null
													&& model3.getValueAt(i, 26).toString().length() != 0
													&& !model3.getValueAt(i, 26).toString().equalsIgnoreCase("0")
													&& !model3.getValueAt(i, 26).toString().equalsIgnoreCase("0.0")
													&& !model3.getValueAt(i, 26).toString()
																	.equalsIgnoreCase("0.00"))){
				
				C6A_94P_Count++;
			}
			
			if (model3.getValueAt(i, 27) != null
					&& model3.getValueAt(i, 27).toString().length() != 0
							&& !model3.getValueAt(i, 27).toString().equalsIgnoreCase("0")
							&& !model3.getValueAt(i, 27).toString().equalsIgnoreCase("0.0")
							&& !model3.getValueAt(i, 27).toString()
											.equalsIgnoreCase("0.00") || (model3.getValueAt(i, 28) != null
													&& model3.getValueAt(i, 28).toString().length() != 0
													&& !model3.getValueAt(i, 28).toString().equalsIgnoreCase("0")
													&& !model3.getValueAt(i, 28).toString().equalsIgnoreCase("0.0")
													&& !model3.getValueAt(i, 28).toString()
																	.equalsIgnoreCase("0.00") || (model3.getValueAt(i, 29) != null
																			&& model3.getValueAt(i, 29).toString().length() != 0
																			&& !model3.getValueAt(i, 29).toString().equalsIgnoreCase("0")
																			&& !model3.getValueAt(i, 29).toString().equalsIgnoreCase("0.0")
																			&& !model3.getValueAt(i, 29).toString()
																							.equalsIgnoreCase("0.00")))){
				
				C6A_94P_Count++;
			}
			
			if (model3.getValueAt(i, 30) != null
					&& model3.getValueAt(i, 30).toString().length() != 0
							&& !model3.getValueAt(i, 30).toString().equalsIgnoreCase("0")
							&& !model3.getValueAt(i, 30).toString().equalsIgnoreCase("0.0")
							&& !model3.getValueAt(i, 30).toString()
											.equalsIgnoreCase("0.00") || (model3.getValueAt(i, 31) != null
													&& model3.getValueAt(i, 31).toString().length() != 0
													&& !model3.getValueAt(i, 31).toString().equalsIgnoreCase("0")
													&& !model3.getValueAt(i, 31).toString().equalsIgnoreCase("0.0")
													&& !model3.getValueAt(i, 31).toString()
																	.equalsIgnoreCase("0.00") || (model3.getValueAt(i, 32) != null
																			&& model3.getValueAt(i, 32).toString().length() != 0
																			&& !model3.getValueAt(i, 32).toString().equalsIgnoreCase("0")
																			&& !model3.getValueAt(i, 32).toString().equalsIgnoreCase("0.0")
																			&& !model3.getValueAt(i, 32).toString()
																							.equalsIgnoreCase("0.00")))){
				
				C6A_94P_Count++;
			}
			
			if (model3.getValueAt(i, 33) != null
					&& model3.getValueAt(i, 33).toString().length() != 0
							&& !model3.getValueAt(i, 33).toString().equalsIgnoreCase("0")
							&& !model3.getValueAt(i, 33).toString().equalsIgnoreCase("0.0")
							&& !model3.getValueAt(i, 33).toString()
											.equalsIgnoreCase("0.00") || (model3.getValueAt(i, 34) != null
													&& model3.getValueAt(i, 34).toString().length() != 0
													&& !model3.getValueAt(i, 34).toString().equalsIgnoreCase("0")
													&& !model3.getValueAt(i, 34).toString().equalsIgnoreCase("0.0")
													&& !model3.getValueAt(i, 34).toString()
																	.equalsIgnoreCase("0.00") || (model3.getValueAt(i, 35) != null
																			&& model3.getValueAt(i, 35).toString().length() != 0
																			&& !model3.getValueAt(i, 35).toString().equalsIgnoreCase("0")
																			&& !model3.getValueAt(i, 35).toString().equalsIgnoreCase("0.0")
																			&& !model3.getValueAt(i, 35).toString()
																							.equalsIgnoreCase("0.00")))){
				
				C6A_94P_Count++;
			}
			
			
			if (model3.getValueAt(i, 36) != null
					&& model3.getValueAt(i, 36).toString().length() != 0
							&& !model3.getValueAt(i, 36).toString().equalsIgnoreCase("0")
							&& !model3.getValueAt(i, 36).toString().equalsIgnoreCase("0.0")
							&& !model3.getValueAt(i, 36).toString()
											.equalsIgnoreCase("0.00") || (model3.getValueAt(i, 37) != null
													&& model3.getValueAt(i, 37).toString().length() != 0
													&& !model3.getValueAt(i, 37).toString().equalsIgnoreCase("0")
													&& !model3.getValueAt(i, 37).toString().equalsIgnoreCase("0.0")
													&& !model3.getValueAt(i, 37).toString()
																	.equalsIgnoreCase("0.00") || (model3.getValueAt(i, 38) != null
																			&& model3.getValueAt(i, 38).toString().length() != 0
																			&& !model3.getValueAt(i, 38).toString().equalsIgnoreCase("0")
																			&& !model3.getValueAt(i, 38).toString().equalsIgnoreCase("0.0")
																			&& !model3.getValueAt(i, 38).toString()
																							.equalsIgnoreCase("0.00")))){
				
				C6A_94P_Count++;
			}
			
			
			if (model3.getValueAt(i, 39) != null
					&& model3.getValueAt(i, 39).toString().length() != 0
							&& !model3.getValueAt(i, 39).toString().equalsIgnoreCase("0")
							&& !model3.getValueAt(i, 39).toString().equalsIgnoreCase("0.0")
							&& !model3.getValueAt(i, 39).toString()
											.equalsIgnoreCase("0.00") || (model3.getValueAt(i, 40) != null
													&& model3.getValueAt(i, 40).toString().length() != 0
													&& !model3.getValueAt(i, 40).toString().equalsIgnoreCase("0")
													&& !model3.getValueAt(i, 40).toString().equalsIgnoreCase("0.0")
													&& !model3.getValueAt(i, 40).toString()
																	.equalsIgnoreCase("0.00") || (model3.getValueAt(i, 40) != null
																			&& model3.getValueAt(i, 40).toString().length() != 0
																			&& !model3.getValueAt(i, 40).toString().equalsIgnoreCase("0")
																			&& !model3.getValueAt(i, 40).toString().equalsIgnoreCase("0.0")
																			&& !model3.getValueAt(i, 40).toString()
																							.equalsIgnoreCase("0.00")))){
				
				C6A_94P_Count++;
			}
			
			if (model3.getValueAt(i, 42) != null
					&& model3.getValueAt(i, 42).toString().length() != 0
							&& !model3.getValueAt(i, 42).toString().equalsIgnoreCase("0")
							&& !model3.getValueAt(i, 42).toString().equalsIgnoreCase("0.0")
							&& !model3.getValueAt(i, 42).toString()
											.equalsIgnoreCase("0.00") || (model3.getValueAt(i, 43) != null
													&& model3.getValueAt(i, 43).toString().length() != 0
													&& !model3.getValueAt(i, 43).toString().equalsIgnoreCase("0")
													&& !model3.getValueAt(i, 43).toString().equalsIgnoreCase("0.0")
													&& !model3.getValueAt(i, 43).toString()
																	.equalsIgnoreCase("0.00") || (model3.getValueAt(i, 44) != null
																			&& model3.getValueAt(i, 44).toString().length() != 0
																			&& !model3.getValueAt(i, 44).toString().equalsIgnoreCase("0")
																			&& !model3.getValueAt(i, 44).toString().equalsIgnoreCase("0.0")
																			&& !model3.getValueAt(i, 44).toString()
																							.equalsIgnoreCase("0.00")))){
				
				C6A_94P_Count++;
			}
			
			if (model3.getValueAt(i, 45) != null
					&& model3.getValueAt(i, 45).toString().length() != 0
							&& !model3.getValueAt(i, 45).toString().equalsIgnoreCase("0")
							&& !model3.getValueAt(i, 45).toString().equalsIgnoreCase("0.0")
							&& !model3.getValueAt(i, 45).toString()
											.equalsIgnoreCase("0.00") || (model3.getValueAt(i, 46) != null
													&& model3.getValueAt(i, 46).toString().length() != 0
													&& !model3.getValueAt(i, 46).toString().equalsIgnoreCase("0")
													&& !model3.getValueAt(i, 46).toString().equalsIgnoreCase("0.0")
													&& !model3.getValueAt(i, 46).toString()
																	.equalsIgnoreCase("0.00") || (model3.getValueAt(i, 47) != null
																			&& model3.getValueAt(i, 47).toString().length() != 0
																			&& !model3.getValueAt(i, 47).toString().equalsIgnoreCase("0")
																			&& !model3.getValueAt(i, 47).toString().equalsIgnoreCase("0.0")
																			&& !model3.getValueAt(i, 47).toString()
																							.equalsIgnoreCase("0.00")))){
				
				C6A_94P_Count++;
			}
			
			if (model3.getValueAt(i, 48) != null
					&& model3.getValueAt(i, 48).toString().length() != 0
							&& !model3.getValueAt(i, 48).toString().equalsIgnoreCase("0")
							&& !model3.getValueAt(i, 48).toString().equalsIgnoreCase("0.0")
							&& !model3.getValueAt(i, 48).toString()
											.equalsIgnoreCase("0.00") || (model3.getValueAt(i, 49) != null
													&& model3.getValueAt(i, 49).toString().length() != 0
													&& !model3.getValueAt(i, 49).toString().equalsIgnoreCase("0")
													&& !model3.getValueAt(i, 49).toString().equalsIgnoreCase("0.0")
													&& !model3.getValueAt(i, 49).toString()
																	.equalsIgnoreCase("0.00") || (model3.getValueAt(i, 50) != null
																			&& model3.getValueAt(i, 50).toString().length() != 0
																			&& !model3.getValueAt(i, 50).toString().equalsIgnoreCase("0")
																			&& !model3.getValueAt(i, 50).toString().equalsIgnoreCase("0.0")
																			&& !model3.getValueAt(i, 50).toString()
																							.equalsIgnoreCase("0.00")))){
				
				C6A_94P_Count++;
			}
			
			if (model3.getValueAt(i, 51) != null
					&& model3.getValueAt(i, 51).toString().length() != 0
							&& !model3.getValueAt(i, 51).toString().equalsIgnoreCase("0")
							&& !model3.getValueAt(i, 51).toString().equalsIgnoreCase("0.0")
							&& !model3.getValueAt(i, 51).toString()
											.equalsIgnoreCase("0.00") || (model3.getValueAt(i, 52) != null
													&& model3.getValueAt(i, 52).toString().length() != 0
													&& !model3.getValueAt(i, 52).toString().equalsIgnoreCase("0")
													&& !model3.getValueAt(i, 52).toString().equalsIgnoreCase("0.0")
													&& !model3.getValueAt(i, 52).toString()
																	.equalsIgnoreCase("0.00") || (model3.getValueAt(i, 53) != null
																			&& model3.getValueAt(i, 53).toString().length() != 0
																			&& !model3.getValueAt(i, 53).toString().equalsIgnoreCase("0")
																			&& !model3.getValueAt(i, 53).toString().equalsIgnoreCase("0.0")
																			&& !model3.getValueAt(i, 53).toString()
																							.equalsIgnoreCase("0.00")))){
				
				C6A_94P_Count++;
			}
			
			anneIII94P.setCountofSection194PChapterVIADetailsRecordsassociatedwithDeductee(""+C6A_94P_Count);
			
			
			if (model3.getValueAt(i, 14) != null
					&& model3.getValueAt(i, 14).toString().length() != 0
							&& !model3.getValueAt(i, 14).toString().equalsIgnoreCase("0")
							&& !model3.getValueAt(i, 14).toString().equalsIgnoreCase("0.0")
							&& !model3.getValueAt(i, 14).toString()
											.equalsIgnoreCase("0.00")){
				AnnexIII_c6ACount.add(14);
			}else
				AnnexIII_c6ACount.add(0);
			
			if (model3.getValueAt(i, 15) != null
					&& model3.getValueAt(i, 15).toString().length() != 0
							&& !model3.getValueAt(i, 15).toString().equalsIgnoreCase("0")
							&& !model3.getValueAt(i, 15).toString().equalsIgnoreCase("0.0")
							&& !model3.getValueAt(i, 15).toString()
											.equalsIgnoreCase("0.00")){
				AnnexIII_c6ACount.add(15);
			}else
				AnnexIII_c6ACount.add(0);
			
			if (model3.getValueAt(i, 16) != null
					&& model3.getValueAt(i, 16).toString().length() != 0
							&& !model3.getValueAt(i, 16).toString().equalsIgnoreCase("0")
							&& !model3.getValueAt(i, 16).toString().equalsIgnoreCase("0.0")
							&& !model3.getValueAt(i, 16).toString()
											.equalsIgnoreCase("0.00")){
				AnnexIII_c6ACount.add(16);
			}else
				AnnexIII_c6ACount.add(0);
			
			if (model3.getValueAt(i, 17) != null
					&& model3.getValueAt(i, 17).toString().length() != 0
							&& !model3.getValueAt(i, 17).toString().equalsIgnoreCase("0")
							&& !model3.getValueAt(i, 17).toString().equalsIgnoreCase("0.0")
							&& !model3.getValueAt(i, 17).toString()
											.equalsIgnoreCase("0.00")){
				AnnexIII_c6ACount.add(17);
			}else
				AnnexIII_c6ACount.add(0);
			
			if (model3.getValueAt(i, 18) != null
					&& model3.getValueAt(i, 18).toString().length() != 0
							&& !model3.getValueAt(i, 18).toString().equalsIgnoreCase("0")
							&& !model3.getValueAt(i, 18).toString().equalsIgnoreCase("0.0")
							&& !model3.getValueAt(i, 18).toString()
											.equalsIgnoreCase("0.00")){
				AnnexIII_c6ACount.add(18);
			}else
				AnnexIII_c6ACount.add(0);
			
			if (model3.getValueAt(i, 19) != null
					&& model3.getValueAt(i, 19).toString().length() != 0
							&& !model3.getValueAt(i, 19).toString().equalsIgnoreCase("0")
							&& !model3.getValueAt(i, 19).toString().equalsIgnoreCase("0.0")
							&& !model3.getValueAt(i, 19).toString()
											.equalsIgnoreCase("0.00")){
				AnnexIII_c6ACount.add(19);
			}else
				AnnexIII_c6ACount.add(0);
			
			if (model3.getValueAt(i, 21) != null
					&& model3.getValueAt(i, 21).toString().length() != 0
							&& !model3.getValueAt(i, 21).toString().equalsIgnoreCase("0")
							&& !model3.getValueAt(i, 21).toString().equalsIgnoreCase("0.0")
							&& !model3.getValueAt(i, 21).toString()
											.equalsIgnoreCase("0.00")){
				AnnexIII_c6ACount.add(21);
			}else
				AnnexIII_c6ACount.add(0);
			
			if (model3.getValueAt(i, 22) != null
					&& model3.getValueAt(i, 22).toString().length() != 0
							&& !model3.getValueAt(i, 22).toString().equalsIgnoreCase("0")
							&& !model3.getValueAt(i, 22).toString().equalsIgnoreCase("0.0")
							&& !model3.getValueAt(i, 22).toString()
											.equalsIgnoreCase("0.00")){
				AnnexIII_c6ACount.add(22);
			}else
				AnnexIII_c6ACount.add(0);
			
			if (model3.getValueAt(i, 23) != null
					&& model3.getValueAt(i, 23).toString().length() != 0
							&& !model3.getValueAt(i, 23).toString().equalsIgnoreCase("0")
							&& !model3.getValueAt(i, 23).toString().equalsIgnoreCase("0.0")
							&& !model3.getValueAt(i, 23).toString()
											.equalsIgnoreCase("0.00")){
				AnnexIII_c6ACount.add(23);
			}else
				AnnexIII_c6ACount.add(0);
			
			if (model3.getValueAt(i, 24) != null
					&& model3.getValueAt(i, 24).toString().length() != 0
							&& !model3.getValueAt(i, 24).toString().equalsIgnoreCase("0")
							&& !model3.getValueAt(i, 24).toString().equalsIgnoreCase("0.0")
							&& !model3.getValueAt(i, 24).toString()
											.equalsIgnoreCase("0.00")){
				AnnexIII_c6ACount.add(24);
			}else
				AnnexIII_c6ACount.add(0);
			
			if (model3.getValueAt(i, 25) != null
					&& model3.getValueAt(i, 25).toString().length() != 0
							&& !model3.getValueAt(i, 25).toString().equalsIgnoreCase("0")
							&& !model3.getValueAt(i, 25).toString().equalsIgnoreCase("0.0")
							&& !model3.getValueAt(i, 25).toString()
											.equalsIgnoreCase("0.00")){
				AnnexIII_c6ACount.add(25);
			}else
				AnnexIII_c6ACount.add(0);
			
			if (model3.getValueAt(i, 26) != null
					&& model3.getValueAt(i, 26).toString().length() != 0
							&& !model3.getValueAt(i, 26).toString().equalsIgnoreCase("0")
							&& !model3.getValueAt(i, 26).toString().equalsIgnoreCase("0.0")
							&& !model3.getValueAt(i, 26).toString()
											.equalsIgnoreCase("0.00")){
				AnnexIII_c6ACount.add(26);
			}else
				AnnexIII_c6ACount.add(0);
			
			if (model3.getValueAt(i, 27) != null
					&& model3.getValueAt(i, 27).toString().length() != 0
							&& !model3.getValueAt(i, 27).toString().equalsIgnoreCase("0")
							&& !model3.getValueAt(i, 27).toString().equalsIgnoreCase("0.0")
							&& !model3.getValueAt(i, 27).toString()
											.equalsIgnoreCase("0.00")){
				AnnexIII_c6ACount.add(27);
			}else
				AnnexIII_c6ACount.add(0);
			
			if (model3.getValueAt(i, 28) != null
					&& model3.getValueAt(i, 28).toString().length() != 0
							&& !model3.getValueAt(i, 28).toString().equalsIgnoreCase("0")
							&& !model3.getValueAt(i, 28).toString().equalsIgnoreCase("0.0")
							&& !model3.getValueAt(i, 28).toString()
											.equalsIgnoreCase("0.00")){
				AnnexIII_c6ACount.add(28);
			}else
				AnnexIII_c6ACount.add(0);
			
			if (model3.getValueAt(i, 29) != null
					&& model3.getValueAt(i, 29).toString().length() != 0
							&& !model3.getValueAt(i, 29).toString().equalsIgnoreCase("0")
							&& !model3.getValueAt(i, 29).toString().equalsIgnoreCase("0.0")
							&& !model3.getValueAt(i, 29).toString()
											.equalsIgnoreCase("0.00")){
				AnnexIII_c6ACount.add(29);
			}else
				AnnexIII_c6ACount.add(0);
			
			if (model3.getValueAt(i, 30) != null
					&& model3.getValueAt(i, 30).toString().length() != 0
							&& !model3.getValueAt(i, 30).toString().equalsIgnoreCase("0")
							&& !model3.getValueAt(i, 30).toString().equalsIgnoreCase("0.0")
							&& !model3.getValueAt(i, 30).toString()
											.equalsIgnoreCase("0.00")){
				AnnexIII_c6ACount.add(30);
			}else
				AnnexIII_c6ACount.add(0);
			
			if (model3.getValueAt(i, 31) != null
					&& model3.getValueAt(i, 31).toString().length() != 0
							&& !model3.getValueAt(i, 31).toString().equalsIgnoreCase("0")
							&& !model3.getValueAt(i, 31).toString().equalsIgnoreCase("0.0")
							&& !model3.getValueAt(i, 31).toString()
											.equalsIgnoreCase("0.00")){
				AnnexIII_c6ACount.add(31);
			}else
				AnnexIII_c6ACount.add(0);
			
			if (model3.getValueAt(i, 32) != null
					&& model3.getValueAt(i, 32).toString().length() != 0
							&& !model3.getValueAt(i, 32).toString().equalsIgnoreCase("0")
							&& !model3.getValueAt(i, 32).toString().equalsIgnoreCase("0.0")
							&& !model3.getValueAt(i, 32).toString()
											.equalsIgnoreCase("0.00")){
				AnnexIII_c6ACount.add(32);
			}else
				AnnexIII_c6ACount.add(0);
			
			if (model3.getValueAt(i, 33) != null
					&& model3.getValueAt(i, 33).toString().length() != 0
							&& !model3.getValueAt(i, 33).toString().equalsIgnoreCase("0")
							&& !model3.getValueAt(i, 33).toString().equalsIgnoreCase("0.0")
							&& !model3.getValueAt(i, 33).toString()
											.equalsIgnoreCase("0.00")){
				AnnexIII_c6ACount.add(33);
			}else
				AnnexIII_c6ACount.add(0);
			
			if (model3.getValueAt(i, 34) != null
					&& model3.getValueAt(i, 34).toString().length() != 0
							&& !model3.getValueAt(i, 34).toString().equalsIgnoreCase("0")
							&& !model3.getValueAt(i, 34).toString().equalsIgnoreCase("0.0")
							&& !model3.getValueAt(i, 34).toString()
											.equalsIgnoreCase("0.00")){
				AnnexIII_c6ACount.add(34);
			}else
				AnnexIII_c6ACount.add(0);
			
			if (model3.getValueAt(i, 35) != null
					&& model3.getValueAt(i, 35).toString().length() != 0
							&& !model3.getValueAt(i, 35).toString().equalsIgnoreCase("0")
							&& !model3.getValueAt(i, 35).toString().equalsIgnoreCase("0.0")
							&& !model3.getValueAt(i, 35).toString()
											.equalsIgnoreCase("0.00")){
				AnnexIII_c6ACount.add(35);
			}else
				AnnexIII_c6ACount.add(0);
			
			if (model3.getValueAt(i, 36) != null
					&& model3.getValueAt(i, 36).toString().length() != 0
							&& !model3.getValueAt(i, 36).toString().equalsIgnoreCase("0")
							&& !model3.getValueAt(i, 36).toString().equalsIgnoreCase("0.0")
							&& !model3.getValueAt(i, 36).toString()
											.equalsIgnoreCase("0.00")){
				AnnexIII_c6ACount.add(36);
			}else
				AnnexIII_c6ACount.add(0);
			
			if (model3.getValueAt(i, 37) != null
					&& model3.getValueAt(i, 37).toString().length() != 0
							&& !model3.getValueAt(i, 37).toString().equalsIgnoreCase("0")
							&& !model3.getValueAt(i, 37).toString().equalsIgnoreCase("0.0")
							&& !model3.getValueAt(i, 37).toString()
											.equalsIgnoreCase("0.00")){
				AnnexIII_c6ACount.add(37);
			}else
				AnnexIII_c6ACount.add(0);
			
			if (model3.getValueAt(i, 38) != null
					&& model3.getValueAt(i, 38).toString().length() != 0
							&& !model3.getValueAt(i, 38).toString().equalsIgnoreCase("0")
							&& !model3.getValueAt(i, 38).toString().equalsIgnoreCase("0.0")
							&& !model3.getValueAt(i, 38).toString()
											.equalsIgnoreCase("0.00")){
				AnnexIII_c6ACount.add(38);
			}else
				AnnexIII_c6ACount.add(0);
			
			if (model3.getValueAt(i, 39) != null
					&& model3.getValueAt(i, 39).toString().length() != 0
							&& !model3.getValueAt(i, 39).toString().equalsIgnoreCase("0")
							&& !model3.getValueAt(i, 39).toString().equalsIgnoreCase("0.0")
							&& !model3.getValueAt(i, 39).toString()
											.equalsIgnoreCase("0.00")){
				AnnexIII_c6ACount.add(39);
			}else
				AnnexIII_c6ACount.add(0);
			
			if (model3.getValueAt(i, 40) != null
					&& model3.getValueAt(i, 40).toString().length() != 0
							&& !model3.getValueAt(i, 40).toString().equalsIgnoreCase("0")
							&& !model3.getValueAt(i, 40).toString().equalsIgnoreCase("0.0")
							&& !model3.getValueAt(i, 40).toString()
											.equalsIgnoreCase("0.00")){
				AnnexIII_c6ACount.add(40);
			}else
				AnnexIII_c6ACount.add(0);
			
			if (model3.getValueAt(i, 41) != null
					&& model3.getValueAt(i, 41).toString().length() != 0
							&& !model3.getValueAt(i, 41).toString().equalsIgnoreCase("0")
							&& !model3.getValueAt(i, 41).toString().equalsIgnoreCase("0.0")
							&& !model3.getValueAt(i, 41).toString()
											.equalsIgnoreCase("0.00")){
				AnnexIII_c6ACount.add(41);
			}else
				AnnexIII_c6ACount.add(0);
			
			if (model3.getValueAt(i, 42) != null
					&& model3.getValueAt(i, 42).toString().length() != 0
							&& !model3.getValueAt(i, 42).toString().equalsIgnoreCase("0")
							&& !model3.getValueAt(i, 42).toString().equalsIgnoreCase("0.0")
							&& !model3.getValueAt(i, 42).toString()
											.equalsIgnoreCase("0.00")){
				AnnexIII_c6ACount.add(42);
			}else
				AnnexIII_c6ACount.add(0);
			
			if (model3.getValueAt(i, 43) != null
					&& model3.getValueAt(i, 43).toString().length() != 0
							&& !model3.getValueAt(i, 43).toString().equalsIgnoreCase("0")
							&& !model3.getValueAt(i, 43).toString().equalsIgnoreCase("0.0")
							&& !model3.getValueAt(i, 43).toString()
											.equalsIgnoreCase("0.00")){
				AnnexIII_c6ACount.add(43);
			}else
				AnnexIII_c6ACount.add(0);
			
			if (model3.getValueAt(i, 44) != null
					&& model3.getValueAt(i, 44).toString().length() != 0
							&& !model3.getValueAt(i, 44).toString().equalsIgnoreCase("0")
							&& !model3.getValueAt(i, 44).toString().equalsIgnoreCase("0.0")
							&& !model3.getValueAt(i, 44).toString()
											.equalsIgnoreCase("0.00")){
				AnnexIII_c6ACount.add(44);
			}else
				AnnexIII_c6ACount.add(0);
			
			if (model3.getValueAt(i, 45) != null
					&& model3.getValueAt(i, 45).toString().length() != 0
							&& !model3.getValueAt(i, 45).toString().equalsIgnoreCase("0")
							&& !model3.getValueAt(i, 45).toString().equalsIgnoreCase("0.0")
							&& !model3.getValueAt(i, 45).toString()
											.equalsIgnoreCase("0.00")){
				AnnexIII_c6ACount.add(45);
			}else
				AnnexIII_c6ACount.add(0);
			
			if (model3.getValueAt(i, 46) != null
					&& model3.getValueAt(i, 46).toString().length() != 0
							&& !model3.getValueAt(i, 46).toString().equalsIgnoreCase("0")
							&& !model3.getValueAt(i, 46).toString().equalsIgnoreCase("0.0")
							&& !model3.getValueAt(i, 46).toString()
											.equalsIgnoreCase("0.00")){
				AnnexIII_c6ACount.add(46);
			}else
				AnnexIII_c6ACount.add(0);
			
			if (model3.getValueAt(i, 47) != null
					&& model3.getValueAt(i, 47).toString().length() != 0
							&& !model3.getValueAt(i, 47).toString().equalsIgnoreCase("0")
							&& !model3.getValueAt(i, 47).toString().equalsIgnoreCase("0.0")
							&& !model3.getValueAt(i, 47).toString()
											.equalsIgnoreCase("0.00")){
				AnnexIII_c6ACount.add(47);
			}else
				AnnexIII_c6ACount.add(0);
			
			if (model3.getValueAt(i, 48) != null
					&& model3.getValueAt(i, 48).toString().length() != 0
							&& !model3.getValueAt(i, 48).toString().equalsIgnoreCase("0")
							&& !model3.getValueAt(i, 48).toString().equalsIgnoreCase("0.0")
							&& !model3.getValueAt(i, 48).toString()
											.equalsIgnoreCase("0.00")){
				AnnexIII_c6ACount.add(48);
			}else
				AnnexIII_c6ACount.add(0);
			
			if (model3.getValueAt(i, 49) != null
					&& model3.getValueAt(i, 49).toString().length() != 0
							&& !model3.getValueAt(i, 49).toString().equalsIgnoreCase("0")
							&& !model3.getValueAt(i, 49).toString().equalsIgnoreCase("0.0")
							&& !model3.getValueAt(i, 49).toString()
											.equalsIgnoreCase("0.00")){
				AnnexIII_c6ACount.add(49);
			}else
				AnnexIII_c6ACount.add(0);
			
			if (model3.getValueAt(i, 50) != null
					&& model3.getValueAt(i, 50).toString().length() != 0
							&& !model3.getValueAt(i, 50).toString().equalsIgnoreCase("0")
							&& !model3.getValueAt(i, 50).toString().equalsIgnoreCase("0.0")
							&& !model3.getValueAt(i, 50).toString()
											.equalsIgnoreCase("0.00")){
				AnnexIII_c6ACount.add(50);
			}else
				AnnexIII_c6ACount.add(0);
			
			if (model3.getValueAt(i, 51) != null
					&& model3.getValueAt(i, 51).toString().length() != 0
							&& !model3.getValueAt(i, 51).toString().equalsIgnoreCase("0")
							&& !model3.getValueAt(i, 51).toString().equalsIgnoreCase("0.0")
							&& !model3.getValueAt(i, 51).toString()
											.equalsIgnoreCase("0.00")){
				AnnexIII_c6ACount.add(51);
			}else
				AnnexIII_c6ACount.add(0);
			
			if (model3.getValueAt(i, 52) != null
					&& model3.getValueAt(i, 52).toString().length() != 0
							&& !model3.getValueAt(i, 52).toString().equalsIgnoreCase("0")
							&& !model3.getValueAt(i, 52).toString().equalsIgnoreCase("0.0")
							&& !model3.getValueAt(i, 52).toString()
											.equalsIgnoreCase("0.00")){
				AnnexIII_c6ACount.add(52);
			}else
				AnnexIII_c6ACount.add(0);
			
			if (model3.getValueAt(i, 53) != null
					&& model3.getValueAt(i, 53).toString().length() != 0
							&& !model3.getValueAt(i, 53).toString().equalsIgnoreCase("0")
							&& !model3.getValueAt(i, 53).toString().equalsIgnoreCase("0.0")
							&& !model3.getValueAt(i, 53).toString()
											.equalsIgnoreCase("0.00")){
				AnnexIII_c6ACount.add(53);
			}else
				AnnexIII_c6ACount.add(0);
			
			
			
			if (model3.getValueAt(i, 54) != null
					&& model3.getValueAt(i, 54).toString().length() != 0) {
				anneIII94P.setAggregateofdeductibleamountunderChapterVIAunderassociatedSection194P(model3
						.getValueAt(i, 54).toString());
			}
			else
			{
				anneIII94P.setAggregateofdeductibleamountunderChapterVIAunderassociatedSection194P("0.00");
			}
			
//////////////////////////////////////P6A End/////////////////////////////////////////////////////////	
			
			
			if (model3.getValueAt(i, 55) != null
					&& model3.getValueAt(i, 55).toString().length() != 0) {
				anneIII94P.setTotaltaxableincome(model3
						.getValueAt(i, 55).toString());

			}	
			
			if (model3.getValueAt(i, 56) != null
					&& model3.getValueAt(i, 56).toString().length() != 0) {
				anneIII94P.setTaxontotalincome(model3
						.getValueAt(i, 56).toString());

			}	
			
			if (model3.getValueAt(i, 57) != null
					&& model3.getValueAt(i, 57).toString().length() != 0) {
				anneIII94P.setRebateundersection87A(model3
						.getValueAt(i, 57).toString());

			}	
			
			if (model3.getValueAt(i, 58) != null
					&& model3.getValueAt(i, 58).toString().length() != 0) {
				anneIII94P.setSurcharge(model3
						.getValueAt(i, 58).toString());

			}
			
			if (model3.getValueAt(i, 59) != null
					&& model3.getValueAt(i, 59).toString().length() != 0) {
				anneIII94P.setHealthandeducationcess(model3
						.getValueAt(i, 59).toString());

			}
			
			if (model3.getValueAt(i, 60) != null
					&& model3.getValueAt(i, 60).toString().length() != 0) {
				anneIII94P.setTaxPayable(model3
						.getValueAt(i, 60).toString());

			}
			
			if (model3.getValueAt(i, 61) != null
					&& model3.getValueAt(i, 61).toString().length() != 0) {
				anneIII94P.setReliefundersection89(model3
						.getValueAt(i, 61).toString());

			}
			
			if (model3.getValueAt(i, 62) != null
					&& model3.getValueAt(i, 62).toString().length() != 0) {
				anneIII94P.setNettaxPayable(model3
						.getValueAt(i, 62).toString());

			}
			
			return anneIII94P;

}


public Annex3_94P_S16Bean _S16_94PAppender(ArrayList<Object> ls, int bhCounter, Annex3_94PBean anneIII94P,
		int inneri, int i, int serialnumber) {

	Annex3_94P_S16Bean s16_94P = new Annex3_94P_S16Bean();

	s16_94P.setLineNumber("" + (ls.size() + 1));
	s16_94P.setRecordType("P16");
	s16_94P.setBatchNumber("" + bhCounter);
	s16_94P.setDetailsRecordNo194P(anneIII94P.getDetailsRecordNo194P());
	s16_94P.setSection16DetailsRecordNo194P(new Integer(serialnumber)
			.toString());

	if (inneri == 8) {
		s16_94P.setSection16sectionID("16(ia)");
	} else if (inneri == 9) {
		s16_94P.setSection16sectionID("16(iii)");
	}
	
	

	if (model3.getValueAt(i, inneri) != null
			&& model3.getValueAt(i, inneri).toString().length() != 0){   // && !model3.getValueAt(i, 6).toString().equalsIgnoreCase("Yes")) { //commented for CR86827 as value should be allowed for 'YES' from FY23-24
		s16_94P.setTotalDeductionunderSection16(model3.getValueAt(i, inneri)
				.toString());
	}

	return s16_94P;

}


public Annex3_94P_C6ABean _C6A_94PAppender(List ls, int bhCounter, Annex3_94PBean anneIII94P, 
		int i, int serialnumber) {
	
	Annex3_94P_C6ABean c6A_94P = new Annex3_94P_C6ABean();

	c6A_94P.setLineNumber("" + (ls.size() + 1));
	c6A_94P.setRecordType("P6A");
	c6A_94P.setBatchNumber("" + bhCounter);
	c6A_94P.setDetailsRecordNo194P(anneIII94P.getDetailsRecordNo194P());
	c6A_94P.setSectionC6ADetailsRecordNo194P(new Integer(serialnumber)
			.toString());
	c6A_94P.setChapterVIASectionID((String)Array.get(c6a_94PString,c6a_94PString_counter));
	
/////////////////////////////////////////////////////////////////////////////////////////////////////////////
	
	/*if (model3.getValueAt(i, 14) != null
			&& model3.getValueAt(i, 14).toString().length() != 0
					&& !model3.getValueAt(i, 14).toString().equalsIgnoreCase("0")
					&& !model3.getValueAt(i, 14).toString().equalsIgnoreCase("0.0")
					&& !model3.getValueAt(i, 14).toString()
									.equalsIgnoreCase("0.00")){
		AnnexIII_c6ACount.add(14);
	}else
		AnnexIII_c6ACount.add(0);
	
	if (model3.getValueAt(i, 15) != null
			&& model3.getValueAt(i, 15).toString().length() != 0
					&& !model3.getValueAt(i, 15).toString().equalsIgnoreCase("0")
					&& !model3.getValueAt(i, 15).toString().equalsIgnoreCase("0.0")
					&& !model3.getValueAt(i, 15).toString()
									.equalsIgnoreCase("0.00")){
		AnnexIII_c6ACount.add(15);
	}else
		AnnexIII_c6ACount.add(0);
	
	if (model3.getValueAt(i, 16) != null
			&& model3.getValueAt(i, 16).toString().length() != 0
					&& !model3.getValueAt(i, 16).toString().equalsIgnoreCase("0")
					&& !model3.getValueAt(i, 16).toString().equalsIgnoreCase("0.0")
					&& !model3.getValueAt(i, 16).toString()
									.equalsIgnoreCase("0.00")){
		AnnexIII_c6ACount.add(16);
	}else
		AnnexIII_c6ACount.add(0);
	
	if (model3.getValueAt(i, 17) != null
			&& model3.getValueAt(i, 17).toString().length() != 0
					&& !model3.getValueAt(i, 17).toString().equalsIgnoreCase("0")
					&& !model3.getValueAt(i, 17).toString().equalsIgnoreCase("0.0")
					&& !model3.getValueAt(i, 17).toString()
									.equalsIgnoreCase("0.00")){
		AnnexIII_c6ACount.add(17);
	}else
		AnnexIII_c6ACount.add(0);
	
	if (model3.getValueAt(i, 18) != null
			&& model3.getValueAt(i, 18).toString().length() != 0
					&& !model3.getValueAt(i, 18).toString().equalsIgnoreCase("0")
					&& !model3.getValueAt(i, 18).toString().equalsIgnoreCase("0.0")
					&& !model3.getValueAt(i, 18).toString()
									.equalsIgnoreCase("0.00")){
		AnnexIII_c6ACount.add(18);
	}else
		AnnexIII_c6ACount.add(0);
	
	if (model3.getValueAt(i, 19) != null
			&& model3.getValueAt(i, 19).toString().length() != 0
					&& !model3.getValueAt(i, 19).toString().equalsIgnoreCase("0")
					&& !model3.getValueAt(i, 19).toString().equalsIgnoreCase("0.0")
					&& !model3.getValueAt(i, 19).toString()
									.equalsIgnoreCase("0.00")){
		AnnexIII_c6ACount.add(19);
	}else
		AnnexIII_c6ACount.add(0);
	
	if (model3.getValueAt(i, 21) != null
			&& model3.getValueAt(i, 21).toString().length() != 0
					&& !model3.getValueAt(i, 21).toString().equalsIgnoreCase("0")
					&& !model3.getValueAt(i, 21).toString().equalsIgnoreCase("0.0")
					&& !model3.getValueAt(i, 21).toString()
									.equalsIgnoreCase("0.00")){
		AnnexIII_c6ACount.add(21);
	}else
		AnnexIII_c6ACount.add(0);
	
	if (model3.getValueAt(i, 22) != null
			&& model3.getValueAt(i, 22).toString().length() != 0
					&& !model3.getValueAt(i, 22).toString().equalsIgnoreCase("0")
					&& !model3.getValueAt(i, 22).toString().equalsIgnoreCase("0.0")
					&& !model3.getValueAt(i, 22).toString()
									.equalsIgnoreCase("0.00")){
		AnnexIII_c6ACount.add(22);
	}else
		AnnexIII_c6ACount.add(0);
	
	if (model3.getValueAt(i, 23) != null
			&& model3.getValueAt(i, 23).toString().length() != 0
					&& !model3.getValueAt(i, 23).toString().equalsIgnoreCase("0")
					&& !model3.getValueAt(i, 23).toString().equalsIgnoreCase("0.0")
					&& !model3.getValueAt(i, 23).toString()
									.equalsIgnoreCase("0.00")){
		AnnexIII_c6ACount.add(23);
	}else
		AnnexIII_c6ACount.add(0);
	
	if (model3.getValueAt(i, 24) != null
			&& model3.getValueAt(i, 24).toString().length() != 0
					&& !model3.getValueAt(i, 24).toString().equalsIgnoreCase("0")
					&& !model3.getValueAt(i, 24).toString().equalsIgnoreCase("0.0")
					&& !model3.getValueAt(i, 24).toString()
									.equalsIgnoreCase("0.00")){
		AnnexIII_c6ACount.add(24);
	}else
		AnnexIII_c6ACount.add(0);
	
	if (model3.getValueAt(i, 25) != null
			&& model3.getValueAt(i, 25).toString().length() != 0
					&& !model3.getValueAt(i, 25).toString().equalsIgnoreCase("0")
					&& !model3.getValueAt(i, 25).toString().equalsIgnoreCase("0.0")
					&& !model3.getValueAt(i, 25).toString()
									.equalsIgnoreCase("0.00")){
		AnnexIII_c6ACount.add(25);
	}else
		AnnexIII_c6ACount.add(0);
	
	if (model3.getValueAt(i, 26) != null
			&& model3.getValueAt(i, 26).toString().length() != 0
					&& !model3.getValueAt(i, 26).toString().equalsIgnoreCase("0")
					&& !model3.getValueAt(i, 26).toString().equalsIgnoreCase("0.0")
					&& !model3.getValueAt(i, 26).toString()
									.equalsIgnoreCase("0.00")){
		AnnexIII_c6ACount.add(26);
	}else
		AnnexIII_c6ACount.add(0);
	
	if (model3.getValueAt(i, 27) != null
			&& model3.getValueAt(i, 27).toString().length() != 0
					&& !model3.getValueAt(i, 27).toString().equalsIgnoreCase("0")
					&& !model3.getValueAt(i, 27).toString().equalsIgnoreCase("0.0")
					&& !model3.getValueAt(i, 27).toString()
									.equalsIgnoreCase("0.00")){
		AnnexIII_c6ACount.add(27);
	}else
		AnnexIII_c6ACount.add(0);
	
	if (model3.getValueAt(i, 28) != null
			&& model3.getValueAt(i, 28).toString().length() != 0
					&& !model3.getValueAt(i, 28).toString().equalsIgnoreCase("0")
					&& !model3.getValueAt(i, 28).toString().equalsIgnoreCase("0.0")
					&& !model3.getValueAt(i, 28).toString()
									.equalsIgnoreCase("0.00")){
		AnnexIII_c6ACount.add(28);
	}else
		AnnexIII_c6ACount.add(0);
	
	if (model3.getValueAt(i, 29) != null
			&& model3.getValueAt(i, 29).toString().length() != 0
					&& !model3.getValueAt(i, 29).toString().equalsIgnoreCase("0")
					&& !model3.getValueAt(i, 29).toString().equalsIgnoreCase("0.0")
					&& !model3.getValueAt(i, 29).toString()
									.equalsIgnoreCase("0.00")){
		AnnexIII_c6ACount.add(29);
	}else
		AnnexIII_c6ACount.add(0);
	
	if (model3.getValueAt(i, 30) != null
			&& model3.getValueAt(i, 30).toString().length() != 0
					&& !model3.getValueAt(i, 30).toString().equalsIgnoreCase("0")
					&& !model3.getValueAt(i, 30).toString().equalsIgnoreCase("0.0")
					&& !model3.getValueAt(i, 30).toString()
									.equalsIgnoreCase("0.00")){
		AnnexIII_c6ACount.add(30);
	}else
		AnnexIII_c6ACount.add(0);
	
	if (model3.getValueAt(i, 31) != null
			&& model3.getValueAt(i, 31).toString().length() != 0
					&& !model3.getValueAt(i, 31).toString().equalsIgnoreCase("0")
					&& !model3.getValueAt(i, 31).toString().equalsIgnoreCase("0.0")
					&& !model3.getValueAt(i, 31).toString()
									.equalsIgnoreCase("0.00")){
		AnnexIII_c6ACount.add(31);
	}else
		AnnexIII_c6ACount.add(0);
	
	if (model3.getValueAt(i, 32) != null
			&& model3.getValueAt(i, 32).toString().length() != 0
					&& !model3.getValueAt(i, 32).toString().equalsIgnoreCase("0")
					&& !model3.getValueAt(i, 32).toString().equalsIgnoreCase("0.0")
					&& !model3.getValueAt(i, 32).toString()
									.equalsIgnoreCase("0.00")){
		AnnexIII_c6ACount.add(32);
	}else
		AnnexIII_c6ACount.add(0);
	
	if (model3.getValueAt(i, 33) != null
			&& model3.getValueAt(i, 33).toString().length() != 0
					&& !model3.getValueAt(i, 33).toString().equalsIgnoreCase("0")
					&& !model3.getValueAt(i, 33).toString().equalsIgnoreCase("0.0")
					&& !model3.getValueAt(i, 3).toString()
									.equalsIgnoreCase("0.00")){
		AnnexIII_c6ACount.add(33);
	}else
		AnnexIII_c6ACount.add(0);
	
	if (model3.getValueAt(i, 34) != null
			&& model3.getValueAt(i, 34).toString().length() != 0
					&& !model3.getValueAt(i, 34).toString().equalsIgnoreCase("0")
					&& !model3.getValueAt(i, 34).toString().equalsIgnoreCase("0.0")
					&& !model3.getValueAt(i, 34).toString()
									.equalsIgnoreCase("0.00")){
		AnnexIII_c6ACount.add(34);
	}else
		AnnexIII_c6ACount.add(0);
	
	if (model3.getValueAt(i, 35) != null
			&& model3.getValueAt(i, 35).toString().length() != 0
					&& !model3.getValueAt(i, 35).toString().equalsIgnoreCase("0")
					&& !model3.getValueAt(i, 35).toString().equalsIgnoreCase("0.0")
					&& !model3.getValueAt(i, 35).toString()
									.equalsIgnoreCase("0.00")){
		AnnexIII_c6ACount.add(35);
	}else
		AnnexIII_c6ACount.add(0);
	
	if (model3.getValueAt(i, 36) != null
			&& model3.getValueAt(i, 36).toString().length() != 0
					&& !model3.getValueAt(i, 36).toString().equalsIgnoreCase("0")
					&& !model3.getValueAt(i, 36).toString().equalsIgnoreCase("0.0")
					&& !model3.getValueAt(i, 36).toString()
									.equalsIgnoreCase("0.00")){
		AnnexIII_c6ACount.add(36);
	}else
		AnnexIII_c6ACount.add(0);
	
	if (model3.getValueAt(i, 37) != null
			&& model3.getValueAt(i, 37).toString().length() != 0
					&& !model3.getValueAt(i, 37).toString().equalsIgnoreCase("0")
					&& !model3.getValueAt(i, 37).toString().equalsIgnoreCase("0.0")
					&& !model3.getValueAt(i, 37).toString()
									.equalsIgnoreCase("0.00")){
		AnnexIII_c6ACount.add(37);
	}else
		AnnexIII_c6ACount.add(0);
	
	if (model3.getValueAt(i, 38) != null
			&& model3.getValueAt(i, 38).toString().length() != 0
					&& !model3.getValueAt(i, 38).toString().equalsIgnoreCase("0")
					&& !model3.getValueAt(i, 38).toString().equalsIgnoreCase("0.0")
					&& !model3.getValueAt(i, 38).toString()
									.equalsIgnoreCase("0.00")){
		AnnexIII_c6ACount.add(38);
	}else
		AnnexIII_c6ACount.add(0);
	
	if (model3.getValueAt(i, 39) != null
			&& model3.getValueAt(i, 39).toString().length() != 0
					&& !model3.getValueAt(i, 39).toString().equalsIgnoreCase("0")
					&& !model3.getValueAt(i, 39).toString().equalsIgnoreCase("0.0")
					&& !model3.getValueAt(i, 39).toString()
									.equalsIgnoreCase("0.00")){
		AnnexIII_c6ACount.add(39);
	}else
		AnnexIII_c6ACount.add(0);
	
	if (model3.getValueAt(i, 40) != null
			&& model3.getValueAt(i, 40).toString().length() != 0
					&& !model3.getValueAt(i, 40).toString().equalsIgnoreCase("0")
					&& !model3.getValueAt(i, 40).toString().equalsIgnoreCase("0.0")
					&& !model3.getValueAt(i, 40).toString()
									.equalsIgnoreCase("0.00")){
		AnnexIII_c6ACount.add(40);
	}else
		AnnexIII_c6ACount.add(0);
	
	if (model3.getValueAt(i, 41) != null
			&& model3.getValueAt(i, 41).toString().length() != 0
					&& !model3.getValueAt(i, 41).toString().equalsIgnoreCase("0")
					&& !model3.getValueAt(i, 41).toString().equalsIgnoreCase("0.0")
					&& !model3.getValueAt(i, 41).toString()
									.equalsIgnoreCase("0.00")){
		AnnexIII_c6ACount.add(41);
	}else
		AnnexIII_c6ACount.add(0);
	
	if (model3.getValueAt(i, 42) != null
			&& model3.getValueAt(i, 42).toString().length() != 0
					&& !model3.getValueAt(i, 42).toString().equalsIgnoreCase("0")
					&& !model3.getValueAt(i, 42).toString().equalsIgnoreCase("0.0")
					&& !model3.getValueAt(i, 42).toString()
									.equalsIgnoreCase("0.00")){
		AnnexIII_c6ACount.add(42);
	}else
		AnnexIII_c6ACount.add(0);
	
	if (model3.getValueAt(i, 43) != null
			&& model3.getValueAt(i, 43).toString().length() != 0
					&& !model3.getValueAt(i, 43).toString().equalsIgnoreCase("0")
					&& !model3.getValueAt(i, 43).toString().equalsIgnoreCase("0.0")
					&& !model3.getValueAt(i, 43).toString()
									.equalsIgnoreCase("0.00")){
		AnnexIII_c6ACount.add(43);
	}else
		AnnexIII_c6ACount.add(0);
	
	if (model3.getValueAt(i, 44) != null
			&& model3.getValueAt(i, 44).toString().length() != 0
					&& !model3.getValueAt(i, 44).toString().equalsIgnoreCase("0")
					&& !model3.getValueAt(i, 44).toString().equalsIgnoreCase("0.0")
					&& !model3.getValueAt(i, 44).toString()
									.equalsIgnoreCase("0.00")){
		AnnexIII_c6ACount.add(44);
	}else
		AnnexIII_c6ACount.add(0);
	
	if (model3.getValueAt(i, 45) != null
			&& model3.getValueAt(i, 45).toString().length() != 0
					&& !model3.getValueAt(i, 45).toString().equalsIgnoreCase("0")
					&& !model3.getValueAt(i, 45).toString().equalsIgnoreCase("0.0")
					&& !model3.getValueAt(i, 45).toString()
									.equalsIgnoreCase("0.00")){
		AnnexIII_c6ACount.add(45);
	}else
		AnnexIII_c6ACount.add(0);
	
	if (model3.getValueAt(i, 46) != null
			&& model3.getValueAt(i, 46).toString().length() != 0
					&& !model3.getValueAt(i, 46).toString().equalsIgnoreCase("0")
					&& !model3.getValueAt(i, 46).toString().equalsIgnoreCase("0.0")
					&& !model3.getValueAt(i, 46).toString()
									.equalsIgnoreCase("0.00")){
		AnnexIII_c6ACount.add(46);
	}else
		AnnexIII_c6ACount.add(0);
	
	if (model3.getValueAt(i, 47) != null
			&& model3.getValueAt(i, 47).toString().length() != 0
					&& !model3.getValueAt(i, 47).toString().equalsIgnoreCase("0")
					&& !model3.getValueAt(i, 47).toString().equalsIgnoreCase("0.0")
					&& !model3.getValueAt(i, 47).toString()
									.equalsIgnoreCase("0.00")){
		AnnexIII_c6ACount.add(47);
	}else
		AnnexIII_c6ACount.add(0);
	
	if (model3.getValueAt(i, 48) != null
			&& model3.getValueAt(i, 48).toString().length() != 0
					&& !model3.getValueAt(i, 48).toString().equalsIgnoreCase("0")
					&& !model3.getValueAt(i, 48).toString().equalsIgnoreCase("0.0")
					&& !model3.getValueAt(i, 48).toString()
									.equalsIgnoreCase("0.00")){
		AnnexIII_c6ACount.add(48);
	}else
		AnnexIII_c6ACount.add(0);
	
	if (model3.getValueAt(i, 49) != null
			&& model3.getValueAt(i, 49).toString().length() != 0
					&& !model3.getValueAt(i, 49).toString().equalsIgnoreCase("0")
					&& !model3.getValueAt(i, 49).toString().equalsIgnoreCase("0.0")
					&& !model3.getValueAt(i, 49).toString()
									.equalsIgnoreCase("0.00")){
		AnnexIII_c6ACount.add(49);
	}else
		AnnexIII_c6ACount.add(0);
	
	if (model3.getValueAt(i, 50) != null
			&& model3.getValueAt(i, 50).toString().length() != 0
					&& !model3.getValueAt(i, 50).toString().equalsIgnoreCase("0")
					&& !model3.getValueAt(i, 50).toString().equalsIgnoreCase("0.0")
					&& !model3.getValueAt(i, 50).toString()
									.equalsIgnoreCase("0.00")){
		AnnexIII_c6ACount.add(50);
	}else
		AnnexIII_c6ACount.add(0);
	
	if (model3.getValueAt(i, 51) != null
			&& model3.getValueAt(i, 51).toString().length() != 0
					&& !model3.getValueAt(i, 51).toString().equalsIgnoreCase("0")
					&& !model3.getValueAt(i, 51).toString().equalsIgnoreCase("0.0")
					&& !model3.getValueAt(i, 51).toString()
									.equalsIgnoreCase("0.00")){
		AnnexIII_c6ACount.add(51);
	}else
		AnnexIII_c6ACount.add(0);
	
	if (model3.getValueAt(i, 52) != null
			&& model3.getValueAt(i, 52).toString().length() != 0
					&& !model3.getValueAt(i, 52).toString().equalsIgnoreCase("0")
					&& !model3.getValueAt(i, 52).toString().equalsIgnoreCase("0.0")
					&& !model3.getValueAt(i, 52).toString()
									.equalsIgnoreCase("0.00")){
		AnnexIII_c6ACount.add(52);
	}else
		AnnexIII_c6ACount.add(0);
	
	if (model3.getValueAt(i, 53) != null
			&& model3.getValueAt(i, 53).toString().length() != 0
					&& !model3.getValueAt(i, 53).toString().equalsIgnoreCase("0")
					&& !model3.getValueAt(i, 53).toString().equalsIgnoreCase("0.0")
					&& !model3.getValueAt(i, 53).toString()
									.equalsIgnoreCase("0.00")){
		AnnexIII_c6ACount.add(53);
	}else
		AnnexIII_c6ACount.add(0);*/
	
////////////////////////////////////////////////////////////////////////////////////////////////////////////	
	
	if(!(AnnexIII_c6ACount.get(c6A_94PCount_counter)==0) && !model3.getValueAt(i, 6).toString().equalsIgnoreCase("Yes"))
	{
		c6A_94P.setTotalGrossamountunderChapterVIA(model3.getValueAt(i, AnnexIII_c6ACount.get(c6A_94PCount_counter)).toString());		
	}
	else
		c6A_94P.setTotalGrossamountunderChapterVIA("");
	c6A_94PCount_counter++;
	
	
	
	if (!(c6A_94P.getChapterVIASectionID() == "80C" || c6A_94P.getChapterVIASectionID() == "80CCC" ||  c6A_94P.getChapterVIASectionID() == "80CCD(1)"
			|| c6A_94P.getChapterVIASectionID() == "80CCD(1B)" || c6A_94P.getChapterVIASectionID() == "80D" || c6A_94P.getChapterVIASectionID() == "80E"))
	{
	if(!(AnnexIII_c6ACount.get(c6A_94PCount_counter)==0) && !model3.getValueAt(i, 6).toString().equalsIgnoreCase("Yes") )
	{
		
		c6A_94P.setTotalQualifyingamountunderChapterVIA(model3.getValueAt(i, AnnexIII_c6ACount.get(c6A_94PCount_counter)).toString());			
	}
	else
		c6A_94P.setTotalQualifyingamountunderChapterVIA("");
	c6A_94PCount_counter++;
	
	}
	
	if(!(AnnexIII_c6ACount.get(c6A_94PCount_counter)==0) && !model3.getValueAt(i, 6).toString().equalsIgnoreCase("Yes"))
	{
		c6A_94P.setTotalDeductibleamountunderChapterVIA(model3.getValueAt(i, AnnexIII_c6ACount.get(c6A_94PCount_counter)).toString());
	}
	else
		c6A_94P.setTotalDeductibleamountunderChapterVIA("");
	c6A_94PCount_counter++;
	
	
	
	return c6A_94P;
	
	
}
			
			
			
			
			
			

		
		
		
	
	
	
	
	//RPU 2.9 end

	/*
	 * ##########################################################################
	 * ############ FOR CORRECTION
	 * #####################################################################
	 */

	/**
	 * Method used for assigning values to FH Bean for 'Correction' statements
	 * @param BH_Count
	 * @return
	 */
	public FHBean _FHAppenderCorrection(Integer BH_Count) {

		fh = new FHBean();
//		DateTimeFormatter dtf = DateTimeFormatter.ofPattern("ddMMyyyy");
//	    LocalDateTime local =LocalDateTime.now();
//	    String CreationDate = dtf.format(local);
//	    fh.setCreationDate(CreationDate);
		fh.setCreationDate(new SimpleDateFormat("ddMMyyyy",Locale.ENGLISH).format(new Date()));
		fh.setEmployerTAN(rpu.tan);

		if (rpu.formNumber.equalsIgnoreCase("24Q")) {
			fh.setFileType("SL1");
		} else if (rpu.formNumber.equalsIgnoreCase("26Q")
				|| rpu.formNumber.equalsIgnoreCase("27Q")) {
			fh.setFileType("NS1");
		} else if (rpu.formNumber.equalsIgnoreCase("27EQ")) {
			fh.setFileType("TC1");
		}
		fh.setUploadType("C");
		fh.setSequenceNum("1");
		fh.setUploaderType("D");
		fh.setNo_of_Batches(BH_Count.toString());
		fh.setRPU_Name("Protean RPU 5.7");//RPU 3.8 VersionChange Production problem
		                               //RPU 3.9 VersionChange Chatbot
		                                 // NSDL Changed to Protean RPU 3.9 
		                                 //RPU 4.0 Changes for CR82186 Version Change FVU 7.5
		                                 //RPU 4.1 Changes for CR82683 Version Change FVU 7.6
		                                 //RPU 4.2 Changes for CR82937 Version Change FVU 7.7
		                                 //RPU 4.3 Changes for CR82937 Version Change FVU 7.8
		                                 //RPU 4.4 Changes for CR83190 Version Change FVU 7.9
		                                 //RPU 4.5 Changes for CR83677 Version Change FVU 8.0
		                                 //RPU 4.6 Changes for CR76613 Version Change FVU 8.1 Only Bug Fix
		                                 //RPU 4.7 Changes for CR84532 Version Change FVU 8.2
		                                 //RPU 4.8 Changes for CR85831 Version Change FVU 8.3
										 //RPU 4.9 Changes for CR85567 Version Change FVU 8.4
		                                 //RPU 5.0 Changes for CR85881 Version Change FVU 8.5
		                                 //RPU 5.1 Changes for CR86668 Version Change FVU 8.6
		                                 //RPU 5.2 Changes for CR86827 Version Change FVU 8.7
		                                 //RPU 5.3 Changes for CR87566 Version Change FVU 8.8
		                                 //RPU 5.4 Changes for CR88008 Version Change FVU 8.9
                                         //RPU 5.5 Changes for CR88360 Version Change FVU 9.0
		                                 //RPU 5.6 Changes for CR88828 Version Change FVU 9.1
		                                 //RPU 5.7 Changes for CR88828 Version Change FVU 9.2
		fh.setConsilidatedHash(GRPU.filehash);
		return fh;
	}

	/**
	 * Method used for assigning values to BH Bean for 'Correction' type statements
	 * @param ls
	 * @param correctionType
	 * @param Annexure_II_List
	 * @param BH_Count
	 * @param challanList
	 * @return
	 */
	public BHBean _BHAppenderCorrection(ArrayList<Object> ls,
			String correctionType, ArrayList<Integer> Annexure_II_List, ArrayList<Integer> Annexure_III_List,
			Integer BH_Count,ArrayList<Integer> challanList) {
		


		BHBean bh = new BHBean();
		DecimalFormatSymbols sf = new DecimalFormatSymbols(Locale.ENGLISH);DecimalFormat df = new DecimalFormat("0.00",sf);
		df.setMaximumFractionDigits(2);
		bh.setLineNumber(new Integer(ls.size() + 1).toString());
		bh.setRecordType("BH");

		// Integer BHNumber = CountOccurence(sb.toString(),"^BH^") + 1 ;
		bh.setBatchNumber(BH_Count.toString());

		if (!("C1").equalsIgnoreCase(correctionType) && !("C4").equalsIgnoreCase(correctionType) && !("C6").equalsIgnoreCase(correctionType)) //## Newly Developed for correction Ver1.2 --- removed '!'
		{ 
			bh.setCountofChallantransfervoucherRecords(rpu.ChallanCount);
		}
		
		
		bh.setFormNumber(rpu.formNumber);

		if (correctionType != null && !correctionType.equals("R")) {

			bh.setTransactionType(correctionType); // for Correction

		}

		// Newly commented as on 07/04/2015 by Akansha
		if (rpu.updateDD != null && !rpu.updateDD.equalsIgnoreCase("")
				&& !rpu.updateDD.equalsIgnoreCase("0")) {
			bh.setBatchUpdationIndicator("1");
		} else {
			bh.setBatchUpdationIndicator("0");
		}
		

		bh.setOriginalTokenNumberofthestatement(rpu.orgtoken);
		bh.setTokennoofpreviousregularstatement(rpu.prevtoken);

		
		  if(!correctionType.equalsIgnoreCase("C5") ) {
		  bh.setTANofDeductorEmployer(rpu.tan);
		  
		  }
		
		bh.setTANRegistrationNumber(rpu.tanregnm); // ## New Development for Java RPU
												// as on 13/04/2015

		if (!correctionType.equalsIgnoreCase("C9")
				&& !correctionType.equalsIgnoreCase("C5")
				&& !correctionType.equalsIgnoreCase("C4")// Added newly as on // 07/04/2015
				&& !correctionType.equalsIgnoreCase("C6")) 
		{

			if (bh.getBatchUpdationIndicator() != null
					&& bh.getBatchUpdationIndicator().equalsIgnoreCase("1")) {
				bh.setPANofDeductorEmployer(rpu.pan);
			}
		}

		bh.setAssessmentYr(rpu.assyear.substring(0, 4)
				+ rpu.assyear.substring(7, 9));
		bh.setFinancialYr(rpu.finyear.substring(0, 4)
				+ rpu.finyear.substring(7, 9));
		bh.setPeriod(rpu.quarter);
		bh.setNameofEmployerDeductor(rpu.dedname);

		if ((rpu.formNumber.equalsIgnoreCase("24Q") && correctionType
				.equalsIgnoreCase("C1"))
				|| ((rpu.formNumber.equalsIgnoreCase("24Q")
						|| rpu.formNumber.equalsIgnoreCase("26Q")
						|| rpu.formNumber.equalsIgnoreCase("27Q") || rpu.formNumber
							.equalsIgnoreCase("27EQ"))
						&& bh.getBatchUpdationIndicator().equalsIgnoreCase("1") && (!correctionType
						.equalsIgnoreCase("C4") && !correctionType.equalsIgnoreCase("C6")
						&& !correctionType.equalsIgnoreCase("C5") && !correctionType
							.equalsIgnoreCase("C9")))) {
			bh.setEmployerDeductorBranchDivision(rpu.dedbranch);
			bh.setEmployerDeductorAddress1(rpu.flatno);
			bh.setEmployerDeductorAddress2(rpu.dedbldgname);
			bh.setEmployerDeductorAddress3(rpu.road);
			bh.setEmployerDeductorAddress4(rpu.area);
			bh.setEmployerDeductorAddress5(rpu.dedtown);
		//	bh.setEmployerDeductorState(rpu.dedstatetwo);
			bh.setEmployerDeductorPIN(rpu.dedpin);
			bh.setEmployerDeductorEmailID(rpu.dedemail);
			// Added newly by Akansha 07/04/2015
			bh.setEmployerDeductorSTDcode(rpu.dedtelstd);
			bh.setEmployerDeductorTelPhoneNo(rpu.dedtel);
			if (rpu.hasaddchanged.equals("1")) {
				bh.setChangeofAddressofemployerDeductorsincelastReturn("Y");
			} else if (rpu.hasaddchanged.equals("2")) {
				bh.setChangeofAddressofemployerDeductorsincelastReturn("N");
			}
			// **************************************
		}
		
		/*****************************************************************/
		//Added by Sadhana, FRD Version 2.1
		/*if (!rpu.dedstateone.equals("0")) {
			bh.setStateName(rpu.dedstateone);
		}*/
		bh.setEmployerDeductorState(rpu.dedstatetwo);
		System.out.println("state code while saving ="+rpu.dedstatetwo);
		//bh.setEmployerDeductorState(rpu.dedstatetwo);
		/*****************************************************************/
		
		if (!rpu.formNumber.equalsIgnoreCase("24Q") && bh.getBatchUpdationIndicator().equalsIgnoreCase("1") ) { //## added for observation 395 version 1.2 by latish
			if (!correctionType.equalsIgnoreCase("C5")
					&& !correctionType.equalsIgnoreCase("C9")) {

				if (rpu.dedtel != null && rpu.dedtel.length() != 0) {
					bh.setEmployerDeductorSTDcode(rpu.dedtelstd);
					bh.setEmployerDeductorTelPhoneNo(rpu.dedtel);
				}

				if (rpu.hasaddchanged.equals("1")) {
					bh.setChangeofAddressofemployerDeductorsincelastReturn("Y");
				} else if (rpu.hasaddchanged.equals("2")) {
					bh.setChangeofAddressofemployerDeductorsincelastReturn("N");
				}

			}

		}

		bh.setDeductorType(GrpuUtil
				.getDeductorCode(rpu.JComboBox_Form_Sub1_Type_of_Deductor
						.getSelectedItem().toString()));

		if ((rpu.formNumber.equalsIgnoreCase("24Q") && correctionType
				.equalsIgnoreCase("C1"))
				|| ((rpu.formNumber.equalsIgnoreCase("24Q")
						|| rpu.formNumber.equalsIgnoreCase("26Q")
						|| rpu.formNumber.equalsIgnoreCase("27Q") || rpu.formNumber
							.equalsIgnoreCase("27EQ"))
						&& (!correctionType.equalsIgnoreCase("C5")
								&& !correctionType.equalsIgnoreCase("C9") && !correctionType
									.equalsIgnoreCase("C4") && !correctionType
									.equalsIgnoreCase("C6")) && bh
						.getBatchUpdationIndicator().equalsIgnoreCase("1"))) {
			bh.setNameofPersonresponsibleforpayingsalaryDeduction(rpu.rpname);
			bh.setDesignationofthePersonresponsibleforpayingsalaryDeduction(rpu.rpdesig);
			bh.setResponsiblePersonAddress1(rpu.rpflatno);
			bh.setResponsiblePersonAddress2(rpu.rpbuldg);
			bh.setResponsiblePersonAddress3(rpu.rproad);
			bh.setResponsiblePersonAddress4(rpu.rparea);
			bh.setResponsiblePersonAddress5(rpu.rptown);
			bh.setResponsiblePersonState(rpu.rpstate);
			bh.setResponsiblePersonPIN(rpu.rppin);
			bh.setResponsiblePersonEmailID(rpu.rpemail);

			bh.setMobilenumber(rpu.rpmobile);
			bh.setResponsiblePersonSTDCode(rpu.rptelnumstd);
			bh.setResponsiblePersonTelPhoneNo(rpu.rptelnum);
		}

	if(bh.getBatchUpdationIndicator().equalsIgnoreCase("1")) //## added for observation 395 version 1.2 by latish
	{
			if (rpu.rpisaddresschng.equals("1")
					&& ((rpu.formNumber.equalsIgnoreCase("24Q") && (correctionType
							.equalsIgnoreCase("C1") || correctionType
							.equalsIgnoreCase("C2") || correctionType
							.equalsIgnoreCase("C3") )) || ((rpu.formNumber
							.equalsIgnoreCase("26Q")
							|| rpu.formNumber.equalsIgnoreCase("27Q") || rpu.formNumber
								.equalsIgnoreCase("27EQ")) && (!correctionType
							.equalsIgnoreCase("C5") && !correctionType
							.equalsIgnoreCase("C9"))))) { // ## Newly developed for correction Ver1.2 by Akansha --- new condition of C2 is added
				bh.setChangeofAddressofResponsiblepersonsincelastReturn("Y");
			} else if ((rpu.rpisaddresschng.equals("2"))
					&& (rpu.formNumber.equalsIgnoreCase("24Q") && (correctionType
							.equalsIgnoreCase("C1") || correctionType
							.equalsIgnoreCase("C2") || correctionType
							.equalsIgnoreCase("C3") ))
					|| ((rpu.formNumber.equalsIgnoreCase("26Q")
							|| rpu.formNumber.equalsIgnoreCase("27Q") || rpu.formNumber
								.equalsIgnoreCase("27EQ")) && (!correctionType
							.equalsIgnoreCase("C5") && !correctionType
							.equalsIgnoreCase("C9")))) {// ## Newly developed for correction Ver1.2 by Akansha --- new condition of C2 is added
				bh.setChangeofAddressofResponsiblepersonsincelastReturn("N");
			}    
	}

		// Code for setting total Deposit amount -- start

		int count = new Integer(rpu.ChallanCount) + 1;
		Double BatchTotal = 0.00;
		if(challanList != null)
		{
			for (Integer i  : challanList) {
				if(correctionType.equalsIgnoreCase("C2") || correctionType.equalsIgnoreCase("C9") )
				{
					if (model.getValueAt(i, 10) != null
						&& !model.getValueAt(i, 10).toString().equalsIgnoreCase("")) {
					Double temp = Double.parseDouble(model.getValueAt(i, 10)
							.toString());
					BatchTotal = BatchTotal + temp;
					}
				}
				else
				{
					if (model.getValueAt(i+1, 10) != null
							&& !model.getValueAt(i+1, 10).toString().equalsIgnoreCase("")) {
						Double temp = Double.parseDouble(model.getValueAt(i+1, 10)
								.toString());
						BatchTotal = BatchTotal + temp;
					}
				}
		}
		}



		// Code for setting total Deposit amount -- End
		if (!BatchTotal.toString().equalsIgnoreCase("0.0")
				&& !correctionType.equalsIgnoreCase("C5")) {
			bh.setBatchTotalofTotalofDepositAmountasperChallan(df.format(BatchTotal
					));
		}
		
		//Production bug fix --- 30/12/2015
		//Newly added for FRD1.5 RPUVer1.5 //newly added for C9 correction
		if (BatchTotal.toString().equalsIgnoreCase("0.0")
				&& (correctionType.equalsIgnoreCase("C3")
				|| correctionType.equalsIgnoreCase("C9"))) {
			bh.setBatchTotalofTotalofDepositAmountasperChallan(df.format(BatchTotal
					));
		}
		//***********************************************************
		

		Integer SalaryCount = 0;

		if (rpu.formNumber.equalsIgnoreCase("24Q")
				&& correctionType.equalsIgnoreCase("C5")) {

			bh.setCountofSalaryDetailsRecords(SalaryCount.toString());

		}

		if (rpu.formNumber.equalsIgnoreCase("24Q")
				&& rpu.quarter.equalsIgnoreCase("Q4")) {
			SalaryCount = 0;

			if (Annexure_II_List != null) {
				SalaryCount = Annexure_II_List.size();
			}

			if (correctionType.equalsIgnoreCase("C4")
					|| correctionType.equalsIgnoreCase("C5")) {

				bh.setCountofSalaryDetailsRecords(SalaryCount.toString());
			}

			SalaryCount = SalaryCount + 1;
			Double SalaryTotal = 0.00;
			Double temp = 0.00;
			if (Annexure_II_List != null)
				for (Integer i : Annexure_II_List) {
					if (model2.getValueAt(i, 16) != null
							&& !model2.getValueAt(i, 16).toString()
									.equalsIgnoreCase("")) {
						temp = Double.parseDouble(model2.getValueAt(i, 16)
								.toString());
					} else {
						temp = 0.00;
					}

					SalaryTotal = SalaryTotal + temp;
				}

			if (correctionType.equalsIgnoreCase("C4")) {

				bh.setBatchTotalofGrossTotalIncomeasperSalaryDetail(df
						.format(SalaryTotal
						));

			}

		}

		// Code for Setting Total Salary cound from annexure 2 -- END

		bh.setAOApproval("N");
		if ("Regular".equalsIgnoreCase(rpu.valueOfTypeOfStmt)) {

			if (rpu.rpisregstatement.equals("1")) {
				bh.setWhetherregularstatementforForm24Qfiledforearlierperiod("Y");
			} else if (rpu.rpisregstatement.equals("2")) {
				bh.setWhetherregularstatementforForm24Qfiledforearlierperiod("N");
			}

		}


		/*
		 * if(!correctionType.equalsIgnoreCase("C5")) {
		 * bh.setLastDeductorType(rpu.lastDD); }
		 */

		if (!correctionType.equalsIgnoreCase("C5")
				&& !correctionType.equalsIgnoreCase("C9")
				&& !correctionType.equalsIgnoreCase("C4")
				&& !correctionType.equalsIgnoreCase("C6")
				&& bh.getBatchUpdationIndicator() != null
				&& bh.getBatchUpdationIndicator().equalsIgnoreCase("1")) {
			if (!rpu.dedstateone.equals("0")) {
				bh.setStateName(rpu.dedstateone);
			}
			bh.setPAOCode(rpu.paocode);
			bh.setDDOCode(rpu.ddocode);
			if (!rpu.dedminstrydept.equalsIgnoreCase("0")) // added for
															// observation in
															// 26Q
			{
				bh.setMinistryName(GrpuUtil
						.getSubMinistryCode(rpu.JComboBox_Form_Sub2_MinistryName
								.getSelectedItem().toString()));
			}

			if (!rpu.dedminstrydeptothers.equalsIgnoreCase("0")) // added for
																	// observation
																	// in 26Q
			{
				bh.setMinistryNameOther(rpu.dedminstrydeptothers);
			}

			bh.setTANRegistrationNumber(rpu.tanregnm); // ---- NEW DEVELOPMENT
														// TEMP COMMENTED BY
														// DEEPAK

			bh.setPAORegistrationNo(rpu.paoregnm);
			bh.setDDORegistrationNo(rpu.ddoregnm);

		}

		if (!correctionType.equalsIgnoreCase("C5")
				&& !correctionType.equalsIgnoreCase("C9") && !correctionType.equalsIgnoreCase("C4") //Added on 24062015 by Akansha
				&& !correctionType.equalsIgnoreCase("C6")
				&& bh.getBatchUpdationIndicator() != null
				&& bh.getBatchUpdationIndicator().equalsIgnoreCase("1")) {
			if (rpu.dedalttelstd != null && rpu.dedalttelstd.length() != 0) {
				bh.setEmployerDeductorSTDcode_alt(rpu.dedalttelstd);
			}

			if (rpu.dedalttel != null && rpu.dedalttel.length() != 0) {
				bh.setEmployerDeductorTelPhoneNo_alt(rpu.dedalttel);
			}

			if (rpu.dedemailalt != null && rpu.dedemailalt.length() != 0) {
				bh.setEmployerDeductorEmailID_alt(rpu.dedemailalt);
			}

			if (rpu.rptelnumaltstd != null && rpu.rptelnumaltstd.length() != 0) {
				bh.setResponsiblePersonSTDCode_alt(rpu.rptelnumaltstd);
			}

			if (rpu.rptelnumalt != null && rpu.rptelnumalt.length() != 0) {
				bh.setResponsiblePersonTelPhoneNo_alt(rpu.rptelnumalt);
			}

			if (rpu.rpemailalt != null && rpu.rpemailalt.length() != 0) {
				bh.setResponsiblePersonEmailID_alt(rpu.rpemailalt);
			}

			

		}
		if ( rpu.dedain != null
				&& rpu.dedain.length() != 0 && bh.getBatchUpdationIndicator().equalsIgnoreCase("1") 
				&& !correctionType.equalsIgnoreCase("C5")
				&& !correctionType.equalsIgnoreCase("C9")
				&& !correctionType.equalsIgnoreCase("C4")
				&& !correctionType.equalsIgnoreCase("C6")) { // ## Newly developed for correction Ver1.2 
			// removed check for (rpu.typeofDD.equalsIgnoreCase("A") || rpu.typeofDD.equalsIgnoreCase("S"))	&& added check for BatchUpdationIndicator 
			bh.setAccountOfficeIdentificationNumber(rpu.dedain);
		}
		if ("Correction".equalsIgnoreCase(rpu.valueOfTypeOfStmt)) {

			if (rpu.lasttan != null && !rpu.lasttan.equals("")) {
				bh.setLastTANofDeductorEmployerCollector(rpu.lasttan);
			}



			if (!correctionType.equalsIgnoreCase("C5")
					&& !correctionType.equalsIgnoreCase("C9")
					&& !correctionType.equalsIgnoreCase("C4")
					&& !correctionType.equalsIgnoreCase("C6")) {

				if (bh.getBatchUpdationIndicator() != null
						&& bh.getBatchUpdationIndicator().equalsIgnoreCase("1")) {
					
					if (rpu.lastDD != null && !rpu.lastDD.equals("")) {
						bh.setLastDeductorType(rpu.lastDD);
					}
				}
			}

		}

		if (correctionType.equalsIgnoreCase("C1")
				|| correctionType.equalsIgnoreCase("C4")
				|| correctionType.equalsIgnoreCase("C5")
				|| correctionType.equalsIgnoreCase("C9")
				|| correctionType.equalsIgnoreCase("C6")) {
			bh.setBatchUpdationIndicator(null);
		}
		
		/***************************************************************/
		//For FRD2.1, added by Sadhana, append new four fillers.
		if (rpu.gstn != null && rpu.gstn.length() != 0 && rpu.gstn != "LINEHASH") {
			bh.setGstn(rpu.gstn);
		}
		
		
		Integer AnnexIIISalaryCount = 0;    // For Bug fix RPU 4.6 CR 76611 No value should be populated for 24Q Q1 Q2 and Q3
		                                    // '0' should be populated for count of 94P in BH if 24Q and Q4 irrespective of FY
		if (rpu.formNumber.equalsIgnoreCase("24Q") && rpu.quarter.equalsIgnoreCase("Q4") &&  Integer.parseInt(rpu.finyear.substring(0, 4)) >= 2009)
				{
			if(correctionType.equalsIgnoreCase("C5")) {

			bh.setCountofSection194PDetailsRecords(AnnexIIISalaryCount.toString());
			
		}
				}
				
		
		// Code for Setting Section 194P Details  Records count from annexure 3  -- Start  //Changes for CR82186 Create file .txt Correction for AnnexureIII
		if (rpu.formNumber.equalsIgnoreCase("24Q")
				&& rpu.quarter.equalsIgnoreCase("Q4")  &&  Integer.parseInt(rpu.finyear.substring(0, 4)) >= 2021) {
			//Integer AnnexIIISalaryCount = 0;
			AnnexIIISalaryCount = 0;

			if (Annexure_III_List != null) {
				AnnexIIISalaryCount = Annexure_III_List.size();
			}

			if (correctionType.equalsIgnoreCase("C6")
					|| correctionType.equalsIgnoreCase("C5")) {

				bh.setCountofSection194PDetailsRecords(AnnexIIISalaryCount.toString());
			}
			
			AnnexIIISalaryCount = AnnexIIISalaryCount + 1;
			Double GrossTotalIncome = 0.00;
			Double temp = 0.00;
           	if (Annexure_III_List != null)
			for (Integer i : Annexure_III_List) {
				if (model3.getValueAt(i, 13) != null
						&& !model3.getValueAt(i, 13).toString()
								.equalsIgnoreCase("")) {
					temp = Double.parseDouble(model3.getValueAt(i, 13)
							.toString());
				} else {
					temp = 0.00;
				}

				GrossTotalIncome = GrossTotalIncome + temp;
			}
			
           	if (correctionType.equalsIgnoreCase("C6")) {
           		
           		bh.setTotalofGrossTotalIncome(df
						.format(GrossTotalIncome));
           	}
		}
			
		// Code for Setting Section 194P Details  Records count from annexure 3  -- End	
		
		
		/*if (rpu.filler71 != null && rpu.filler71.length() != 0) {
			bh.setFiller71(rpu.filler71);
		}
		if (rpu.filler72 != null && rpu.filler72.length() != 0) {
			bh.setFiller72(rpu.filler72);
		}
		if (rpu.filler73 != null && rpu.filler73.length() != 0) {
			bh.setFiller73(rpu.filler73);
		}*/
		/***************************************************************/
		
		
		
		return bh;
	}

	/**
	 * Method used for assigning values to CD Bean for 'Correction' type statements
	 * @param ls
	 * @param i
	 * @param ddcount
	 * @param CorrectionType
	 * @param ChallanUpdationIndicatorList
	 * @param BH_Count
	 * @return
	 */
	public CDBean _CDAppenderCorrection(ArrayList<Object> ls, int i,
			int ddcount, String CorrectionType,
			List<Integer> ChallanUpdationIndicatorList, Integer BH_Count) {
		DecimalFormatSymbols sf = new DecimalFormatSymbols(Locale.ENGLISH);DecimalFormat df = new DecimalFormat("0.00",sf);
		CDBean cd = new CDBean();

		cd.setLineNumber(new Integer(ls.size() + 1).toString());
		cd.setRecordType("CD");
		cd.setBatchNumber(BH_Count.toString());
		cd.setChallanDetailRecordNumber(new Integer(i - 1).toString());

		// For obtaining Deductee detail record Number //

		Integer DeducteeCount = (new Integer(model1.getRowCount() - 2));

		li = deducteeDetails(DeducteeCount, i - 1);
		
		if("C9".equalsIgnoreCase(CorrectionType) && li!= null)
		{
			ddcount = li.size();
		}

		// Logic Added for Setting Challan UPDATION Indicator -- start //

		if (CorrectionType.equalsIgnoreCase("C3")) {
			if (ChallanUpdationIndicatorList != null) {
				if (ChallanUpdationIndicatorList.contains(i)) {
					cd.setChallanUpdationIndicator("1");
				} else {
					cd.setChallanUpdationIndicator("0");
				}
			}

		}

		// Logic Added for Setting Challan UPDATION Indicator -- END //
		// END //

		// Validating NIL Challan on basis of other values //
		String TDS_Fees;
		String TDS_Others;
		String TDS_Interest;
		String TDS_CESS;
		String TDS_SurCharge;
		String TDS_Income_Tax;

	
		if (model.getValueAt(i, 3) != null
				&& !model.getValueAt(i, 3).toString().equals("")) {
			TDS_Income_Tax = model.getValueAt(i, 3).toString();
		} else {
			TDS_Income_Tax = "0.00";
		}

		if (model.getValueAt(i, 4) != null
				&& !model.getValueAt(i, 4).toString().equals("")) {
			TDS_SurCharge = model.getValueAt(i, 4).toString();
		} else {
			TDS_SurCharge = "0.00";
		}

		if (model.getValueAt(i, 5) != null
				&& !model.getValueAt(i, 5).toString().equals("")) {
			TDS_CESS = model.getValueAt(i, 5).toString();
		} else {
			TDS_CESS = "0.00";
		}

		if (model.getValueAt(i, 6) != null
				&& !model.getValueAt(i, 6).toString().equals("")) {
			TDS_Interest = model.getValueAt(i, 6).toString();
		} else {
			TDS_Interest = "0.00";
		}

		if (model.getValueAt(i, 8) != null
				&& !model.getValueAt(i, 8).toString().equals("")) {
			TDS_Others = model.getValueAt(i, 8).toString();
		} else {
			TDS_Others = "0.00";
		}

		if (model.getValueAt(i, 7) != null
				&& !model.getValueAt(i, 7).toString().equals("")) {
			TDS_Fees = model.getValueAt(i, 7).toString();
		} else {
			TDS_Fees = "0.00";
		}

		if (TDS_Income_Tax.equalsIgnoreCase("0.00")
				&& TDS_SurCharge.equalsIgnoreCase("0.00")
				&& TDS_CESS.equalsIgnoreCase("0.00")
				&& TDS_Interest.equalsIgnoreCase("0.00")
				&& TDS_Others.equalsIgnoreCase("0.00")
				&& TDS_Fees.equalsIgnoreCase("0.00")) {
			cd.setNILChallanIndicator("Y");
		} else {
			cd.setNILChallanIndicator("N");
		}

		if(CorrectionType.equalsIgnoreCase("C9"))
		{
			cd.setCountofDeducteePartyRecords(new Integer(ddcount).toString());
		}
		
		
		// cd.setCountofDeducteePartyRecords(DeducteeCount.toString());
		if (ddcount != 0) {
			cd.setCountofDeducteePartyRecords(new Integer(ddcount).toString()); // count
																				// of
																				// dd
																				// --
																				// Zero
																				// for
																				// c2
		}

		if (cd.getNILChallanIndicator().equals("N")
				&& !CorrectionType.equalsIgnoreCase("C5")) {

			if (model.getValueAt(i, 17) != null
					&& !model.getValueAt(i, 17).toString().equals("")
					&& ((model.getValueAt(i, 18).toString().equals("--Select--") && 
							Integer.parseInt(rpu.finyear.substring(0, 4)) < 2010) || model.getValueAt(i, 18).toString().substring(0, 1)
							.equalsIgnoreCase("N"))) {
				cd.setChallanSerialNo(model.getValueAt(i, 17).toString()); // column
																			// 17
																			// for
																			// each
																			// row
			} else {
				if (model.getValueAt(i, 17) != null
						&& !model.getValueAt(i, 17).toString().equals("")
						&& model.getValueAt(i, 18).toString().substring(0, 1)
								.equalsIgnoreCase("Y")) {
					cd.setDDOSerialNo(model.getValueAt(i, 17).toString());
				}
			}

		}


/*		if (!CorrectionType.equalsIgnoreCase("C5")
				&& model.getValueAt(i, 13) != null
				&& !model.getValueAt(i, 13).toString().equals("")
				&& model.getValueAt(i, 18).toString().substring(0, 1)
						.equalsIgnoreCase("N")) {
			if (cd.getNILChallanIndicator().equals("N")) {
				cd.setBankBranchCode(model.getValueAt(i, 13).toString());
			}

		}*/
		
		if (!CorrectionType.equalsIgnoreCase("C5") && model.getValueAt(i, 13) != null
				&& !model.getValueAt(i, 13).toString().equals("")
				&& (model.getValueAt(i, 18).toString().equals("--Select--") || model.getValueAt(i, 18).toString().substring(0, 1)
						.equalsIgnoreCase("N"))) // Changed on 03/03/2015 --
												// Defect FIx for 27Q
												// Observation NO 23 -
												// questionable
		{
			
			if (cd.getNILChallanIndicator().equals("N")) {
				cd.setBankBranchCode(model.getValueAt(i, 13).toString());
			}

		} else if (!CorrectionType.equalsIgnoreCase("C5") && model.getValueAt(i, 13) != null
				&& !model.getValueAt(i, 13).toString().equals("")
				&& Integer.parseInt(rpu.finyear.substring(0, 4)) >= 2010) {
			if (cd.getNILChallanIndicator().equals("N")) {
				cd.setBankBranchCode(model.getValueAt(i, 13).toString());
			}
		}

		if (!CorrectionType.equalsIgnoreCase("C5")
				&& model.getValueAt(i, 15) != null
				&& !model.getValueAt(i, 15).toString().equals("")) {
			cd.setDateofBankChallanTransferVoucher(model.getValueAt(i, 15)
					.toString().replaceAll("/", ""));
		}

		if (!model.getValueAt(i, 2).toString().contains("Select")
				&& (CorrectionType.equalsIgnoreCase("C2")
						|| CorrectionType.equalsIgnoreCase("C3") || CorrectionType
							.equalsIgnoreCase("C9")) ) { //## Newly developed for correction Ver1.2 by Akansha Obv 432 --- added check of updation indicator
			//## Newly developed for correction Ver1.2 by Akansha Obv 454 --- added check of updation indicator
			if(Integer.parseInt(rpu.finyear.substring(0,4))<2010 && !"0".equals(cd.getChallanUpdationIndicator()))
			
			cd.setSection(model.getValueAt(i, 2).toString());
			
			else if(Integer.parseInt(rpu.finyear.substring(0,4))>=2010 && Integer.parseInt(rpu.assyear.substring(0,4))<2014)
				cd.setSection(model.getValueAt(i, 2).toString());
		}//****************************************************************************

		if (!CorrectionType.equalsIgnoreCase("C5") && !"0".equals(cd.getChallanUpdationIndicator())) { //## Newly developed for correction Ver1.2 by Akansha Obv 432 --- added check of updation indicator
			cd.setOltasTDSTCSIncomeTax(TDS_Income_Tax);
			cd.setOltasTDSTCSSurcharge(TDS_SurCharge);
			cd.setOltasTDSTCSCess(TDS_CESS);
			cd.setOltasTDSTCSInterestAmount(TDS_Interest); 
			cd.setOltasTDSTCSOthers(TDS_Others);
		}

		if (!CorrectionType.equalsIgnoreCase("C5")) {

			if (cd.getNILChallanIndicator().equals("N")) {
				if (model.getValueAt(i, 10) != null
						&& !model.getValueAt(i, 10).toString().equals("")) {
					cd.setTotal_DepositAmount_ChallanTransferVoucherNumber(model
							.getValueAt(i, 10).toString());
				}
			} else {
				cd.setTotal_DepositAmount_ChallanTransferVoucherNumber("0.00");
			}

		}

		Double TotalTaxDeposited = 0.00;

		Double DDSurcharge = 0.00;
		Double DDCess = 0.00;
		Double DDIncomeTax = 0.00;
		Double TotalTaxDeducted = 0.00;

		System.out.println("li = "+li);
		for (Integer j : li) {


			if (model1.getValueAt(j, 23) != null
					&& !model1.getValueAt(j, 23).toString()
							.equalsIgnoreCase("")) {
				if (model1.getValueAt(j, 2) != null
						&& !model1.getValueAt(j, 2).toString()
								.equalsIgnoreCase("")
						&& model1.getValueAt(j, 2).toString().substring(0, 1)
								.equalsIgnoreCase("U")) {
					System.out.println("value of j create file err = "+model1.getValueAt(j, 23));
					System.err.println(Double.parseDouble(model1.getValueAt(j, 23).toString()));
					System.err.println(Double.parseDouble(model1.getValueAt(j, 24).toString()));
					TotalTaxDeposited = TotalTaxDeposited
							+ Double.parseDouble(model1.getValueAt(j, 23)
									.toString())
							- Double.parseDouble(model1.getValueAt(j, 24)
									.toString());
				} else if (model1.getValueAt(j, 2) != null
						&& !model1.getValueAt(j, 2).toString()
						.equalsIgnoreCase("")
				&& model1.getValueAt(j, 2).toString().substring(0, 1)
						.equalsIgnoreCase("A")) {
					TotalTaxDeposited = TotalTaxDeposited
							+ Double.parseDouble(model1.getValueAt(j, 23)
									.toString());
				}

			} else {
				TotalTaxDeposited = TotalTaxDeposited + 0.00;
			}

			if (model1.getValueAt(j, 21) != null
					&& !model1.getValueAt(j, 21).toString()
							.equalsIgnoreCase("")) {
				if (model1.getValueAt(j, 2) != null
						&& !model1.getValueAt(j, 2).toString()
								.equalsIgnoreCase("")
						&& model1.getValueAt(j, 2).toString().substring(0, 1)
								.equalsIgnoreCase("U")) {
					TotalTaxDeducted = TotalTaxDeducted
							+ Double.parseDouble(model1.getValueAt(j, 21)
									.toString())
							- Double.parseDouble(model1.getValueAt(j, 22)
									.toString());

				} else if (model1.getValueAt(j, 2) != null
						&& !model1.getValueAt(j, 2).toString()
						.equalsIgnoreCase("")
				&& model1.getValueAt(j, 2).toString().substring(0, 1)
						.equalsIgnoreCase("A")){
					TotalTaxDeducted = TotalTaxDeducted
							+ Double.parseDouble(model1.getValueAt(j, 21)
									.toString());
				}

			} else {
				TotalTaxDeducted = TotalTaxDeducted + 0.00;
			}



			Object o[] = rpu.ddlist.get(j);
			Integer ddListLength =0;
			if(o!=null)
			ddListLength = o.length;
		
			

			
			if (model1.getValueAt(j, 19) != null
					&& !model1.getValueAt(j, 19).toString()
							.equalsIgnoreCase("")) {
				if (model1.getValueAt(j, 2) != null
						&& !model1.getValueAt(j, 2).toString()
								.equalsIgnoreCase("")
						&& model1.getValueAt(j, 2).toString().substring(0, 1)
								.equalsIgnoreCase("U")) {

					if ("Import".equals(rpu.method)) {
						
						DDSurcharge = DDSurcharge
								+ Double.parseDouble(model1.getValueAt(j, 19)
										.toString())
								- Double.parseDouble(o[14].toString());
					} else {
						
						String lastDDSurcharge;
						if("24Q".equalsIgnoreCase(rpu.formNumber))
						{	//rpu 3.1 +5  //rpu 3.3 old value 39 //RPU 3.4 -2(38-2)
							lastDDSurcharge=o[36].toString();
						}
						else if("27Q".equalsIgnoreCase(rpu.formNumber))
						{
							//rpu 3.1 +5 
							lastDDSurcharge=o[55].toString(); // initial value 42 //rahul CR84532 27Q old value 51
						}
						else if("26Q".equalsIgnoreCase(rpu.formNumber))
						{
							//rpu 3.1 +5 
							lastDDSurcharge=o[45].toString();  //rahul CR84532 26Q old value 42
						}
						else
						{
							//lastDDSurcharge=o[38].toString();
							/*************************************************************************/
							//Added by sadhana, FRD 2.2 for newly added 2 columns in Annexure I
							//lastDDSurcharge=o[38].toString();
							//rpu 3.1 start BUG old 40 //RPU 3.4 (44-2)
							lastDDSurcharge=o[46].toString();  //rahul CR84532 old 45
							/*************************************************************************/
				
						}
						
						DDSurcharge = DDSurcharge
								+ Double.parseDouble(model1.getValueAt(j, 19)
										.toString())
								- Double.parseDouble(lastDDSurcharge);
					}
				} else if (model1.getValueAt(j, 2) != null
						&& !model1.getValueAt(j, 2).toString()
						.equalsIgnoreCase("")
				&& model1.getValueAt(j, 2).toString().substring(0, 1)
						.equalsIgnoreCase("A")) {
					DDSurcharge = DDSurcharge
							+ Double.parseDouble(model1.getValueAt(j, 19)
									.toString());
				}

			} else {
				DDSurcharge = DDSurcharge + 0.00;
			}

			if (model1.getValueAt(j, 20) != null
					&& !model1.getValueAt(j, 20).toString()
							.equalsIgnoreCase("")) {
				if (model1.getValueAt(j, 2) != null
						&& !model1.getValueAt(j, 2).toString()
								.equalsIgnoreCase("")
						&& model1.getValueAt(j, 2).toString().substring(0, 1)
								.equalsIgnoreCase("U")) {
					if ("Import".equals(rpu.method)) {
						DDCess = DDCess
								+ Double.parseDouble(model1.getValueAt(j, 20)
										.toString())
								- Double.parseDouble(o[15].toString());
					} else {
						
						String lastDDCess;
						if("24Q".equalsIgnoreCase(rpu.formNumber))
						{	// rpu 3.1 BUG old value 35  //RPU 3.4 (39-2)
							lastDDCess=o[37].toString();
						}
						else if("27Q".equalsIgnoreCase(rpu.formNumber))
						{
							//rpu 3.1 start +5
							lastDDCess=o[56].toString(); // initial value 47 //rahul CR84532 27Q old value 52
						}
						else if("26Q".equalsIgnoreCase(rpu.formNumber))
						{
							//rpu 3.1 start +5
							lastDDCess=o[46].toString(); // initial value 38  //rahul CR84532 26Q old value 43
							System.out.println("lastDDCess  0 43"+o[43].toString());
						}
						else
						{
							//lastDDCess=o[39].toString();
							/************************************************************/
							//added by sadhana, FRD 2.2, for newly added teo columns in annexure i
							//lastDDCess=o[39].toString();
							//rpu 3.1 BUG  old 41 //RPU 3.4 (45-2)
							lastDDCess=o[47].toString();   //rahul CR84532 old 46
							/************************************************************/
							System.out.println("lastDDCess  0 41"+o[46].toString());
						}
						
						
						
						DDCess = DDCess
								+ Double.parseDouble(model1.getValueAt(j, 20)
										.toString())
								- Double.parseDouble(lastDDCess.toString());
					}
				} else if (model1.getValueAt(j, 2) != null
						&& !model1.getValueAt(j, 2).toString()
						.equalsIgnoreCase("")
				&& model1.getValueAt(j, 2).toString().substring(0, 1)
						.equalsIgnoreCase("A")){
					DDCess = DDCess
							+ Double.parseDouble(model1.getValueAt(j, 20)
									.toString());
				
				}

			} else {
				DDCess = DDCess + 0.00;
			}

			if (model1.getValueAt(j, 18) != null
					&& !model1.getValueAt(j, 18).toString()
							.equalsIgnoreCase("")) {
				if (model1.getValueAt(j, 2) != null
						&& !model1.getValueAt(j, 2).toString()
								.equalsIgnoreCase("")
						&& model1.getValueAt(j, 2).toString().substring(0, 1)
								.equalsIgnoreCase("U")) {
					if ("Import".equals(rpu.method)) {
						DDIncomeTax = DDIncomeTax
								+ Double.parseDouble(model1.getValueAt(j, 18)
										.toString())
								- Double.parseDouble(o[13].toString());
					} else {
						String lastDDIncomeTax;
						if("24Q".equalsIgnoreCase(rpu.formNumber))
						{ //rpu 3.1 start +5 BUG //rpu 3.3 old value 38 //RPU 3.4 (37-2)
							lastDDIncomeTax=o[35].toString(); //38 but trying 37
						}
						else if("27Q".equalsIgnoreCase(rpu.formNumber))
						{
							//rpu 3.1 start +5
							lastDDIncomeTax=o[54].toString(); // initial value 45 //rahul CR84532 27Q old value 50
						}
						else if("26Q".equalsIgnoreCase(rpu.formNumber))
						{
							//rpu 3.1 start +5
							lastDDIncomeTax=o[44].toString();// initial value 36 //rahul CR84532 26Q old value 41
						}
						else
						{
							//lastDDIncomeTax=o[37].toString();
							/************************************************************/
							//added by sadhana, FRD 2.2, for newly added teo columns in annexure i
							//lastDDIncomeTax=o[37].toString();
							//rpu 3.1 BUG old 39 //RPU 3.4 (43-2)
							lastDDIncomeTax=o[45].toString();    //rahul CR84532 old 44 
							/************************************************************/
						}
						
						DDIncomeTax = DDIncomeTax
								+ Double.parseDouble(model1.getValueAt(j, 18)
										.toString())
								- Double.parseDouble(lastDDIncomeTax);
					}
				} else if (model1.getValueAt(j, 2) != null
						&& !model1.getValueAt(j, 2).toString()
						.equalsIgnoreCase("")
				&& model1.getValueAt(j, 2).toString().substring(0, 1)
						.equalsIgnoreCase("A")) {
					System.out.println("Incorrect value here"+DDIncomeTax+ "  DDIncomeTax  "+model1.getValueAt(j, 18)
									.toString());
					DDIncomeTax = DDIncomeTax
							+ Double.parseDouble(model1.getValueAt(j, 18)
									.toString());
				}

			} else {
				DDIncomeTax = DDIncomeTax + 0.00;
			}

		}

		if (!CorrectionType.equalsIgnoreCase("C2")
				&& !CorrectionType.equalsIgnoreCase("C5")) {
			cd.setTDSTCSIncomeTax(df.format(DDIncomeTax));
			cd.setTDSTCSSurcharge(df.format(DDSurcharge));
			cd.setTDSTCSCess(df.format(DDCess));
			cd.setSumofTotalIncomeTaxDeductedatSource(df.format(TotalTaxDeducted));

			if (cd.getNILChallanIndicator().equals("N")) {
				cd.setTotalTaxDepositAmountasperdeducteeannexure(df.format(TotalTaxDeposited
						));
			} else {
				cd.setTotalTaxDepositAmountasperdeducteeannexure("0.00");
			}
		}


		//System.out.println("Correction type1: "+ CorrectionType);
		
		if (CorrectionType.equalsIgnoreCase("C3")
				|| CorrectionType.equalsIgnoreCase("C2")
				|| CorrectionType.equalsIgnoreCase("C9")) {
			if (model.getValueAt(i, 19) != null
					&& !model.getValueAt(i, 19).toString().equalsIgnoreCase("")) {
				//System.out.println("Correction type2: "+ CorrectionType);
				//System.out.println("Value in C9: "+ model.getValueAt(i, 19).toString());
				cd.setTDSTCSInterestAmount(model.getValueAt(i, 19).toString());
			}
			if (model.getValueAt(i, 20) != null
					&& !model.getValueAt(i, 20).toString().equalsIgnoreCase("")) {
				cd.setTDSTCSOthers(model.getValueAt(i, 20).toString());
				//System.out.println("Value in C9: "+ model.getValueAt(i, 20).toString());
			}

		}
		
		
		//## Newly added for correction Ver1.2 by Akansha
		if(Integer.parseInt(rpu.finyear.substring(0, 4)) <= 2010){
			if(!(model.getValueAt(i, 11) == null)
				&& !(model.getValueAt(i, 11).toString().equalsIgnoreCase("")) && (CorrectionType.equalsIgnoreCase("C2") || CorrectionType.equalsIgnoreCase("C3") || CorrectionType.equalsIgnoreCase("C9")) && !"0".equals(cd.getChallanUpdationIndicator()))
			cd.setChequeDDNo(model.getValueAt(i, 11).toString());
		}
		else if(Integer.parseInt(rpu.finyear.substring(0, 4))>2010 && Integer.parseInt(rpu.finyear.substring(0, 4)) <= 2012){
			if (!CorrectionType.equalsIgnoreCase("C5")
				&& !(model.getValueAt(i, 11) == null)
				&& !(model.getValueAt(i, 11).toString().equalsIgnoreCase("")) 
				&& (((CorrectionType.equalsIgnoreCase("C2") || CorrectionType.equalsIgnoreCase("C3")) && !"0".equals(cd.getChallanUpdationIndicator()))
						|| CorrectionType.equalsIgnoreCase("C9"))) {
			cd.setChequeDDNo(model.getValueAt(i, 11).toString()); //## Newly added for correction Ver1.2 by Akansha ---> added for C2 and !"0"
			}
		}
		if (cd.getNILChallanIndicator().equals("N") && !(CorrectionType.equalsIgnoreCase("C5") && Integer.parseInt(rpu.finyear.substring(0, 4))<2010)) { // (!CorrectionType.equalsIgnoreCase("C5")) && --- Newly commented for Ver1.2 by Akansha
			if (model.getValueAt(i, 18) != null
					&& !model.getValueAt(i, 18).toString().equals("") && !model.getValueAt(i, 18).toString().contains("Select")) {
				cd.setByBookentryCash(model.getValueAt(i, 18).toString().substring(0, 1));
			}
		}

		if (!CorrectionType.equalsIgnoreCase("C5")
				&& Integer.parseInt(rpu.finyear.substring(0, 4)) >= 2012) {
			cd.setFee(TDS_Fees);

		}

		if ((!CorrectionType.equalsIgnoreCase("C5") && !CorrectionType
				.equalsIgnoreCase("C4"))
				&& cd.getNILChallanIndicator().equals("N")) {

			if (model.getValueAt(i, 21) != null
					&& !model.getValueAt(i, 21).toString().contains("Select")) {
				if(!("C3").equalsIgnoreCase(CorrectionType) || ("1").equalsIgnoreCase(cd.getChallanUpdationIndicator()) ) //Added for observation 443 for correction version 1.2
				{
					cd.setMinorHeadChallan(model.getValueAt(i, 21).toString());
				}
			}

		}

		// ================================================ For Correction Setup
		// -- Start ===========================================================

		if ("Correction".equals(rpu.valueOfTypeOfStmt)) {

			if (model.getValueAt(i, 9) != null
					&& !model.getValueAt(i, 9).toString().equals("")) {
				cd.setLastTotal_DepositAmount_Challan(model.getValueAt(i, 9)
						.toString());
			}
			if (model.getValueAt(i, 12) != null
					&& !model.getValueAt(i, 12).toString().equals("")) {
				cd.setLastBankBranchCode(model.getValueAt(i, 12).toString());
			}
			if (model.getValueAt(i, 14) != null
					&& !model.getValueAt(i, 14).toString().equals("")) {
				cd.setLastDate_BankChallanNo_TransferVoucherNo(model
						.getValueAt(i, 14).toString().replaceAll("/", ""));
			}

			for (String s : rpu.LastModeofDeposit) {

			}


			if (model.getValueAt(i, 16) != null
					&& !model.getValueAt(i, 16).toString().equals("")
					&& rpu.LastModeofDeposit.get(i - 2).substring(0, 1)
							.equalsIgnoreCase("Y")) {
				cd.setLastDDOSerialNo(model.getValueAt(i, 16).toString());
			} else if (model.getValueAt(i, 16) != null
					&& !model.getValueAt(i, 16).toString().equals("")
					&&((rpu.LastModeofDeposit.get(i - 2).equals("--Select--")&&Integer.parseInt(rpu.finyear.substring(0, 4)) <2010) ||rpu.LastModeofDeposit.get(i - 2).substring(0, 1)
							.equalsIgnoreCase("N"))) {
				cd.setLastChallanSerialNumber(model.getValueAt(i, 16)
						.toString());
			}
		}

		// ================================================ For Correction Setup
		// -- END =============================================================
		System.out.println("cd = "+cd);
		return cd;
	}

	/**
	 * Method used for assigning values to DD Bean for 'Correction' type statements
	 * @param ls
	 * @param inneri
	 * @param cd
	 * @param CorrectionType
	 * @param BH_Count
	 * @return
	 */
	public DDBean _DDAppenderCorrection(ArrayList<Object> ls, int inneri,
			CDBean cd, String CorrectionType, Integer BH_Count) {

		DDBean dd = new DDBean();

		dd.setLine_Number(new Integer(ls.size() + 1).toString());
		dd.setRecordType("DD");
		dd.setBatchNumber(BH_Count.toString());

		if (!(model1.getValueAt(inneri, 1).toString().contains("Select"))) {

			dd.setChallan_DetailRecordNumber(model1.getValueAt(inneri, 1)
					.toString());

		}

		if (model1.getValueAt(inneri, 11) != null
				&& model1.getValueAt(inneri, 11).toString().length() != 0) {

			dd.setDeducteePartyDetailRecordNo(model1.getValueAt(inneri, 11)
					.toString());

		}

		if (!CorrectionType.equalsIgnoreCase("C5")) {
			if (!CorrectionType.equalsIgnoreCase("C9")) {
				//change
				//new development for newly appended value "F", FRD1.9 on 02/01/17
				if ((rpu.strAnnexIColValue.length() > (inneri - 2)) && (rpu.strAnnexIColValue.charAt(inneri - 2) == 'F')){
					dd.setMode("F");
				}else{
					dd.setMode(model1.getValueAt(inneri, 2).toString().substring(0, 1));
				}
				//dd.setMode(model1.getValueAt(inneri, 2).toString().substring(0, 1));

			} else {
				dd.setMode("O");
			}
		}

		/*
		 * if(model1.getValueAt(i, 2).toString().equalsIgnoreCase("ADD")) {
		 * dd.setMode("A"); }
		 * 
		 * if(model1.getValueAt(i, 2).toString().equalsIgnoreCase("UPDATE")) {
		 * dd.setMode("U"); }
		 */
		if (model1.getValueAt(inneri, 12) != null
				&& model1.getValueAt(inneri, 12).toString().length() != 0
				&& rpu.formNumber.equalsIgnoreCase("24Q")
				&& (CorrectionType.equalsIgnoreCase("C3") || CorrectionType
						.equalsIgnoreCase("C9"))) {
			dd.setEmployeeSerialNo(model1.getValueAt(inneri, 12).toString());
		}

		if (!rpu.formNumber.equalsIgnoreCase("24Q")
				&& model1.getValueAt(inneri, 27) != null
				&& !CorrectionType.equalsIgnoreCase("C5") /*&& "U".equals(dd.getMode()) */// to be checked --- 21/05/2015
				&& model1.getValueAt(inneri, 27).toString().length() != 0
				&& !(model1.getValueAt(inneri, 27).toString()
						.contains("Select"))) {
			dd.setDeducteePartyCode(Integer.valueOf(model1.getValueAt(inneri, 27).toString()).toString());
		}

		if (model1.getValueAt(inneri, 14) != null
				&& model1.getValueAt(inneri, 14).toString().length() != 0) {
			dd.setEmployeePartyPAN(model1.getValueAt(inneri, 14).toString());
		}

		if (model1.getValueAt(inneri, 15) != null
				&& model1.getValueAt(inneri, 15).toString().length() != 0
				&& !CorrectionType.equalsIgnoreCase("C5")) {
			dd.setNameofEmployeeParty(model1.getValueAt(inneri, 15).toString());
		}

		if (model1.getValueAt(inneri, 18) != null
				&& model1.getValueAt(inneri, 18).toString().length() != 0
				&& !CorrectionType.equalsIgnoreCase("C5")) {
			dd.setTDSTCS_IncomeTaxfortheperiod(model1.getValueAt(inneri, 18)
					.toString());
		}

		if (model1.getValueAt(inneri, 19) != null
				&& model1.getValueAt(inneri, 19).toString().length() != 0
				&& !CorrectionType.equalsIgnoreCase("C5")) {
			dd.setTDSTCS_Surchargefortheperiod(model1.getValueAt(inneri, 19)
					.toString());
		}

		if (model1.getValueAt(inneri, 20) != null
				&& model1.getValueAt(inneri, 20).toString().length() != 0
				&& !CorrectionType.equalsIgnoreCase("C5")) {
			dd.setTDSTCS_Cess(model1.getValueAt(inneri, 20).toString());
		}

		if (model1.getValueAt(inneri, 21) != null
				&& model1.getValueAt(inneri, 21).toString().length() != 0
				&& !CorrectionType.equalsIgnoreCase("C5")) {
			dd.setTotalIncomeTaxDeductedatSource(model1.getValueAt(inneri, 21)
					.toString());
		}

		if (model1.getValueAt(inneri, 23) != null
				&& model1.getValueAt(inneri, 23).toString().length() != 0
				&& cd.getNILChallanIndicator().equals("N")
				&& !CorrectionType.equalsIgnoreCase("C5")) {
			dd.setTotalTaxDeposited(model1.getValueAt(inneri, 23).toString());
		} else if (!CorrectionType.equalsIgnoreCase("C5")) {
			dd.setTotalTaxDeposited("0.00");
		}

		if (model1.getValueAt(inneri, 17) != null
				&& model1.getValueAt(inneri, 17).toString().length() != 0
				&& !CorrectionType.equalsIgnoreCase("C5")) {
			dd.setAmountofPaymentCredit(model1.getValueAt(inneri, 17)
					.toString());
		}

		if (model1.getValueAt(inneri, 16) != null
				&& model1.getValueAt(inneri, 16).toString().length() != 0
				&& !CorrectionType.equalsIgnoreCase("C5")) {
			dd.setDateonwhichAmountpaidCredited(model1.getValueAt(inneri, 16)
					.toString().replaceAll("/", ""));
		}

		if (model1.getValueAt(inneri, 25) != null
				&& model1.getValueAt(inneri, 25).toString().length() != 0
				&& !CorrectionType.equalsIgnoreCase("C5")) {
			dd.setDateonwhichtaxDeducted(model1.getValueAt(inneri, 25)
					.toString().replaceAll("/", ""));
		}

		/* NA For 26Q */

		if (rpu.formNumber.equalsIgnoreCase("24Q")
				&& model1.getValueAt(inneri, 4) != null
				&& model1.getValueAt(inneri, 4).toString().length() != 0) {
			if (CorrectionType.equalsIgnoreCase("C3")
					|| CorrectionType.equalsIgnoreCase("C9")) {
				dd.setDateofDeposit(model1.getValueAt(inneri, 4).toString()
						.replaceAll("/", ""));
			}
		}

		/* NA For 24Q */

		if (!rpu.formNumber.equalsIgnoreCase("24Q") && !rpu.formNumber.equalsIgnoreCase("27EQ")
				&& model1.getValueAt(inneri, 28) != null
				&& model1.getValueAt(inneri, 28).toString().length() != 0
				&& !CorrectionType.equalsIgnoreCase("C5")) {
			dd.setRateatwhichTaxDeductedCollected((model1.getValueAt(inneri, 28)
					.toString()));
		}

		/* For 27EQ */ //## Newly developed for correction Ver1.2 by Akansha
		if (rpu.formNumber.equalsIgnoreCase("27EQ") && !CorrectionType.equalsIgnoreCase("C5")
				&& model1.getValueAt(inneri, 29) != null 
				&& model1.getValueAt(inneri, 29).toString().length() != 0) {
			dd.setRateatwhichTaxDeductedCollected((model1.getValueAt(inneri, 29)
					.toString())); //new development for FRD1.3 by Akansha 
		}

		
		//******************************************************
		
		/* NA For 26Q or 24Q */

		if (rpu.formNumber.equalsIgnoreCase("27Q")
				&& model1.getValueAt(inneri, 35) != null
				&& model1.getValueAt(inneri, 35).toString().length() != 0
				&& !(model1.getValueAt(inneri, 35).toString()
						.contains("Select"))&& !CorrectionType.equalsIgnoreCase("C5")) { // Newly added for Correction Ver1.2 to eliminate C5 by Akansha
			dd.setGrossingupIndicator(model1.getValueAt(inneri, 35).toString()
					.substring(0, 1));
		}

		/* NA For 24Q */

		if (!rpu.formNumber.equalsIgnoreCase("24Q") && !rpu.formNumber.equalsIgnoreCase("27EQ") && !CorrectionType.equalsIgnoreCase("C5")
				&& model1.getValueAt(inneri, 29) != null
				&& model1.getValueAt(inneri, 29).toString().length() != 0
				&& !(model1.getValueAt(inneri, 29).toString()
						.contains("Select"))) {
			dd.setBookEntryCashIndicator(model1.getValueAt(inneri, 29)
					.toString().substring(0, 1));
		}
		
		/* For 27EQ */
		
		if (rpu.formNumber.equalsIgnoreCase("27EQ")
				&& model1.getValueAt(inneri, 30) != null
				&& model1.getValueAt(inneri, 30).toString().length() != 0
				&& !(model1.getValueAt(inneri, 30).toString()
						.contains("Select"))) {
			//new development for FRD1.3 by Akansha
			if (CorrectionType.equalsIgnoreCase("C5")) 
			{
				
				if(Integer.parseInt(rpu.finyear.substring(0, 4)) > 2012)
				{
					dd.setBookEntryCashIndicator(model1.getValueAt(inneri, 30)
						.toString().substring(0, 1));
				}
				
			}
			else
			{
				dd.setBookEntryCashIndicator(model1.getValueAt(inneri, 30)
						.toString().substring(0, 1));
			}
			//**********************************************
			
		}
		//**************************************************************	

		if (CorrectionType.equalsIgnoreCase("C3")
				|| CorrectionType.equalsIgnoreCase("C9")) {
			if (!(model1.getValueAt(inneri, 26).toString().contains("Select"))) {
				if("B - In case of 15G/15H".equals(model1.getValueAt(inneri, 26).toString()))
					dd.setRemarks1("B"); // new development for FRD1.5 by akansha
				else	
				dd.setRemarks1(model1.getValueAt(inneri, 26).toString());

			}
		}

		if (model1.getValueAt(inneri, 6) != null
				&& model1.getValueAt(inneri, 6).toString().length() != 0
				&& !model1.getValueAt(inneri, 6).toString().contains("Select")
				&& !CorrectionType.equalsIgnoreCase("C5") && Integer.parseInt(rpu.finyear.substring(0,4))>2012) { //## Newly added for correction Ver1.2 by Akansha
		
			//dd.setSectionCodePaymentMade(model1.getValueAt(inneri, 6).toString());
			if("194IC".equals(model1.getValueAt(inneri, 6).toString())){
				dd.setSectionCodePaymentMade("4IC");
			}
			else{
				dd.setSectionCodePaymentMade(model1.getValueAt(inneri, 6).toString());
			}
		}

		/* For 24Q */
		if (CorrectionType.equalsIgnoreCase("C3")
				|| CorrectionType.equalsIgnoreCase("C9")) {
			if (rpu.formNumber.equalsIgnoreCase("24Q")
					&& model1.getValueAt(inneri, 27) != null
					&& model1.getValueAt(inneri, 27).toString().length() != 0 &&  !model1.getValueAt(
							inneri, 27).toString().contains("Select")) {
				dd.setCertificateNumberAssessingOfficer(model1.getValueAt(
						inneri, 27).toString());
				// System.out.println("My VALUE IS : "+
				// model1.getValueAt(inneri, 27).toString());
			}
		}

		/* For 26Q || 27Q */
		if (CorrectionType.equalsIgnoreCase("C3")
				|| CorrectionType.equalsIgnoreCase("C9")) {

			if ((rpu.formNumber.equalsIgnoreCase("26Q") || rpu.formNumber.equalsIgnoreCase("27Q"))
					&& model1.getValueAt(inneri, 30) != null
					&& model1.getValueAt(inneri, 30).toString().length() != 0
					&& !CorrectionType.equalsIgnoreCase("C5") &&  !model1.getValueAt(
							inneri, 30).toString().contains("Select")) {
				dd.setCertificateNumberAssessingOfficer(model1.getValueAt(
						inneri, 30).toString());
				// System.out.println("My VALUE IS : "+
				// model1.getValueAt(inneri, 27).toString());
			}
		}
		//RPU 3.1 start correction
		/* For 26Q */
	
						
						
		if (CorrectionType.equalsIgnoreCase("C3")) {

			if ((rpu.formNumber.equalsIgnoreCase("26Q"))
					&& model1.getValueAt(inneri, 31) != null
					&& model1.getValueAt(inneri, 31).toString().length() != 0
					&& "94N".equals(model1.getValueAt(inneri, 6)))
			{
				if ((Integer.parseInt(rpu.finyear.substring(0, 4)) == 2019 && !(rpu.quarter
						.equalsIgnoreCase("Q1")))
						|| (Integer.parseInt(rpu.finyear.substring(0, 4)) > 2019)) 
				{
					dd.setAmtOfCshWdrawInExcessOfRs1CrS194N(model1.getValueAt(inneri, 31).toString());
					System.out.println("My VALUE IS in correction : "+ model1.getValueAt(inneri, 31).toString());
				}
			}
			//RPU 3.4  correction
			if ((rpu.formNumber.equalsIgnoreCase("26Q"))
					&& model1.getValueAt(inneri, 32) != null
					&& model1.getValueAt(inneri, 32).toString().length() != 0
					&& "4NF".equals(model1.getValueAt(inneri, 6)))
			{
				if ((Integer.parseInt(rpu.finyear.substring(0, 4)) == 2020 && !(rpu.quarter
						.equalsIgnoreCase("Q1")))
						|| (Integer.parseInt(rpu.finyear.substring(0, 4)) > 2020)) 
				{
					dd.setAmtOfCshWdrawInExcessOfRs20lkhSbclause_a_194N(model1.getValueAt(inneri, 32).toString());
					System.out.println("My VALUE IS in correction 32: "+ model1.getValueAt(inneri, 32).toString());
				}
			}
			if ((rpu.formNumber.equalsIgnoreCase("26Q"))
					&& model1.getValueAt(inneri, 33) != null
					&& model1.getValueAt(inneri, 33).toString().length() != 0
					&& "4NF".equals(model1.getValueAt(inneri, 6)))
			{
				if ((Integer.parseInt(rpu.finyear.substring(0, 4)) == 2020 && !(rpu.quarter
						.equalsIgnoreCase("Q1")))
						|| (Integer.parseInt(rpu.finyear.substring(0, 4)) > 2020)) 
				{
					dd.setAmtOfCshWdrawInExcessOfRs20lkhSbclause_b_194N(model1.getValueAt(inneri, 33).toString());
					System.out.println("My VALUE IS in correction 33: "+ model1.getValueAt(inneri, 33).toString());
				}
			}
			
			//rahul CR84532 26Q Column Addition 419D start
			//rahul CR84532 26Q section code change
			if ((rpu.formNumber.equalsIgnoreCase("26Q"))
					&& model1.getValueAt(inneri, 34) != null
					&& model1.getValueAt(inneri, 34).toString().length() != 0
					&& "4NC".equals(model1.getValueAt(inneri, 6)))
			{
				if ((Integer.parseInt(rpu.finyear.substring(0, 4)) >= 2023)) 
				{
					dd.setAmtOfCshWdrawInExcessOfRs3Cr_Society_194N(model1.getValueAt(inneri, 34).toString());
					System.out.println("My VALUE IS in correction : "+ model1.getValueAt(inneri, 34).toString());
				}
			}
			//rahul CR84532 26Q Column Addition 419D end
			
			// CR 84532 26Q Column Addition 419E - Start by Khalid 
			//rahul CR84532 26Q section code change
			if ((rpu.formNumber.equalsIgnoreCase("26Q"))
					&& model1.getValueAt(inneri, 35) != null
					&& model1.getValueAt(inneri, 35).toString().length() != 0
					&& "9FT".equals(model1.getValueAt(inneri, 6)))
			{
				if ((Integer.parseInt(rpu.finyear.substring(0, 4)) >= 2023)) 
				{
					dd.setAmtCshWdrawRs20lkhSbcleThrdProvsnSec194N(model1.getValueAt(inneri, 35).toString());
					System.out.println("My VALUE IS in correction : "+ model1.getValueAt(inneri, 35).toString());
				}
			}
			//CR 84532 26Q Column Addition 419E - End by Khalid
			
			//renuka CR84532 26Q Column Addition 419F
			//rahul CR84532 26Q section code change
			/*if ((rpu.formNumber.equalsIgnoreCase("26Q"))
					&& model1.getValueAt(inneri, 36) != null
					&& model1.getValueAt(inneri, 36).toString().length() != 0
					&& "9FT".equals(model1.getValueAt(inneri, 6)))
			{
				if ((Integer.parseInt(rpu.finyear.substring(0, 4)) >= 2023)) 
				{
					dd.setAmtOfCshWdrawInExcessOfRs3Cr_Society_194N(model1.getValueAt(inneri, 36).toString());
					System.out.println("My VALUE IS in correction : "+ model1.getValueAt(inneri, 36).toString());
				}
			}*/
			//renuka CR84532 26Q Column Addition 419F
			
			//rahul bug fixed 23Feb2024 start
			if ((rpu.formNumber.equalsIgnoreCase("26Q"))
					&& model1.getValueAt(inneri, 36) != null
					&& model1.getValueAt(inneri, 36).toString().length() != 0
					&& "9FT".equals(model1.getValueAt(inneri, 6)))
			{
				if ((Integer.parseInt(rpu.finyear.substring(0, 4)) >= 2023)) 
				{
					dd.setAmtCshWdrawRs3Crsbclause_b_194N_419F(model1.getValueAt(inneri, 36).toString());
					System.out.println("My VALUE IS in correction : "+ model1.getValueAt(inneri, 36).toString());
				}
			}
			//rahul bug fixed 23Feb2024 end
		}
		
		/* For 27EQ */
		if (CorrectionType.equalsIgnoreCase("C3")
				|| CorrectionType.equalsIgnoreCase("C9")) {

			if (rpu.formNumber.equalsIgnoreCase("27EQ")
					&& model1.getValueAt(inneri, 31) != null
					&& model1.getValueAt(inneri, 31).toString().length() != 0
					&& !CorrectionType.equalsIgnoreCase("C5") &&  !model1.getValueAt(
							inneri, 31).toString().contains("Select")) {
				dd.setCertificateNumberAssessingOfficer(model1.getValueAt(
						inneri, 31).toString());
				// System.out.println("My VALUE IS : "+
				// model1.getValueAt(inneri, 27).toString());
			}
		}
		if(CorrectionType.equalsIgnoreCase("C3") && rpu.formNumber.equalsIgnoreCase("27EQ")) //RPU 3.5 Addition of new columns	
		{
			if (model1.getValueAt(inneri, 34) != null
					&& model1.getValueAt(inneri, 34).toString().length() != 0
					&& !(model1.getValueAt(inneri, 34).toString()
							.contains("Select"))) {
				dd.setWhetherPymntisLiable(model1.getValueAt(inneri, 34)
						.toString().substring(0, 1));
			}
			if ( model1.getValueAt(inneri, 35) != null
					&& model1.getValueAt(inneri, 35).toString().length() != 0) {
				dd.setChallanNumber(model1.getValueAt(inneri, 35)
						.toString());
			}
			if ( model1.getValueAt(inneri, 36) != null
					&& model1.getValueAt(inneri, 36).toString().length() != 0) {
				dd.setDateofPymntofTDStoCG(model1.getValueAt(inneri, 36).toString()
						.replaceAll("/", ""));
			}
			
			//rahul CR84532 27EQ Addition of column 719B correction start
			if (model1.getValueAt(inneri, 37) != null
					&& model1.getValueAt(inneri, 37).toString().length() != 0
					&& !(model1.getValueAt(inneri, 37).toString()
							.contains("Select"))) {
				dd.setWhetherDedOptingOutOfTaxRegime27EQ(model1.getValueAt(inneri, 37)
						.toString().substring(0, 1));
			}
			//rahul CR84532 27EQ Addition of column 719B correction end
		}

		/* For 27Q */
		if (CorrectionType.equalsIgnoreCase("C3")
				|| CorrectionType.equalsIgnoreCase("C9")) {

			if (rpu.formNumber.equalsIgnoreCase("27Q")
					&& model1.getValueAt(inneri, 31) != null
					&& model1.getValueAt(inneri, 31).toString().length() != 0 && !(model1.getValueAt(inneri, 31).toString()
							.contains("Select"))) 
			{
				dd.setWhetherTDSrateisTDS_ITactandDTAA(model1.getValueAt(
						inneri, 31).toString());
			}
		}

		/* For 27Q */
		if (CorrectionType.equalsIgnoreCase("C3")
				|| CorrectionType.equalsIgnoreCase("C9")) {

			if (rpu.formNumber.equalsIgnoreCase("27Q")
					&& model1.getValueAt(inneri, 32) != null
					&& model1.getValueAt(inneri, 32).toString().length() != 0 && !(model1.getValueAt(inneri, 32).toString()
							.contains("Select"))) {
				dd.setNatureOfRemittance(GrpuUtil
						.getRemittanceCodeReverse(model1.getValueAt(inneri, 32)
								.toString()));
			}

		}

		/* For 27Q */
		if (CorrectionType.equalsIgnoreCase("C3")
				|| CorrectionType.equalsIgnoreCase("C9")) {

			if (rpu.formNumber.equalsIgnoreCase("27Q")
					&& model1.getValueAt(inneri, 33) != null
					&& model1.getValueAt(inneri, 33).toString().length() != 0) {
				dd.setUniqueAcknowledgementOfForm15CA(model1.getValueAt(inneri,
						33).toString());
			}

		}

		/* For 27Q */
		if (CorrectionType.equalsIgnoreCase("C3")
				|| CorrectionType.equalsIgnoreCase("C9")) {

			if (rpu.formNumber.equalsIgnoreCase("27Q")
					&& model1.getValueAt(inneri, 34) != null
					&& model1.getValueAt(inneri, 34).toString().length() != 0
					&& !(model1.getValueAt(inneri, 34).toString()
							.contains("Select"))) {
				dd.setCountryofDeductee(GrpuUtil.getCountryCodeReverse(model1
						.getValueAt(inneri, 34).toString()));
			}

		}

		if ("Correction".equals(rpu.valueOfTypeOfStmt)) {

			if (model1.getValueAt(inneri, 13) != null
					&& !model1.getValueAt(inneri, 13).toString().equals("")
					&& !CorrectionType.equalsIgnoreCase("C5") && !CorrectionType.equalsIgnoreCase("C3")) {
				dd.setLastEmployeePartyPAN(model1.getValueAt(inneri, 13)
						.toString());

			}
			
			if (model1.getValueAt(inneri, 14) != null
					&& !model1.getValueAt(inneri, 14).toString().equals("") 
					&& model1.getValueAt(inneri, 13) != null
					&& !model1.getValueAt(inneri, 13).toString().equals("")
					&& CorrectionType.equalsIgnoreCase("C3")) {
				
				if(model1.getValueAt(inneri, 14).toString().equalsIgnoreCase("PANAPPLIED") || model1.getValueAt(inneri, 14).toString().equalsIgnoreCase("PANINVALID") || model1.getValueAt(inneri, 14).toString().equalsIgnoreCase("PANNOTAVBL"))	
				{
					dd.setLastEmployeePartyPAN(model1.getValueAt(inneri, 13).toString());
				}
				else
					if(model1.getValueAt(inneri, 13).toString().equalsIgnoreCase("PANAPPLIED") || model1.getValueAt(inneri, 13).toString().equalsIgnoreCase("PANINVALID") || model1.getValueAt(inneri, 13).toString().equalsIgnoreCase("PANNOTAVBL"))	
						{
							dd.setLastEmployeePartyPAN(model1.getValueAt(inneri, 13).toString());
						}
					else
						{
							dd.setLastEmployeePartyPAN(model1.getValueAt(inneri, 14).toString());
						}

			}

		/*	if ((dd.getMode() != null && dd.getMode().equalsIgnoreCase("U"))
					|| (model1.getValueAt(inneri, 2) != null
						&& !model1.getValueAt(inneri, 2).toString().equalsIgnoreCase("") 
						&& model1.getValueAt(inneri, 2).toString().contains("PAN")) 
					|| (model1.getValueAt(inneri, 2) != null
						&& !model1.getValueAt(inneri, 2).toString().equalsIgnoreCase("") 
						&& model1.getValueAt(inneri, 2).toString().equalsIgnoreCase("UPDATE")
						&& CorrectionType.equalsIgnoreCase("C5")) ) 
			{
				if (model1.getValueAt(inneri, 22) != null) 
				{
					dd.setLastTotalIncomeTaxDeductedatSource(model1.getValueAt(inneri, 22).toString());
				}

				if (model1.getValueAt(inneri, 24) != null) 
				{
					dd.setLastTotalTaxDeposited(model1.getValueAt(inneri, 24).toString());
				}
			}*/
			if ((dd.getMode() != null && dd.getMode().equalsIgnoreCase("U"))
					|| (model1.getValueAt(inneri, 2) != null
						&& !model1.getValueAt(inneri, 2).toString().equalsIgnoreCase("") 
						&& model1.getValueAt(inneri, 2).toString().contains("PAN")) 
					|| (model1.getValueAt(inneri, 2) != null
						&& !model1.getValueAt(inneri, 2).toString().equalsIgnoreCase("") 
						&& model1.getValueAt(inneri, 2).toString().equalsIgnoreCase("UPDATE")
						&& CorrectionType.equalsIgnoreCase("C5")) 
					|| ((rpu.strAnnexIColValue.length() > (inneri - 2)) && (rpu.strAnnexIColValue.charAt(inneri - 2) == 'F'))) 
			{
				//new development for newly appended value "F", FRD1.9 on 02/09/17
				if (model1.getValueAt(inneri, 22) != null) 
				{
					dd.setLastTotalIncomeTaxDeductedatSource(model1.getValueAt(inneri, 22).toString());
				}

				if (model1.getValueAt(inneri, 24) != null) 
				{
					dd.setLastTotalTaxDeposited(model1.getValueAt(inneri, 24).toString());
				}
			}

		}
		
		//## Newly added for correction Ver1.2 
		
		if (!rpu.formNumber.equalsIgnoreCase("24Q")){
				if (((("C3").equalsIgnoreCase(CorrectionType) && ("U".equals(dd.getMode().toString()) || "A".equals(dd.getMode().toString()))) // && condition added for observation no :488 26-MAY-2015
					||
					("C9").equalsIgnoreCase(CorrectionType))
					&& model1.getValueAt(inneri, 12) != null
					&& model1.getValueAt(inneri, 12).toString().length() != 0
					|| ((rpu.strAnnexIColValue.length() > (inneri - 2)) && (rpu.strAnnexIColValue.charAt(inneri - 2) == 'F'))) {
				//new development for newly appended value "F", FRD1.9 on 02/09/17
				dd.setPANRefNo(model1.getValueAt(inneri, 12).toString());
			}
			
			//newly added for FRD1.6 by akansha

			/*if ((("C3").equalsIgnoreCase(CorrectionType) && "U".equals(dd
					.getMode().toString()))
					&& rpu.LastPanRefNo != null
					&& rpu.LastPanRefNo.size()>2 && !"".equals(rpu.LastPanRefNo.get(inneri - 2).toString())) {
				dd.setLastEmployeePartyPANRefNo(rpu.LastPanRefNo
						.get(inneri - 2).toString());
			}*/
			System.out.println("rpu.LastPanRefNo.size() = " +rpu.LastPanRefNo);
			System.out.println("inneri = "+ inneri);
			//System.out.println("rpu.LastPanRefNo.get(inneri - 2).toString() = " +rpu.LastPanRefNo.get(inneri - 2).toString());
			if ((("C3").equalsIgnoreCase(CorrectionType) && "U".equals(dd
					.getMode().toString()))
					&& rpu.LastPanRefNo != null
					&& rpu.LastPanRefNo.size()>2 && !"".equals(rpu.LastPanRefNo.get(inneri - 2).toString()) 
					|| ((rpu.strAnnexIColValue.length() > (inneri - 2)) && (rpu.strAnnexIColValue.charAt(inneri - 2) == 'F')) ) {
				//new development for newly appended value "F", FRD1.9 on 02/09/17
				dd.setLastEmployeePartyPANRefNo(rpu.LastPanRefNo.get(inneri - 2).toString());
			}
		}
		
		//************************************************************	
		
		if (rpu.formNumber.equalsIgnoreCase("27EQ")
				&& model1.getValueAt(inneri, 28) != null
				&& model1.getValueAt(inneri, 28).toString().length() != 0 && (("C3").equalsIgnoreCase(CorrectionType) || ("C9").equalsIgnoreCase(CorrectionType))
				) {
			dd.setTotalValueofPurchase(model1.getValueAt(inneri, 28).toString());
		}
		
		/***********************************************************************************************************************************************************/
		//Added by sadhana, FRD 2.2
		if (rpu.formNumber.equalsIgnoreCase("27EQ")
				&& model1.getValueAt(inneri, 32) != null
				&& model1.getValueAt(inneri, 32).toString().length() != 0
				&& !(model1.getValueAt(inneri, 32).toString().contains("Select")) 
			//	&& (("C3").equalsIgnoreCase(CorrectionType) || ("C5").equalsIgnoreCase(CorrectionType) || ("C9").equalsIgnoreCase(CorrectionType))) {   // rahul CR 85381 bug fix
				&& (("C3").equalsIgnoreCase(CorrectionType))) {   // rahul CR 85881 bug fix
			dd.setDeducteeIsPermanentResident(model1.getValueAt(inneri, 32).toString().substring(0, 1));
		}
		
		if (rpu.formNumber.equalsIgnoreCase("27EQ")
				&& model1.getValueAt(inneri, 33) != null
				&& model1.getValueAt(inneri, 33).toString().length() != 0
				&& !(model1.getValueAt(inneri, 33).toString().contains("Select")) 
			//	&& (("C3").equalsIgnoreCase(CorrectionType) || ("C5").equalsIgnoreCase(CorrectionType) || ("C9").equalsIgnoreCase(CorrectionType))) {  // rahul CR 85381 bug fix
				&& (("C3").equalsIgnoreCase(CorrectionType))) {   // rahul CR 85881 bug fix
			dd.setDeducteeIsPermanentResidentEstablishment(model1.getValueAt(inneri, 33).toString().substring(0, 1));
		}
		/*****************************************************************************************************************************************************************/

		//newly added for FRD1.6 by akansha

				if (rpu.formNumber.equalsIgnoreCase("27Q") && 
						("U".equals(model1.getValueAt(inneri, 2).toString().substring(0,1)) || "A".equals(model1.getValueAt(inneri, 2).toString().substring(0,1)))){
					//System.out.println("Hie Akki" + " finyear:"+rpu.finyear.substring(0, 4));
					if(Integer.parseInt(rpu.finyear.substring(0, 4)) >= 2016){
					//	System.out.println("Hie Akki...2016");
						if(model1.getValueAt(inneri,36)!=null && !"".equalsIgnoreCase(model1.getValueAt(inneri,36).toString().trim())){
							dd.setEmailIdofDeductee(model1.getValueAt(inneri,36).toString());
						}
						
						if(model1.getValueAt(inneri,37)!=null && !"".equalsIgnoreCase(model1.getValueAt(inneri,37).toString().trim())){
							dd.setContactNumberofDeductee(model1.getValueAt(inneri,37).toString());
						}
						
						if(model1.getValueAt(inneri,38)!=null && !"".equalsIgnoreCase(model1.getValueAt(inneri,38).toString().trim())){
							dd.setAddressofDeductee(model1.getValueAt(inneri,38).toString());
						}
						if(model1.getValueAt(inneri,39)!=null && !"".equalsIgnoreCase(model1.getValueAt(inneri,39).toString().trim())){
							dd.setTaxIdentificationNumber(model1.getValueAt(inneri,39).toString());
						}
					}
				}
				//*********************************************************
				//rpu 3.1 start
				//for 27Q 
				if(rpu.formNumber.equalsIgnoreCase("27Q") && ("C3").equalsIgnoreCase(CorrectionType))
				{
				if ( model1.getValueAt(inneri, 40) != null
						&& model1.getValueAt(inneri, 40).toString().length() != 0 ) 
					{
					if((Integer.parseInt(rpu.finyear.substring(0, 4)) == 2019 && !(rpu.quarter.equalsIgnoreCase("Q1")))
						|| (Integer.parseInt(rpu.finyear.substring(0, 4)) > 2019))
						{
					dd.setAmtOfCshWdrawInExcessOfRs1CrS194N(model1.getValueAt(inneri, 40).toString());
						}
					}
				//RPU 3.4 Correction
				if ( model1.getValueAt(inneri, 41) != null
						&& model1.getValueAt(inneri, 41).toString().length() != 0 ) 
					{
					if((Integer.parseInt(rpu.finyear.substring(0, 4)) == 2020 && !(rpu.quarter.equalsIgnoreCase("Q1")))
						|| (Integer.parseInt(rpu.finyear.substring(0, 4)) > 2020))
						{
						System.out.println("Inside c3" + model1.getValueAt(inneri, 41).toString() );
					dd.setAmtOfCshWdrawInExcessOfRs20lkhSbclause_a_194N(model1.getValueAt(inneri, 41).toString());
						}
					}
				
				if ( model1.getValueAt(inneri, 42) != null
						&& model1.getValueAt(inneri, 42).toString().length() != 0 ) 
					{
					if((Integer.parseInt(rpu.finyear.substring(0, 4)) == 2020 && !(rpu.quarter.equalsIgnoreCase("Q1")))
						|| (Integer.parseInt(rpu.finyear.substring(0, 4)) > 2020))
						{
					dd.setAmtOfCshWdrawInExcessOfRs20lkhSbclause_b_194N(model1.getValueAt(inneri, 42).toString());
						}
					}
				
				//rahul CR84532 27Q Column Addition 720D start
				//rahul CR84532 26Q section code change
				if (model1.getValueAt(inneri, 43) != null
						&& model1.getValueAt(inneri, 43).toString().length() != 0
						&& "4NC".equals(model1.getValueAt(inneri, 6)))
				{
					if ((Integer.parseInt(rpu.finyear.substring(0, 4)) >= 2023)) 
					{
						dd.setAmtOfCshWdrawInExcessOfRs3Cr_Society_194N(model1.getValueAt(inneri, 43).toString());
						System.out.println("My VALUE IS in correction : "+ model1.getValueAt(inneri, 43).toString());
					}
				}
				//rahul CR84532 27Q Column Addition 720D end
				
				//Renuka CR84532 27Q column addition 720E starts
				//rahul CR84532 26Q section code change
				if (model1.getValueAt(inneri, 44) != null
						&& model1.getValueAt(inneri, 44).toString().length() != 0
						&& "9FT".equals(model1.getValueAt(inneri, 6)))
				{
					if ((Integer.parseInt(rpu.finyear.substring(0, 4)) >= 2023)) 
					{
						dd.setAmtCshWdrawRs20lkhSbcleThrdProvsnSec194N(model1.getValueAt(inneri, 44).toString());
						System.out.println("My VALUE IS in correction : "+ model1.getValueAt(inneri, 44).toString());
					}
				}
				//rahul CR84532 26Q section code change
				if (model1.getValueAt(inneri, 45) != null
						&& model1.getValueAt(inneri, 45).toString().length() != 0
						&& "9FT".equals(model1.getValueAt(inneri, 6)))
				{
					if ((Integer.parseInt(rpu.finyear.substring(0, 4)) >= 2023)) 
					{
						dd.setAmtCshWdrawRs3Crsbclause_b_194N_419F(model1.getValueAt(inneri, 45).toString());
						System.out.println("My VALUE IS in correction : "+ model1.getValueAt(inneri, 45).toString());
					}
				}
				//Renuka CR84532 27Q column addition 720E ends
				
				//rahul CR84532 27Q Addition of column 719B correction start
				if (model1.getValueAt(inneri, 46) != null
						&& model1.getValueAt(inneri, 46).toString().length() != 0
						&& !(model1.getValueAt(inneri, 46).toString()
								.contains("Select"))) {
					dd.setWhetherDedOptingOutOfTaxRegime27Q(model1.getValueAt(inneri, 46)
							.toString().substring(0, 1));
				}
				//rahul CR84532 27Q Addition of column 719B correction end
				}

		return dd;
	}

	/**
	 * Method used for assigning values to SD Bean for 'Correction' type statements
	 * @param ls
	 * @param i
	 * @param BH_Count
	 * @return
	 */
	public SDBean _SDAppenderCorrection(ArrayList<Object> ls, int i,
			Integer BH_Count) {
		
		S16Count.clear();
		c6ACount.clear();
		
		//newly added for FRD1.6 by akansha
		int countPANLandLord =0;
		int countPANLender = 0;
		 totalDed16 = 0; //RPU 3.6 Observation fix
	     ded16II = 0;
		 ded16III = 0;
		 ded16IA = 0;
		 temp80C80CCCand80CCD=0; //RPU 3.6 Observation 22 fix
		//*******************************************
		
		SDBean sd = new SDBean();

		sd.setLineNumber(new Integer(ls.size() + 1).toString());
		sd.setRecordType("SD");
		sd.setBatchNumber(BH_Count.toString());

		if (model2.getValueAt(i, 1) != null
				&& model2.getValueAt(i, 1).toString().length() != 0) {

			sd.setSalaryDetailsRecordNo(model2.getValueAt(i, 1).toString());

		}

		if (model2.getValueAt(i, 2) != null && model2.getValueAt(i, 2).toString().length() != 0) {
			//change
			//new development for newly appended value "F", FRD1.9 on 02/01/17
			if ((!rpu.strAnnexIIColValue.equals("")) && (rpu.strAnnexIIColValue.length() > (i - 2)) && (rpu.strAnnexIIColValue.charAt(i - 2) == 'F')){
				sd.setMode("F");
			}else{
				sd.setMode(model2.getValueAt(i, 2).toString().substring(0, 1).toUpperCase());
			}
			//sd.setMode(model2.getValueAt(i, 2).toString().substring(0, 1).toUpperCase());

		}

		if (model2.getValueAt(i, 3) != null
				&& model2.getValueAt(i, 3).toString().length() != 0
				&& sd.getMode() != null
				&& (sd.getMode().equalsIgnoreCase("A") || sd.getMode()
						.equalsIgnoreCase("P"))) {
			sd.setEmployeePAN(model2.getValueAt(i, 3).toString());

		}

		if (model2.getValueAt(i, 10) != null
				&& model2.getValueAt(i, 10).toString().length() != 0
				&& sd.getMode() != null
				&& (sd.getMode().equalsIgnoreCase("A") || !sd.getMode()
						.equalsIgnoreCase("P") ) && !sd.getMode()
						.equalsIgnoreCase("D")) { // ## Newly developed for correction Ver1.2 by Akansha Obv 432

			sd.setTotalamountofsalary(model2.getValueAt(i, 10).toString());
		}

		

		if (model2.getValueAt(i, 4) != null
				&& model2.getValueAt(i, 4).toString().length() != 0
				&& sd.getMode() != null && sd.getMode().equalsIgnoreCase("A")) {
			sd.setNameofEmployee(model2.getValueAt(i, 4).toString());
		}

		if (model2.getValueAt(i, 5) != null
				&& model2.getValueAt(i, 5).toString().length() != 0
				&& !(model2.getValueAt(i, 5).toString().contains("Select"))
				&& sd.getMode() != null && sd.getMode().equalsIgnoreCase("A")) {

			sd.setCategoryofEmployee(GrpuUtil.getEmployeeCode(model2
					.getValueAt(i, 5).toString()));

		}

		if (model2.getValueAt(i, 6) != null
				&& model2.getValueAt(i, 6).toString().length() != 0
				&& sd.getMode() != null && sd.getMode().equalsIgnoreCase("A")) {
			sd.setPeriodofEmploymentFromDate(model2.getValueAt(i, 6).toString()
					.replaceAll("/", ""));
		}

		if (model2.getValueAt(i, 7) != null
				&& model2.getValueAt(i, 7).toString().length() != 0
				&& sd.getMode() != null && sd.getMode().equalsIgnoreCase("A")) {
			sd.setPeriodofEmploymentToDate(model2.getValueAt(i, 7).toString()
					.replaceAll("/", ""));
		}

		if (model2.getValueAt(i, 11) != null
				&& !model2.getValueAt(i, 11).toString().equalsIgnoreCase("0")
				&& !model2.getValueAt(i, 11).toString().equalsIgnoreCase("0.0")
				&& !model2.getValueAt(i, 11).toString()
						.equalsIgnoreCase("0.00")
				&& model2.getValueAt(i, 11).toString().length() != 0
				&& sd.getMode() != null && sd.getMode().equalsIgnoreCase("A")) {

			S16Count.add(11);

		}

		if (model2.getValueAt(i, 12) != null
				&& !model2.getValueAt(i, 12).toString().equalsIgnoreCase("0")
				&& !model2.getValueAt(i, 12).toString().equalsIgnoreCase("0.0")
				&& !model2.getValueAt(i, 12).toString()
						.equalsIgnoreCase("0.00")
				&& model2.getValueAt(i, 12).toString().length() != 0
				&& sd.getMode() != null && sd.getMode().equalsIgnoreCase("A")) {
			S16Count.add(12);

		}
		//For RPU 2.6
		//FRD 2.3 added 16(ia)		
				if (model2.getValueAt(i, 13) != null
						&& !model2.getValueAt(i, 13).toString().equalsIgnoreCase("0")
						&& !model2.getValueAt(i, 13).toString().equalsIgnoreCase("0.0")
						&& !model2.getValueAt(i, 13).toString()
								.equalsIgnoreCase("0.00")
						&& model2.getValueAt(i, 13).toString().length() != 0 
						&& sd.getMode() != null && sd.getMode().equalsIgnoreCase("A")) {
					S16Count.add(13);

				}
		
		/*********************************************************/				
		/*//FRD 2.3 added 16(ia)		
		if (model2.getValueAt(i, 13) != null
				&& !model2.getValueAt(i, 13).toString().equalsIgnoreCase("0")
				&& !model2.getValueAt(i, 13).toString().equalsIgnoreCase("0.0")
				&& !model2.getValueAt(i, 13).toString()
						.equalsIgnoreCase("0.00")
				&& model2.getValueAt(i, 13).toString().length() != 0) {
			S16Count.add(13);

		}*/
		/*********************************************************/
		if (sd.getMode() != null && sd.getMode().equalsIgnoreCase("A")) {
			sd.setCountofSalaryDetailsSection16DetailRecordsassociatedwiththisDeductee(new Integer(
					S16Count.size()).toString());
		}

		
		/*********************************************************/				
		//FRD 2.3 added 16(ia)
		/*if (model2.getValueAt(i, 13) != null
				&& model2.getValueAt(i, 13).toString().length() != 0
				&& sd.getMode() != null && sd.getMode().equalsIgnoreCase("A")) {
			sd.setGrossTotalofTotalDeductionundersection16underassociatedSalaryDetailsSection16Detail(model2
			.getValueAt(i, 13).toString());
		}*/
		
		if (model2.getValueAt(i, 11) != null && model2.getValueAt(i, 11).toString().length() != 0) {
			ded16II = Double.parseDouble(model2.getValueAt(i, 11).toString());
		}
		
		if (model2.getValueAt(i, 12) != null && model2.getValueAt(i, 12).toString().length() != 0) {
			ded16III = Double.parseDouble(model2.getValueAt(i, 12).toString());
		}
		
		if (model2.getValueAt(i, 13) != null && model2.getValueAt(i, 13).toString().length() != 0) {
			ded16IA = Double.parseDouble(model2.getValueAt(i, 13).toString());
		}
		
		totalDed16 = ded16II + ded16III + ded16IA;
		if (sd.getMode() != null && sd.getMode().equalsIgnoreCase("A")) {
			sd.setGrossTotalofTotalDeductionundersection16underassociatedSalaryDetailsSection16Detail(Double.toString(totalDed16));
		}
		//sd.setGrossTotalofTotalDeductionundersection16underassociatedSalaryDetailsSection16Detail(Double.toString(totalDed16));
		/*********************************************************/

		if (model2.getValueAt(i, 14) != null
				&& model2.getValueAt(i, 14).toString().length() != 0
				&& sd.getMode() != null && sd.getMode().equalsIgnoreCase("A")) {
			sd.setIncomechargeableundertheheadSalaries(model2.getValueAt(i, 14)
					.toString());
		}

		if (model2.getValueAt(i, 15) != null
				&& model2.getValueAt(i, 15).toString().length() != 0
				&& sd.getMode() != null && sd.getMode().equalsIgnoreCase("A")) {
			sd.setIncomeUnderanyheadotherthanincomeundertheheadSalariesofferedforTDS(model2
					.getValueAt(i, 15).toString());
		}

		if (model2.getValueAt(i, 16) != null
				&& model2.getValueAt(i, 16).toString().length() != 0
				&& sd.getMode() != null
				&& (sd.getMode().equalsIgnoreCase("A") || sd.getMode()
						.equalsIgnoreCase("D") )) {
			sd.setGrossTotalIncome(model2.getValueAt(i, 16).toString());
		}
		
	

		if ( sd.getMode()
				.equalsIgnoreCase("P") || (sd.getMode() != null && "D".equalsIgnoreCase(sd.getMode()))
				) // Newly added for PAN UPDATE and C5
									// correction
		{
			sd.setLastGrossTotalIncome(model2.getValueAt(i, 16).toString());
		}

		if (model2.getValueAt(i, 2).toString().equalsIgnoreCase("PAN UPDATE")) {
			sd.setMode(null);
		}
		/*if (model2.getValueAt(i, 17) != null
				&& model2.getValueAt(i, 17).toString().length() != 0
				&& sd.getMode() != null && sd.getMode().equalsIgnoreCase("A")) {
			c6ACount.add(17);

		}

		if (model2.getValueAt(i, 18) != null
				&& model2.getValueAt(i, 18).toString().length() != 0
				&& sd.getMode() != null && sd.getMode().equalsIgnoreCase("A")) {
			c6ACount.add(18);

		}

		if (model2.getValueAt(i, 19) != null
				&& model2.getValueAt(i, 19).toString().length() != 0
				&& sd.getMode() != null && sd.getMode().equalsIgnoreCase("A")) {
			c6ACount.add(19);

		}

		if (model2.getValueAt(i, 20) != null
				&& model2.getValueAt(i, 20).toString().length() != 0
				&& sd.getMode() != null && sd.getMode().equalsIgnoreCase("A")) {
			c6ACount.add(20);

		}*/
		
		
		//RPU 2.9 start
				if (model2.getValueAt(i, 17) != null
						&& sd.getMode() != null && sd.getMode() != null && sd.getMode().equalsIgnoreCase("A")
						&& model2.getValueAt(i, 17).toString().length() != 0) {
					c6ACount.add(17);
				}else
					c6ACount.add(0);
				
				c6ACount.add(0); //for 80CCE gross
				c6ACount.add(0); //for 80CCE qualifying

				if (model2.getValueAt(i, 18) != null
						&& sd.getMode() != null && sd.getMode().equalsIgnoreCase("A")
						&& model2.getValueAt(i, 18).toString().length() != 0) {
					c6ACount.add(18);
				}else
					c6ACount.add(0);

				c6ACount.add(0); //for 80CCF gross
				c6ACount.add(0); //for 80CCF qualifying
				
				if (model2.getValueAt(i, 19) != null
						&& sd.getMode() != null && sd.getMode().equalsIgnoreCase("A")
						&& model2.getValueAt(i, 19).toString().length() != 0) {
					c6ACount.add(19);
				}else
					c6ACount.add(0);

				c6ACount.add(0); //for 80CCG gross
				c6ACount.add(0); //for 80CCG qualifying
				
				if (model2.getValueAt(i, 20) != null
						&& sd.getMode() != null && sd.getMode().equalsIgnoreCase("A")
						&& model2.getValueAt(i, 20).toString().length() != 0) {
					c6ACount.add(20);
				}else
					c6ACount.add(0);
				
				if (model2.getValueAt(i, 91) != null
						&& sd.getMode() != null && sd.getMode().equalsIgnoreCase("A")
						&& model2.getValueAt(i, 91).toString().length() != 0) {
					c6ACount.add(91);
				}else
					c6ACount.add(0);
				
				if (model2.getValueAt(i, 92) != null
						&& sd.getMode() != null && sd.getMode().equalsIgnoreCase("A")
						&& model2.getValueAt(i, 92).toString().length() != 0) {
					c6ACount.add(92);
				}else
					c6ACount.add(0);
				
				
				if (model2.getValueAt(i, 71) != null
						&& sd.getMode() != null && sd.getMode().equalsIgnoreCase("A")
						&& model2.getValueAt(i, 71).toString().length() != 0) {
					c6ACount.add(71);
				}else
					c6ACount.add(0);
				
				if (model2.getValueAt(i, 70) != null
						&& sd.getMode() != null && sd.getMode().equalsIgnoreCase("A")
						&& model2.getValueAt(i, 70).toString().length() != 0) {
					c6ACount.add(70);
				}else
					c6ACount.add(0);
				
				c6ACount.add(0); //for 80C qualifying
				
				if (model2.getValueAt(i, 73) != null
						&& sd.getMode() != null && sd.getMode().equalsIgnoreCase("A")
						&& model2.getValueAt(i, 73).toString().length() != 0) {
					c6ACount.add(73);
				}else
					c6ACount.add(0);
				
				if (model2.getValueAt(i, 72) != null
						&& sd.getMode() != null && sd.getMode().equalsIgnoreCase("A")
						&& model2.getValueAt(i, 72).toString().length() != 0) {
					c6ACount.add(72);
				}else
					c6ACount.add(0);
				
				c6ACount.add(0); //for 80CCC qualifying
				
				if (model2.getValueAt(i, 75) != null
						&& sd.getMode() != null && sd.getMode().equalsIgnoreCase("A")
						&& model2.getValueAt(i, 75).toString().length() != 0) {
					c6ACount.add(75);
				}else
					c6ACount.add(0);
			
				if (model2.getValueAt(i, 74) != null
						&& sd.getMode() != null && sd.getMode().equalsIgnoreCase("A")
						&& model2.getValueAt(i, 74).toString().length() != 0) {
					c6ACount.add(74);
				}else
					c6ACount.add(0);
				
				c6ACount.add(0); //for 80CCD(1) qualifying
				
				if (model2.getValueAt(i, 77) != null
						&& sd.getMode() != null && sd.getMode().equalsIgnoreCase("A")
						&& model2.getValueAt(i, 77).toString().length() != 0) {
					c6ACount.add(77);
				}else
					c6ACount.add(0);
				
				if (model2.getValueAt(i, 76) != null
						&& sd.getMode() != null && sd.getMode().equalsIgnoreCase("A")
						&& model2.getValueAt(i, 76).toString().length() != 0) {
					c6ACount.add(76);
				}else
					c6ACount.add(0);
				
				c6ACount.add(0); //for 80CCD(1B) qualifying

				if (model2.getValueAt(i, 79) != null
						&& sd.getMode() != null && sd.getMode().equalsIgnoreCase("A")
						&& model2.getValueAt(i, 79).toString().length() != 0) {
					c6ACount.add(79);
				}else
					c6ACount.add(0);
				
				if (model2.getValueAt(i, 78) != null
						&& sd.getMode() != null && sd.getMode().equalsIgnoreCase("A")
						&& model2.getValueAt(i, 78).toString().length() != 0) {
					c6ACount.add(78);
				}else
					c6ACount.add(0);
				
				c6ACount.add(0); //for 80CCD(2) qualifying
				
				if (model2.getValueAt(i, 81) != null
						&& sd.getMode() != null && sd.getMode().equalsIgnoreCase("A")
						&& model2.getValueAt(i, 81).toString().length() != 0) {
					c6ACount.add(81);
				}else
					c6ACount.add(0);
				
				if (model2.getValueAt(i, 80) != null
						&& sd.getMode() != null && sd.getMode().equalsIgnoreCase("A")
						&& model2.getValueAt(i, 80).toString().length() != 0) {
					c6ACount.add(80);
				}else
					c6ACount.add(0);
				
				c6ACount.add(0); //for 80D qualifying
				
				if (model2.getValueAt(i, 83) != null
						&& sd.getMode() != null && sd.getMode().equalsIgnoreCase("A")
						&& model2.getValueAt(i, 83).toString().length() != 0) {
					c6ACount.add(83);

				}else
					c6ACount.add(0);
				
				if (model2.getValueAt(i, 82) != null
						&& sd.getMode() != null && sd.getMode().equalsIgnoreCase("A")
						&& model2.getValueAt(i, 82).toString().length() != 0) {
					c6ACount.add(82);
				}else
					c6ACount.add(0);
				
				c6ACount.add(0); //for 80E qualifying
				
				if (model2.getValueAt(i, 86) != null
						&& sd.getMode() != null && sd.getMode().equalsIgnoreCase("A")
						&& model2.getValueAt(i, 86).toString().length() != 0) {
					c6ACount.add(86);
				}else
					c6ACount.add(0);
				
				if (model2.getValueAt(i, 84) != null
						&& sd.getMode() != null && sd.getMode().equalsIgnoreCase("A")
						&& model2.getValueAt(i, 84).toString().length() != 0) {
					c6ACount.add(84);
				}else
					c6ACount.add(0);
				
				if (model2.getValueAt(i, 85) != null
						&& sd.getMode() != null && sd.getMode().equalsIgnoreCase("A")
						&& model2.getValueAt(i, 85).toString().length() != 0) {
					c6ACount.add(85);
				}else
					c6ACount.add(0);
				
				if (model2.getValueAt(i, 89) != null
						&& sd.getMode() != null && sd.getMode().equalsIgnoreCase("A")
						&& model2.getValueAt(i, 89).toString().length() != 0) {
					c6ACount.add(89);

				}else
					c6ACount.add(0);
				
				if (model2.getValueAt(i, 87) != null
						&& sd.getMode() != null && sd.getMode().equalsIgnoreCase("A")
						&& model2.getValueAt(i, 87).toString().length() != 0) {
					c6ACount.add(87);
				}
				else
					c6ACount.add(0);
				
				if (model2.getValueAt(i, 88) != null
						&& sd.getMode() != null && sd.getMode() != null && sd.getMode().equalsIgnoreCase("A")
						&& model2.getValueAt(i, 88).toString().length() != 0) {
					c6ACount.add(88);
				}else
					c6ACount.add(0);
				
				
				//rahul CR84532 24Q added 80CCH and 80CCH(1) start
				if (model2.getValueAt(i, 96) != null
						&& sd.getMode() != null && sd.getMode() != null && sd.getMode().equalsIgnoreCase("A")
						&& model2.getValueAt(i, 96).toString().length() != 0) {
					c6ACount.add(96);
				}else
					c6ACount.add(0);
				
				if (model2.getValueAt(i, 95) != null
						&& sd.getMode() != null && sd.getMode() != null && sd.getMode().equalsIgnoreCase("A")
						&& model2.getValueAt(i, 95).toString().length() != 0) {
					c6ACount.add(95);
				}else
					c6ACount.add(0);
				
				c6ACount.add(0); //for 80CCH qualifying
				
				
				if (model2.getValueAt(i, 98) != null
						&& sd.getMode() != null && sd.getMode() != null && sd.getMode().equalsIgnoreCase("A")
						&& model2.getValueAt(i, 98).toString().length() != 0) {
					c6ACount.add(98);
				}else
					c6ACount.add(0);
				
				if (model2.getValueAt(i, 97) != null
						&& sd.getMode() != null && sd.getMode() != null && sd.getMode().equalsIgnoreCase("A")
						&& model2.getValueAt(i, 97).toString().length() != 0) {
					c6ACount.add(97);
				}else
					c6ACount.add(0);
				
				c6ACount.add(0); //for 80CCH(1) qualifying
				
				//rahul CR84532 24Q added 80CCH and 80CCH(1) end
				
							
			    c6aCount=0;
			    if(model2.getValueAt(i, 17) != null && !model2.getValueAt(i, 17).toString().isEmpty() && !model2.getValueAt(i, 17).toString().trim().equals("0.00") && sd.getMode() != null && sd.getMode().equalsIgnoreCase("A")) 						{
				
					c6aCount++;
							
				}
				
				if(model2.getValueAt(i, 18) != null && !model2.getValueAt(i, 18).toString().isEmpty() && !model2.getValueAt(i, 18).toString().trim().equals("0.00") && sd.getMode() != null && sd.getMode().equalsIgnoreCase("A"))
				{
					c6aCount++;
							
				}
				
				if(model2.getValueAt(i, 19) != null && !model2.getValueAt(i, 19).toString().isEmpty() && !model2.getValueAt(i, 19).toString().trim().equals("0.00") && sd.getMode() != null && sd.getMode().equalsIgnoreCase("A"))
				{
					c6aCount++;
							
				}
				
				if((model2.getValueAt(i, 20) != null && !model2.getValueAt(i, 20).toString().isEmpty() &&  !model2.getValueAt(i, 20).toString().trim().equals("0.00") && sd.getMode() != null && sd.getMode().equalsIgnoreCase("A")) 
						|| (model2.getValueAt(i, 91) != null && !model2.getValueAt(i, 91).toString().isEmpty() &&  !model2.getValueAt(i, 91).toString().trim().equals("0.00") && sd.getMode() != null && sd.getMode().equalsIgnoreCase("A")) 
						|| (model2.getValueAt(i, 92) != null && !model2.getValueAt(i, 92).toString().isEmpty() && !model2.getValueAt(i, 92).toString().trim().equals("0.00")) && sd.getMode() != null && sd.getMode().equalsIgnoreCase("A"))

				{
					c6aCount++;
							
				}
				
				if((model2.getValueAt(i, 70) != null && !model2.getValueAt(i, 70).toString().isEmpty() && !model2.getValueAt(i, 70).toString().trim().equals("0.00") && sd.getMode() != null && sd.getMode().equalsIgnoreCase("A")) 
						|| (model2.getValueAt(i, 71) != null && !model2.getValueAt(i, 71).toString().isEmpty() && !model2.getValueAt(i, 71).toString().trim().equals("0.00")) && sd.getMode() != null && sd.getMode().equalsIgnoreCase("A") )

				{
					c6aCount++;
							
				}
				

				if((model2.getValueAt(i, 72) != null && !model2.getValueAt(i, 72).toString().isEmpty() && !model2.getValueAt(i, 72).toString().trim().equals("0.00") && sd.getMode() != null && sd.getMode().equalsIgnoreCase("A")) 
						|| (model2.getValueAt(i, 73) != null && !model2.getValueAt(i, 73).toString().isEmpty() && !model2.getValueAt(i, 73).toString().trim().equals("0.00")) && sd.getMode() != null && sd.getMode().equalsIgnoreCase("A") )

				{
					c6aCount++;
							
				}
				

				if((model2.getValueAt(i, 74) != null && !model2.getValueAt(i, 74).toString().isEmpty() && !model2.getValueAt(i, 74).toString().trim().equals("0.00") && sd.getMode() != null && sd.getMode().equalsIgnoreCase("A")) 
						|| (model2.getValueAt(i, 75) != null && !model2.getValueAt(i, 75).toString().isEmpty() && !model2.getValueAt(i, 75).toString().trim().equals("0.00"))  && sd.getMode() != null && sd.getMode().equalsIgnoreCase("A"))								
				{
					c6aCount++;
							
				}
				

				if((model2.getValueAt(i, 76) != null && !model2.getValueAt(i, 76).toString().isEmpty() && !model2.getValueAt(i, 76).toString().trim().equals("0.00") && sd.getMode() != null && sd.getMode().equalsIgnoreCase("A")) 
						|| (model2.getValueAt(i, 77) != null && !model2.getValueAt(i, 77).toString().isEmpty() && !model2.getValueAt(i, 77).toString().trim().equals("0.00"))  && sd.getMode() != null && sd.getMode().equalsIgnoreCase("A"))
				{
					c6aCount++;
							
				}
				
				if((model2.getValueAt(i, 78) != null && !model2.getValueAt(i, 78).toString().isEmpty() && !model2.getValueAt(i, 78).toString().trim().equals("0.00") && sd.getMode() != null && sd.getMode().equalsIgnoreCase("A")) 
						|| (model2.getValueAt(i, 79) != null && !model2.getValueAt(i, 79).toString().isEmpty() && !model2.getValueAt(i, 79).toString().trim().equals("0.00")) && sd.getMode() != null && sd.getMode().equalsIgnoreCase("A") )
				{
					c6aCount++;
							
				}
				if((model2.getValueAt(i, 80) != null && !model2.getValueAt(i, 80).toString().isEmpty() && !model2.getValueAt(i, 80).toString().trim().equals("0.00") && sd.getMode() != null && sd.getMode().equalsIgnoreCase("A")) 
						|| (model2.getValueAt(i, 81) != null && !model2.getValueAt(i, 81).toString().isEmpty() && !model2.getValueAt(i, 81).toString().trim().equals("0.00")) && sd.getMode() != null && sd.getMode().equalsIgnoreCase("A") )
				{
					c6aCount++;
							
				}
				if((model2.getValueAt(i, 82) != null && !model2.getValueAt(i, 82).toString().isEmpty() && !model2.getValueAt(i, 82).toString().trim().equals("0.00") && sd.getMode() != null && sd.getMode().equalsIgnoreCase("A")) 
						|| (model2.getValueAt(i, 83) != null && !model2.getValueAt(i, 83).toString().isEmpty() && !model2.getValueAt(i, 83).toString().trim().equals("0.00")) && sd.getMode() != null && sd.getMode().equalsIgnoreCase("A") )
				{
					c6aCount++;
							
				}

				if((model2.getValueAt(i, 84) != null && !model2.getValueAt(i, 84).toString().isEmpty() && !model2.getValueAt(i, 84).toString().trim().equals("0.00")) 
						|| (model2.getValueAt(i, 85) != null && !model2.getValueAt(i, 85).toString().isEmpty() && !model2.getValueAt(i, 85).toString().trim().equals("0.00")) 
						|| (model2.getValueAt(i, 86) != null && !model2.getValueAt(i, 86).toString().isEmpty() && !model2.getValueAt(i, 86).toString().trim().equals("0.00")))
				{
					c6aCount++;
							
				}
				
				if((model2.getValueAt(i, 87) != null && !model2.getValueAt(i, 87).toString().isEmpty() && !model2.getValueAt(i, 87).toString().trim().equals("0.00") && sd.getMode() != null && sd.getMode().equalsIgnoreCase("A")) 
						|| (model2.getValueAt(i, 88) != null && !model2.getValueAt(i, 88).toString().isEmpty() && !model2.getValueAt(i, 88).toString().trim().equals("0.00") && sd.getMode() != null && sd.getMode().equalsIgnoreCase("A")) 
						|| (model2.getValueAt(i, 89) != null && !model2.getValueAt(i, 89).toString().isEmpty() &&  !model2.getValueAt(i, 89).toString().trim().equals("0.00")) && sd.getMode() != null && sd.getMode().equalsIgnoreCase("A"))

				{
					c6aCount++;
							
				}
				
				//rahul CR84532 24Q added 80CCH and 80CCH(1) start
				if((model2.getValueAt(i, 95) != null && !model2.getValueAt(i, 95).toString().isEmpty() && !model2.getValueAt(i, 95).toString().trim().equals("0.00") && sd.getMode() != null && sd.getMode().equalsIgnoreCase("A")) 
						|| (model2.getValueAt(i, 96) != null && !model2.getValueAt(i, 96).toString().isEmpty() && !model2.getValueAt(i, 96).toString().trim().equals("0.00")) && sd.getMode() != null && sd.getMode().equalsIgnoreCase("A") )
				{
					c6aCount++;
							
				}
				
				if((model2.getValueAt(i, 97) != null && !model2.getValueAt(i, 97).toString().isEmpty() && !model2.getValueAt(i, 97).toString().trim().equals("0.00") && sd.getMode() != null && sd.getMode().equalsIgnoreCase("A")) 
						|| (model2.getValueAt(i, 98) != null && !model2.getValueAt(i, 98).toString().isEmpty() && !model2.getValueAt(i, 98).toString().trim().equals("0.00")) && sd.getMode() != null && sd.getMode().equalsIgnoreCase("A") )
				{
					c6aCount++;
							
				}
//rahul CR84532 24Q added 80CCH and 80CCH(1) end
				
				
				/*sd.setCountofSalaryDetails_ChapterVIA_Detail(new Integer(c6ACount
						.size()).toString());*/
				
				
				//RPU 2.9 end

		if (sd.getMode() != null && sd.getMode().equalsIgnoreCase("A")) {
			System.out.println("c6aCount for row:"+i+": " +c6aCount);
			sd.setCountofSalaryDetails_ChapterVIA_Detail(""+c6aCount);
		}

		if (model2.getValueAt(i, 21) != null
				&& model2.getValueAt(i, 21).toString().length() != 0
				&& sd.getMode() != null && (sd.getMode().equalsIgnoreCase("A"))) {
			sd.setGrossTotalofAmountdeductibleunderprovisionsofchapterVI_A(model2
					.getValueAt(i, 21).toString());
		}

		if (model2.getValueAt(i, 22) != null
				&& model2.getValueAt(i, 22).toString().length() != 0
				&& sd.getMode() != null && sd.getMode().equalsIgnoreCase("A")) {
			sd.setTotalTaxableIncome(model2.getValueAt(i, 22).toString());
		}

		if (model2.getValueAt(i, 23) != null
				&& model2.getValueAt(i, 23).toString().length() != 0
				&& sd.getMode() != null && sd.getMode().equalsIgnoreCase("A")) {
			sd.setIncomeTaxonTotalIncome(model2.getValueAt(i, 23).toString());
		}

		if (model2.getValueAt(i, 24) != null
				&& model2.getValueAt(i, 24).toString().length() != 0
				&& sd.getMode() != null && sd.getMode().equalsIgnoreCase("A")) {
			sd.setSurcharge(model2.getValueAt(i, 24).toString());
		}

		if (model2.getValueAt(i, 25) != null
				&& model2.getValueAt(i, 25).toString().length() != 0
				&& sd.getMode() != null && sd.getMode().equalsIgnoreCase("A")) {
			sd.setEducationCess(model2.getValueAt(i, 25).toString());
		}

		if (model2.getValueAt(i, 26) != null
				&& model2.getValueAt(i, 26).toString().length() != 0
				&& sd.getMode() != null && sd.getMode().equalsIgnoreCase("A")) {
			sd.setIncomeTaxRelief(model2.getValueAt(i, 26).toString());
		}

		if (model2.getValueAt(i, 27) != null
				&& model2.getValueAt(i, 27).toString().length() != 0
				&& sd.getMode() != null && sd.getMode().equalsIgnoreCase("A")) {
			sd.setNetIncomeTaxpayable(model2.getValueAt(i, 27).toString());
		}

		if (model2.getValueAt(i, 30) != null
				&& model2.getValueAt(i, 30).toString().length() != 0
				&& sd.getMode() != null && sd.getMode().equalsIgnoreCase("A")) {
			sd.setTotalamountoftaxdeductedatsourceforthewholeyear(model2
					.getValueAt(i, 30).toString());
		}

		if (model2.getValueAt(i, 31) != null
				&& model2.getValueAt(i, 31).toString().length() != 0
				&& sd.getMode() != null && sd.getMode().equalsIgnoreCase("A")) {
			sd.setShortfallintaxdeductionExcesstaxdeduction(model2.getValueAt(
					i, 31).toString());
		}

		if (model2.getValueAt(i, 8) != null
				&& model2.getValueAt(i, 8).toString().length() != 0
				&& sd.getMode() != null && sd.getMode().equalsIgnoreCase("A")) {
			sd.setTaxableAmountonwhichtaxisdeductedbythecurrentemployer(model2
					.getValueAt(i, 8).toString());
		}

		if (model2.getValueAt(i, 9) != null
				&& model2.getValueAt(i, 9).toString().length() != 0
				&& sd.getMode() != null && sd.getMode().equalsIgnoreCase("A")) {
			sd.setReportedTaxableAmountonwhichtaxisdeductedbypreviousemployer(model2
					.getValueAt(i, 9).toString());
		}

		if (model2.getValueAt(i, 28) != null
				&& model2.getValueAt(i, 28).toString().length() != 0
				&& sd.getMode() != null && sd.getMode().equalsIgnoreCase("A")) {
			sd.setTotalAmountoftaxdeductedatsourcebythecurrentemployerforthewholeyear(model2
					.getValueAt(i, 28).toString());
		}

		if (model2.getValueAt(i, 29) != null
				&& model2.getValueAt(i, 29).toString().length() != 0
				&& sd.getMode() != null && sd.getMode().equalsIgnoreCase("A")) {
			sd.setReportedamountofTaxdeductedatsourcebypreviousemployer(model2
					.getValueAt(i, 29).toString());
		}

		if ((model2.getValueAt(i, 32) != null && !model2.getValueAt(i, 32)
				.toString().contains("Select"))
				&& !(Integer.parseInt(rpu.finyear.substring(0, 4)) < 2013)
				&& sd.getMode() != null && sd.getMode().equalsIgnoreCase("A")) {
			sd.setWhethertaxdeductedatHigherrate(model2.getValueAt(i, 32)
					.toString().substring(0,1));
		}

		
				//newly added for FRD1.6 by akansha
			//	System.out.println("Fin year:"+rpu.finyear+" Mode:"+sd.getMode());
				if(Integer.parseInt(rpu.finyear.substring(0, 4)) >= 2016 
						&& sd.getMode() != null && (sd.getMode().equalsIgnoreCase("A"))){
					// ||sd.getMode().equalsIgnoreCase("D") removed as per discussion with Deepak on 19/08/2016
					if(model2.getValueAt(i,33)!=null && !model2.getValueAt(i,33).toString().contains("Select")){
						sd.setWhetherhouserentallowanceclaim(model2.getValueAt(i,33).toString().substring(0,1));
					}
					

					if(model2.getValueAt(i,33)!=null && !model2.getValueAt(i,33).toString().contains("Select")
							&& !model2.getValueAt(i,33).toString().contains("No")){
						
						if(model2.getValueAt(i,34)!=null && model2.getValueAt(i,34).toString().length() != 0){
							// newly changed for taking column value, FRD1.9 on 19/01/17
							if(model2.getValueAt(i, 34).toString().equals("--Select--") || 
									model2.getValueAt(i, 34).toString().equals("--SELECT--") || 
									model2.getValueAt(i, 34).toString().equals("")){
								sd.setPanofLandlord1(null);
							}else{
								if (model2
										.getValueAt(i, 34)
										.toString()
										.equals("Payment made to Government organization (Central/State only)")) {
									sd.setPanofLandlord1("GOVERNMENT");

									System.out.println("File appender ka value hai :");

								} else if (model2.getValueAt(i, 34).toString()
										.equals("Payment made to Non-resident")) {
									sd.setPanofLandlord1("NONRESDENT");

								} else if (model2
										.getValueAt(i, 34)
										.toString()
										.equals("Payment made to Other than Government organization and Non-resident")) {
									sd.setPanofLandlord1("OTHERVALUE");
								}

								else {
									sd.setPanofLandlord1(model2.getValueAt(i, 34).toString());
								}
								countPANLandLord++;
							}
							/*if (model2
									.getValueAt(i, 34)
									.toString()
									.equals("Payment made to Government organization (Central/State only)")) {
								sd.setPanofLandlord1("GOVERNMENT");

								//System.out.println("File appender ka value hai :");

							} else if (model2.getValueAt(i, 34).toString()
									.equals("Payment made to Non-resident")) {
								sd.setPanofLandlord1("NONRESDENT");

							} else if (model2
									.getValueAt(i, 34)
									.toString()
									.equals("Payment made to Other than Government organization and Non-resident")) {
								sd.setPanofLandlord1("OTHERVALUE");
							}

							else {
								sd.setPanofLandlord1(model2.getValueAt(i, 34)
										.toString());
							}
						//	sd.setPanofLandlord1(model2.getValueAt(i, 34).toString());
							countPANLandLord++;*/
						}
						
						if(model2.getValueAt(i,35)!=null && model2.getValueAt(i,35).toString().length() != 0){
							sd.setNameofLandlord1(model2.getValueAt(i, 35).toString());
							
						}
						
						
						if(model2.getValueAt(i,36)!=null && model2.getValueAt(i,36).toString().length() != 0){
							
							//newly changed for taking column value, FRD1.9 on 19/01/17
							if(model2.getValueAt(i, 36).toString().equals("--Select--") || 
									model2.getValueAt(i, 36).toString().equals("--SELECT--") || 
									model2.getValueAt(i, 36).toString().equals("")){
								sd.setPanofLandlord2(null);
							}else{
								if (model2
										.getValueAt(i, 36)
										.toString()
										.equals("Payment made to Government organization (Central/State only)")) {
									sd.setPanofLandlord2("GOVERNMENT");

								} else if (model2.getValueAt(i, 36).toString()
										.equals("Payment made to Non-resident")) {
									sd.setPanofLandlord2("NONRESDENT");

								} else if (model2
										.getValueAt(i, 36)
										.toString()
										.equals("Payment made to Other than Government organization and Non-resident")) {
									sd.setPanofLandlord2("OTHERVALUE");
								}

								else {
									sd.setPanofLandlord2(model2.getValueAt(i, 36)
											.toString());
								}
								countPANLandLord++;
							}
							/*if (model2
									.getValueAt(i, 36)
									.toString()
									.equals("Payment made to Government organization (Central/State only)")) {
								sd.setPanofLandlord2("GOVERNMENT");

							} else if (model2.getValueAt(i, 36).toString()
									.equals("Payment made to Non-resident")) {
								sd.setPanofLandlord2("NONRESDENT");

							} else if (model2
									.getValueAt(i, 36)
									.toString()
									.equals("Payment made to Other than Government organization and Non-resident")) {
								sd.setPanofLandlord2("OTHERVALUE");
							}

							else {
								sd.setPanofLandlord2(model2.getValueAt(i, 36)
										.toString());
							}
							//**********************************************
							
							//sd.setPanofLandlord2(model2.getValueAt(i, 36).toString());
							countPANLandLord++;*/
						}
						
						if(model2.getValueAt(i,37)!=null && model2.getValueAt(i,37).toString().length() != 0){
							sd.setNameofLandlord2(model2.getValueAt(i, 37).toString());
							
						}
						
						
						if(model2.getValueAt(i,38)!=null && model2.getValueAt(i,38).toString().length() != 0){
							

							//newly changed for taking column value, FRD1.9 on 19/01/17
							if(model2.getValueAt(i, 38).toString().equals("--Select--") || 
									model2.getValueAt(i, 38).toString().equals("--SELECT--") || 
									model2.getValueAt(i, 38).toString().equals("")){
								sd.setPanofLandlord3(null);
							}else{
								if (model2
										.getValueAt(i, 38)
										.toString()
										.equals("Payment made to Government organization (Central/State only)")) {
									sd.setPanofLandlord3("GOVERNMENT");

								} else if (model2.getValueAt(i, 38).toString()
										.equals("Payment made to Non-resident")) {
									sd.setPanofLandlord3("NONRESDENT");

								} else if (model2
										.getValueAt(i, 38)
										.toString()
										.equals("Payment made to Other than Government organization and Non-resident")) {
									sd.setPanofLandlord3("OTHERVALUE");
								}

								else {
									sd.setPanofLandlord3(model2.getValueAt(i, 38)
											.toString());
								}
								countPANLandLord++;
							}
							/*if (model2
									.getValueAt(i, 38)
									.toString()
									.equals("Payment made to Government organization (Central/State only)")) {
								sd.setPanofLandlord3("GOVERNMENT");

							} else if (model2.getValueAt(i, 38).toString()
									.equals("Payment made to Non-resident")) {
								sd.setPanofLandlord3("NONRESDENT");

							} else if (model2
									.getValueAt(i, 38)
									.toString()
									.equals("Payment made to Other than Government organization and Non-resident")) {
								sd.setPanofLandlord3("OTHERVALUE");
							}

							else {
								sd.setPanofLandlord3(model2.getValueAt(i, 38)
										.toString());
							}
							//**********************************************
							
							//sd.setPanofLandlord3(model2.getValueAt(i, 38).toString());
							countPANLandLord++;*/
						}
						
						if(model2.getValueAt(i,39)!=null && model2.getValueAt(i,39).toString().length() != 0){
							sd.setNameofLandlord3(model2.getValueAt(i, 39).toString());
							
						}
						
						if(model2.getValueAt(i,40)!=null && model2.getValueAt(i,40).toString().length() != 0){
							
							//newly changed for taking column value, FRD1.9 on 19/01/17
							if(model2.getValueAt(i, 40).toString().equals("--Select--") || 
									model2.getValueAt(i, 40).toString().equals("--SELECT--") || 
									model2.getValueAt(i, 40).toString().equals("")){
								sd.setPanofLandlord4(null);
							}else{
								if (model2
										.getValueAt(i, 40)
										.toString()
										.equals("Payment made to Government organization (Central/State only)")) {
									sd.setPanofLandlord4("GOVERNMENT");

								} else if (model2.getValueAt(i, 40).toString()
										.equals("Payment made to Non-resident")) {
									sd.setPanofLandlord4("NONRESDENT");

								} else if (model2
										.getValueAt(i, 40)
										.toString()
										.equals("Payment made to Other than Government organization and Non-resident")) {
									sd.setPanofLandlord4("OTHERVALUE");
								}

								else {
									sd.setPanofLandlord4(model2.getValueAt(i, 40)
											.toString());
								}
								countPANLandLord++;
							}
							/*if (model2
									.getValueAt(i, 40)
									.toString()
									.equals("Payment made to Government organization (Central/State only)")) {
								sd.setPanofLandlord4("GOVERNMENT");

							} else if (model2.getValueAt(i, 40).toString()
									.equals("Payment made to Non-resident")) {
								sd.setPanofLandlord4("NONRESDENT");

							} else if (model2
									.getValueAt(i, 40)
									.toString()
									.equals("Payment made to Other than Government organization and Non-resident")) {
								sd.setPanofLandlord4("OTHERVALUE");
							}

							else {
								sd.setPanofLandlord4(model2.getValueAt(i, 40)
										.toString());
							}
							//**********************************************
							
							//sd.setPanofLandlord4(model2.getValueAt(i, 40).toString());
							countPANLandLord++;*/
						}
						
						if(model2.getValueAt(i,41)!=null && model2.getValueAt(i,41).toString().length() != 0){
							sd.setNameofLandlord4(model2.getValueAt(i, 41).toString());
							
						}
							//sd.setCountofPANoftheLandLord(String.valueOf(countPANLandLord));
					}
					sd.setCountofPANoftheLandLord(String.valueOf(countPANLandLord));
					
					if(model2.getValueAt(i,42)!=null && !model2.getValueAt(i,42).toString().contains("Select")){
						sd.setWhetherInterestPaidtotheLender(model2.getValueAt(i,42).toString().substring(0,1));
					}
					
					
					
					if(model2.getValueAt(i,42)!=null && !model2.getValueAt(i,42).toString().contains("Select")
							&& !model2.getValueAt(i,42).toString().contains("No")){
					
						if(model2.getValueAt(i,43)!=null && model2.getValueAt(i,43).toString().length() != 0){
							// newly changed for taking column value, Added by Sadhana FRD2.0 on 04/10/2017
							if(model2.getValueAt(i, 43).toString().equals("--Select--") || 
									model2.getValueAt(i, 43).toString().equals("--SELECT--") || 
									model2.getValueAt(i, 43).toString().equals("")){
								sd.setDeductionOfInterestUnderHeadIncomePANofLender1(null);
							}else{
								if (model2
										.getValueAt(i, 43)
										.toString()
										.equals("Payment made to Government organization (Central/State only)")) {
									sd.setDeductionOfInterestUnderHeadIncomePANofLender1("GOVERNMENT");

								} else if (model2.getValueAt(i, 43).toString()
										.equals("Payment made to Non-resident")) {
									sd.setDeductionOfInterestUnderHeadIncomePANofLender1("NONRESDENT");

								} else if (model2
										.getValueAt(i, 43)
										.toString()
										.equals("Payment made to Other than Government organization and Non-resident")) {
									sd.setDeductionOfInterestUnderHeadIncomePANofLender1("OTHERVALUE");
								}

								else {
									sd.setDeductionOfInterestUnderHeadIncomePANofLender1(model2.getValueAt(i, 43)
											.toString());
								}
								countPANLender++;
							}
							/*if (model2
									.getValueAt(i, 43)
									.toString()
									.equals("Payment made to Government organization (Central/State only)")) {
								sd.setDeductionOfInterestUnderHeadIncomePANofLender1("GOVERNMENT");

								//System.out.println("File appender ka value hai :");

							} else if (model2.getValueAt(i, 43).toString()
									.equals("Payment made to Non-resident")) {
								sd.setDeductionOfInterestUnderHeadIncomePANofLender1("NONRESDENT");

							} else if (model2
									.getValueAt(i, 43)
									.toString()
									.equals("Payment made to Other than Government organization and Non-resident")) {
								sd.setDeductionOfInterestUnderHeadIncomePANofLender1("OTHERVALUE");
							}

							else {
								sd.setDeductionOfInterestUnderHeadIncomePANofLender1(model2.getValueAt(i, 43)
										.toString());
							}
							//****************************** 04/10/2017 ********************************
							//sd.setDeductionOfInterestUnderHeadIncomePANofLender1(model2.getValueAt(i, 43).toString());
							countPANLender++;*/
						}
						
						if(model2.getValueAt(i,44)!=null && model2.getValueAt(i,44).toString().length() != 0){
							sd.setDeductionOfInterestUnderHeadIncomeNameofLender1(model2.getValueAt(i, 44).toString());
							
						}
						
						
						
						if(model2.getValueAt(i,45)!=null && model2.getValueAt(i,45).toString().length() != 0){
							// newly changed for taking column value, Added by Sadhana FRD2.0 on 04/10/2017
							if(model2.getValueAt(i, 45).toString().equals("--Select--") || 
									model2.getValueAt(i, 45).toString().equals("--SELECT--") || 
									model2.getValueAt(i, 45).toString().equals("")){
								sd.setDeductionOfInterestUnderHeadIncomePANofLender2(null);
							}else{
								if (model2
										.getValueAt(i, 45)
										.toString()
										.equals("Payment made to Government organization (Central/State only)")) {
									sd.setDeductionOfInterestUnderHeadIncomePANofLender2("GOVERNMENT");

								} else if (model2.getValueAt(i, 45).toString()
										.equals("Payment made to Non-resident")) {
									sd.setDeductionOfInterestUnderHeadIncomePANofLender2("NONRESDENT");

								} else if (model2
										.getValueAt(i, 45)
										.toString()
										.equals("Payment made to Other than Government organization and Non-resident")) {
									sd.setDeductionOfInterestUnderHeadIncomePANofLender2("OTHERVALUE");
								}

								else {
									sd.setDeductionOfInterestUnderHeadIncomePANofLender2(model2.getValueAt(i, 45)
											.toString());
								}
								countPANLender++;
							}
							/*if (model2
									.getValueAt(i, 45)
									.toString()
									.equals("Payment made to Government organization (Central/State only)")) {
								sd.setDeductionOfInterestUnderHeadIncomePANofLender2("GOVERNMENT");

								//System.out.println("File appender ka value hai :");

							} else if (model2.getValueAt(i, 45).toString()
									.equals("Payment made to Non-resident")) {
								sd.setDeductionOfInterestUnderHeadIncomePANofLender2("NONRESDENT");

							} else if (model2
									.getValueAt(i, 45)
									.toString()
									.equals("Payment made to Other than Government organization and Non-resident")) {
								sd.setDeductionOfInterestUnderHeadIncomePANofLender2("OTHERVALUE");
							}

							else {
								sd.setDeductionOfInterestUnderHeadIncomePANofLender2(model2.getValueAt(i, 45)
										.toString());
							}
							//****************************** 04/10/2017 ********************************
							//sd.setDeductionOfInterestUnderHeadIncomePANofLender2(model2.getValueAt(i, 45).toString());
							countPANLender++;*/
						}
						
						if(model2.getValueAt(i,46)!=null && model2.getValueAt(i,46).toString().length() != 0){
							sd.setDeductionOfInterestUnderHeadIncomeNameofLender2(model2.getValueAt(i, 46).toString());
							
						}
						
						
						if(model2.getValueAt(i,47)!=null && model2.getValueAt(i,47).toString().length() != 0){
							// newly changed for taking column value, Added by Sadhana FRD2.0 on 04/10/2017
							if(model2.getValueAt(i, 47).toString().equals("--Select--") || 
									model2.getValueAt(i, 47).toString().equals("--SELECT--") || 
									model2.getValueAt(i, 47).toString().equals("")){
								sd.setDeductionOfInterestUnderHeadIncomePANofLender3(null);
							}else{
								if (model2
										.getValueAt(i, 47)
										.toString()
										.equals("Payment made to Government organization (Central/State only)")) {
									sd.setDeductionOfInterestUnderHeadIncomePANofLender3("GOVERNMENT");

								} else if (model2.getValueAt(i, 47).toString()
										.equals("Payment made to Non-resident")) {
									sd.setDeductionOfInterestUnderHeadIncomePANofLender3("NONRESDENT");

								} else if (model2
										.getValueAt(i, 47)
										.toString()
										.equals("Payment made to Other than Government organization and Non-resident")) {
									sd.setDeductionOfInterestUnderHeadIncomePANofLender3("OTHERVALUE");
								}

								else {
									sd.setDeductionOfInterestUnderHeadIncomePANofLender3(model2.getValueAt(i, 47)
											.toString());
								}
								//sd.setDeductionOfInterestUnderHeadIncomePANofLender3(model2.getValueAt(i, 47).toString());
								countPANLender++;
							}
							/*if (model2
									.getValueAt(i, 47)
									.toString()
									.equals("Payment made to Government organization (Central/State only)")) {
								sd.setDeductionOfInterestUnderHeadIncomePANofLender3("GOVERNMENT");

								//System.out.println("File appender ka value hai :");

							} else if (model2.getValueAt(i, 47).toString()
									.equals("Payment made to Non-resident")) {
								sd.setDeductionOfInterestUnderHeadIncomePANofLender3("NONRESDENT");

							} else if (model2
									.getValueAt(i, 47)
									.toString()
									.equals("Payment made to Other than Government organization and Non-resident")) {
								sd.setDeductionOfInterestUnderHeadIncomePANofLender3("OTHERVALUE");
							}

							else {
								sd.setDeductionOfInterestUnderHeadIncomePANofLender3(model2.getValueAt(i, 47)
										.toString());
							}
							//****************************** 04/10/2017 ********************************
							//sd.setDeductionOfInterestUnderHeadIncomePANofLender3(model2.getValueAt(i, 47).toString());
							countPANLender++;*/
						}
						
						if(model2.getValueAt(i,48)!=null && model2.getValueAt(i,48).toString().length() != 0){
							sd.setDeductionOfInterestUnderHeadIncomeNameofLender3(model2.getValueAt(i, 48).toString());
							
						}
						
						if(model2.getValueAt(i,49)!=null && model2.getValueAt(i,49).toString().length() != 0){
							// newly changed for taking column value, Added by Sadhana FRD2.0 on 04/10/2017
							if(model2.getValueAt(i, 49).toString().equals("--Select--") || 
									model2.getValueAt(i, 49).toString().equals("--SELECT--") || 
									model2.getValueAt(i, 49).toString().equals("")){
								sd.setDeductionOfInterestUnderHeadIncomePANofLender4(null);
							}else{
								if (model2
										.getValueAt(i, 49)
										.toString()
										.equals("Payment made to Government organization (Central/State only)")) {
									sd.setDeductionOfInterestUnderHeadIncomePANofLender4("GOVERNMENT");

								} else if (model2.getValueAt(i, 49).toString()
										.equals("Payment made to Non-resident")) {
									sd.setDeductionOfInterestUnderHeadIncomePANofLender4("NONRESDENT");

								} else if (model2
										.getValueAt(i, 49)
										.toString()
										.equals("Payment made to Other than Government organization and Non-resident")) {
									sd.setDeductionOfInterestUnderHeadIncomePANofLender4("OTHERVALUE");
								}

								else {
									sd.setDeductionOfInterestUnderHeadIncomePANofLender4(model2.getValueAt(i, 49)
											.toString());
								}
								//sd.setDeductionOfInterestUnderHeadIncomePANofLender4(model2.getValueAt(i, 49).toString());
								countPANLender++;
							}
							/*if (model2
									.getValueAt(i, 49)
									.toString()
									.equals("Payment made to Government organization (Central/State only)")) {
								sd.setDeductionOfInterestUnderHeadIncomePANofLender4("GOVERNMENT");

								//System.out.println("File appender ka value hai :");

							} else if (model2.getValueAt(i, 49).toString()
									.equals("Payment made to Non-resident")) {
								sd.setDeductionOfInterestUnderHeadIncomePANofLender4("NONRESDENT");

							} else if (model2
									.getValueAt(i, 49)
									.toString()
									.equals("Payment made to Other than Government organization and Non-resident")) {
								sd.setDeductionOfInterestUnderHeadIncomePANofLender4("OTHERVALUE");
							}

							else {
								sd.setDeductionOfInterestUnderHeadIncomePANofLender4(model2.getValueAt(i, 49)
										.toString());
							}
							//****************************** 04/10/2017 ********************************
							//sd.setDeductionOfInterestUnderHeadIncomePANofLender4(model2.getValueAt(i, 49).toString());
							countPANLender++;*/
						}
						
						if(model2.getValueAt(i,50)!=null && model2.getValueAt(i,50).toString().length() != 0){
							sd.setDeductionOfInterestUnderHeadIncomeNameofLender4(model2.getValueAt(i, 50).toString());
							
						}
						
						
						//sd.setCountofPANoftheLender(String.valueOf(countPANLender));
					}
					sd.setCountofPANoftheLender(String.valueOf(countPANLender));
				}
				
				
				//newly added for revised FRD1.6 by akansha
				if(Integer.parseInt(rpu.finyear.substring(0, 4)) >= 2013 
						&& sd.getMode() != null && (sd.getMode().equalsIgnoreCase("A"))){
						//		||sd.getMode().equalsIgnoreCase("D"))) removed as per discussion with Deepak 19/08/2016
					if(model2.getValueAt(i,51)!=null && !model2.getValueAt(i,51).toString().contains("Select")){
						sd.setWhetherContributionsPaidByTrustees(model2.getValueAt(i,51).toString().substring(0,1));
					}
					
					if(model2.getValueAt(i,51)!=null && !model2.getValueAt(i,51).toString().contains("Select")
							&& !model2.getValueAt(i,51).toString().contains("No")){
						if(model2.getValueAt(i,52)!=null && model2.getValueAt(i,52).toString().length()!=0){
							sd.setNameOfSuperAnnuationFund(model2.getValueAt(i,52).toString());
						}
						
						if(model2.getValueAt(i,53)!=null && model2.getValueAt(i,53).toString().length()!=0){
							sd.setDateFromWhichEmpContrSuperAnnFund(model2.getValueAt(i,53).toString().replaceAll("/", ""));
						}
						
						if(model2.getValueAt(i,54)!=null && model2.getValueAt(i,54).toString().length()!=0){
							sd.setDateToWhichEmpContrSuperAnnFund(model2.getValueAt(i,54).toString().replaceAll("/", ""));
						}
						
						if(model2.getValueAt(i,55)!=null && model2.getValueAt(i,55).toString().length()!=0){
							sd.setAmountOfContrRepaidPI(model2.getValueAt(i,55).toString());
						}
						if(model2.getValueAt(i,56)!=null && model2.getValueAt(i,56).toString().length()!=0){
							sd.setAvgRateOfDedTaxPrecedingThreeYears(model2.getValueAt(i,56).toString());
						}
						if(model2.getValueAt(i,57)!=null && model2.getValueAt(i,57).toString().length()!=0){
							sd.setAmountOfTaxDeductedRepayment(model2.getValueAt(i,57).toString());
						}
						if(model2.getValueAt(i,58)!=null && model2.getValueAt(i,58).toString().length()!=0){
							sd.setGrossTotalIncomeContrPISuperAnnuation(model2.getValueAt(i,58).toString());
						}
					}
				}
				//**************************************************************
				/****************** Added for 2.7 Start ********************/
								
				if(Integer.parseInt(rpu.finyear.substring(0, 4)) >= 2018 
						&& sd.getMode() != null && (sd.getMode().equalsIgnoreCase("A"))){
					
					
					if (model2.getValueAt(i, 71) != null
							&& model2.getValueAt(i, 71).toString().length() != 0) {
						temp80C80CCCand80CCD = Double.parseDouble(model2.getValueAt(
								i, 71).toString());
					}
					
					if (model2.getValueAt(i, 73) != null
							&& model2.getValueAt(i, 73).toString().length() != 0) {
						temp80C80CCCand80CCD = temp80C80CCCand80CCD + Double.parseDouble(model2.getValueAt(
								i, 73).toString());
					}
					
					if (model2.getValueAt(i, 75) != null
							&& model2.getValueAt(i, 75).toString().length() != 0) {
						temp80C80CCCand80CCD = temp80C80CCCand80CCD + Double.parseDouble(model2.getValueAt(
								i, 75).toString());
					}
					
					sd.setAggregateamountofdeductionsadmissibleundersection80C80CCCand80CCD(Double.toString(temp80C80CCCand80CCD));
										
					
					if(model2.getValueAt(i,59)!=null && model2.getValueAt(i,59).toString().length()!=0){
						sd.setGrossSalaryAsPerSec17_1(model2.getValueAt(i,59).toString());
					}
					if(model2.getValueAt(i,60)!=null && model2.getValueAt(i,60).toString().length()!=0){
						sd.setValueOfPerquisiteAsPerSec17_2(model2.getValueAt(i,60).toString());
					}
					if(model2.getValueAt(i,61)!=null && model2.getValueAt(i,61).toString().length()!=0){
						sd.setProfitsInLieuOfSalaryAsPerSec17_3(model2.getValueAt(i,61).toString());
					}
					if(model2.getValueAt(i,62)!=null && model2.getValueAt(i,62).toString().length()!=0){
						sd.setTravelConcession(model2.getValueAt(i,62).toString());
					}
					if(model2.getValueAt(i,63)!=null && model2.getValueAt(i,63).toString().length()!=0){
						sd.setDeathCumRetirementGratuity(model2.getValueAt(i,63).toString());
					}
					if(model2.getValueAt(i,64)!=null && model2.getValueAt(i,64).toString().length()!=0){
						sd.setCommutedValueOfPension(model2.getValueAt(i,64).toString());
					}
					if(model2.getValueAt(i,65)!=null && model2.getValueAt(i,65).toString().length()!=0){
						sd.setCashEquivalentOfLeaveSalary(model2.getValueAt(i,65).toString());
					}
					if(model2.getValueAt(i,66)!=null && model2.getValueAt(i,66).toString().length()!=0){
						sd.setHRA(model2.getValueAt(i,66).toString());
					}
					if(model2.getValueAt(i,67)!=null && model2.getValueAt(i,67).toString().length()!=0){
						sd.setAmountOfAnyOtherExemption(model2.getValueAt(i,67).toString());
					}
					if(model2.getValueAt(i,68)!=null && model2.getValueAt(i,68).toString().length()!=0){
						sd.setTotalAmountOfExemption(model2.getValueAt(i,68).toString());
					}
					if(model2.getValueAt(i,69)!=null && model2.getValueAt(i,69).toString().length()!=0){
						sd.setIncomeUnderTheHead(model2.getValueAt(i,69).toString());
					}
			 		if(model2.getValueAt(i,90)!=null && model2.getValueAt(i,90).toString().length()!=0){
						sd.setRebateUnderSection87A(model2.getValueAt(i,90).toString());
					}
					if(Integer.parseInt(rpu.finyear.substring(0, 4)) >= 2020)
					if(model2.getValueAt(i,93)!=null && !model2.getValueAt(i,93).toString().contains("Select")   ){
						sd.setWhetheroptingfornewtax(model2.getValueAt(i,93).toString().substring(0,1));//RPU 3.6 changes to set value Y N for column 93
					}
					
					//rahul CR86827 other Special Allowance start
					if(Integer.parseInt(rpu.finyear.substring(0, 4)) >= 2023)
						if(model2.getValueAt(i,94)!=null && model2.getValueAt(i,94).toString().length()!=0){
							sd.setOtherSpecialAllowancesUnderSection10_14(model2.getValueAt(i,94).toString());
						}
					//rahul CR86827 other Special Allowance end
					
					// rahul CR 88008 new column added for Annex 2 start
					if(Integer.parseInt(rpu.finyear.substring(0, 4)) >= 2024)
						if(model2.getValueAt(i,99)!=null && model2.getValueAt(i,99).toString().length()!=0){
							sd.setAmtReportedAsperSec1922B(model2.getValueAt(i,99).toString());
						}
					// rahul CR 88008 new column added for Annex 2 end
					
				}
				
				/*if(Integer.parseInt(rpu.finyear.substring(0, 4)) >= 2023)
					if(model2.getValueAt(i,94)!=null && model2.getValueAt(i,94).toString().length()!=0){
						sd.setOtherSpecialAllowancesUnderSection10_14(model2.getValueAt(i,94).toString());
					}*/
				/****************** Added for 2.7 End ********************/
				
				//*********************************************************************
		
		return sd;

	}
	
	
	public Annex3_94PBean _94PAppenderCorrection(ArrayList<Object> ls, int i,
			Integer BH_Count) {
		
		AnnexIII94P_S16Count.clear();
		AnnexIII_c6ACount.clear();

		Annex3_94PBean anneIII94P = new Annex3_94PBean();
		
		totalDed16Anne3 = 0; 
	    
		ded16IIIAnne3 = 0;
		ded16IAAnne3 = 0;
		temp80C80CCCand80CCDAnne3 = 0;
			
		anneIII94P.setLineNumber("" + (ls.size() + 1));
		anneIII94P.setRecordType("94P");
		anneIII94P.setBatchNumber(BH_Count.toString());
		
		if (model3.getValueAt(i, 1) != null
				&& model3.getValueAt(i, 1).toString().length() != 0) {
			anneIII94P.setDetailsRecordNo194P(model3.getValueAt(i, 1).toString());
		}
		
		if (model3.getValueAt(i, 2) != null && model3.getValueAt(i, 2).toString().length() != 0) {
			anneIII94P.setMode(model3.getValueAt(i, 2).toString().substring(0, 1).toUpperCase());
		}
		
		if (model3.getValueAt(i, 3) != null && model3.getValueAt(i, 3).toString().length() != 0
				&& anneIII94P.getMode() != null && (anneIII94P.getMode().equalsIgnoreCase("A") || anneIII94P.getMode().equalsIgnoreCase("P"))) {
			anneIII94P.setPANNo(model3.getValueAt(i, 3).toString());

		}
		
		if (model3.getValueAt(i, 4) != null && model3.getValueAt(i, 4).toString().length() != 0
				&& anneIII94P.getMode() != null && anneIII94P.getMode().equalsIgnoreCase("A")) {
			anneIII94P.setNameofSeniorCitizen(model3.getValueAt(i, 4).toString());
		}
		
		if (model3.getValueAt(i, 5) != null && model3.getValueAt(i, 5).toString().length() != 0
				&& !(model3.getValueAt(i, 5).toString().contains("Select")) && anneIII94P.getMode() != null
				&& anneIII94P.getMode().equalsIgnoreCase("A")) {

			anneIII94P.setCategoryofSeniorCitizen(GrpuUtil.getAnnex3EmployeeCode(model3
					.getValueAt(i, 5).toString()));

		}
		
		if (model3.getValueAt(i, 6) != null && !model3.getValueAt(i, 6).toString().contains("Select")
				&& anneIII94P.getMode() != null && anneIII94P.getMode().equalsIgnoreCase("A")) {
			anneIII94P.setWhetheroptingfornewtax(model3.getValueAt(i, 6).toString().substring(0, 1));
		}
		
		if (model3.getValueAt(i, 7) != null
				&& model3.getValueAt(i, 7).toString().length() != 0 && anneIII94P.getMode() != null && anneIII94P.getMode().equalsIgnoreCase("A"))
		{
			anneIII94P.setGrossPensionSection17_1(model3
					.getValueAt(i, 7).toString());
		}
		
		
// P16 Starts
		if (model3.getValueAt(i, 8) != null
				&& !model3.getValueAt(i, 8).toString().equalsIgnoreCase("0")
				&& !model3.getValueAt(i, 8).toString().equalsIgnoreCase("0.0")
				&& !model3.getValueAt(i, 8).toString()
						.equalsIgnoreCase("0.00")
				&& model3.getValueAt(i, 8).toString().length() != 0 
			&& anneIII94P.getMode() != null && anneIII94P.getMode().equalsIgnoreCase("A")){

			AnnexIII94P_S16Count.add(8);

		}
		
		if (model3.getValueAt(i, 9) != null
				&& !model3.getValueAt(i, 9).toString().equalsIgnoreCase("0")
				&& !model3.getValueAt(i, 9).toString().equalsIgnoreCase("0.0")
				&& !model3.getValueAt(i, 9).toString()
						.equalsIgnoreCase("0.00")
				&& model3.getValueAt(i, 9).toString().length() != 0 
				&& anneIII94P.getMode() != null && anneIII94P.getMode().equalsIgnoreCase("A")){
			AnnexIII94P_S16Count.add(9);

		}
		
		
		if (anneIII94P.getMode() != null && anneIII94P.getMode().equalsIgnoreCase("A")) {
		anneIII94P.setCountofSection194PSection16DetailRecordsassociatedwithDeductee(new Integer(
				AnnexIII94P_S16Count.size()).toString());
		}

		
		/*if (model3.getValueAt(i, 10) != null
				&& model3.getValueAt(i, 10).toString().length() != 0 
					&& anneIII94P.getMode() != null && anneIII94P.getMode().equalsIgnoreCase("A")){
			anneIII94P.setGrossTotalofTotalDeductionundersection16(model3
					.getValueAt(i, 10).toString());

		}*/
		
		if (model3.getValueAt(i, 8) != null && model3.getValueAt(i, 8).toString().length() != 0) {
			ded16IAAnne3 = Double.parseDouble(model3.getValueAt(i, 8).toString());
		}
		
		if (model3.getValueAt(i, 9) != null && model3.getValueAt(i, 9).toString().length() != 0) {
			ded16IIIAnne3 = Double.parseDouble(model3.getValueAt(i, 9).toString());
		}
		
		totalDed16Anne3 =  ded16IAAnne3 + ded16IIIAnne3;
		if (anneIII94P.getMode() != null && anneIII94P.getMode().equalsIgnoreCase("A")) {
		anneIII94P.setGrossTotalofTotalDeductionundersection16(Double.toString(totalDed16Anne3));
		}
		//P16 End	
		
		if (model3.getValueAt(i, 11) != null
				&& model3.getValueAt(i, 11).toString().length() != 0 
					&& anneIII94P.getMode() != null && anneIII94P.getMode().equalsIgnoreCase("A")){
			anneIII94P.setIncomeundertheheadSalaries(model3
					.getValueAt(i, 11).toString());

		}
		
		if (model3.getValueAt(i, 12) != null
				&& model3.getValueAt(i, 12).toString().length() != 0 
			&& anneIII94P.getMode() != null && anneIII94P.getMode().equalsIgnoreCase("A")){
			anneIII94P.setInterestIncomeundertheothersourcespaidbythespecifiedbank(model3
					.getValueAt(i, 12).toString());

		}
		
		if (model3.getValueAt(i, 13) != null
				&& model3.getValueAt(i, 13).toString().length() != 0
				&& anneIII94P.getMode() != null && anneIII94P.getMode().equalsIgnoreCase("A") || anneIII94P.getMode().equalsIgnoreCase("D")){
			anneIII94P.setGrossTotalIncome(model3
					.getValueAt(i, 13).toString());

		}
		
		if ( anneIII94P.getMode()
				.equalsIgnoreCase("P") || (anneIII94P.getMode() != null && "D".equalsIgnoreCase(anneIII94P.getMode()))
				) // Newly added for PAN UPDATE and C5
									// correction
		{
			anneIII94P.setLastGrossTotalIncome(model3.getValueAt(i, 13).toString());
		}
		
		if (anneIII94P.getMode() != null && anneIII94P.getMode().equalsIgnoreCase("A")){
		
		if (model3.getValueAt(i, 15) != null
				&& model3.getValueAt(i, 15).toString().length() != 0) {
			temp80C80CCCand80CCDAnne3 = Double.parseDouble(model3.getValueAt(
					i, 15).toString());
		}
		
		if (model3.getValueAt(i, 17) != null
				&& model3.getValueAt(i, 17).toString().length() != 0) {
			temp80C80CCCand80CCDAnne3 = temp80C80CCCand80CCDAnne3 + Double.parseDouble(model3.getValueAt(
					i, 17).toString());
		}
		
		if (model3.getValueAt(i, 19) != null
				&& model3.getValueAt(i, 19).toString().length() != 0) {
			temp80C80CCCand80CCDAnne3 = temp80C80CCCand80CCDAnne3 + Double.parseDouble(model3.getValueAt(
					i, 19).toString());
		}
		
		
		anneIII94P.setTotalDeductionus80C80CCCand80CCD1(Double.toString(temp80C80CCCand80CCDAnne3));
		
		}
		
		/*if (model3.getValueAt(i, 20) != null
				&& model3.getValueAt(i, 20).toString().length() != 0
			&& anneIII94P.getMode() != null && anneIII94P.getMode().equalsIgnoreCase("A")){
			anneIII94P.setTotalDeductionus80C80CCCand80CCD1(model3
					.getValueAt(i, 20).toString());

		}*/
		
		if (model3.getValueAt(i, 2).toString().equalsIgnoreCase("PAN UPDATE")) {
			anneIII94P.setMode(null);
		}
		
//////////////////////////////////////P6A Start/////////////////////////////////////////////////////////
		
int C6A_94P_Count = 0;


if (model3.getValueAt(i, 14) != null
&& model3.getValueAt(i, 14).toString().length() != 0
&& !model3.getValueAt(i, 14).toString().equalsIgnoreCase("0")
&& !model3.getValueAt(i, 14).toString().equalsIgnoreCase("0.0")
&& !model3.getValueAt(i, 14).toString()
				.equalsIgnoreCase("0.00") || (model3.getValueAt(i, 15) != null
				&& model3.getValueAt(i, 15).toString().length() != 0
				&& !model3.getValueAt(i, 15).toString().equalsIgnoreCase("0")
				&& !model3.getValueAt(i, 15).toString().equalsIgnoreCase("0.0")
				&& !model3.getValueAt(i, 15).toString()
								.equalsIgnoreCase("0.00")) && anneIII94P.getMode() != null && anneIII94P.getMode().equalsIgnoreCase("A")){

C6A_94P_Count++;
}



if (model3.getValueAt(i, 16) != null
&& model3.getValueAt(i, 16).toString().length() != 0
&& !model3.getValueAt(i, 16).toString().equalsIgnoreCase("0")
&& !model3.getValueAt(i, 16).toString().equalsIgnoreCase("0.0")
&& !model3.getValueAt(i, 16).toString()
				.equalsIgnoreCase("0.00") || (model3.getValueAt(i, 17) != null
						&& model3.getValueAt(i, 17).toString().length() != 0
						&& !model3.getValueAt(i, 17).toString().equalsIgnoreCase("0")
						&& !model3.getValueAt(i, 17).toString().equalsIgnoreCase("0.0")
						&& !model3.getValueAt(i, 17).toString()
										.equalsIgnoreCase("0.00"))&& anneIII94P.getMode() != null && anneIII94P.getMode().equalsIgnoreCase("A")){

C6A_94P_Count++;
}

if (model3.getValueAt(i, 18) != null
&& model3.getValueAt(i, 18).toString().length() != 0
&& !model3.getValueAt(i, 18).toString().equalsIgnoreCase("0")
&& !model3.getValueAt(i, 18).toString().equalsIgnoreCase("0.0")
&& !model3.getValueAt(i, 18).toString()
				.equalsIgnoreCase("0.00") || (model3.getValueAt(i, 19) != null
						&& model3.getValueAt(i, 19).toString().length() != 0
						&& !model3.getValueAt(i, 19).toString().equalsIgnoreCase("0")
						&& !model3.getValueAt(i, 19).toString().equalsIgnoreCase("0.0")
						&& !model3.getValueAt(i, 19).toString()
										.equalsIgnoreCase("0.00"))&& anneIII94P.getMode() != null && anneIII94P.getMode().equalsIgnoreCase("A")){

C6A_94P_Count++;
}


if (model3.getValueAt(i, 21) != null
&& model3.getValueAt(i, 21).toString().length() != 0
&& !model3.getValueAt(i, 21).toString().equalsIgnoreCase("0")
&& !model3.getValueAt(i, 21).toString().equalsIgnoreCase("0.0")
&& !model3.getValueAt(i, 21).toString()
				.equalsIgnoreCase("0.00") || (model3.getValueAt(i, 22) != null
						&& model3.getValueAt(i, 22).toString().length() != 0
						&& !model3.getValueAt(i, 22).toString().equalsIgnoreCase("0")
						&& !model3.getValueAt(i, 22).toString().equalsIgnoreCase("0.0")
						&& !model3.getValueAt(i, 22).toString()
										.equalsIgnoreCase("0.00"))&& anneIII94P.getMode() != null && anneIII94P.getMode().equalsIgnoreCase("A")){

C6A_94P_Count++;
}

if (model3.getValueAt(i, 23) != null
&& model3.getValueAt(i, 23).toString().length() != 0
&& !model3.getValueAt(i, 23).toString().equalsIgnoreCase("0")
&& !model3.getValueAt(i, 23).toString().equalsIgnoreCase("0.0")
&& !model3.getValueAt(i, 23).toString()
				.equalsIgnoreCase("0.00") || (model3.getValueAt(i, 24) != null
						&& model3.getValueAt(i, 24).toString().length() != 0
						&& !model3.getValueAt(i, 24).toString().equalsIgnoreCase("0")
						&& !model3.getValueAt(i, 24).toString().equalsIgnoreCase("0.0")
						&& !model3.getValueAt(i, 24).toString()
										.equalsIgnoreCase("0.00"))&& anneIII94P.getMode() != null && anneIII94P.getMode().equalsIgnoreCase("A")){

C6A_94P_Count++;
}

if (model3.getValueAt(i, 25) != null
&& model3.getValueAt(i, 25).toString().length() != 0
&& !model3.getValueAt(i, 25).toString().equalsIgnoreCase("0")
&& !model3.getValueAt(i, 25).toString().equalsIgnoreCase("0.0")
&& !model3.getValueAt(i, 25).toString()
				.equalsIgnoreCase("0.00") || (model3.getValueAt(i, 26) != null
						&& model3.getValueAt(i, 26).toString().length() != 0
						&& !model3.getValueAt(i, 26).toString().equalsIgnoreCase("0")
						&& !model3.getValueAt(i, 26).toString().equalsIgnoreCase("0.0")
						&& !model3.getValueAt(i, 26).toString()
										.equalsIgnoreCase("0.00"))&& anneIII94P.getMode() != null && anneIII94P.getMode().equalsIgnoreCase("A")){

C6A_94P_Count++;
}

if (model3.getValueAt(i, 27) != null
&& model3.getValueAt(i, 27).toString().length() != 0
&& !model3.getValueAt(i, 27).toString().equalsIgnoreCase("0")
&& !model3.getValueAt(i, 27).toString().equalsIgnoreCase("0.0")
&& !model3.getValueAt(i, 27).toString()
				.equalsIgnoreCase("0.00") || (model3.getValueAt(i, 28) != null
						&& model3.getValueAt(i, 28).toString().length() != 0
						&& !model3.getValueAt(i, 28).toString().equalsIgnoreCase("0")
						&& !model3.getValueAt(i, 28).toString().equalsIgnoreCase("0.0")
						&& !model3.getValueAt(i, 28).toString()
										.equalsIgnoreCase("0.00") || (model3.getValueAt(i, 29) != null
												&& model3.getValueAt(i, 29).toString().length() != 0
												&& !model3.getValueAt(i, 29).toString().equalsIgnoreCase("0")
												&& !model3.getValueAt(i, 29).toString().equalsIgnoreCase("0.0")
												&& !model3.getValueAt(i, 29).toString()
																.equalsIgnoreCase("0.00")))&& anneIII94P.getMode() != null && anneIII94P.getMode().equalsIgnoreCase("A")){

C6A_94P_Count++;
}

if (model3.getValueAt(i, 30) != null
&& model3.getValueAt(i, 30).toString().length() != 0
&& !model3.getValueAt(i, 30).toString().equalsIgnoreCase("0")
&& !model3.getValueAt(i, 30).toString().equalsIgnoreCase("0.0")
&& !model3.getValueAt(i, 30).toString()
				.equalsIgnoreCase("0.00") || (model3.getValueAt(i, 31) != null
						&& model3.getValueAt(i, 31).toString().length() != 0
						&& !model3.getValueAt(i, 31).toString().equalsIgnoreCase("0")
						&& !model3.getValueAt(i, 31).toString().equalsIgnoreCase("0.0")
						&& !model3.getValueAt(i, 31).toString()
										.equalsIgnoreCase("0.00") || (model3.getValueAt(i, 32) != null
												&& model3.getValueAt(i, 32).toString().length() != 0
												&& !model3.getValueAt(i, 32).toString().equalsIgnoreCase("0")
												&& !model3.getValueAt(i, 32).toString().equalsIgnoreCase("0.0")
												&& !model3.getValueAt(i, 32).toString()
																.equalsIgnoreCase("0.00")))&& anneIII94P.getMode() != null && anneIII94P.getMode().equalsIgnoreCase("A")){

C6A_94P_Count++;
}

if (model3.getValueAt(i, 33) != null
&& model3.getValueAt(i, 33).toString().length() != 0
&& !model3.getValueAt(i, 33).toString().equalsIgnoreCase("0")
&& !model3.getValueAt(i, 33).toString().equalsIgnoreCase("0.0")
&& !model3.getValueAt(i, 3).toString()
				.equalsIgnoreCase("0.00") || (model3.getValueAt(i, 34) != null
						&& model3.getValueAt(i, 34).toString().length() != 0
						&& !model3.getValueAt(i, 34).toString().equalsIgnoreCase("0")
						&& !model3.getValueAt(i, 34).toString().equalsIgnoreCase("0.0")
						&& !model3.getValueAt(i, 34).toString()
										.equalsIgnoreCase("0.00") || (model3.getValueAt(i, 35) != null
												&& model3.getValueAt(i, 35).toString().length() != 0
												&& !model3.getValueAt(i, 35).toString().equalsIgnoreCase("0")
												&& !model3.getValueAt(i, 35).toString().equalsIgnoreCase("0.0")
												&& !model3.getValueAt(i, 35).toString()
																.equalsIgnoreCase("0.00")))&& anneIII94P.getMode() != null && anneIII94P.getMode().equalsIgnoreCase("A")){

C6A_94P_Count++;
}


if (model3.getValueAt(i, 36) != null
&& model3.getValueAt(i, 36).toString().length() != 0
&& !model3.getValueAt(i, 36).toString().equalsIgnoreCase("0")
&& !model3.getValueAt(i, 36).toString().equalsIgnoreCase("0.0")
&& !model3.getValueAt(i, 36).toString()
				.equalsIgnoreCase("0.00") || (model3.getValueAt(i, 37) != null
						&& model3.getValueAt(i, 37).toString().length() != 0
						&& !model3.getValueAt(i, 37).toString().equalsIgnoreCase("0")
						&& !model3.getValueAt(i, 37).toString().equalsIgnoreCase("0.0")
						&& !model3.getValueAt(i, 37).toString()
										.equalsIgnoreCase("0.00") || (model3.getValueAt(i, 38) != null
												&& model3.getValueAt(i, 38).toString().length() != 0
												&& !model3.getValueAt(i, 38).toString().equalsIgnoreCase("0")
												&& !model3.getValueAt(i, 38).toString().equalsIgnoreCase("0.0")
												&& !model3.getValueAt(i, 38).toString()
																.equalsIgnoreCase("0.00")))&& anneIII94P.getMode() != null && anneIII94P.getMode().equalsIgnoreCase("A")){

C6A_94P_Count++;
}


if (model3.getValueAt(i, 39) != null
&& model3.getValueAt(i, 39).toString().length() != 0
&& !model3.getValueAt(i, 39).toString().equalsIgnoreCase("0")
&& !model3.getValueAt(i, 39).toString().equalsIgnoreCase("0.0")
&& !model3.getValueAt(i, 39).toString()
				.equalsIgnoreCase("0.00") || (model3.getValueAt(i, 40) != null
						&& model3.getValueAt(i, 40).toString().length() != 0
						&& !model3.getValueAt(i, 40).toString().equalsIgnoreCase("0")
						&& !model3.getValueAt(i, 40).toString().equalsIgnoreCase("0.0")
						&& !model3.getValueAt(i, 40).toString()
										.equalsIgnoreCase("0.00") || (model3.getValueAt(i, 40) != null
												&& model3.getValueAt(i, 40).toString().length() != 0
												&& !model3.getValueAt(i, 40).toString().equalsIgnoreCase("0")
												&& !model3.getValueAt(i, 40).toString().equalsIgnoreCase("0.0")
												&& !model3.getValueAt(i, 40).toString()
																.equalsIgnoreCase("0.00")))&& anneIII94P.getMode() != null && anneIII94P.getMode().equalsIgnoreCase("A")){

C6A_94P_Count++;
}

if (model3.getValueAt(i, 42) != null
&& model3.getValueAt(i, 42).toString().length() != 0
&& !model3.getValueAt(i, 42).toString().equalsIgnoreCase("0")
&& !model3.getValueAt(i, 42).toString().equalsIgnoreCase("0.0")
&& !model3.getValueAt(i, 42).toString()
				.equalsIgnoreCase("0.00") || (model3.getValueAt(i, 43) != null
						&& model3.getValueAt(i, 43).toString().length() != 0
						&& !model3.getValueAt(i, 43).toString().equalsIgnoreCase("0")
						&& !model3.getValueAt(i, 43).toString().equalsIgnoreCase("0.0")
						&& !model3.getValueAt(i, 43).toString()
										.equalsIgnoreCase("0.00") || (model3.getValueAt(i, 44) != null
												&& model3.getValueAt(i, 44).toString().length() != 0
												&& !model3.getValueAt(i, 44).toString().equalsIgnoreCase("0")
												&& !model3.getValueAt(i, 44).toString().equalsIgnoreCase("0.0")
												&& !model3.getValueAt(i, 44).toString()
																.equalsIgnoreCase("0.00")))&& anneIII94P.getMode() != null && anneIII94P.getMode().equalsIgnoreCase("A")){

C6A_94P_Count++;
}

if (model3.getValueAt(i, 45) != null
&& model3.getValueAt(i, 45).toString().length() != 0
&& !model3.getValueAt(i, 45).toString().equalsIgnoreCase("0")
&& !model3.getValueAt(i, 45).toString().equalsIgnoreCase("0.0")
&& !model3.getValueAt(i, 45).toString()
				.equalsIgnoreCase("0.00") || (model3.getValueAt(i, 46) != null
						&& model3.getValueAt(i, 46).toString().length() != 0
						&& !model3.getValueAt(i, 46).toString().equalsIgnoreCase("0")
						&& !model3.getValueAt(i, 46).toString().equalsIgnoreCase("0.0")
						&& !model3.getValueAt(i, 46).toString()
										.equalsIgnoreCase("0.00") || (model3.getValueAt(i, 47) != null
												&& model3.getValueAt(i, 47).toString().length() != 0
												&& !model3.getValueAt(i, 47).toString().equalsIgnoreCase("0")
												&& !model3.getValueAt(i, 47).toString().equalsIgnoreCase("0.0")
												&& !model3.getValueAt(i, 47).toString()
																.equalsIgnoreCase("0.00")))&& anneIII94P.getMode() != null && anneIII94P.getMode().equalsIgnoreCase("A")){

C6A_94P_Count++;
}

if (model3.getValueAt(i, 48) != null
&& model3.getValueAt(i, 48).toString().length() != 0
&& !model3.getValueAt(i, 48).toString().equalsIgnoreCase("0")
&& !model3.getValueAt(i, 48).toString().equalsIgnoreCase("0.0")
&& !model3.getValueAt(i, 48).toString()
				.equalsIgnoreCase("0.00") || (model3.getValueAt(i, 49) != null
						&& model3.getValueAt(i, 49).toString().length() != 0
						&& !model3.getValueAt(i, 49).toString().equalsIgnoreCase("0")
						&& !model3.getValueAt(i, 49).toString().equalsIgnoreCase("0.0")
						&& !model3.getValueAt(i, 49).toString()
										.equalsIgnoreCase("0.00") || (model3.getValueAt(i, 50) != null
												&& model3.getValueAt(i, 50).toString().length() != 0
												&& !model3.getValueAt(i, 50).toString().equalsIgnoreCase("0")
												&& !model3.getValueAt(i, 50).toString().equalsIgnoreCase("0.0")
												&& !model3.getValueAt(i, 50).toString()
																.equalsIgnoreCase("0.00")))&& anneIII94P.getMode() != null && anneIII94P.getMode().equalsIgnoreCase("A")){

C6A_94P_Count++;
}

if (model3.getValueAt(i, 51) != null
&& model3.getValueAt(i, 51).toString().length() != 0
&& !model3.getValueAt(i, 51).toString().equalsIgnoreCase("0")
&& !model3.getValueAt(i, 51).toString().equalsIgnoreCase("0.0")
&& !model3.getValueAt(i, 51).toString()
				.equalsIgnoreCase("0.00") || (model3.getValueAt(i, 52) != null
						&& model3.getValueAt(i, 52).toString().length() != 0
						&& !model3.getValueAt(i, 52).toString().equalsIgnoreCase("0")
						&& !model3.getValueAt(i, 52).toString().equalsIgnoreCase("0.0")
						&& !model3.getValueAt(i, 52).toString()
										.equalsIgnoreCase("0.00") || (model3.getValueAt(i, 53) != null
												&& model3.getValueAt(i, 53).toString().length() != 0
												&& !model3.getValueAt(i, 53).toString().equalsIgnoreCase("0")
												&& !model3.getValueAt(i, 53).toString().equalsIgnoreCase("0.0")
												&& !model3.getValueAt(i, 53).toString()
																.equalsIgnoreCase("0.00")))&& anneIII94P.getMode() != null && anneIII94P.getMode().equalsIgnoreCase("A")){

C6A_94P_Count++;
}

if (anneIII94P.getMode() != null && anneIII94P.getMode().equalsIgnoreCase("A")) {
	anneIII94P.setCountofSection194PChapterVIADetailsRecordsassociatedwithDeductee(""+C6A_94P_Count);
	}


if (model3.getValueAt(i, 14) != null
&& model3.getValueAt(i, 14).toString().length() != 0
&& !model3.getValueAt(i, 14).toString().equalsIgnoreCase("0")
&& !model3.getValueAt(i, 14).toString().equalsIgnoreCase("0.0")
&& !model3.getValueAt(i, 14).toString()
				.equalsIgnoreCase("0.00")&& anneIII94P.getMode() != null && anneIII94P.getMode().equalsIgnoreCase("A")){
AnnexIII_c6ACount.add(14);
}else
AnnexIII_c6ACount.add(0);

if (model3.getValueAt(i, 15) != null
&& model3.getValueAt(i, 15).toString().length() != 0
&& !model3.getValueAt(i, 15).toString().equalsIgnoreCase("0")
&& !model3.getValueAt(i, 15).toString().equalsIgnoreCase("0.0")
&& !model3.getValueAt(i, 15).toString()
				.equalsIgnoreCase("0.00")&& anneIII94P.getMode() != null && anneIII94P.getMode().equalsIgnoreCase("A")){
AnnexIII_c6ACount.add(15);
}else
AnnexIII_c6ACount.add(0);

if (model3.getValueAt(i, 16) != null
&& model3.getValueAt(i, 16).toString().length() != 0
&& !model3.getValueAt(i, 16).toString().equalsIgnoreCase("0")
&& !model3.getValueAt(i, 16).toString().equalsIgnoreCase("0.0")
&& !model3.getValueAt(i, 16).toString()
				.equalsIgnoreCase("0.00")&& anneIII94P.getMode() != null && anneIII94P.getMode().equalsIgnoreCase("A")){
AnnexIII_c6ACount.add(16);
}else
AnnexIII_c6ACount.add(0);

if (model3.getValueAt(i, 17) != null
&& model3.getValueAt(i, 17).toString().length() != 0
&& !model3.getValueAt(i, 17).toString().equalsIgnoreCase("0")
&& !model3.getValueAt(i, 17).toString().equalsIgnoreCase("0.0")
&& !model3.getValueAt(i, 17).toString()
				.equalsIgnoreCase("0.00")&& anneIII94P.getMode() != null && anneIII94P.getMode().equalsIgnoreCase("A")){
AnnexIII_c6ACount.add(17);
}else
AnnexIII_c6ACount.add(0);

if (model3.getValueAt(i, 18) != null
&& model3.getValueAt(i, 18).toString().length() != 0
&& !model3.getValueAt(i, 18).toString().equalsIgnoreCase("0")
&& !model3.getValueAt(i, 18).toString().equalsIgnoreCase("0.0")
&& !model3.getValueAt(i, 18).toString()
				.equalsIgnoreCase("0.00")&& anneIII94P.getMode() != null && anneIII94P.getMode().equalsIgnoreCase("A")){
AnnexIII_c6ACount.add(18);
}else
AnnexIII_c6ACount.add(0);

if (model3.getValueAt(i, 19) != null
&& model3.getValueAt(i, 19).toString().length() != 0
&& !model3.getValueAt(i, 19).toString().equalsIgnoreCase("0")
&& !model3.getValueAt(i, 19).toString().equalsIgnoreCase("0.0")
&& !model3.getValueAt(i, 19).toString()
				.equalsIgnoreCase("0.00")&& anneIII94P.getMode() != null && anneIII94P.getMode().equalsIgnoreCase("A")){
AnnexIII_c6ACount.add(19);
}else
AnnexIII_c6ACount.add(0);

if (model3.getValueAt(i, 21) != null
&& model3.getValueAt(i, 21).toString().length() != 0
&& !model3.getValueAt(i, 21).toString().equalsIgnoreCase("0")
&& !model3.getValueAt(i, 21).toString().equalsIgnoreCase("0.0")
&& !model3.getValueAt(i, 21).toString()
				.equalsIgnoreCase("0.00")&& anneIII94P.getMode() != null && anneIII94P.getMode().equalsIgnoreCase("A")){
AnnexIII_c6ACount.add(21);
}else
AnnexIII_c6ACount.add(0);

if (model3.getValueAt(i, 22) != null
&& model3.getValueAt(i, 22).toString().length() != 0
&& !model3.getValueAt(i, 22).toString().equalsIgnoreCase("0")
&& !model3.getValueAt(i, 22).toString().equalsIgnoreCase("0.0")
&& !model3.getValueAt(i, 22).toString()
				.equalsIgnoreCase("0.00")&& anneIII94P.getMode() != null && anneIII94P.getMode().equalsIgnoreCase("A")){
AnnexIII_c6ACount.add(22);
}else
AnnexIII_c6ACount.add(0);

if (model3.getValueAt(i, 23) != null
&& model3.getValueAt(i, 23).toString().length() != 0
&& !model3.getValueAt(i, 23).toString().equalsIgnoreCase("0")
&& !model3.getValueAt(i, 23).toString().equalsIgnoreCase("0.0")
&& !model3.getValueAt(i, 23).toString()
				.equalsIgnoreCase("0.00")&& anneIII94P.getMode() != null && anneIII94P.getMode().equalsIgnoreCase("A")){
AnnexIII_c6ACount.add(23);
}else
AnnexIII_c6ACount.add(0);

if (model3.getValueAt(i, 24) != null
&& model3.getValueAt(i, 24).toString().length() != 0
&& !model3.getValueAt(i, 24).toString().equalsIgnoreCase("0")
&& !model3.getValueAt(i, 24).toString().equalsIgnoreCase("0.0")
&& !model3.getValueAt(i, 24).toString()
				.equalsIgnoreCase("0.00")&& anneIII94P.getMode() != null && anneIII94P.getMode().equalsIgnoreCase("A")){
AnnexIII_c6ACount.add(24);
}else
AnnexIII_c6ACount.add(0);

if (model3.getValueAt(i, 25) != null
&& model3.getValueAt(i, 25).toString().length() != 0
&& !model3.getValueAt(i, 25).toString().equalsIgnoreCase("0")
&& !model3.getValueAt(i, 25).toString().equalsIgnoreCase("0.0")
&& !model3.getValueAt(i, 25).toString()
				.equalsIgnoreCase("0.00")&& anneIII94P.getMode() != null && anneIII94P.getMode().equalsIgnoreCase("A")){
AnnexIII_c6ACount.add(25);
}else
AnnexIII_c6ACount.add(0);

if (model3.getValueAt(i, 26) != null
&& model3.getValueAt(i, 26).toString().length() != 0
&& !model3.getValueAt(i, 26).toString().equalsIgnoreCase("0")
&& !model3.getValueAt(i, 26).toString().equalsIgnoreCase("0.0")
&& !model3.getValueAt(i, 26).toString()
				.equalsIgnoreCase("0.00")&& anneIII94P.getMode() != null && anneIII94P.getMode().equalsIgnoreCase("A")){
AnnexIII_c6ACount.add(26);
}else
AnnexIII_c6ACount.add(0);

if (model3.getValueAt(i, 27) != null
&& model3.getValueAt(i, 27).toString().length() != 0
&& !model3.getValueAt(i, 27).toString().equalsIgnoreCase("0")
&& !model3.getValueAt(i, 27).toString().equalsIgnoreCase("0.0")
&& !model3.getValueAt(i, 27).toString()
				.equalsIgnoreCase("0.00")&& anneIII94P.getMode() != null && anneIII94P.getMode().equalsIgnoreCase("A")){
AnnexIII_c6ACount.add(27);
}else
AnnexIII_c6ACount.add(0);

if (model3.getValueAt(i, 28) != null
&& model3.getValueAt(i, 28).toString().length() != 0
&& !model3.getValueAt(i, 28).toString().equalsIgnoreCase("0")
&& !model3.getValueAt(i, 28).toString().equalsIgnoreCase("0.0")
&& !model3.getValueAt(i, 28).toString()
				.equalsIgnoreCase("0.00")&& anneIII94P.getMode() != null && anneIII94P.getMode().equalsIgnoreCase("A")){
AnnexIII_c6ACount.add(28);
}else
AnnexIII_c6ACount.add(0);

if (model3.getValueAt(i, 29) != null
&& model3.getValueAt(i, 29).toString().length() != 0
&& !model3.getValueAt(i, 29).toString().equalsIgnoreCase("0")
&& !model3.getValueAt(i, 29).toString().equalsIgnoreCase("0.0")
&& !model3.getValueAt(i, 29).toString()
				.equalsIgnoreCase("0.00")&& anneIII94P.getMode() != null && anneIII94P.getMode().equalsIgnoreCase("A")){
AnnexIII_c6ACount.add(29);
}else
AnnexIII_c6ACount.add(0);

if (model3.getValueAt(i, 30) != null
&& model3.getValueAt(i, 30).toString().length() != 0
&& !model3.getValueAt(i, 30).toString().equalsIgnoreCase("0")
&& !model3.getValueAt(i, 30).toString().equalsIgnoreCase("0.0")
&& !model3.getValueAt(i, 30).toString()
				.equalsIgnoreCase("0.00")&& anneIII94P.getMode() != null && anneIII94P.getMode().equalsIgnoreCase("A")){
AnnexIII_c6ACount.add(30);
}else
AnnexIII_c6ACount.add(0);

if (model3.getValueAt(i, 31) != null
&& model3.getValueAt(i, 31).toString().length() != 0
&& !model3.getValueAt(i, 31).toString().equalsIgnoreCase("0")
&& !model3.getValueAt(i, 31).toString().equalsIgnoreCase("0.0")
&& !model3.getValueAt(i, 31).toString()
				.equalsIgnoreCase("0.00")&& anneIII94P.getMode() != null && anneIII94P.getMode().equalsIgnoreCase("A")){
AnnexIII_c6ACount.add(31);
}else
AnnexIII_c6ACount.add(0);

if (model3.getValueAt(i, 32) != null
&& model3.getValueAt(i, 32).toString().length() != 0
&& !model3.getValueAt(i, 32).toString().equalsIgnoreCase("0")
&& !model3.getValueAt(i, 32).toString().equalsIgnoreCase("0.0")
&& !model3.getValueAt(i, 32).toString()
				.equalsIgnoreCase("0.00")&& anneIII94P.getMode() != null && anneIII94P.getMode().equalsIgnoreCase("A")){
AnnexIII_c6ACount.add(32);
}else
AnnexIII_c6ACount.add(0);

if (model3.getValueAt(i, 33) != null
&& model3.getValueAt(i, 33).toString().length() != 0
&& !model3.getValueAt(i, 33).toString().equalsIgnoreCase("0")
&& !model3.getValueAt(i, 33).toString().equalsIgnoreCase("0.0")
&& !model3.getValueAt(i, 3).toString()
				.equalsIgnoreCase("0.00")&& anneIII94P.getMode() != null && anneIII94P.getMode().equalsIgnoreCase("A")){
AnnexIII_c6ACount.add(33);
}else
AnnexIII_c6ACount.add(0);

if (model3.getValueAt(i, 34) != null
&& model3.getValueAt(i, 34).toString().length() != 0
&& !model3.getValueAt(i, 34).toString().equalsIgnoreCase("0")
&& !model3.getValueAt(i, 34).toString().equalsIgnoreCase("0.0")
&& !model3.getValueAt(i, 34).toString()
				.equalsIgnoreCase("0.00")&& anneIII94P.getMode() != null && anneIII94P.getMode().equalsIgnoreCase("A")){
AnnexIII_c6ACount.add(34);
}else
AnnexIII_c6ACount.add(0);

if (model3.getValueAt(i, 35) != null
&& model3.getValueAt(i, 35).toString().length() != 0
&& !model3.getValueAt(i, 35).toString().equalsIgnoreCase("0")
&& !model3.getValueAt(i, 35).toString().equalsIgnoreCase("0.0")
&& !model3.getValueAt(i, 35).toString()
				.equalsIgnoreCase("0.00")&& anneIII94P.getMode() != null && anneIII94P.getMode().equalsIgnoreCase("A")){
AnnexIII_c6ACount.add(35);
}else
AnnexIII_c6ACount.add(0);

if (model3.getValueAt(i, 36) != null
&& model3.getValueAt(i, 36).toString().length() != 0
&& !model3.getValueAt(i, 36).toString().equalsIgnoreCase("0")
&& !model3.getValueAt(i, 36).toString().equalsIgnoreCase("0.0")
&& !model3.getValueAt(i, 36).toString()
				.equalsIgnoreCase("0.00")&& anneIII94P.getMode() != null && anneIII94P.getMode().equalsIgnoreCase("A")){
AnnexIII_c6ACount.add(36);
}else
AnnexIII_c6ACount.add(0);

if (model3.getValueAt(i, 37) != null
&& model3.getValueAt(i, 37).toString().length() != 0
&& !model3.getValueAt(i, 37).toString().equalsIgnoreCase("0")
&& !model3.getValueAt(i, 37).toString().equalsIgnoreCase("0.0")
&& !model3.getValueAt(i, 37).toString()
				.equalsIgnoreCase("0.00")&& anneIII94P.getMode() != null && anneIII94P.getMode().equalsIgnoreCase("A")){
AnnexIII_c6ACount.add(37);
}else
AnnexIII_c6ACount.add(0);

if (model3.getValueAt(i, 38) != null
&& model3.getValueAt(i, 38).toString().length() != 0
&& !model3.getValueAt(i, 38).toString().equalsIgnoreCase("0")
&& !model3.getValueAt(i, 38).toString().equalsIgnoreCase("0.0")
&& !model3.getValueAt(i, 38).toString()
				.equalsIgnoreCase("0.00")&& anneIII94P.getMode() != null && anneIII94P.getMode().equalsIgnoreCase("A")){
AnnexIII_c6ACount.add(38);
}else
AnnexIII_c6ACount.add(0);

if (model3.getValueAt(i, 39) != null
&& model3.getValueAt(i, 39).toString().length() != 0
&& !model3.getValueAt(i, 39).toString().equalsIgnoreCase("0")
&& !model3.getValueAt(i, 39).toString().equalsIgnoreCase("0.0")
&& !model3.getValueAt(i, 39).toString()
				.equalsIgnoreCase("0.00")&& anneIII94P.getMode() != null && anneIII94P.getMode().equalsIgnoreCase("A")){
AnnexIII_c6ACount.add(39);
}else
AnnexIII_c6ACount.add(0);

if (model3.getValueAt(i, 40) != null
&& model3.getValueAt(i, 40).toString().length() != 0
&& !model3.getValueAt(i, 40).toString().equalsIgnoreCase("0")
&& !model3.getValueAt(i, 40).toString().equalsIgnoreCase("0.0")
&& !model3.getValueAt(i, 40).toString()
				.equalsIgnoreCase("0.00")&& anneIII94P.getMode() != null && anneIII94P.getMode().equalsIgnoreCase("A")){
AnnexIII_c6ACount.add(40);
}else
AnnexIII_c6ACount.add(0);

if (model3.getValueAt(i, 41) != null
&& model3.getValueAt(i, 41).toString().length() != 0
&& !model3.getValueAt(i, 41).toString().equalsIgnoreCase("0")
&& !model3.getValueAt(i, 41).toString().equalsIgnoreCase("0.0")
&& !model3.getValueAt(i, 41).toString()
				.equalsIgnoreCase("0.00")&& anneIII94P.getMode() != null && anneIII94P.getMode().equalsIgnoreCase("A")){
AnnexIII_c6ACount.add(41);
}else
AnnexIII_c6ACount.add(0);

if (model3.getValueAt(i, 42) != null
&& model3.getValueAt(i, 42).toString().length() != 0
&& !model3.getValueAt(i, 42).toString().equalsIgnoreCase("0")
&& !model3.getValueAt(i, 42).toString().equalsIgnoreCase("0.0")
&& !model3.getValueAt(i, 42).toString()
				.equalsIgnoreCase("0.00")&& anneIII94P.getMode() != null && anneIII94P.getMode().equalsIgnoreCase("A")){
AnnexIII_c6ACount.add(42);
}else
AnnexIII_c6ACount.add(0);

if (model3.getValueAt(i, 43) != null
&& model3.getValueAt(i, 43).toString().length() != 0
&& !model3.getValueAt(i, 43).toString().equalsIgnoreCase("0")
&& !model3.getValueAt(i, 43).toString().equalsIgnoreCase("0.0")
&& !model3.getValueAt(i, 43).toString()
				.equalsIgnoreCase("0.00")&& anneIII94P.getMode() != null && anneIII94P.getMode().equalsIgnoreCase("A")){
AnnexIII_c6ACount.add(43);
}else
AnnexIII_c6ACount.add(0);

if (model3.getValueAt(i, 44) != null
&& model3.getValueAt(i, 44).toString().length() != 0
&& !model3.getValueAt(i, 44).toString().equalsIgnoreCase("0")
&& !model3.getValueAt(i, 44).toString().equalsIgnoreCase("0.0")
&& !model3.getValueAt(i, 44).toString()
				.equalsIgnoreCase("0.00")&& anneIII94P.getMode() != null && anneIII94P.getMode().equalsIgnoreCase("A")){
AnnexIII_c6ACount.add(44);
}else
AnnexIII_c6ACount.add(0);

if (model3.getValueAt(i, 45) != null
&& model3.getValueAt(i, 45).toString().length() != 0
&& !model3.getValueAt(i, 45).toString().equalsIgnoreCase("0")
&& !model3.getValueAt(i, 45).toString().equalsIgnoreCase("0.0")
&& !model3.getValueAt(i, 45).toString()
				.equalsIgnoreCase("0.00")&& anneIII94P.getMode() != null && anneIII94P.getMode().equalsIgnoreCase("A")){
AnnexIII_c6ACount.add(45);
}else
AnnexIII_c6ACount.add(0);

if (model3.getValueAt(i, 46) != null
&& model3.getValueAt(i, 46).toString().length() != 0
&& !model3.getValueAt(i, 46).toString().equalsIgnoreCase("0")
&& !model3.getValueAt(i, 46).toString().equalsIgnoreCase("0.0")
&& !model3.getValueAt(i, 46).toString()
				.equalsIgnoreCase("0.00")&& anneIII94P.getMode() != null && anneIII94P.getMode().equalsIgnoreCase("A")){
AnnexIII_c6ACount.add(46);
}else
AnnexIII_c6ACount.add(0);

if (model3.getValueAt(i, 47) != null
&& model3.getValueAt(i, 47).toString().length() != 0
&& !model3.getValueAt(i, 47).toString().equalsIgnoreCase("0")
&& !model3.getValueAt(i, 47).toString().equalsIgnoreCase("0.0")
&& !model3.getValueAt(i, 47).toString()
				.equalsIgnoreCase("0.00")&& anneIII94P.getMode() != null && anneIII94P.getMode().equalsIgnoreCase("A")){
AnnexIII_c6ACount.add(47);
}else
AnnexIII_c6ACount.add(0);

if (model3.getValueAt(i, 48) != null
&& model3.getValueAt(i, 48).toString().length() != 0
&& !model3.getValueAt(i, 48).toString().equalsIgnoreCase("0")
&& !model3.getValueAt(i, 48).toString().equalsIgnoreCase("0.0")
&& !model3.getValueAt(i, 48).toString()
				.equalsIgnoreCase("0.00")&& anneIII94P.getMode() != null && anneIII94P.getMode().equalsIgnoreCase("A")){
AnnexIII_c6ACount.add(48);
}else
AnnexIII_c6ACount.add(0);

if (model3.getValueAt(i, 49) != null
&& model3.getValueAt(i, 49).toString().length() != 0
&& !model3.getValueAt(i, 49).toString().equalsIgnoreCase("0")
&& !model3.getValueAt(i, 49).toString().equalsIgnoreCase("0.0")
&& !model3.getValueAt(i, 49).toString()
				.equalsIgnoreCase("0.00")&& anneIII94P.getMode() != null && anneIII94P.getMode().equalsIgnoreCase("A")){
AnnexIII_c6ACount.add(49);
}else
AnnexIII_c6ACount.add(0);

if (model3.getValueAt(i, 50) != null
&& model3.getValueAt(i, 50).toString().length() != 0
&& !model3.getValueAt(i, 50).toString().equalsIgnoreCase("0")
&& !model3.getValueAt(i, 50).toString().equalsIgnoreCase("0.0")
&& !model3.getValueAt(i, 50).toString()
				.equalsIgnoreCase("0.00")&& anneIII94P.getMode() != null && anneIII94P.getMode().equalsIgnoreCase("A")){
AnnexIII_c6ACount.add(50);
}else
AnnexIII_c6ACount.add(0);

if (model3.getValueAt(i, 51) != null
&& model3.getValueAt(i, 51).toString().length() != 0
&& !model3.getValueAt(i, 51).toString().equalsIgnoreCase("0")
&& !model3.getValueAt(i, 51).toString().equalsIgnoreCase("0.0")
&& !model3.getValueAt(i, 51).toString()
				.equalsIgnoreCase("0.00")&& anneIII94P.getMode() != null && anneIII94P.getMode().equalsIgnoreCase("A")){
AnnexIII_c6ACount.add(51);
}else
AnnexIII_c6ACount.add(0);

if (model3.getValueAt(i, 52) != null
&& model3.getValueAt(i, 52).toString().length() != 0
&& !model3.getValueAt(i, 52).toString().equalsIgnoreCase("0")
&& !model3.getValueAt(i, 52).toString().equalsIgnoreCase("0.0")
&& !model3.getValueAt(i, 52).toString()
				.equalsIgnoreCase("0.00")&& anneIII94P.getMode() != null && anneIII94P.getMode().equalsIgnoreCase("A")){
AnnexIII_c6ACount.add(52);
}else
AnnexIII_c6ACount.add(0);

if (model3.getValueAt(i, 53) != null
&& model3.getValueAt(i, 53).toString().length() != 0
&& !model3.getValueAt(i, 53).toString().equalsIgnoreCase("0")
&& !model3.getValueAt(i, 53).toString().equalsIgnoreCase("0.0")
&& !model3.getValueAt(i, 53).toString()
				.equalsIgnoreCase("0.00")&& anneIII94P.getMode() != null && anneIII94P.getMode().equalsIgnoreCase("A")){
AnnexIII_c6ACount.add(53);
}else
AnnexIII_c6ACount.add(0);



if (model3.getValueAt(i, 54) != null
&& model3.getValueAt(i, 54).toString().length() != 0
		&& anneIII94P.getMode() != null && anneIII94P.getMode().equalsIgnoreCase("A")){
anneIII94P.setAggregateofdeductibleamountunderChapterVIAunderassociatedSection194P(model3
	.getValueAt(i, 54).toString());
}
else {
	if (anneIII94P.getMode() != null && anneIII94P.getMode().equalsIgnoreCase("A"))
	{
		anneIII94P.setAggregateofdeductibleamountunderChapterVIAunderassociatedSection194P("0.00");
	}
}

/*if (model3.getValueAt(i, 54) == ""
&& model3.getValueAt(i, 54).toString().length() == 0
		&& anneIII94P.getMode() != null && anneIII94P.getMode().equalsIgnoreCase("A")){
anneIII94P.setAggregateofdeductibleamountunderChapterVIAunderassociatedSection194P("0.00");
}*/

//////////////////////////////////////P6A End/////////////////////////////////////////////////////////	
         
			if (model3.getValueAt(i, 55) != null
					&& model3.getValueAt(i, 55).toString().length() != 0
							&& anneIII94P.getMode() != null && anneIII94P.getMode().equalsIgnoreCase("A")){
				anneIII94P.setTotaltaxableincome(model3
						.getValueAt(i, 55).toString());

			}	
			
			if (model3.getValueAt(i, 56) != null
					&& model3.getValueAt(i, 56).toString().length() != 0
							&& anneIII94P.getMode() != null && anneIII94P.getMode().equalsIgnoreCase("A")){
				anneIII94P.setTaxontotalincome(model3
						.getValueAt(i, 56).toString());

			}	
			
			if (model3.getValueAt(i, 57) != null
					&& model3.getValueAt(i, 57).toString().length() != 0
							&& anneIII94P.getMode() != null && anneIII94P.getMode().equalsIgnoreCase("A")){
				anneIII94P.setRebateundersection87A(model3
						.getValueAt(i, 57).toString());

			}	
			
			if (model3.getValueAt(i, 58) != null
					&& model3.getValueAt(i, 58).toString().length() != 0
							&& anneIII94P.getMode() != null && anneIII94P.getMode().equalsIgnoreCase("A")){
				anneIII94P.setSurcharge(model3
						.getValueAt(i, 58).toString());

			}
			
			if (model3.getValueAt(i, 59) != null
					&& model3.getValueAt(i, 59).toString().length() != 0
							&& anneIII94P.getMode() != null && anneIII94P.getMode().equalsIgnoreCase("A")){
				anneIII94P.setHealthandeducationcess(model3
						.getValueAt(i, 59).toString());

			}
			
			if (model3.getValueAt(i, 60) != null
					&& model3.getValueAt(i, 60).toString().length() != 0
							&& anneIII94P.getMode() != null && anneIII94P.getMode().equalsIgnoreCase("A")){
				anneIII94P.setTaxPayable(model3
						.getValueAt(i, 60).toString());

			}
			
			if (model3.getValueAt(i, 61) != null
					&& model3.getValueAt(i, 61).toString().length() != 0
							&& anneIII94P.getMode() != null && anneIII94P.getMode().equalsIgnoreCase("A")){
				anneIII94P.setReliefundersection89(model3
						.getValueAt(i, 61).toString());

			}
			
			if (model3.getValueAt(i, 62) != null
					&& model3.getValueAt(i, 62).toString().length() != 0
							&& anneIII94P.getMode() != null && anneIII94P.getMode().equalsIgnoreCase("A")){
				anneIII94P.setNettaxPayable(model3
						.getValueAt(i, 62).toString());

			}
			
			return anneIII94P;

	}

	/*
	 * =================================================================Below
	 * are Utilities for Appenders===========================================
	 */

	/**
	 * Utility for Appenders
	 * @param str
	 * @param findStr
	 * @return
	 */
	public Integer CountOccurence(String str, String findStr) {
		int count = 0;
		// String findStr = "\n";
		int lastIndex = 0;

		while (lastIndex != -1) {

			lastIndex = str.indexOf(findStr, lastIndex);

			if (lastIndex != -1) {
				count++;
				lastIndex += findStr.length();
			}
		}

		if (!findStr.contains("BH")) {
			count = count + 1; // added to make it next line
		}

		return (new Integer(count));
	}

	/**
	 * Utility for Appenders
	 * @return
	 */
	public String GenerateSequence() {
		//DateTimeFormatter dtf = DateTimeFormatter.ofPattern("ddMMyyyyHHmmss");
	    //LocalDateTime local =LocalDateTime.now();
	    //String sequence = dtf.format(local);
		String sequence = new SimpleDateFormat("ddMMyyyyHHmmss",Locale.ENGLISH).format(new Date()).toString();

		return sequence;
	}

	/**
	 * Utility for Appenders
	 * @param deducteecount
	 * @param position
	 * @return
	 */
	public ArrayList<Integer> deducteeDetails(int deducteecount,
			Integer position) {
		ArrayList<Integer> li = new ArrayList<Integer>();
		deducteecount++;

		for (int i = 2; i <= deducteecount; i++) {
			if (model1.getValueAt(i, 1) != null
					&& !(model1.getValueAt(i, 1).toString().equals(""))) {
				if (model1.getValueAt(i, 1).toString()
						.equals(position.toString())) {
					li.add(i);
				}
			}
		}

		return li;

	}

	
	
	
	
	

}
