/**
 * Author: Akansha Rajesh (711397)
 * Created For: New columns added to Form 27Q --> Address of Deductee ( Country of Residence)
 * Date: 11/07/2016
 */
package com.tin.etbaf.annexure1;

import java.awt.Component;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.util.EventObject;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import javax.swing.AbstractCellEditor;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.TableCellEditor;

import com.tin.etbaf.rpu.Chk_LengthOnly;
import com.tin.etbaf.rpu.GRPU;
import com.tin.etbaf.rpu.GrpuUtil;

public class GRPUTableCellEditorAddofDedCountryResidence extends
		AbstractCellEditor implements TableCellEditor {

	JComponent component;
	int rowTable;
	int colTable;
	//newly added for FRD1.6 by akansha
	private String validateAlpha = "^[a-zA-Z0-9 /*/&/%/$/!@#/(/)/{/}/:/;/</>/,/./_/+=?/|\\\\/`\\]\\[\\-\\\"\\\'/~]+$";

	public GRPUTableCellEditorAddofDedCountryResidence() {

		component = new JTextField();
		component.addFocusListener(new FocusListener() {

			@Override
			public void focusLost(FocusEvent arg0) {
				JButton eventOwner;
				if (arg0.getOppositeComponent() instanceof JButton) {
					eventOwner = (JButton) arg0.getOppositeComponent();
					if ("Create File".equalsIgnoreCase(eventOwner.getText()
							.trim())) {
						GRPU.grpu.isCreateFileFocusOut = true;
					}
				} else {
					GRPU.grpu.isCreateFileFocusOut = false;
				}
			}

			@Override
			public void focusGained(FocusEvent arg0) {
				// TODO Auto-generated method stub

			}
		});
		rowTable = 0;
		colTable = 0;

	}

	@Override
	public Object getCellEditorValue() {
		
		
		Object value = ((JTextField) component).getText();
		
		//newly added for FRD1.6 by akansha
				Pattern pt1 = Pattern.compile(validateAlpha);
				Matcher mh1 = pt1.matcher(value.toString());
				boolean matchFound1 = mh1.matches();
				
				//********************************************
		
		if (((JTextField) component).getText().toString().trim().length() > 150) {
			GRPU.grpu
					.getMessage("<html>Length of Address of deductee in country of residence <br>should be less than or equal to 150 characters</html>");
			GRPU.grpu.setErrorAt(rowTable, colTable);
			return "";
		}
		if (((JTextField) component).getText().toString().trim().length() == 0) {
			GRPU.grpu.getMessage("<html>Invalid value. Please provide valid value under field <br>Address of deductee in country of residence</html>");
			GRPU.grpu.setErrorAt(rowTable, colTable);
			return "";
		}
		/*if (!GrpuUtil.checkOneAlpah(value.toString())) {
			String message = "Special Characters not Allowed in Address of deductee in country of residence";
			GRPU.grpu.getMessage(message);
			GRPU.grpu.setErrorAt(rowTable, colTable);
			return "";

		}*/
		if (!(matchFound1)) {
			String message = "<html>Invalid value. Please provide valid value under field <br>Address of deductee in country of residence</html>";
			GRPU.grpu.getMessage(message);
			GRPU.grpu.setErrorAt(rowTable, colTable);
			return "";
		}
		
		/*int posCaret = value.toString().trim().indexOf("^");
		if (posCaret != -1) {
			GRPU.grpu.getMessage("Special Character : '^' Not Allowed");
			String strRmCaret = value.toString().trim().substring(0, posCaret);
			((JTextField) component).setText(strRmCaret);
		}*/
		GRPU.grpu.setNoErrorAt(rowTable, colTable);
		return ((JTextField) component).getText().toUpperCase();
	}

	@Override
	public Component getTableCellEditorComponent(JTable table, Object value,
			boolean isSelected, int rowIndex, int vColIndex) {
		((JTextField) component).setDocument(new Chk_LengthOnly(150));
		if (value == null)
			((JTextField) component).setText("");
		else
			((JTextField) component).setText((String) value);
		rowTable = rowIndex;
		colTable = vColIndex;
		return component;
	}

	public boolean isCellEditable(EventObject evt) {
		if (evt instanceof MouseEvent) {
			int clickCount = 2;
			return ((MouseEvent) evt).getClickCount() >= clickCount;
		} else {
			return true;
		}
	}
}
