package com.tin.etbaf.annexure1;

import java.awt.Component;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.util.EventObject;
import javax.swing.*;
import javax.swing.table.TableCellEditor;
import javax.swing.text.JTextComponent;

import com.tin.etbaf.rpu.Chk_LengthOnly;
import com.tin.etbaf.rpu.GRPU;
import com.tin.etbaf.rpu.GrpuUtil;

// Referenced classes of package com.tin.etbaf.rpu:
//            Chk_LengthOnly, GRPU

public class GRPUTableCellEditorBSRCd extends AbstractCellEditor
    implements TableCellEditor
{

    JComponent component;
    int rowTable;
    int colTable;

    public GRPUTableCellEditorBSRCd()
    {
        component = new JTextField();
 component.addFocusListener(new FocusListener() {
			
			@Override
			public void focusLost(FocusEvent arg0) {
				JButton eventOwner;
				if(arg0.getOppositeComponent() instanceof JButton)
				{
					eventOwner =  (JButton) arg0.getOppositeComponent();
					if("Create File".equalsIgnoreCase(eventOwner.getText().trim()) ){
						GRPU.grpu.isCreateFileFocusOut = true;
					}					
				}
				else{
					GRPU.grpu.isCreateFileFocusOut = false;
				}
			}
			
			@Override
			public void focusGained(FocusEvent arg0) {
				// TODO Auto-generated method stub
				
			}
		});
        rowTable = 0;
        colTable = 0;
    }

    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int rowIndex, int vColIndex)
    {
        ((JTextField)component).setDocument(new Chk_LengthOnly(25));
        if(value == null)
            ((JTextField)component).setText("");
        else
            ((JTextField)component).setText((String)value);
        rowTable = rowIndex;
        colTable = vColIndex;
        return component;
    }

    public Object getCellEditorValue()
    {
        Object value = ((JTextField)component).getText();
        if(((JTextField)component).getText().toString().trim().length() > 25)
        {
            GRPU.grpu.getMessage("Length of Address Line 1 should be less than or equal to 25 characters");
            GRPU.grpu.setErrorAt(rowTable, colTable);
            return "";
        }
        if(((JTextField)component).getText().toString().trim().length() == 0)
        {
            GRPU.grpu.getMessage("Address Line 1 is Mandatory bhai");
            GRPU.grpu.setErrorAt(rowTable, colTable);
            return "";
        }
        if(!GrpuUtil.checkOneAlpah(value.toString()))
        {
        	String message = "Special Characters not Allowed in Address Line 1";
        	GRPU.grpu.getMessage(message);
        	 GRPU.grpu.setErrorAt(rowTable, colTable);
             return "";
        	
        }
        int posCaret = value.toString().trim().indexOf("^");
        if(posCaret != -1)
        {
            GRPU.grpu.getMessage("Special Character : '^' Not Allowed");
            String strRmCaret = value.toString().trim().substring(0, posCaret);
            ((JTextField)component).setText(strRmCaret);
        }
        GRPU.grpu.setNoErrorAt(rowTable, colTable);
        return ((JTextField)component).getText();
    }

    public boolean isCellEditable(EventObject evt)
    {
        if(evt instanceof MouseEvent)
        {
            int clickCount = 2;
            return ((MouseEvent)evt).getClickCount() >= clickCount;
        } else
        {
            return true;
        }
    }
}

