package com.tin.etbaf.annexure1;

import java.awt.Component;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.util.EventObject;
import javax.swing.*;
import javax.swing.table.TableCellEditor;
import javax.swing.text.JTextComponent;

import com.tin.etbaf.rpu.Chk_LengthOnly;
import com.tin.etbaf.rpu.GRPU;
import com.tin.etbaf.rpu.GrpuUtil;

// Referenced classes of package com.tin.etbaf.rpu:
//            Chk_LengthOnly, GRPU

public class GRPUTableCellEditorEmpRefNum extends AbstractCellEditor implements
		TableCellEditor {

	JComponent component;
	int rowTable;
	int colTable;
	String formNumber;

	public GRPUTableCellEditorEmpRefNum(String formNumber) {
		component = new JTextField();
		 component.addFocusListener(new FocusListener() {
				
				@Override
				public void focusLost(FocusEvent arg0) {
					JButton eventOwner;
					if(arg0.getOppositeComponent() instanceof JButton)
					{
						eventOwner =  (JButton) arg0.getOppositeComponent();
						if("Create File".equalsIgnoreCase(eventOwner.getText().trim()) ){
							GRPU.grpu.isCreateFileFocusOut = true;
						}					
					}
					else{
						GRPU.grpu.isCreateFileFocusOut = false;
					}
				}
				
				@Override
				public void focusGained(FocusEvent arg0) {
					// TODO Auto-generated method stub
					
				}
			});
		rowTable = 0;
		colTable = 0;
		this.formNumber = formNumber;
	}

	public Component getTableCellEditorComponent(JTable table, Object value,
			boolean isSelected, int rowIndex, int vColIndex) {
		if (formNumber.equals("24Q"))
			((JTextField) component).setDocument(new Chk_LengthOnly(9));
		else
			((JTextField) component).setDocument(new Chk_LengthOnly(10));

		if (value == null)
			((JTextField) component).setText("");
		else
			((JTextField) component).setText((String) value);
		rowTable = rowIndex;
		colTable = vColIndex;
		return component;
	}

	public Object getCellEditorValue() {
		Object value = ((JTextField) component).getText();
		if (!((JTextField) component).getText().equals(""))

		{
			if (formNumber.equals("24Q")) {

				// New Development as on 01/04/2015 depicted with '#'
				if (((JTextField) component).getText().toString().trim()
						.length() <= 10) // ####
				{
					if (!GrpuUtil.checkOneAlpah(((JTextField) component).getText()
							.toString().trim())) { //## changed from isInt to checkOneAlpha

						GRPU.grpu
								.getMessage("Employe Reference Number for Form 24Q should be numeric only");
						GRPU.grpu.setErrorAt(rowTable, colTable);
						return "";
					} else {
						GRPU.grpu.setNoErrorAt(rowTable, colTable);
						return ((JTextField) component).getText().trim();
					}

				}

				else {
					GRPU.grpu
							.getMessage("Length of Employe Reference Number for Form 24Q  should not exceed 10 digits");
					GRPU.grpu.setErrorAt(rowTable, colTable);
					return "";

				}

			}

			else {
				if (((JTextField) component).getText().toString().trim()
						.length() <= 10) {
					if (!GrpuUtil.checkOneAlpah(((JTextField) component)
							.getText().toString().trim())) {

						GRPU.grpu
								.getMessage("Employe Reference Number can't have special characters");
						GRPU.grpu.setErrorAt(rowTable, colTable);
						return "";
					} else {
						GRPU.grpu.setNoErrorAt(rowTable, colTable);
						return ((JTextField) component).getText().trim();
					}

				}

				else {
					GRPU.grpu
							.getMessage("Length of Employe Reference Number  should not exceed 10 digits");
					GRPU.grpu.setErrorAt(rowTable, colTable);
					return "";

				}
			}

		} else
		{
			GRPU.grpu.setNoErrorAt(rowTable, colTable);
			return "";
		}

	}

	public boolean isCellEditable(EventObject evt) {
		if (evt instanceof MouseEvent) {
			int clickCount = 2;
			return ((MouseEvent) evt).getClickCount() >= clickCount;
		} else {
			return true;
		}
	}
}
