package com.tin.etbaf.annexure1;

import java.awt.Component;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.util.EventObject;

import javax.swing.*;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.text.JTextComponent;

import com.tin.etbaf.rpu.Chk_LengthOnly;
import com.tin.etbaf.rpu.Chk_LengthOnly_insert;
import com.tin.etbaf.rpu.GRPU;
import com.tin.etbaf.rpu.GrpuUtil;
import com.tin.etbaf.validations.SecondaryValidations;

// Referenced classes of package com.tin.etbaf.rpu:
//            Chk_LengthOnly, GRPU, GrpuUtil

public class GRPUTableCellEditorInsertValidation extends AbstractCellEditor
		implements TableCellEditor {

	JComponent component;
	int rowTable;
	int colTable;

	public GRPUTableCellEditorInsertValidation() {
		component = new JTextField();
		component.addFocusListener(new FocusListener() {

			@Override
			public void focusLost(FocusEvent arg0) {
				JButton eventOwner;
				if (arg0.getOppositeComponent() instanceof JButton) {
					eventOwner = (JButton) arg0.getOppositeComponent();
					if ("Create File".equalsIgnoreCase(eventOwner.getText()
							.trim())) {
						GRPU.grpu.isCreateFileFocusOut = true;
					}
				} else {
					GRPU.grpu.isCreateFileFocusOut = false;
				}
			}

			@Override
			public void focusGained(FocusEvent arg0) {
				// TODO Auto-generated method stub

			}
		});
		rowTable = 0;
		colTable = 0;
	}

	public Component getTableCellEditorComponent(JTable table, Object value,
			boolean isSelected, int rowIndex, int vColIndex) {
		((JTextField) component).setDocument(new Chk_LengthOnly_insert(7));
		  //Added newly on 09/07/2015 ---- R&D by Akansha
        new SecondaryValidations().numericValidation(component,"Please enter only numeric values");
		if (value == null)
			((JTextField) component).setText("");
		else
			((JTextField) component).setText(String.valueOf(value));

		rowTable = rowIndex;
		colTable = vColIndex;
		return component;
	}

	public Object getCellEditorValue() {

		Object transVoucher = ((JTextField) component).getText().toString();
		if (!transVoucher.toString().equals("")) {
			if (((JTextField) component).getText().toString().trim().length() <= 7) // newly
																					// changed
																					// by
																					// cholia
			{
				if (!GrpuUtil.isInt(((JTextField) component).getText()
						.toString().trim())) {

					GRPU.grpu
							.getMessage(" Number of Deductee added should be numeric only");
					GRPU.grpu.setErrorAt(rowTable, colTable);
					return "";
				} else {
					GRPU.grpu.setNoErrorAt(rowTable, colTable);
					return ((JTextField) component).getText().trim();
				}

			}

			else {
				GRPU.grpu
						.getMessage("Length of  Transfer Voucher should not exceed 7 digits"); // newly
																								// changed
																								// by
																								// cholia
				GRPU.grpu.setErrorAt(rowTable, colTable);
				return "";

			}

		} else {
			GRPU.grpu.setNoErrorAt(rowTable, colTable);
			return "";
		}

	}

	public boolean isCellEditable(EventObject evt) {
		if (evt instanceof MouseEvent) {
			int clickCount = 2;
			return ((MouseEvent) evt).getClickCount() >= clickCount;
		} else {
			return true;
		}

	}
}
