
package com.tin.etbaf.annexure1;
import java.awt.Component;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.util.EventObject;

import javax.swing.*;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.text.JTextComponent;

import com.tin.etbaf.rpu.*;
// Referenced classes of package com.tin.etbaf.rpu:
//            Chk_LengthOnly, GRPU, GrpuUtil
import com.tin.etbaf.validations.SecondaryValidations;

public class GRPUTableCellEditorRateTaxDedtd extends AbstractCellEditor
    implements TableCellEditor
{

    JComponent component;
    int rowTable;
    int colTable;

    public GRPUTableCellEditorRateTaxDedtd()
    {
        component = new JTextField();
        component.addFocusListener(new FocusListener() {
			
			@Override
			public void focusLost(FocusEvent arg0) {
				JButton eventOwner;
				if(arg0.getOppositeComponent() instanceof JButton)
				{
					eventOwner =  (JButton) arg0.getOppositeComponent();
					if("Create File".equalsIgnoreCase(eventOwner.getText().trim()) ){
						GRPU.grpu.isCreateFileFocusOut = true;
					}					
				}
				else{
					GRPU.grpu.isCreateFileFocusOut = false;
				}
			}
			
			@Override
			public void focusGained(FocusEvent arg0) {
				// TODO Auto-generated method stub
				
			}
		});
        rowTable = 0;
        colTable = 0;
    }

    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int rowIndex, int vColIndex)
    {
        ((JTextField)component).setDocument(new Chk_LengthOnly(20));
        //Added newly on 09/07/2015 ---- R&D by Akansha
        new SecondaryValidations().numericValidation(component,"Rate at which tax deducted should be valid e.g. 10.0000");
        if(value == null)
            ((JTextField)component).setText("");
        else
            ((JTextField)component).setText(String.valueOf(value));
        rowTable = rowIndex;
        colTable = vColIndex;
        return component;
    }

    
    
    
    public Object getCellEditorValue()
    {
       
    	       Object rate=((JTextField)component).getText().toString();
    	       
    	        int dotCounter=0;
    	       
    	       if(!((JTextField)component).getText().toString().equals(""))
    	       {
    	    	   
    	    	if(((JTextField)component).getText().toString().trim().length()<=7)
		        {  
    	    	   if(GrpuUtil.isIntwithdot(((JTextField)component).getText().toString().trim()))
   		            {
   		            
    	    		  if(!rate.toString().contains("."))
    	    		  {
    	    			  String tdamount=rate.toString()+".0000";
    	    			  ((JTextField)component).setText(tdamount);
    	    		 
    	    			  if(((JTextField)component).getText().toString().length()>7)
    	    			  { GRPU.grpu.getMessage("<html>Length of Rate at which tax deducted should not exceed 7 digits <br>(including 4 digits decimal value). E.g. 12.0000</html>");
    	    			  	GRPU.grpu.setErrorAt(rowTable, colTable);
       		            	return "";
    	    			  }
	    	              else
	    	              {
	    	            	GRPU.grpu.setNoErrorAt(rowTable, colTable);
	   	                   // System.out.println("setting total tax value");
	   	                   // System.out.println("value is bhai"+((JTextField)component).getText().trim().toString());
	   	                    return tdamount;  
	    	              }
    	           
    	    		  }
    	    		  else 
    	    		  { 
    	        	   	int length = rate.toString().length();
    	       			String str=null;
    	       			int decimalPosition; 
    	       			if (rate.toString().charAt(0) == '.')
    	       				{
    	       					GRPU.grpu.getMessage("Rate at which tax deducted should be valid e.g. 10.0000");
    	       					GRPU.grpu.setErrorAt(rowTable, colTable);
    	       					return "";
    	       				}
    	       			else
    	       			{	
    	       			for (int j = 0; j < length; j++)
    	       				{
    	       					if (!(Character.isDigit(rate.toString().charAt(j))))
    	       					{
    	       						if (rate.toString().charAt(j) == '.')
    	       						{   decimalPosition = j;
    	       							dotCounter++;
    	       							str=rate.toString().substring(decimalPosition+1);
    	       				    
    	       						}
    	       				
    	       					}
    	       				}
    	       		
    	       			if(dotCounter>1)
	    	       		 {
	    	       		   GRPU.grpu.getMessage("Rate at which tax deducted should be valid e.g. 10.0000");
	    	       		   GRPU.grpu.setErrorAt(rowTable, colTable);
	    	       		   return "";  
	    	       		 }
    	       		
	    	       	   else
	    	       	   {
	    	       	   if(str.length()!=4)
	    	       		{ 
	    	       			 if(str.length()==1)
	    	       			 {
	    	       				rate=rate.toString()+"000";
	    	       			 }
	    	       			 if(str.length()==2)
	    	       			 {
	    	       				rate=rate.toString()+"00";
	    	       			 }
	    	       			 if(str.length()==3)
	    	       			 {
	    	       				rate=rate.toString()+"0";
	    	       			 }
	    	       			 if(str.length()==0){
	    	       				rate=rate.toString()+"0000";
	    	       			 }
	    	       		  }
	    	       	
		    	       	 ((JTextField)component).setText(rate.toString());
			        	   
			        	   if(((JTextField)component).getText().toString().length()>7)
			              { GRPU.grpu.getMessage("<html>Length of Rate at which tax deducted should not exceed 7 digits<br> (including 4 digits decimal value). E.g. 12.0000</html>");
				            GRPU.grpu.setErrorAt(rowTable, colTable);
		  		          return "";
			              }
			              else
			              {
			            	  	GRPU.grpu.setNoErrorAt(rowTable, colTable);
			                   // System.out.println("setting total tax value");
			                  //  System.out.println("value is bhai"+((JTextField)component).getText().trim().toString());
			                    return rate;  
			              } 
		    	       		
		    	       		
		    	       		}	
    	       			} //Not dot closes here
    	        	       
    	        	  
    	        	} //bahar wala
    	           
		        
   		            }
		        
    	    	   else
    	    		   
    	    	   {
    	    		   	GRPU.grpu.getMessage("Rate at which tax deducted should be valid e.g. 10.0000");
     		            GRPU.grpu.setErrorAt(rowTable, colTable);
       		          	return "";
    	    		   
    	    		   
    	    	   }
		        
		        }
    	      
    	    	else
    	    	{  GRPU.grpu.getMessage("<html>Length of Rate at which tax deducted should not exceed 7 digits <br>(including 4 digits decimal value). E.g. 12.0000</html>");
		           GRPU.grpu.setErrorAt(rowTable, colTable);
		           return "";
    	    		
    	    	}
    	       
    	       
    	       }
    	
    	       else
    	       {
    	    	  // GRPU.grpu.getMessage("Rate at which tax dedcuted should be valid");
		           GRPU.grpu.setErrorAt(rowTable, colTable);
		           return "";
    	    	   
    	       }
    }

    public boolean isCellEditable(EventObject evt)
    {
        if(evt instanceof MouseEvent)
        {
            int clickCount = 2;
            return ((MouseEvent)evt).getClickCount() >= clickCount;
        } else
        {
            return true;
        }
    
    }  
}
