/**
 * Author: Akansha Rajesh (711397)
 * Created for: New columns added to form 27Q --> Email Id of the deductee
 * Date: 11/07/2016
 */
package com.tin.etbaf.annexure1;

import java.awt.Component;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.util.EventObject;

import javax.swing.AbstractCellEditor;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.TableCellEditor;

import com.tin.etbaf.rpu.Chk_LengthOnly;
import com.tin.etbaf.rpu.GRPU;
import com.tin.etbaf.rpu.GrpuUtil;

public class GRPUTableCellEmailIDofdeductee extends AbstractCellEditor
		implements TableCellEditor {

	JComponent component;
	int rowTable;
	int colTable;

	public GRPUTableCellEmailIDofdeductee() {

		component = new JTextField();
		component.addFocusListener(new FocusListener() {

			@Override
			public void focusLost(FocusEvent arg0) {
				JButton eventOwner;
				if (arg0.getOppositeComponent() instanceof JButton) {
					eventOwner = (JButton) arg0.getOppositeComponent();
					if ("Create File".equalsIgnoreCase(eventOwner.getText()
							.trim())) {
						GRPU.grpu.isCreateFileFocusOut = true;
					}
				} else {
					GRPU.grpu.isCreateFileFocusOut = false;
				}
			}

			@Override
			public void focusGained(FocusEvent arg0) {
				// TODO Auto-generated method stub

			}
		});
		rowTable = 0;
		colTable = 0;

	}

	@Override
	public Object getCellEditorValue() {

		Object email = ((JTextField) component).getText().toString();
		if (!email.toString().equals("")) {
			if (((JTextField) component).getText().toString().trim().length() <= 75) {
				if (!GrpuUtil.isValidEmail(((JTextField) component).getText()
						.toString().trim())) {

					GRPU.grpu
							.getMessage("Invalid value. Please provide valid value under field Email ID of deductee");
					GRPU.grpu.setErrorAt(rowTable, colTable);
					return "";
				} else {
					GRPU.grpu.setNoErrorAt(rowTable, colTable);
					return ((JTextField) component).getText().trim().toUpperCase();
				}

			}

			else {
				GRPU.grpu
						.getMessage("Length of Email ID of deductee should not exceed 75 characters");
				GRPU.grpu.setErrorAt(rowTable, colTable);
				return ((JTextField) component).getText().trim();

			}

		} else {
			GRPU.grpu.setNoErrorAt(rowTable, colTable);
			return "";
		}

	}

	@Override
	public Component getTableCellEditorComponent(JTable table, Object value,
			boolean isSelected, int rowIndex, int vColIndex) {
		((JTextField) component).setDocument(new Chk_LengthOnly(75));
		if (value == null)
			((JTextField) component).setText("");
		else
			((JTextField) component).setText((String) value);
		rowTable = rowIndex;
		colTable = vColIndex;
		return component;
	}

	public boolean isCellEditable(EventObject evt) {
		if (evt instanceof MouseEvent) {
			int clickCount = 2;
			return ((MouseEvent) evt).getClickCount() >= clickCount;
		} else {
			return true;
		}
	}
}
