package com.tin.etbaf.annexure3;

import java.awt.Component;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.EventObject;
import java.util.Locale;

import javax.swing.AbstractCellEditor;
import javax.swing.JButton;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingConstants;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;

import com.tin.etbaf.rpu.Chk_LengthOnly;
import com.tin.etbaf.rpu.GRPU;
import com.tin.etbaf.rpu.GrpuUtil;
import com.tin.etbaf.validations.SecondaryValidations;

public class GRPUTableCellEditorDedInRespOFContri80GGC_DeductibleAmount extends AbstractCellEditor
implements TableCellEditor {
	
	Component component;
    int rowTable;
    int colTable;
    String valueOfTypeOfStmt;
    public static GRPU grpu = null;
    public DefaultTableModel model3 = null;
    
    public GRPUTableCellEditorDedInRespOFContri80GGC_DeductibleAmount(String valueOfTypeOfStmt )
    {
        component = new JTextField();
 component.addFocusListener(new FocusListener() {
			
			@Override
			public void focusLost(FocusEvent arg0) {
				JButton eventOwner;
				if(arg0.getOppositeComponent() instanceof JButton)
				{
					eventOwner =  (JButton) arg0.getOppositeComponent();
					if("Create File".equalsIgnoreCase(eventOwner.getText().trim()) ){
						GRPU.grpu.isCreateFileFocusOut = true;
					}					
				}
				else{
					GRPU.grpu.isCreateFileFocusOut = false;
				}
			}
			
			@Override
			public void focusGained(FocusEvent arg0) {
				// TODO Auto-generated method stub
				
			}
		});
        rowTable = 0;
        colTable = 0;
        this.valueOfTypeOfStmt=valueOfTypeOfStmt;
    }

    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int rowIndex, int vColIndex)
    {
        ((JTextField)component).setDocument(new Chk_LengthOnly(15));
        //Added newly on 09/07/2015 ---- R&D by Akansha
        new SecondaryValidations().numericValidation(component,"Deduction in respect of contributions given by any person to political parties u/s 80GGC   (Deductible Amount) should be valid.For e.g. 1000.00");
        if(value == null)
            ((JTextField)component).setText("0.00");
        else
            ((JTextField)component).setText((String)value);
        
        ((JTextField)component).setHorizontalAlignment(SwingConstants.RIGHT);
        rowTable = rowIndex;
        colTable = vColIndex;
         
        return component;
    }

    public Object getCellEditorValue()
    {
    	DecimalFormatSymbols sf = new DecimalFormatSymbols(Locale.ENGLISH);
    	DecimalFormat df = new DecimalFormat("0.00",sf);
		df.setMaximumFractionDigits(2);
	       Object Deduction=((JTextField)component).getText().toString();
	       
	       if(!((JTextField)component).getText().toString().equals(""))
	       {
	    	   
	    	if(((JTextField)component).getText().toString().trim().length() <= 15)
	        {  
	    	   if(GrpuUtil.isDecimalNonZero(((JTextField)component).getText().toString().trim(),2))
	            {
	            
	    		   	GRPU.grpu.getMessage("Deduction in respect of contributions given by any person to political parties u/s 80GGC   (Deductible Amount) should be valid.For e.g. 1000.00");
	            	GRPU.grpu.setErrorAt(rowTable, colTable);
	            	
	            	return "0.00";
	            }
	    	   
	    	   
	    	   
	    	   if(!Deduction.toString().contains("."))
	           {
	    		 
	    		   if(Deduction.equals("0"))
	    		     {
	    		    	 String tdamount=Deduction.toString()+".000.00";
	    	    		 ((JTextField)component).setText(tdamount); 
	    		    	 
	    		     }
	    		     else
	    		     { 
	    		    	 String tdamount=Deduction.toString()+".00";
	    		         ((JTextField)component).setText(tdamount);
	    		     }
	    		   
	              if(((JTextField)component).getText().toString().length()> 15)
	              { GRPU.grpu.getMessage("Deduction in respect of contributions given by any person to political parties u/s 80GGC   (Deductible Amount) should not exceed 15 digits");
		            GRPU.grpu.setErrorAt(rowTable, colTable);
		            return "0.00";
	              }
	              else
	              {
	            	GRPU.grpu.setNoErrorAt(rowTable, colTable);
	            	GRPU.grpu.setAggregateDedAmntChapVIA(((JTextField)component).getText().trim().toString(),rowTable,colTable);
	            	GRPU.grpu.setTotalTaxableIncome(((JTextField)component).getText().trim().toString(),rowTable,colTable);
                   return df.format(Double.parseDouble(((JTextField)component).getText().trim()+"0" ));  
	              }
	           
	           }
	           else
	        	   {
	        		   GRPU.grpu.setNoErrorAt(rowTable, colTable);
	        		   GRPU.grpu.setAggregateDedAmntChapVIA(((JTextField)component).getText().trim().toString(),rowTable,colTable);
	        		   GRPU.grpu.setTotalTaxableIncome(((JTextField)component).getText().trim().toString(),rowTable,colTable);
	        		   return df.format(Double.parseDouble(((JTextField)component).getText().trim()+"0" ));
	        	   }
	           
	        }
	      
	    	else
	    	{  GRPU.grpu.getMessage("Deduction in respect of contributions given by any person to political parties u/s 80GGC   (Deductible Amount) should not exceed 15 digits");
	           GRPU.grpu.setErrorAt(rowTable, colTable);
	           return "0.00";
	    		
	    	}
	       
	       
	       }
	
	       else
	       {
	    	   GRPU.grpu.setErrorAt(rowTable, colTable);
	         
           	
	    	   GRPU.grpu.setAggregateDedAmntChapVIA("0.00",rowTable,colTable);
	    	   GRPU.grpu.setTotalTaxableIncome("0.00",rowTable,colTable);
	           return "0.00";
	    	   
	       }
    }

    public boolean isCellEditable(EventObject evt)
    {
        if(evt instanceof MouseEvent)
        {
            int clickCount = 2;
            return ((MouseEvent)evt).getClickCount() >= clickCount;
        } else
        {
            return true;
        }
    }

}
