
package com.tin.etbaf.rpu;

import javax.swing.text.*;

// Referenced classes of package com.tin.etbaf.rpu:
//            GrpuUtil, GRPU

public class Chk_Length_Alpha_SpclChar extends PlainDocument
{

    int maxSize;

    public Chk_Length_Alpha_SpclChar(int limit)
    {
        maxSize = limit;
    }

    public void insertString(int offs, String str, AttributeSet a)
        throws BadLocationException
    {
        if(getLength() + str.length() <= maxSize)
            super.insertString(offs, str, a);
        else
            throw new BadLocationException("Insertion exceeds max size of document", offs);
    }

    public void insertUpdate(javax.swing.text.AbstractDocument.DefaultDocumentEvent evt, AttributeSet a)
    {
        int off = evt.getOffset();
        int len = evt.getLength();
        boolean gLenChk = true;
        try
        {
            String str = evt.getDocument().getText(off, len);
            if(!GrpuUtil.isInt(str.trim()))
            {
                evt.getDocument().remove(off, len);
                GRPU.grpu.getMessage("Alphabets / Special Characters not Allowed");
            }
        }
        catch(Exception e)
        {
            e.printStackTrace();
        }
    }
}
