package com.tin.etbaf.rpu;




import java.awt.Component;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.util.EventObject;
import javax.swing.*;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.text.JTextComponent;

// Referenced classes of package com.tin.etbaf.rpu:
//            Chk_LengthOnly, GRPU, GrpuUtil

public class GRPUTableCellEditorLastBsrCode extends AbstractCellEditor
    implements TableCellEditor
{

    JComponent component;
    int rowTable;
    int colTable;

    public GRPUTableCellEditorLastBsrCode()
    {
        component = new JTextField();
 component.addFocusListener(new FocusListener() {
			
			@Override
			public void focusLost(FocusEvent arg0) {
				JButton eventOwner;
				if(arg0.getOppositeComponent() instanceof JButton)
				{
					eventOwner =  (JButton) arg0.getOppositeComponent();
					if("Create File".equalsIgnoreCase(eventOwner.getText().trim()) ){
						GRPU.grpu.isCreateFileFocusOut = true;
					}					
				}
				else{
					GRPU.grpu.isCreateFileFocusOut = false;
				}
			}
			
			@Override
			public void focusGained(FocusEvent arg0) {
				// TODO Auto-generated method stub
				
			}
		});
        rowTable = 0;
        colTable = 0;
    }

    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int rowIndex, int vColIndex)
    {
        ((JTextField)component).setDocument(new Chk_LengthOnly(12));
        if(value == null)
            ((JTextField)component).setText("");
        else
            ((JTextField)component).setText(String.valueOf(value));
        rowTable = rowIndex;
        colTable = vColIndex;
        return component;
    }

    
    
    
    public Object getCellEditorValue()
    {
       
    	       Object lstBsrCode=((JTextField)component).getText().toString();
    	       
    	       if(!lstBsrCode.toString().equals("")) 
    	       {
    	       if(((JTextField)component).getText().toString().trim().length() == 7)
		        {  
    	        	if(!GrpuUtil.isInt(((JTextField)component).getText().toString().trim()))
    		        {
    		            
        	    	    GRPU.grpu.getMessage("Last BSR code/24G should be  numeric only");
    		            GRPU.grpu.setErrorAt(rowTable, colTable);
    		            return ((JTextField)component).getText().trim();
    		        }
    	            else
    	        	   {
    	        		   GRPU.grpu.setNoErrorAt(rowTable, colTable);
    	        		   return ((JTextField)component).getText().trim();
    	        	   }
    	           
    	        }
    	
    	       else
    	       {
    	    	   GRPU.grpu.getMessage("Length of Last BSR code/24G should be 7 digits");
		           GRPU.grpu.setErrorAt(rowTable, colTable);
		           return "";
    	    	   
    	       }
    	       }
    	       else
    	       {
    	    	   GRPU.grpu.setNoErrorAt(rowTable, colTable);
    	    	   return "";
    	       }
    
    }

    public boolean isCellEditable(EventObject evt)
    {
        if(evt instanceof MouseEvent)
        {
            int clickCount = 2;
            return ((MouseEvent)evt).getClickCount() >= clickCount;
        } else
        {
            return true;
        }
    
    }  
}
