package com.tin.etbaf.rpu;




import java.awt.Component;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.util.EventObject;
import javax.swing.*;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.text.JTextComponent;

// Referenced classes of package com.tin.etbaf.rpu:
//            Chk_LengthOnly, GRPU, GrpuUtil

public class GRPUTableCellEditorLastDateTaxDepstd extends AbstractCellEditor
    implements TableCellEditor
{

    JComponent component;
    int rowTable;
    int colTable;

    public GRPUTableCellEditorLastDateTaxDepstd()
    {
        component = new JTextField();
 component.addFocusListener(new FocusListener() {
			
			@Override
			public void focusLost(FocusEvent arg0) {
				JButton eventOwner;
				if(arg0.getOppositeComponent() instanceof JButton)
				{
					eventOwner =  (JButton) arg0.getOppositeComponent();
					if("Create File".equalsIgnoreCase(eventOwner.getText().trim()) ){
						GRPU.grpu.isCreateFileFocusOut = true;
					}					
				}
				else{
					GRPU.grpu.isCreateFileFocusOut = false;
				}
			}
			
			@Override
			public void focusGained(FocusEvent arg0) {
				// TODO Auto-generated method stub
				
			}
		});
        rowTable = 0;
        colTable = 0;
    }

    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int rowIndex, int vColIndex)
    {
        ((JTextField)component).setDocument(new Chk_LengthOnly(12));
        if(value == null)
            ((JTextField)component).setText("");
        else
            ((JTextField)component).setText(String.valueOf(value));
        rowTable = rowIndex;
        colTable = vColIndex;
        return component;
    }

    
    
    
    public Object getCellEditorValue()
    {
       
    	         Object date=((JTextField)component).getText().toString();
    	       
    	        if(((JTextField)component).getText().toString().trim().length()==10)
		        {  
    	        	char sep1=((JTextField)component).getText().toString().charAt(2);
    	        	char sep2=((JTextField)component).getText().toString().charAt(5);
    	        	String day=((JTextField)component).getText().toString().substring(0,2);
    	        	String month=((JTextField)component).getText().toString().substring(3,5);
    	        	String year=((JTextField)component).getText().toString().substring(6,10);
    	        	
    	        	if(sep1!='/'||sep2!='/')
    	        	{
    	        		GRPU.grpu.getMessage("only '/' is allowed as separator in the date filed");
    		            GRPU.grpu.setErrorAt(rowTable, colTable);
    		            return "";
    	        		
    	        	}
    	        	
    	        	else if(!GrpuUtil.isInt(day)||!GrpuUtil.isInt(month) ||!GrpuUtil.isInt(year))
    	        			{
    	        		      GRPU.grpu.getMessage("Only Numeric values is allowed as day ,month or year");
    		                  GRPU.grpu.setErrorAt(rowTable, colTable);
    		                  return "";
    	        		
    	        			}
    	        	
    	        	else if(GrpuUtil.isDate(day,month,year))
    		        {
    		            
        	    	    GRPU.grpu.getMessage("Last date on which Tax deposited is not valid");
    		            GRPU.grpu.setErrorAt(rowTable, colTable);
    		            return "";
    		        }
    	            else
    	        	   {
    	        		   GRPU.grpu.setNoErrorAt(rowTable, colTable);
    	        		   return ((JTextField)component).getText().trim();
    	        	   }
    	           
    	        }
    	
    	       else
    	       {
    	    	   GRPU.grpu.getMessage("Last date on which Tax deposited is not valid");
		           GRPU.grpu.setErrorAt(rowTable, colTable);
		           return "";
    	    	   
    	       }
    }

    public boolean isCellEditable(EventObject evt)
    {
        if(evt instanceof MouseEvent)
        {
            int clickCount = 2;
            return ((MouseEvent)evt).getClickCount() >= clickCount;
        } else
        {
            return true;
        }
    
    }  
}
