/**
 * Created by Sadhana(1369875)
 * This class represents, change color of TDS column of Annexure I tab
 * FRD2.0 on 04/06/2017
 * 
 * Sr No					Modified Date				Modified By						Purpose
 * -------------------------------------------------------------------------------------------------------------------------
 * 1.						04/06/2017					Sadhana							Change color of TDS column of Annexure I tab
 */
package com.tin.etbaf.rpu;

import java.awt.Color;
import java.awt.Component;
import javax.swing.BorderFactory;
import javax.swing.JTable;
import javax.swing.SwingConstants;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.table.DefaultTableCellRenderer;

public class GRPUTableCellEditorTDSValue extends DefaultTableCellRenderer{

    LineBorder focusBorder;
    EmptyBorder emptyfocusBrd;
    Color lightYellow;
    String tabname;
    int selYear_anne2;
    int  next_year_anne2;
    String formNumber;
    String changeColor;
    public GRPUTableCellEditorTDSValue(String tabname,int selYear_anne2,int  next_year_anne2,String formNumber,boolean rightAlign, String strChangecolor,boolean centerAlign )
    {
        focusBorder = (LineBorder)BorderFactory.createLineBorder(Color.black, 2);
        emptyfocusBrd = new EmptyBorder(1, 1, 1, 1);
        lightYellow = new Color(255, 255, 166);
        this.tabname=tabname;
        this.selYear_anne2=selYear_anne2;
        this.next_year_anne2=next_year_anne2;
        this.formNumber= formNumber  ;
        this.changeColor = strChangecolor;
        if(rightAlign)
            this.setHorizontalAlignment(SwingConstants.RIGHT);
        if(centerAlign)
        	 this.setHorizontalAlignment(SwingConstants.CENTER);
    }

    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column)
    {
    	
    	Color c ;
        setBorder(emptyfocusBrd);
        if((column == 0 && !isSelected))
        {
        	setBackground(Color.gray.brighter());
            setForeground(Color.black.darker());
           
        } 
        
        if(hasFocus){
        	setBackground(Color.green.brighter());
            setForeground(Color.black.darker());
        }
        
        if( GRPU.columnNumberEditableForcolour(column,this.tabname,row,this.selYear_anne2,this.next_year_anne2,this.formNumber)) //Just to set the colour of the 
        {
        	
        	setBackground(Color.gray.brighter());
            setForeground(Color.black.darker());
           
            
        } 
        else
        if(row == GRPU.errRow && column == GRPU.errCol)
        {
            setBackground(lightYellow);
            setForeground(Color.black);
            if(hasFocus && column > 0)
                setBorder(focusBorder);
        } else
        if(row == FindReplace.FindRow && column == FindReplace.FindCol)
        {
            if(isSelected && column > 0)
            {
                setBorder(focusBorder);
                setForeground(Color.black);
                setBackground(Color.white);
                transferFocus();
            }
        } else
        if(hasFocus && column > 0)
        {
            setForeground(Color.blue.brighter());
            setBackground(Color.white);
            setBorder(focusBorder);
        } else
        if(column != 0 && isSelected && value != null )
        {
            setBackground(Color.gray.brighter());
            setForeground(Color.black.darker());
           
        } else
        if(isSelected)
        {
            setBackground(Color.gray);
            setForeground(Color.white);
          
        } else
        {
            setForeground(Color.black);
            setBackground(Color.white);
          
        }
        
        if(isSelected && hasFocus && row>1){
        	setBorder(focusBorder);
        }
       
        if(this.tabname.equals("Anne1"))
        {
       	 if(row>1 && (row-2)<this.changeColor.length())
            {
       		 	char ctype = this.changeColor.charAt(row-2);
       		 	if(ctype == 'Y')
       		 	{
       		 		setBackground(Color.red);
       		 	}
       		 	if(ctype == 'N')
    		 	{
    		 		setBackground(Color.white);
    		 	}
            }
        }
        setValue(value);
        return this;
    }
}
