
package com.tin.etbaf.rpu;

import java.awt.Color;
import java.awt.Component;
import javax.swing.*;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.table.DefaultTableCellRenderer;

// Referenced classes of package com.tin.etbaf.rpu:
//            GRPU, FindReplace

public class GRPUTableCellRenderer extends DefaultTableCellRenderer
{

    LineBorder focusBorder;
    EmptyBorder emptyfocusBrd;
    Color lightYellow;
    String tabname;

    public GRPUTableCellRenderer(String tabname,boolean rightAlign)
    
    {
        focusBorder = (LineBorder)BorderFactory.createLineBorder(Color.black, 2);
        emptyfocusBrd = new EmptyBorder(1, 1, 1, 1);
        lightYellow = new Color(255, 255, 166);
        this.tabname=tabname;
        if(rightAlign)
        this.setHorizontalAlignment(SwingConstants.RIGHT);
       
    
    }

    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column)
    {
    	
  //  	System.out.println("I am inside cell renderer");
//    	System.out.println("Column Value: "+ column);
//    	System.out.println("isSelected Value: "+isSelected);
//    	System.out.println("Has Focus: "+ hasFocus);
        int count = 0;
        setBorder(emptyfocusBrd);
        if((column == 0 && !isSelected))
        {
        	setBackground(Color.gray.brighter());
            setForeground(Color.black.darker());
        } 
              
        
        if( GRPU.columnNumberEditable(column,this.tabname,row)) //Just to set the colour of the 
        {
        	
        	setBackground(Color.gray.brighter());
            setForeground(Color.black.darker());
           
        } 
        else
        if(row == GRPU.errRow && column == GRPU.errCol)
        {
            setBackground(lightYellow);
            setForeground(Color.black);
            if(hasFocus && column > 0)
                setBorder(focusBorder);
        } else
        if(row == FindReplace.FindRow && column == FindReplace.FindCol)
        {
            if(isSelected && column > 0)
            {
                setBorder(focusBorder);
                setForeground(Color.black);
                setBackground(Color.white);
                transferFocus();
            }
        } else
        if(hasFocus && column > 0)
        {
            setForeground(Color.blue.brighter());
            setBackground(Color.white);
            setBorder(focusBorder);
        } else
        if(column != 0 && isSelected && value != null)
        {
            setBackground(Color.gray.brighter());
            setForeground(Color.black.darker());
            
        } else
        if(isSelected)
        {
            setBackground(Color.gray);
            setForeground(Color.white);
           
        } else
        {
            setForeground(Color.black);
            setBackground(Color.white);
            
        }
        
        //newly added by Akansha for FRD1.3 
        if(isSelected && hasFocus && row>1){
        	setBorder(focusBorder);
        }
        //********************************************
     
        setValue(value);
        return this;
    }
}
