
package com.tin.etbaf.rpu;

import java.awt.Color;
import java.awt.Component;
import javax.swing.*;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.table.DefaultTableCellRenderer;

// Referenced classes of package com.tin.etbaf.rpu:
//            GRPU, FindReplace

public class GRPUTableRevisionCellRenderer extends DefaultTableCellRenderer
{

    LineBorder focusBorder;
    EmptyBorder emptyfocusBrd;
    Color lightYellow;

    public GRPUTableRevisionCellRenderer()
    {
        focusBorder = (LineBorder)BorderFactory.createLineBorder(Color.black, 2);
        emptyfocusBrd = new EmptyBorder(1, 1, 1, 1);
        lightYellow = new Color(255, 255, 166);
    }

    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column)
    {
    	
    	//System.out.println("Inside Revision cell Renderer");
        int count = 0;
        setBorder(emptyfocusBrd);
        if(column == 0 && !isSelected)
        {
            setBackground(Color.gray.brighter());
            setForeground(Color.black.darker());
        } else
        if(row == GRPU.errRow && column == GRPU.errCol)
        {
            setBackground(lightYellow);
            setForeground(Color.black);
            if(hasFocus && column > 0)
                setBorder(focusBorder);
        } else
        if(row == FindReplace.FindRow && column == FindReplace.FindCol)
        {
            if(isSelected && column > 0)
            {
              setBorder(focusBorder);
                setForeground(Color.black);
                setBackground(Color.white);
                transferFocus();
            }
        } else
        if(hasFocus && column > 0)
        {
            setForeground(Color.blue.brighter());
            setBackground(Color.white);
            setBorder(focusBorder);
        } else
        if(column != 0 && isSelected && value != null)
        {
            setBackground(Color.gray.brighter());
            setForeground(Color.black.darker());
        } else
        if(isSelected)
        {
            setBackground(Color.gray);
            setForeground(Color.white);
        } else
        {
            setForeground(Color.black);
            setBackground(Color.white);
        }
        setValue(value);
        return this;
    }
}
