package com.tin.etbaf.rpu;

import java.awt.AlphaComposite;
import java.awt.BorderLayout;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;

import com.tin.etbaf.validations.Validations;

public class MarqueeDemo {

    public static void main(String[] args) {

        EventQueue.invokeLater(new Runnable() {
            @Override
            public void run() {
                try {
                    UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
                } catch (ClassNotFoundException ex) {
                } catch (InstantiationException ex) {
                } catch (IllegalAccessException ex) {
                } catch (UnsupportedLookAndFeelException ex) {
                }

                JFrame frame = new JFrame();
                frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
                frame.setLayout(new BorderLayout());
                frame.add(new BlinkPane());
                frame.setSize(200, 200);
                frame.setLocationRelativeTo(null);
                frame.setVisible(true);
            }
        });

    }

    public static class BlinkPane extends JLabel {

        private JLabel label;
        private JLabel label2;
        JButton NSDLMascot = new JButton();
        private boolean on = true;
        private Validations validation = new Validations();

        public BlinkPane() {
        
            
         //  NSDLMascot.setBorder(blackline);
    		NSDLMascot.setBorderPainted(false);
    	
    		NSDLMascot.setContentAreaFilled(false);
    		NSDLMascot.setFocusPainted(false);
    		NSDLMascot.setOpaque(true);
    		
    		NSDLMascot.setToolTipText("<html>You can now get the answers to a range of queries related to PAN/TAN applications quickly and easily through Chat option.<br> Click here to chat with PAN Assist</html>");
    		validation.loadingAdvertisementImg(NSDLMascot, "/icon/Mascot.png",1005, 540, 275, 150);
           
            setLayout(new GridBagLayout());

            add(NSDLMascot);
          //  add(label2);
            Timer timer = new Timer(250, new ActionListener() {
                @Override
                public void actionPerformed(ActionEvent ae) {
                    on = !on;
                    repaint();
                }
            });
            timer.setRepeats(true);
            timer.setCoalesce(true);
            timer.start();
        }

        @Override
        public void paint(Graphics g) {
            Graphics2D g2d = (Graphics2D) g.create();
            if (!on) {
                g2d.setComposite(AlphaComposite.SrcOver.derive(0f));
            } else {
                g2d.setComposite(AlphaComposite.SrcOver.derive(1f));
            }
            super.paint(g2d); 
            g2d.dispose();
        }

    }
}