package com.tin.etbaf.rpu;

import java.awt.Component;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;

import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.ToolTipManager;
import javax.swing.plaf.basic.BasicComboBoxRenderer;

//created on 01/02/17
//new development for newly appended value "F", FRD1.9 on 02/02/17
public class MyComboBoxPanOfLandLord extends BasicComboBoxRenderer{


	public String[] remarksArry={"Payment made to Government organization (Central/State only)", 
			"Payment made to Non-resident",
			"Payment made to Other than Government organization and Non-resident", "Enter PAN"};//Edited on 01/02/17
	public List<String> tooltipsArry = new ArrayList<String>();
	public String formNumber;
	JComboBox combo;
	JList comboList;

	MyComboBoxPanOfLandLord() {
		super();
	}

	public MyComboBoxPanOfLandLord(String formNumber,JComboBox combo) {
		
		this.formNumber = formNumber;
		this.combo = combo;
		toolTips();
	}

	// Added for forming the required tooltip array depending on the section
	// codes
	public void toolTips() {
		String[] remarks = this.remarksArry;
		tooltipsArry.add("--Select--");
		String form = this.formNumber;
		for (int i = 0; i < remarks.length; i++)//Edited on 01/02/17
			{
			//Form wise distribution of the remark's tooltips
			if("24Q".equals(form)){
				if("Payment made to Government organization (Central/State only)".equals(remarks[i])){
					tooltipsArry.add("Payment made to Government organization (Central/State only)");
				}else if("Payment made to Non-resident".equals(remarks[i])){
					tooltipsArry.add("Payment made to Non-resident");
				}else if("Payment made to Other than Government organization and Non-resident".equals(remarks[i])){
					tooltipsArry.add("Payment made to Other than Government organization and Non-resident");
				}
				
			}
			
		}

	}

	public Component getListCellRendererComponent(JList list, Object value,
			int index, boolean isSelected, boolean cellHasFocus) {

		if (isSelected) {
			//Added for tooltips on mouse movement
	    	  super.getListCellRendererComponent(list, value, index,
						isSelected, cellHasFocus);
				if (comboList == null) {
					comboList = list;
					combo.addKeyListener(new KeyAdapter() {
						public void keyReleased(KeyEvent e) {
							if (e.getKeyCode() == KeyEvent.VK_DOWN
									|| e.getKeyCode() == KeyEvent.VK_UP) {
								int x = 5;
								int y = comboList.indexToLocation(comboList
										.getSelectedIndex()).y;
								ToolTipManager.sharedInstance().mouseEntered(
										new MouseEvent(comboList,
												MouseEvent.MOUSE_ENTERED, 0, 0,
												x, y, 0, false));
								ToolTipManager.sharedInstance().mouseMoved(
										new MouseEvent(comboList,
												MouseEvent.MOUSE_MOVED, 0, 0,
												x, y, 0, false));
							}
						}
					});
				}
	    	  
	    	  
	    	 //End of tooltips on mouse movement

			setBackground(list.getSelectionBackground());
			setForeground(list.getSelectionForeground());
			if (-1 < index) {
				if (this.tooltipsArry != null) {
					list.setToolTipText(this.tooltipsArry.get(index));
				}
			}
		} else {
			setBackground(list.getBackground());
			setForeground(list.getForeground());
		}
		setFont(list.getFont());
	//	System.out.println("Value of Combobox: "+ value.toString());
		setText((value == null) ? "" : value.toString());
		return this;
	}



}
