
package com.tin.etbaf.rpu;

import java.util.StringTokenizer;

// Referenced classes of package com.tin.etbaf.rpu:
//            GRPU, GrpuUtil

public class TDCellPasteValidations
{

    public TDCellPasteValidations()
    {
    }

    public static boolean Validate_Field(Object tabval, int tabrow, int tabcol)
    {
        switch(tabcol)
        {
        case 4: // '\004'
            return validatecell_TANTD(tabval, tabrow, tabcol);

        case 5: // '\005'
            return validatecell_NameTD(tabval, tabrow, tabcol);

        case 10: // '\006'
            return validatecell_Addr1TD(tabval, tabrow, tabcol);

        case 11: // '\007'
            return validatecell_Addr2TD(tabval, tabrow, tabcol);

        case 12: // '\b'
            return validatecell_Addr3TD(tabval, tabrow, tabcol);

        case 13: // '\t'
            return validatecell_Addr4TD(tabval, tabrow, tabcol);

        case 14: // '\n'
            return validatecell_CityTD(tabval, tabrow, tabcol);

        case 15: // '\013'
            return validatecell_StateTD(tabval, tabrow, tabcol);

        case 16: // '\f'
            return validatecell_PinTD(tabval, tabrow, tabcol);

        case 19: // '\r'
            return validatecell_TaxAmountTD(tabval, tabrow, tabcol);

        /*case 14: // '\016'
            return validatecell_MthYrTD(tabval, tabrow, tabcol);*/
        }
        return true;
    }

    private static boolean validatecell_TANTD(Object tabval, int tabrow, int tabcol)
    {
        String tan = "";
        boolean gStatusTAN = false;
        if(tabval == null)
        {
            errPaste("TAN must Not be NULL", tabrow, tabcol);
            return false;
        }
        tan = tabval.toString().trim();
        gStatusTAN = GRPU.grpu.checkTan(tan,tabrow);
        if(gStatusTAN)
        {
            errPaste("Invalid TAN", tabrow, tabcol);
            return false;
        } else
        {
            GRPU.grpu.setNoErrorAt(tabrow, tabcol);
            return true;
        }
    }

    private static boolean validatecell_NameTD(Object tabval, int tabrow, int tabcol)
    {
        String Name = "";
        boolean gStatus = true;
        if(tabval != null)
            Name = tabval.toString().trim();
        if(tabval == null || Name.length() == 0)
        {
            errPaste("Name must Not be NULL", tabrow, tabcol);
            gStatus = false;
        } else
        if(Name.length() >= 76)
        {
            errPaste("Length(Name) should be < = 75", tabrow, tabcol);
            return false;
        }
        GRPU.grpu.setNoErrorAt(tabrow, tabcol);
        return true;
    }

    private static boolean validatecell_Addr1TD(Object tabval, int tabrow, int tabcol)
    {
        String Addr1 = "";
        if(tabval != null)
            Addr1 = tabval.toString().trim();
        if(tabval == null || Addr1.length() == 0)
        {
            errPaste("Address 1 must Not be NULL", tabrow, tabcol);
            return false;
        }
        if(Addr1.length() >= 26)
        {
            errPaste("Length(Address 1) should be < = 25", tabrow, tabcol);
            return false;
        } else
        {
            GRPU.grpu.setNoErrorAt(tabrow, tabcol);
            return true;
        }
    }

    private static boolean validatecell_Addr2TD(Object tabval, int tabrow, int tabcol)
    {
        if(tabval != null)
        {
            String Addr2 = tabval.toString().trim();
            if(Addr2.length() >= 26)
            {
                errPaste("Length(Address 2) should be < = 25", tabrow, tabcol);
                return false;
            }
        }
        GRPU.grpu.setNoErrorAt(tabrow, tabcol);
        return true;
    }

    private static boolean validatecell_Addr3TD(Object tabval, int tabrow, int tabcol)
    {
        if(tabval != null)
        {
            String Addr3 = tabval.toString().trim();
            if(Addr3.length() >= 26)
            {
                errPaste("Length(Address 3) should be < = 25", tabrow, tabcol);
                return false;
            } else
            {
                return true;
            }
        } else
        {
            GRPU.grpu.setNoErrorAt(tabrow, tabcol);
            return true;
        }
    }

    private static boolean validatecell_Addr4TD(Object tabval, int tabrow, int tabcol)
    {
        if(tabval != null)
        {
            String Addr4 = tabval.toString().trim();
            if(Addr4.length() >= 26)
            {
                errPaste("Length(Address 4) should be < = 25", tabrow, tabcol);
                return false;
            } else
            {
                return true;
            }
        } else
        {
            GRPU.grpu.setNoErrorAt(tabrow, tabcol);
            return true;
        }
    }

    private static boolean validatecell_CityTD(Object tabval, int tabrow, int tabcol)
    {
        if(tabval == null || tabval.toString().trim().equals(""))
        {
            errPaste("City must Not be NULL", tabrow, tabcol);
            return false;
        }
        if(tabval != null)
        {
            String City = tabval.toString().trim();
            if(City.length() >= 26)
            {
                errPaste("Length(City) should be < = 25", tabrow, tabcol);
                return false;
            }
            if(GrpuUtil.isValidCityName(City))
            {
                errPaste("Invalid DDO City : " + City + ". \nSpecial characters Hyphen - ,Underscore _ ," + "Open bracket ( ,Closed Bracket ) and . Dot are only allowed.\n " + "Number (0-9) not allowed ", tabrow, tabcol);
                return false;
            }
        }
        GRPU.grpu.setNoErrorAt(tabrow, tabcol);
        return true;
    }

    private static boolean validatecell_StateTD(Object tabval, int tabrow, int tabcol)
    {
        String StateStr = "";
        String chkState = "";
        if(tabval != null)
        {
            StateStr = tabval.toString().trim();
            if(!StateStr.trim().equals("--Select--"))
            {
                String stCode = GrpuUtil.getStateCode(StateStr.trim());
                if(stCode.trim().equals("") || stCode.trim().equals("--Select--"))
                {
                    errPaste("State Name : '" + StateStr.trim() + "' doesn't match with the options given in the " + "Drop down List for Address State(Column 9). \nPlease select a valid State from " + "the Drop down list of Column 9(Address State)", tabrow, tabcol);
                    StateStr = "--Select--";
                    return false;
                }
            }
        }
        if(tabval == null || StateStr.equals("--Select--") || StateStr.equals(""))
        {
            errPaste("Please select a valid State from the Drop down list at ", tabrow, tabcol);
            return false;
        } else
        {
            GRPU.grpu.setNoErrorAt(tabrow, tabcol);
            return true;
        }
    }

    private static boolean validatecell_PinTD(Object tabval, int tabrow, int tabcol)
    {
        boolean gPIN = true;
        String pinTD = "";
        int pinVal = 0;
        if(tabval != null)
        {
            pinTD = tabval.toString().trim();
            try
            {
                pinVal = Integer.parseInt(pinTD);
            }
            catch(NumberFormatException e)
            {
                errPaste("PIN Code should be valid 6 digit code", tabrow, tabcol);
                return false;
            }
            catch(Exception e)
            {
                errPaste("PIN Code should be valid 6 digit code", tabrow, tabcol);
                return false;
            }
        }
        if(tabval == null || tabval.toString().trim().equals(""))
        {
            errPaste("PIN Code should be valid 6 digit code", tabrow, tabcol);
            return false;
        }
        gPIN = GrpuUtil.isInt(pinTD);
        if(!gPIN)
        {
            errPaste("PIN Code should be valid 6 digit code", tabrow, tabcol);
            return false;
        }
        if(pinTD.length() != 6)
        {
            errPaste("PIN Code should be valid 6 digit code", tabrow, tabcol);
            return false;
        }
        if(pinVal < 0x1adb1)
            errPaste("PIN Code should be greater than or equal to 110001", tabrow, tabcol);
        GRPU.grpu.setNoErrorAt(tabrow, tabcol);
        return true;
    }

    private static boolean validatecell_TaxAmountTD(Object tabval, int tabrow, int tabcol)
    {
        boolean gStatus = true;
        boolean gtaxAmt = true;
        String taxAmtTD = "";
        if(tabval != null)
            taxAmtTD = tabval.toString().trim();
        if(tabval == null || tabval.toString().trim().equals(""))
        {
            errPaste("Tax Amount must Not be NULL", tabrow, tabcol);
            return false;
        }
        gtaxAmt = GrpuUtil.isInt(taxAmtTD);
        if(!gtaxAmt)
        {
            errPaste("Invalid Tax Amount", tabrow, tabcol);
            return false;
        }
        if(taxAmtTD.length() >= 13)
        {
            errPaste("Length of Tax Amount should be less than or equal to 12", tabrow, tabcol);
            return false;
        }
        if(taxAmtTD.indexOf(".") != -1)
        {
            errPaste("Tax amount should not be decimal value ", tabrow, tabcol);
            return false;
        } else
        {
            GRPU.grpu.setNoErrorAt(tabrow, tabcol);
            return true;
        }
    }

//    private static boolean validatecell_MthYrTD(Object tabval, int tabrow, int tabcol)
//    {
//        String MthYrArray[] = new String[2];
//        int i = 0;
//        int parseCount = 0;
//        boolean gStatus = true;
//        String MthYrStr = "";
//        if(tabval == null || tabval.toString().trim().equals("--Select--"))
//        {
//            errPaste("Invalid Month & Year of Payment", tabrow, tabcol);
//            return false;
//        }
//        if(tabval != null)
//        {
//            MthYrStr = tabval.toString().trim();
//            if(!MthYrStr.equals("--Select--"))
//            {
//                StringTokenizer parser = new StringTokenizer(MthYrStr, " ");
//                parseCount = parser.countTokens();
//                while(parser.hasMoreTokens()) 
//                {
//                    MthYrArray[i] = parser.nextToken().toString().trim();
//                    i++;
//                }
//                if(parseCount != 2)
//                {
//                    errPaste("Invalid Month & Year of Payment", tabrow, tabcol);
//                    return false;
//                }
//                if(!GRPU.grpu.chkMthYrClipboard(MthYrArray, tabrow))
//                {
//                    errPaste("Invalid Month & Year of Payment", tabrow, tabcol);
//                    return false;
//                } else
//                {
//                    return true;
//                }
//            }
//        }
//        GRPU.grpu.setNoErrorAt(tabrow, tabcol);
//        return true;
//    }

    public static void errPaste(String msg, int tabrow, int tabcol)
    {
        String message = msg + " at row : " + (tabrow + 1) + " and col : " + (tabcol - 2);
        GRPU.grpu.getMessage(message);
    }
}
