/**
 * Created By Akansha
 * This file provides with all the necessary validations required in the Form.
 * *******************************************************************************************************************************
 * Sr No.  		Date			Name						New Addition
 * *******************************************************************************************************************************
 * 1.		 01/12/2014			Akansha					Creation of the file.
 * 2.        01/12/2014			Akansha					Addition of method txtFieldValidation() respective to TAN and PAN
 * 
 */
package com.tin.etbaf.validations;

import java.awt.Component;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import javax.swing.JOptionPane;
import javax.swing.JTextField;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

import com.tin.etbaf.rpu.GRPU;

public class SecondaryValidations extends PlainDocument {
	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;
	// Regular Expressions for Field Validations
	private String validateAlphaChar = "^[a-zA-Z0-9]+$";
	private String validateNumeric = "^[0-9.]+$"; // Added newly on 09/07/2015 --- R&D by Akansha
	private String validateNumericForAnne2 = "^[0-9.-]+$"; //new development for FRD1.3 by akansha
	// *****************************************
	private int limit;

	public SecondaryValidations(int limit) {
		super();
		this.limit = limit;
	}

	SecondaryValidations(int limit, boolean upper) {
		super();
		this.limit = limit;
	}

	public SecondaryValidations() {
		// TODO Auto-generated constructor stub
	}

	/**
	 * Function used for conversion of the value to uppercase while key press event
	 */
	public void insertString(int offset, String str, AttributeSet attr)
			throws BadLocationException {
		if (str == null)
			return;

		if ((getLength() + str.length()) <= limit) {
			super.insertString(offset, str.toUpperCase(), attr);
		}
	}

	/**
	 * Function used to restrict the entry of '^' at key press event
	 */
	public void insertUpdate(
			javax.swing.text.AbstractDocument.DefaultDocumentEvent evt,
			AttributeSet a) {
		int off = evt.getOffset();
		int len = evt.getLength();
		boolean gLenChk = true;

		try {
			String str = evt.getDocument().getText(off, len);
			if (str.trim().equals("^")) {
				evt.getDocument().remove(off, len);
				GRPU.grpu.getMessage("Special Character Not Allowed");
			}
		} catch (Exception exception) {
		}
	}

	/**
	 * Function used for validating the input values of the textboxes in the Form Tab
	 * @param ke
	 * @param cmp
	 * @param type
	 */
	public void txtFieldValidation(KeyEvent ke, JTextField cmp, String type) {
		if ("AlphaNumeric".equals(type)) {
			if (cmp.getText().equals("")) {
				cmp.setText("");
			} else {
				String name = cmp.getText();
				Pattern pt1 = Pattern.compile(validateAlphaChar);
				Matcher mh1 = pt1.matcher(name);
				boolean matchFound1 = mh1.matches();
				if ((!matchFound1)) {
					JOptionPane.showMessageDialog(null,
							"Special Characters are not allowed.");
					cmp.setText("");
				}
			}
		}
	}

	/**
	 * Function used for validating the input values of the textboxes in the Form Tab
	 * @param comp
	 * @param msg
	 */
	public void numericValidation(Component comp,final String msg) {
		final JTextField cmp = (JTextField)comp;
		//System.out.println("Text is: "+ cmp.getText());
		cmp.addKeyListener(new KeyListener() {
			
			@Override
			public void keyTyped(KeyEvent arg0) {
				// TODO Auto-generated method stub
				
			}
			
			@Override
			public void keyReleased(KeyEvent arg0) {
				if (cmp.getText().equals("")) {
					cmp.setText("");
				} else {
					String name = cmp.getText();
					Pattern pt1 = Pattern.compile(validateNumeric);
					Matcher mh1 = pt1.matcher(name);
					boolean matchFound1 = mh1.matches();
					if (!(matchFound1)) {
						cmp.setText(""); // --- by Akansha
						JOptionPane.showMessageDialog(null,msg);
						
					}

				}
				
			}
			
			@Override
			public void keyPressed(KeyEvent arg0) {
				// TODO Auto-generated method stub
				
			}
		});
		
		
	}
	
	/**
	 * Function used to allow negative values in all Annexure2 columns
	 * @param comp
	 * @param msg
	 */
	public void numericValidationForAnne2(Component comp,final String msg) {
		final JTextField cmp = (JTextField)comp;
		//System.out.println("Text is: "+ cmp.getText());
		cmp.addKeyListener(new KeyListener() {
			
			@Override
			public void keyTyped(KeyEvent arg0) {
				// TODO Auto-generated method stub
				
			}
			
			@Override
			public void keyReleased(KeyEvent arg0) {
				if (cmp.getText().equals("")) {
					cmp.setText("");
				} else {
					String name = cmp.getText();
					Pattern pt1 = Pattern.compile(validateNumericForAnne2);
					Matcher mh1 = pt1.matcher(name);
					boolean matchFound1 = mh1.matches();
					if (!(matchFound1)) {
						cmp.setText(""); // --- by Akansha
						JOptionPane.showMessageDialog(null,msg);
						
					}

				}
				
			}
			
			@Override
			public void keyPressed(KeyEvent arg0) {
				// TODO Auto-generated method stub
				
			}
		});
		
		
	}
	//****************************************************************
}
