/**
 * Created By Akansha
 * This file provides with all the necessary validations required in the Form.
 * *******************************************************************************************************************************
 * Sr No.  		Date			Name						New Addition
 * *******************************************************************************************************************************
 * 1.		 25/11/2014			Akansha					Addition of the method txtFieldValidation()
 * 2.		 28/11/2014			Akansha					Addition of validations-- validateAlpha, validateNumeric, validateEmail
 * 
 */


package com.tin.etbaf.validations;

import java.awt.Cursor;
import java.awt.Dialog.ModalityType;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.image.BufferedImage;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.net.URL;
import java.nio.file.Files;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingConstants;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

import com.tin.etbaf.rpu.GRPU;
import com.tin.etbaf.rpu.GRPUMain;

public class Validations extends PlainDocument {
	// Regular Expressions for Field Validations
	private String validateAlphaChar = "^[a-zA-Z0-9]+$";
	private String validateAlpha = "^[a-zA-Z0-9 /*/&/%/$/!@#/(/)/{/}/:/;/</>/,/./_/+=?/|\\\\/`\\]\\[\\-\\\"\\\'/~]+$";
	private String validateNumeric = "^[0-9]+$";
	private String validateEmail = "^[a-zA-Z0-9-_.@]+$";
	public static final String[] TDS_FVU_RCC = { "AGR", "AHM", "ALD", "AMR",
			"BBN", "BLR", "BPL", "BRD", "CAL", "CHE", "CHN", "CMB", "DEL",
			"HYD", "JBP", "JDH", "JLD", "JPR", "KLP", "KNP", "LKN", "MRI",
			"MRT", "MUM", "NGP", "NSK", "PNE", "PTL", "PTN", "RCH", "RKT",
			"RTK", "SHL", "SRT", "TVD", "VPN" };

	JDialog jframe;
	
	//new development for FRD1.3 by Akansha
		public static String savedfilepath = "";
		public static String previousSavedFileFolder = "";
		public static File savedFileName;
	
	
	// *****************************************
	private int limit;

	public Validations(int limit) {
		super();
		this.limit = limit;
	}

	Validations(int limit, boolean upper) {
		super();
		this.limit = limit;
	}

	public Validations() {
		// TODO Auto-generated constructor stub
	}

	/**
	 * Function used for conversion of the value to uppercase while key press event
	 */
	public void insertString(int offset, String str, AttributeSet attr)
			throws BadLocationException {
		if (str == null)
			return;

		if ((getLength() + str.length()) <= limit) {
			super.insertString(offset, str.toUpperCase(), attr);
		}
	}
	
	/**
	 * Function used to restrict the entry of '^' at key press event
	 */
	public void insertUpdate(javax.swing.text.AbstractDocument.DefaultDocumentEvent evt, AttributeSet a)
	  {
	       int off = evt.getOffset();
	        int len = evt.getLength();
	       boolean gLenChk = true;
	       
	       try
	       {
	          String str = evt.getDocument().getText(off, len);
	          if(str.trim().equals("^")) 
	         {
	             evt.getDocument().remove(off, len);
	              GRPU.grpu.getMessage("Special Character '^' Not Allowed");
	         }
	       }        catch(Exception exception) { }
	  }
	
	/**
	 * Function used for validating the input values of the textboxes in the Form Tab
	 * @param ke
	 * @param cmp
	 * @param type
	 */
	public void txtFieldValidation(KeyEvent ke, JTextField cmp, String type) {
		boolean flag = false;
		if ("AlphaNumeric".equals(type)) {
			if (cmp.getText().equals("")) {
				cmp.setText("");
			} else {
				String name = cmp.getText();
				Pattern pt1 = Pattern.compile(validateAlphaChar);
				Matcher mh1 = pt1.matcher(name);
				boolean matchFound1 = mh1.matches();
				if ((!matchFound1)) {
					JOptionPane.showMessageDialog(null,
							"Special Characters are not allowed.");
					cmp.setText(""); // --- by Akansha
					cmp.requestFocus();
				}
			}
		} else if ("Alpha".equals(type)) {
			if (cmp.getText().equals("")) {
				cmp.setText("");
			} else {
				String name = cmp.getText();
				Pattern pt1 = Pattern.compile(validateAlpha);
				Matcher mh1 = pt1.matcher(name);
				boolean matchFound1 = mh1.matches();
				if (!(matchFound1)) {
					JOptionPane.showMessageDialog(null,
							"Caret symbol is not allowed.");
					cmp.setText(""); // ---- by Akansha
					cmp.requestFocus();
				}
			}
		}else if ("Numeric".equals(type)) {
			if (cmp.getText().equals("")) {
				cmp.setText("");
			} else {
				String name = cmp.getText();
				Pattern pt1 = Pattern.compile(validateNumeric);
				Matcher mh1 = pt1.matcher(name);
				boolean matchFound1 = mh1.matches();
				if (!(matchFound1)) {
					JOptionPane.showMessageDialog(null,
							"Only Numeric values are allowed.");
					cmp.setText(""); // --- by Akansha
					cmp.requestFocus();
				}
			}
		} else if ("Email".equals(type)) {
			if (cmp.getText().equals("")) {
				cmp.setText("");
			} else {
				String name = cmp.getText();
				Pattern pt1 = Pattern.compile(validateEmail,
						Pattern.CASE_INSENSITIVE);
				Matcher mh1 = pt1.matcher(name);
				boolean matchFound1 = mh1.matches();
				if (!(matchFound1)) {
					
					flag = true;
					cmp.setText(""); // ----- by Akansha
					cmp.requestFocus();
				}
				if(flag)
				JOptionPane.showMessageDialog(null,
						"Please enter valid email.");
			}
		}
	}

	/**
	 * Length should be 10, First 3 Characters should be among the 36 RCCs,
	 * First 3 Characters should be between capital A to capital Z, Fourth
	 * character should be letter or digit and if letter then should be be
	 * between capital A to capital Z, 5th,6th,7th,8th,9th character should be
	 * numberic(between 0 and 9). If integer of 5th,6th,7th,8th,9th character
	 * mod 7 is 0 the last character of TAN should be A. If integer of
	 * 5th,6th,7th,8th,9th character mod 7 is 1 the last character of TAN should
	 * be B. If integer of 5th,6th,7th,8th,9th character mod 7 is 2 the last
	 * character of TAN should be C. If integer of 5th,6th,7th,8th,9th
	 * character mod 7 is 3 the last character of TAN should be D. If integer
	 * of 5th,6th,7th,8th,9th character mod 7 is 4 the last character of TAN
	 * should be E. If integer of 5th,6th,7th,8th,9th character mod 7 is 5 the
	 * last character of TAN should be F. If integer of 5th,6th,7th,8th,9th
	 * character mod 7 is 6 the last character of TAN should be G.
	 * @param tan
	 * @return
	 */
	public boolean checkTan(String tan) {
		int checkBit;
		if (tan.trim().length() != 10) {
			return true;
		}
		String subtan = tan.substring(0, 3);
		String midSubtan = tan.substring(4, 9);
		String endSubtan = tan.substring(9, 10);

		/*
		 * if(FileValidatorInterface.TDS_FVU_RCC.indexOf(subtan) == -1) { return
		 * true; }
		 */

		// //////////***************
		int rccFlag = 0;
		for (int localR = 0; localR < TDS_FVU_RCC.length; localR++) {
			if (subtan.equals(TDS_FVU_RCC[localR])) {
				rccFlag = 1;
				break;
			}
		}
		if (rccFlag == 0) {
			return true;
		}
		// //////////***************
		for (int i = 0; i < 3; i++) {
			if (!(subtan.charAt(i) > 64 && subtan.charAt(i) < 91)) {
				return true;
			}
		}

		if (!Character.isLetterOrDigit(tan.charAt(3))) {
			return true;
		}

		if (Character.isLetter(tan.charAt(3))) {
			if (!(tan.charAt(3) > 64 && tan.charAt(3) < 91)) {
				return true;
			}

		}
		
		if (!Character.isLetter(tan.charAt(4))) {
			if (!(tan.charAt(3) > 64 && tan.charAt(3) < 91)) {
				return true;
			}

		}
		
		for (int i = 0; i < 5; i++) {
			if (!(midSubtan.charAt(i) > 47 && midSubtan.charAt(i) < 58)) {
				return true;
			}
		}

		checkBit = Integer.parseInt(midSubtan) % 7;

		//RPU 2.8 TanChanages Start 
		if (checkBit == 0 && (endSubtan.charAt(0) == 'A' || endSubtan.charAt(0) == 'H'))
			return false;
		if (checkBit == 1 && (endSubtan.charAt(0) == 'B' || endSubtan.charAt(0) == 'I'))
			return false;
		if (checkBit == 2 && (endSubtan.charAt(0) == 'C' || endSubtan.charAt(0) == 'J'))
			return false;
		if (checkBit == 3 && (endSubtan.charAt(0) == 'D' || endSubtan.charAt(0) == 'K'))
			return false;
		if (checkBit == 4 && (endSubtan.charAt(0) == 'E' || endSubtan.charAt(0) == 'L'))
			return false;
		if (checkBit == 5 && (endSubtan.charAt(0) == 'F' || endSubtan.charAt(0) == 'M'))
			return false;
		if (checkBit == 6 && (endSubtan.charAt(0) == 'G' || endSubtan.charAt(0) == 'N'))
			return false;
		//RPU 2.8 TanChanages end

		return true;
	}

	/**
	 * Length should be 10,First 3 Characters should be between capital A to
	 * capital Z, Characters 6,7,8 should be numeric(between 0 and 9),Fourth
	 * character should be amongst 'P','H','C','J','F','A','T','B','L','G'.Fifth
	 * and tenth character should be between capital A to capital Z.
	 * @param pan
	 * @return
	 */
	public boolean checkPan(String pan) {

		if (pan.trim().length() != 10 || pan.length() != 10) {
			return true;
		}
		for (int i = 0; i < 3; i++) {
			if (!(pan.charAt(i) > 64 && pan.charAt(i) < 91)) {
				return true;
			}
		}

		for (int i = 5; i < 9; i++) {
			if (!(pan.charAt(i) > 47 && pan.charAt(i) < 58)) {
				return true;
			}
		}

		if (pan.charAt(3) != 'P' && pan.charAt(3) != 'H'
				&& pan.charAt(3) != 'C' && pan.charAt(3) != 'J'
				&& pan.charAt(3) != 'F' && pan.charAt(3) != 'A'
				&& pan.charAt(3) != 'T' && pan.charAt(3) != 'B'
				&& pan.charAt(3) != 'L' && pan.charAt(3) != 'G') {
			return true;
		}

		if (!(pan.charAt(4) > 64 && pan.charAt(4) < 91)) {
			return true;
		}

		if (!(pan.charAt(9) > 64 && pan.charAt(9) < 91)) {
			return true;
		}

		return false;
	}

	/**
	 * Valid quarter check Funtion added inorder to check the quarter to be valid as per system date	
	 * @param formno
	 * @param finYear
	 * @param method
	 * @return
	 */
	public String isValidQuarter(String formno, String finYear,String method) {
		Calendar cal2 = null;
		Calendar cal1 = Calendar.getInstance();
		SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy",Locale.ENGLISH);
		String str = sdf.format(cal1.getTime());
		Calendar sysdate = new GregorianCalendar(Integer.parseInt(str
				.substring(6)), Integer.parseInt(str.substring(3, 5)) - 1,
				Integer.parseInt(str.substring(0, 2)));
		int year = Integer.parseInt(finYear.substring(0, 4));
		String strbr = "--Select--";

		// For addition of Q1
		cal2 = new GregorianCalendar(year, 6, 1);
		if (!sysdate.before(cal2))
			strbr += ",Q1";

		// For addition of Q2
		cal2 = new GregorianCalendar(year, 9, 1);
		if (!sysdate.before(cal2))
			strbr += (",Q2");

		// For addition of Q3
		cal2 = new GregorianCalendar(year + 1, 0, 1);
		if (!sysdate.before(cal2))
			strbr += (",Q3");

		// For addition of Q4
		if (formno.equalsIgnoreCase("24Q"))
			cal2 = new GregorianCalendar(year, 3, 1);
		else
			cal2 = new GregorianCalendar(year + 1, 3, 1);

		if (!sysdate.before(cal2))
			strbr += (",Q4");	//if(!(formno.equalsIgnoreCase("24Q") && year>=2019)) //added to remove Q4 Quarter //rpu 3.2 start
		
		strbr += ("");

		// Code adding the popup
		String[] quarter = strbr.split(",");
		
		if(!"Open".equals(method)){ // new development for FRD1.3 by Akansha
		
		if (!"24Q".equals(formno)) {
			
			if (quarter.length > 1) {
				String temp = "Please select quarter. Return can be prepared only for "
						+ quarter[1];

				for (int i = 2; i < quarter.length; i++) {
					if (i == quarter.length - 1) {
						temp += " and " + quarter[i];
					} else {
						temp += ", " + quarter[i];
					}
				}
				temp += " for selected financial year.";
				JOptionPane.showMessageDialog(null, temp);
			} else if (quarter.length == 1 && "--Select--".equals(quarter[0].toString())){
				String temp = "Return can not be prepared before completion of the relevant quarter of selected financial year";
				JOptionPane.showMessageDialog(null, temp);
			}
		} else if("24Q".equals(formno)){
			if (quarter.length == 2){
				String temp = "Please select quarter. Return can be prepared only for Q4 of selected financial year";
				JOptionPane.showMessageDialog(null, temp);
			}else{
				String temp ="";
				if(method!=null && !"Open".equals(method) && !"Import".equals(method)){
				 temp = "Please select quarter.";
				JOptionPane.showMessageDialog(null, temp);
				}
			}
		}
		// ***************************
		}
		return strbr;
	}

	/**
	 * Function added for dynamic generation of the assessment year depending upon the financial 
	 * year selected in the dropdown
	 * @param j
	 * @return
	 */
	public static List AssessmentYearCombo(int j) {

		int year = Calendar.getInstance().get(Calendar.YEAR);
		// System.out.println(year);

		int k = year;
		Calendar nowDate = Calendar.getInstance();
		Calendar toDate = Calendar.getInstance();
		toDate.set(year, 03, 01);
		// List common = new ArrayList();
		// List fY2 = new ArrayList();
		// List fY3 = new ArrayList();
		List fy4 = new ArrayList();
		if (!nowDate.before(toDate)) {
			for (int i = 2007; i <= year; i++) {
				String new_nik = Integer.toString(i + 1);
				String new_nikToBeAdded = Integer.toString(i + 2);
				fy4.add(new String((new_nik) + "-" + (new_nikToBeAdded)));
			}

		} else {
			for (int i = 2007; i <= year - 1; i++) {
				String new_nik = Integer.toString(i + 1);
				String new_nikToBeAdded = Integer.toString(i + 2);

				fy4.add(new String((new_nik) + "-" + (new_nikToBeAdded)));
			}
		}
		java.util.Collections.reverse(fy4);
		return fy4;
	}

	/**
	 * Function added inorder to return financial years to be added to the combo box
	 * @return
	 */
	public static HashMap FinYearCombo() {

		int year = Calendar.getInstance().get(Calendar.YEAR);
		HashMap finyear = new HashMap();
		int k = year;
		Calendar nowDate = Calendar.getInstance();
		Calendar toDate = Calendar.getInstance();
		toDate.set(year, 03, 01);
		List fy4 = new ArrayList();
		if (!nowDate.before(toDate)) {
			for (int i = 2007; i <= year; i++) {
				String new_nik = Integer.toString(i + 1);
				String new_nikToBeAdded = Integer.toString(i + 2);
				String newyear = Integer.toString(i + 2) + "-"
						+ Integer.toString(i + 2).substring(2, 4);
				fy4.add(new String((new_nik) + "-" + (new_nikToBeAdded)));
				finyear.put(newyear, new String((new_nik) + "-"
						+ (new_nikToBeAdded)));
			}

		} else {
			for (int i = 2007; i <= year - 1; i++) {
				String new_nik = Integer.toString(i + 1);
				String new_nikToBeAdded = Integer.toString(i + 2);
				String newyear = Integer.toString(i + 2) + "-"
						+ Integer.toString(i + 2).substring(2, 4);
				fy4.add(new String((new_nik) + "-" + (new_nikToBeAdded)));
				finyear.put(newyear, new String((new_nik) + "-"
						+ (new_nikToBeAdded)));
			}
		}

		return finyear;
	}

	/**
	 * Function used for displaying dialog box while saving the file to the system
	 * @param details
	 * @param FileName
	 * @param mainObject
	 */
	public void showSaveFileDialog(ArrayList<Object> details,String FileName,GRPUMain mainObject) {
		mainObject.contentPanel.setCursor(Cursor.getPredefinedCursor(Cursor.WAIT_CURSOR));		
		/*JFileChooser fileChooser = new JFileChooser();
		fileChooser.setDialogTitle("Specify a file to save");
		fileChooser.setSelectedFile(new File(FileName));
		int userSelection = fileChooser.showSaveDialog(null);*/
		//String filenm = "";
//		//temp code
//		/*EncryptDecrypt d = new EncryptDecrypt();*/
//		String txt="some text to be encrypted" ;
//	       String key="key phrase used for XOR-ing";
//	     //  System.out.println(txt+" XOR-ed to: "+(txt=xorMessage( txt, key )));
//	       String encoded="";       
//	       String temp="";
//		//**************
		try {
			//new development for FRD1.5 by akansha
			if (!"".equals(savedfilepath)) {
				//filenm = savedfilepath.substring(savedfilepath.lastIndexOf("\\")+1,savedfilepath.length());
			/*int res = JOptionPane.showConfirmDialog(null,"The file already exists. Do you want to replace it?","Save File",JOptionPane.YES_NO_CANCEL_OPTION);
				if(res == 0){
					if (userSelection == JFileChooser.APPROVE_OPTION) {
						File fileToSave = fileChooser.getSelectedFile();

						BufferedWriter out = new BufferedWriter(new FileWriter(
								fileToSave));
						for (Object x : details) {
							if (x != null)
								out.write(x.toString());
						}
						out.close();
						// System.out.println("Outside save file:"+System.currentTimeMillis());

						mainObject.contentPanel.setCursor(Cursor
								.getPredefinedCursor(Cursor.DEFAULT_CURSOR));
						JOptionPane
						.showMessageDialog(
								null,
								"<html>File has been saved successfully at "
										+ fileToSave.getAbsolutePath()
										+ ". <br> This file can be opened again for modifications by using the File Menu -->  Open option in this TDS/TCS Return Preparation Utility</html>");

					}
				}else if(res ==1){
					JOptionPane.showMessageDialog(null,"File is not saved");
					savedfilepath = "";
				}*/
				JFileChooser existingfileChooser = new JFileChooser();
				existingfileChooser.setFileSelectionMode(JFileChooser.DIRECTORIES_ONLY);
				System.out.println("saved file path:" +previousSavedFileFolder);
				File currentFile = new File(previousSavedFileFolder.trim());
				existingfileChooser.setCurrentDirectory(currentFile);
				existingfileChooser.setDialogTitle("Specify a file to save");
				existingfileChooser.setSelectedFile(new File(currentFile.getName()));
				int userSelection1 = existingfileChooser.showSaveDialog(null);
				if (userSelection1 == JFileChooser.APPROVE_OPTION) {
					System.out.println("current file path "+currentFile.getName());
					System.out.println("existing file chooser "+existingfileChooser.getSelectedFile()+"\\"+currentFile.getName());
					File newFile = new File(existingfileChooser.getSelectedFile()+"\\"+currentFile.getName());
					System.out.println("copied file "+ newFile.toPath());
					Files.copy(currentFile.toPath(), newFile.toPath());
					BufferedWriter out = new BufferedWriter(new FileWriter(newFile));
					for (Object x : details) {
						if (x != null)
							out.write(x.toString());
					}
					out.close();
					System.out.println("next saved file path"+existingfileChooser.getSelectedFile().getAbsolutePath());

					mainObject.contentPanel.setCursor(Cursor
							.getPredefinedCursor(Cursor.DEFAULT_CURSOR));
					JOptionPane
					.showMessageDialog(
							null,
							"<html>File has been saved successfully at "
									+ existingfileChooser.getSelectedFile().getAbsolutePath()
									+ ". <br> This file can be opened again for modifications by using the File Menu -->  Open option in this TDS/TCS Return Preparation Utility</html>");
					previousSavedFileFolder = newFile.getAbsolutePath(); //added by sadhana, FRD 2.2
					savedfilepath = newFile.getAbsolutePath();
				
				}else{
					JOptionPane.showMessageDialog(null,"File is not saved");
					//savedfilepath = "";
				}
			} else {
				JFileChooser fileChooser = new JFileChooser();
				fileChooser.setDialogTitle("Specify a file to save");
				fileChooser.setSelectedFile(new File(FileName));
				int userSelection = fileChooser.showSaveDialog(null);
				if (userSelection == JFileChooser.APPROVE_OPTION) {
					File fileToSave = fileChooser.getSelectedFile();

					//System.out.println("saved file name:"+fileToSave.getName());
					savedfilepath = fileToSave.getAbsolutePath();
					BufferedWriter out = new BufferedWriter(new FileWriter(
							fileToSave));
					for (Object x : details) {
						if (x != null)
							out.write(x.toString());
					}
					out.close();
					// System.out.println("Outside save file:"+System.currentTimeMillis());
					mainObject.contentPanel.setCursor(Cursor
							.getPredefinedCursor(Cursor.DEFAULT_CURSOR));
					JOptionPane
							.showMessageDialog(
									null,
									"<html>File has been saved successfully at "
											+ fileToSave.getAbsolutePath()
											+ ". <br> This file can be opened again for modifications by using the File Menu -->  Open option in this TDS/TCS Return Preparation Utility</html>");

					
					previousSavedFileFolder = fileChooser.getSelectedFile().getPath();
					//System.out.println("saved file path first time....."+previousSavedFileFolder);
					savedFileName = fileToSave;
				}else{
					savedfilepath="";
				}
				// ******************************************************

			}
		} catch (Exception e) { // IOException removed
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
	}
	
	/**
	 * Function used for saving the 'Regular' file to the system
	 * @param details
	 * @param FileName
	 */
	public void showSaveFileDialogReg(ArrayList<Object> details,String FileName) {
		JFileChooser fileChooser = new JFileChooser();
		
		fileChooser.setDialogTitle("Specify a file to save");
		fileChooser.setSelectedFile(new File(FileName));
		int userSelection = fileChooser.showSaveDialog(null);
		try {
			//new development for FRD1.5 by akansha
			if (!"".equals(savedfilepath)) {
				//System.out.println("Saved file path:##################: "+savedfilepath);
				int res = JOptionPane.showConfirmDialog(null, FileName
						+ " already exists. Do you want to replace it?",
						"Save File", JOptionPane.YES_NO_CANCEL_OPTION);
				if (res == 0) {
					if (userSelection == JFileChooser.APPROVE_OPTION) {
						File fileToSave = fileChooser.getSelectedFile();

						BufferedWriter out = new BufferedWriter(new FileWriter(
								fileToSave));
						// System.out.println("Details array:"+details.size());

						for (Object x : details) {
							if (x != null)
								out.write(x.toString());
						}
						out.close();
						savedfilepath = fileToSave.getAbsolutePath();
						JOptionPane
								.showMessageDialog(
										null,
										"<html>File has been saved successfully at "
												+ fileToSave.getAbsolutePath()
												+ ". <br> This file can be opened again for modifications by using the File Menu -->  Open option in this TDS/TCS Return Preparation Utility</html>");

						// Add a dialog box for openeing file
						GRPU.grpu.fileitemopen_actionPerformed(null);
					}
				}else if(res == 1){
					JOptionPane.showMessageDialog(null,"File is not saved");
				}
			}else {
				
				if (userSelection == JFileChooser.APPROVE_OPTION) {
					File fileToSave = fileChooser.getSelectedFile();

					BufferedWriter out = new BufferedWriter(new FileWriter(
							fileToSave));
					// System.out.println("Details array:"+details.size());

					for (Object x : details) {
						if (x != null)
							out.write(x.toString());
					}
					out.close();
					savedfilepath = fileToSave.getAbsolutePath();
					JOptionPane
							.showMessageDialog(
									null,
									"<html>File has been saved successfully at "
											+ fileToSave.getAbsolutePath()
											+ ". <br> This file can be opened again for modifications by using the File Menu -->  Open option in this TDS/TCS Return Preparation Utility</html>");

					// Add a dialog box for openeing file
					GRPU.grpu.fileitemopen_actionPerformed(null);
				}
			}
			//**************************************************************************
		} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
	}

	/**
	 * Function used for writing data onto the .txt file created
	 * @param canonicalFilename
	 * @param text
	 * @throws IOException
	 */
	public static void writeFile(String canonicalFilename, String text)
			throws IOException {
		File file = new File(canonicalFilename);
		BufferedWriter out = new BufferedWriter(new FileWriter(file));
		out.write(text);
		out.close();
	}

		
	/**
	 * Function used for Custom dialog box creation for popup on click of correction button
	 * @param contentPanel
	 */
		private void createCustomDialog(JFrame contentPanel) {
			jframe = new JDialog(new JFrame(),"Message",ModalityType.APPLICATION_MODAL);
			jframe.setFont(new Font("Arial", Font.PLAIN, 12));
			
			JLabel jlabel = new JLabel("Please import latest Consolidated TDS/TCS file to prepare correction statement.",SwingConstants.CENTER);
			JButton button = new JButton("OK");
			
			
			
			JPanel jpanel = new JPanel();
			
			jpanel.add(jlabel);
			jpanel.add(button);
			//jframe.setTitle("Message");
			jframe.getContentPane().add(jpanel);
			//jframe.setModalityType(ModalityType.APPLICATION_MODAL);		
			
			button.addActionListener(new ActionListener() {
				public void actionPerformed(ActionEvent arg0) {
					jframe.dispose();
				}
			});
			jframe.setSize(510, 100);
			jframe.setResizable(false);
			jframe.setLocationRelativeTo(contentPanel); 
			jframe.setVisible(true);
			
			
		}
	//******************************************************************
		

		/**
		 * Method created for Displaying Advertisement Links onto the main screen
		 */
		
		
		public void loadingAdvertisementImg(JButton btnAdvLink, String url_link,int x,int y, int width, int height) {
			URL url = null;
			url = getClass().getResource(url_link);
			
			BufferedImage originalImage = null;
			try {
				originalImage = ImageIO.read(getClass().getResource(url_link));
			} catch (IOException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
			int type = originalImage.getType() == 0? BufferedImage.TYPE_INT_ARGB : originalImage.getType();
			BufferedImage resizedImage = new BufferedImage(width, height, type);
			Graphics2D g = resizedImage.createGraphics();
			g.drawImage(originalImage, 0, 0, width, height, null);
			g.dispose();
			btnAdvLink.setIcon(new ImageIcon(resizedImage));
			btnAdvLink.setFont(new Font("Arial", Font.BOLD, 12));
			btnAdvLink.setBounds(x, y, width, height);
		}	
}
