package com.tin.tds.tanContact.util;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Types;


import com.tin.tds.tanContact.util.Log;

public class DBUtility {

	public int insertInTanContactMaster(String tan,String email,String altEmail,String mobileNo,String type,java.util.Date date,String respPerName,Connection obj_DbConn) throws Exception
	{
		PreparedStatement pStmt = null;
		ResultSet rs =null;
		
		try
		{		
			Log.tds_log.debug("Entering insertInTanContactMaster() method for TAN:"+tan);
			pStmt = obj_DbConn.prepareStatement(Parameters.getInsertQuery());
				
			pStmt.setString(1, tan);
			pStmt.setString(2, email);
			if(altEmail.equals("NA"))
				pStmt.setNull(3, Types.VARCHAR);
			else
				pStmt.setString(3,altEmail);
			if(mobileNo.equals("NA"))
				pStmt.setNull(4, Types.VARCHAR);
			else
				pStmt.setString(4, mobileNo);
			if(respPerName.equals("NA"))
				pStmt.setNull(5, Types.VARCHAR);
			else
				pStmt.setString(5,respPerName);
			pStmt.setString(6, type);
			pStmt.setDate(7, new java.sql.Date(date.getTime()));
			
			int check=pStmt.executeUpdate();
			if(check==1)
			{
				Log.tds_log.debug("Insert successful for TAN:"+tan);
				return 0;
			}
			/*if(check!=1)
			{
				 Log.tds_log.error("Error while inserting the TAN "+tan+ " in TDS.TDS_TAN_CONTACT_MASTER table");
				 throw new Exception("Exception while inserting in TDS.TDS_TAN_CONTACT_MASTER table");
			}*/
			
		}
		catch(SQLException se)
		{
			if(se.getSQLState().equals("23503") || se.getErrorCode()==-530)
			{
				Log.tds_log.debug("Insert failed for TAN:"+tan);
				return 1;
			}
		}
		catch(Exception e)
		{
			 Log.tds_log.error("DBUtility.java insertTanInContactMaster(): Exception Occurred:" ,e);
			 throw new Exception(e.toString(), e);
		}
		
		finally
		{
			try
			{	
				if(rs!=null)
					rs.close();
			if(pStmt !=null)				
				pStmt.close();
			}
			catch (Exception e) {
				Log.tds_log.error(
						"Exception while closing the statement  in insertTanInContactMaster() method   Exception is : " + e);
				throw new Exception(e.toString(), e);
			}
		}
		return 0;
	}
	
/*	public String checkTanInContactMaster(String tan,Connection objConnection) throws Exception
	{
		PreparedStatement pStmt = null;
		ResultSet rs =null;
		try
		{
			pStmt=objConnection.prepareStatement(Parameters.getCheckTan());
			pStmt.setString(1, tan);
			pStmt.execute();
			
			rs = pStmt.getResultSet();
			if(rs.next())
			{
				return rs.getString(1)+"^"+rs.getString(2)+"^"+(rs.getDate(3)).toString();
			}
			else
			{
				if(pStmt !=null)				
					pStmt.close();
				if(rs!=null)
					rs.close();
				return "";
			}

		}
		catch(Exception e)
		{
			
		}
		finally
		{
			try
			{			
			if(pStmt !=null)				
				pStmt.close();
			if(rs!=null)
				rs.close();
			}
			catch (Exception e) {
				Log.tds_log.error(
						"Exception while closing the statement  in checkTanInContactMaster() method   Exception is : " + e);
				throw new Exception(e.toString(), e);
			}
		}
		return "";
	}*/
	public int updateInTanContactMaster(String tan,String email,String altEmail,String mobileNo,String respPerName,String type,java.util.Date date,Connection obj_DbConn) throws Exception
	{
		PreparedStatement pStmt = null;
		
		
		try
		{	
			Log.tds_log.debug("Entering updateInTanContactMaster() method for TAN:"+tan);
			pStmt=obj_DbConn.prepareStatement(Parameters.getInsertIntoAuditQuery());
			pStmt.setString(1, tan);
			int check1=0;
			check1=pStmt.executeUpdate();
			if(check1==1)
			{
				Log.tds_log.debug("Inserted successfully into audit table for TAN:"+tan);
			}
			else if (check1==0)
			{
				Log.tds_log.debug("No Record Found for insert into audit table for TAN:"+tan);
				return 1;			
			}
			else
			{
				
			}
			
			if(pStmt!=null)
				pStmt.close();
			
			if(type.equals("TAN-REG"))
			{
				pStmt = obj_DbConn.prepareStatement(Parameters.getUpdateQuery());
				pStmt.setString(1, email);
				if(altEmail.equals("NA"))
					pStmt.setNull(2, Types.VARCHAR);
				else
					pStmt.setString(2,altEmail);
				if(mobileNo.equals("NA"))
					pStmt.setNull(3, Types.VARCHAR);
				else
					pStmt.setString(3, mobileNo);
				if(respPerName.equals("NA"))
					pStmt.setNull(4, Types.VARCHAR);
				else
					pStmt.setString(4,respPerName);
					
				pStmt.setString(5, type);
				pStmt.setDate(6, new java.sql.Date(date.getTime()));
				pStmt.setString(7, tan);
			}
			else if (type.equals("FILE-PROC"))
			{
				pStmt = obj_DbConn.prepareStatement(Parameters.getUpdateQueryForFileProc());
				pStmt.setString(1, email);
				if(altEmail.equals("NA"))
					pStmt.setNull(2, Types.VARCHAR);
				else
					pStmt.setString(2,altEmail);
				if(mobileNo.equals("NA"))
					pStmt.setNull(3, Types.VARCHAR);
				else
					pStmt.setString(3, mobileNo);
				if(respPerName.equals("NA"))
					pStmt.setNull(4, Types.VARCHAR);
				else
					pStmt.setString(4,respPerName);
					
				pStmt.setString(5, type);
				pStmt.setDate(6, new java.sql.Date(date.getTime()));
				pStmt.setString(7, tan);
				pStmt.setDate(8, new java.sql.Date(date.getTime()));
			}
			else
			{
				
			}
			
			
			int check=pStmt.executeUpdate();
			if(check==1)
			{
				Log.tds_log.debug("Update successful for TAN:"+tan);
				return 0;
			}
			else if (check==0)
			{
				Log.tds_log.debug("No Record Found for update of TAN:"+tan);
				return 1;			
			}
			else
			{
				
			}
			
			/*if(check!=1)
			{
				 Log.tds_log.error("Error while updating the TAN "+tan+ " in TDS.TDS_TAN_CONTACT_MASTER table");
				 throw new Exception("Exception while updating in TDS.TDS_TAN_CONTACT_MASTER table");
			}*/
			
		}
		/*catch(SQLException se)
		{
			if(se.getSQLState().equals("02000") || se.getErrorCode()==100)
			{
				Log.tds_log.debug("No Record Found for update of TAN:"+tan);
				return 1;
			}
		}*/
		catch(Exception e)
		{
			 Log.tds_log.error("DBUtility.java updateInTanContactMaster(): Exception Occurred:" ,e);
			 throw new Exception(e.toString(), e);
		}
		
		finally
		{
			try
			{	
				
			if(pStmt !=null)				
				pStmt.close();
			}
			catch (Exception e) {
				Log.tds_log.error(
						"Exception while closing the statement  in updateInTanContactMaster() method   Exception is : " + e);
				throw new Exception(e.toString(), e);
			}
		}
		return 0;
	}
}
