package com.tin.framework.common.logging;

import org.apache.log4j.Logger;

public class LoggingManager {
	
	private static final String LOG_MESSAGE_DELIMITER = "^";
	
	public static Logger getLogger(String className){
		return Logger.getLogger( className );
	}
	
	public static void info(	
		Logger logger,
		String methodName,
		String message,
		Object[] objects) {

			
			if (logger.isInfoEnabled()) {

				logger.info(
				(new StringBuffer())				
					.append("Method:")
					.append(methodName)
					.append(LOG_MESSAGE_DELIMITER)
					.append(message)
					.append(LOG_MESSAGE_DELIMITER)
					.append(
						LoggingManagerUtils.convertObjectArrayToString(
							objects))
					.toString());
			}

		}

	public static void warn(	
		Logger logger,
		String methodName,
		String message,
		Object[] objects) {
			
			logger.warn(
			(new StringBuffer())			
			    .append("Method:")
				.append(methodName)
				.append(LOG_MESSAGE_DELIMITER)
				.append(message)
				.append(LOG_MESSAGE_DELIMITER)
				.append(
					LoggingManagerUtils.convertObjectArrayToString(
						objects))
				.toString());
			
	}
	
	public static void error(
		Logger logger,
		String methodName,
		String message,
		Object[] objects) {

		
			logger.error(
			(new StringBuffer())			
				.append("Method:")
				.append(methodName)
				.append(LOG_MESSAGE_DELIMITER)
				.append(message)
				.append(LOG_MESSAGE_DELIMITER)
				.append(
					LoggingManagerUtils.convertObjectArrayToString(
						objects))
				.toString());
			
	}
		
	public static void exception (
		
		Logger logger,
		String methodName,
		String message,
		Throwable exception){

			
			logger.error(
			(new StringBuffer())			
				.append("Method:")
				.append(methodName)
				.append(LOG_MESSAGE_DELIMITER)
				.append(message), exception	);
					
	}

	public static void fatal(

		Logger logger,
		String methodName,
		String message,
		Object[] objects) {

	
		logger.fatal(
		(new StringBuffer())			
			.append("Method:")
			.append(methodName)
			.append(LOG_MESSAGE_DELIMITER)
			.append(message)
			.append(LOG_MESSAGE_DELIMITER)
			.append(
				LoggingManagerUtils.convertObjectArrayToString(
					objects))
			.toString());
	}

		
		
	public static void debug(
		Logger logger,
		String methodName,
		String message,
		Object[] objects) {
		
		
		if (logger.isDebugEnabled()) {
			
			
			
			logger.debug(
				(new StringBuffer())					
					.append("Method:")
					.append(methodName)
					.append(LOG_MESSAGE_DELIMITER)
					.append(message)
					.append(LOG_MESSAGE_DELIMITER)
					.append(
						LoggingManagerUtils.convertObjectArrayToString(
							objects))
					.toString());
			
		}
	}

	public static void info(	
			Logger logger,
			String methodName,
			String message
			) {
			
		LoggingManager.info(logger,methodName, message, null);
	}
	
	public static void debug(
			Logger logger,
			String methodName,
			String message
			) {
			
		LoggingManager.debug(logger,methodName, message, null);
	}
	
	public static void warn(	
			Logger logger,
			String methodName,
			String message
			) {
			
		LoggingManager.warn(logger,methodName, message, null);
	}
	public static void error(	
			Logger logger,
			String methodName,
			String message
			) {
			
		LoggingManager.error(logger,methodName, message, null);
	}
	
	public static void fatal(
			Logger logger,
			String methodName,
			String message
			) {
			
		LoggingManager.fatal(logger,methodName, message, null);
	}
	
	
	public static void info(	
			String className,
			String methodName,
			String message
			) {
			
		LoggingManager.info(className,methodName, message, null);
	}
	
	public static void debug(
			String className,
			String methodName,
			String message
			) {
			
		LoggingManager.debug(className,methodName, message, null);
	}
	
	public static void warn(	
			String className,
			String methodName,
			String message
			) {
			
		LoggingManager.warn(className,methodName, message, null);
	}
	public static void error(	
			String className,
			String methodName,
			String message
			) {
			
		LoggingManager.error(className,methodName, message, null);
	}
	
	public static void fatal(
			String className,
			String methodName,
			String message
			) {
			
		LoggingManager.fatal(className,methodName, message, null);
	}
	
	public static void info(	
	String className,
	String methodName,
	String message,
	Object[] objects) {

		Logger logger = Logger.getLogger( className );
		LoggingManager.info(logger,methodName, message, objects);
		

	}

	public static void warn(	
	String className,
	String methodName,
	String message,
	Object[] objects) {

		
		Logger logger = Logger.getLogger( className );		
		LoggingManager.warn(logger,methodName, message, objects);
	}

	public static void error(
	
	String className,
	String methodName,
	String message,
	Object[] objects) {

		Logger logger = Logger.getLogger( className );
		LoggingManager.error(logger,methodName, message, objects);
		
	}
	
	public static void exception (
	
			String className,
			String methodName,
			String message,
			Throwable exception){

			Logger logger = Logger.getLogger( className );
			LoggingManager.exception(logger,methodName, message, exception);
				
	}

	public static void fatal(

	String className,
	String methodName,
	String message,
	Object[] objects) {

		Logger logger = Logger.getLogger( className );
		LoggingManager.fatal(logger,methodName, message, objects);
	}

	
	
	public static void debug(

		String className,
		String methodName,
		String message,
		Object[] objects) {
		
		Logger logger = Logger.getLogger( className );
		LoggingManager.debug(logger,methodName, message, objects);
	}

	



}
