package com.tin.framework.common.util;

public class Common
{
	/**
	 * Checks For the passed parameter If field is not integer then returns true else false
	 * @param field
	 * @return boolean (status of int field)
	 */
	public static boolean isInt(String field)
	{
		int length = field.length();
		for (int j = 0; j < length; j++)
		{
			char ch = field.charAt(j);
			if (!Character.isDigit(ch))
			{
				return true; // error!
			}
		}
		return false;
	}
	/**Checks For the passed parameter If field is not Double then returns true else false
	 * @param field
	 * @return
	 */
	public static boolean isDouble(String field)
	{
		int pointCounter = 0;

		if (field.substring(0, 1).equals("+") || field.substring(0, 1).equals("-"))
		{

			field = field.substring(1, field.length());

		}
		boolean error = false;
		int length = field.length();
		for (int j = 0; j < length; j++)
		{

			if (!Character.isDigit(field.charAt(j)))
			{

				if (field.charAt(j) == '.')
				{

					pointCounter++;

				}
				else
				{

					error = true;

				}
			}
		}
		if (pointCounter > 1)
		{
			error = true;

		}

		return error;
	}
	

	
	/**Checks For the passed parameter If field is not Alphabet(A-Z,a-z),Numeric(0-9) then returns true else false
	 * @param field
	 * @return
	 */
	public static boolean isAlphaNum(String field)
	{
		int length = field.length();
		for (int j = 0; j < length; j++)
		{
			if (!Character.isLetterOrDigit(field.charAt(j)))
			{
				return true;
			}
		}
		return false;
	} //end of AlNum

	/**
	 * Checks For the passed parameter If field is not Alphabet(A-Z,a-z),Numeric(0-9),space(" ") then returns true else false
	 * @param field (String which is already trimed)
	 * @return
	 */
	public static boolean isAlphaNumSpace(String field)
	{
		int length = field.length();
		for (int j = 0; j < length; j++)
		{
			if (!(Character.isLetterOrDigit(field.charAt(j)) || field.charAt(j) == ' '))
			{
				return true;
			}
		}
		return false;
	} //end of AlNum

	/**Checks For the passed parameter If field is not valid date then returns true else false
	 * 
	 * ValidateDate is class defined to check the date, checkValidation() method in ValidateDate is called to valid the string date in ddmmyy format
	 * 
	 * @param date1
	 * @return
	 */
	public static boolean isDate(String date1) //date in ddmmyy form
	{
		if (isInt(date1) || (date1.length() != 6))
		{
			return true;
		}
		boolean errorDate = false;

		String yy = date1.substring(4, 6);
		String mm = date1.substring(2, 4);
		String dd = date1.substring(0, 2);
		//ValidateDate valDate = new ValidateDate();
		try
		{
			int year = Integer.parseInt(yy);
			int month = Integer.parseInt(mm);
			int day = Integer.parseInt(dd);
			if (year >= 50)
			{
				year = 1900 + year;
			}
			else
			{
				year = 2000 + year;
			}
			if (ValidateDate.checkValidation(year, month, day))
			{
				errorDate = false;
			}
			else
			{
				errorDate = true;
			}
		}
		catch (Exception e)
		{
			//System.out.println(" Error "+e.getMessage());
			errorDate = true;
		}
		return errorDate;
	} //end of valdate

	/**
	 * Checks For the passed parameter and filter out the PrintableChar if NonPrintableChar enters  then returns true else false
	 * @param s
	 * @return
	 */
	public static boolean isNonPrintableChar(String field)
	{
		int length = field.length();
		for (int j = 0; j < length; j++)
		{
			if (!(Character.isLetterOrDigit(field.charAt(j))
				|| field.charAt(j) == ' '
				|| field.charAt(j) == '!'
				|| field.charAt(j) == '@'
				|| field.charAt(j) == '#'
				|| field.charAt(j) == '$'
				|| field.charAt(j) == '%'
				|| field.charAt(j) == '^'
				|| field.charAt(j) == '&'
				|| field.charAt(j) == '*'
				|| field.charAt(j) == '('
				|| field.charAt(j) == ')'
				|| field.charAt(j) == '{'
				|| field.charAt(j) == '}'
				|| field.charAt(j) == '['
				|| field.charAt(j) == ']'
				|| field.charAt(j) == '|'
				|| field.charAt(j) == '\\'
				|| field.charAt(j) == '-'
				|| field.charAt(j) == '_'
				|| field.charAt(j) == '+'
				|| field.charAt(j) == '='
				|| field.charAt(j) == '~'
				|| field.charAt(j) == '`'
				|| field.charAt(j) == ':'
				|| field.charAt(j) == ';'
				|| field.charAt(j) == '<'
				|| field.charAt(j) == '>'
				|| field.charAt(j) == '/'
				|| field.charAt(j) == ','
				|| field.charAt(j) == '.'
				|| field.charAt(j) == '"'
				|| field.charAt(j) == '\''))
			{
				return true;
			}
		}
		return false;
	} // end of Printable

	/**
	 * Checks For the passed parameter If field is not Alphabet(A-Z,a-z),space(" ")then returns true else false
	 * @param s
	 * @return
	 */
	public static boolean isAlphaSpace(String s)
	{
		int length = s.length();
		for (int i = 0; i < length; i++)
		{
			System.out.println("Char is" + s.charAt(i));
			if (!(Character.isLetter(s.charAt(i)) || s.charAt(i) == ' '))
			{
				return true;
			}
		}
		return false;
	}
	public static boolean isName(String field)
	{
		int alphaCount = 0;
		int length = field.length();
		for (int i = 0; i < length; i++)
		{
			if ((Character.isLetter(field.charAt(i))))
			{
				alphaCount++;
			}
		}
		if (alphaCount > 1)
		{
			for (int i = 0; i < length; i++)
			{
				if (!(Character.isLetterOrDigit(field.charAt(i)) || field.charAt(i) == ' ' || field.charAt(i) == '.'))
				{
					return true;
				}

			}
		}
		else
		{
			return true;
		}
		return false;
	} // end of isname

	/* This function will compare two dates if that dates are same then return 0,
	if first date is greater than second than return -1 else return 1.
	*/
	public static int compareDate(String date1, String date2)
	{
		//String yy1 = date1.substring(4, 6);
		int yy1 = Integer.parseInt(date1.substring(4, 6));
		int mm1 = Integer.parseInt(date1.substring(2, 4));
		int dd1 = Integer.parseInt(date1.substring(0, 2));
		int yy2 = Integer.parseInt(date2.substring(4, 6));
		int mm2 = Integer.parseInt(date2.substring(2, 4));
		int dd2 = Integer.parseInt(date2.substring(0, 2));
		int year1;
		int year2;
		if (yy1 >= 50)
		{
			year1 = 1900 + yy1;
		}
		else
		{
			year1 = 2000 + yy1;
		}
		if (yy2 >= 50)
		{
			year2 = 1900 + yy2;
		}
		else
		{
			year2 = 2000 + yy2;
		}
		if (year2 > year1)
		{
			return 1;
		}
		else
		{
			if (year2 < year1)
			{
				return -1;
			}
			else
			{
				if (mm2 > mm1)
				{
					return 1;
				}
				else
				{
					if (mm2 < mm1)
					{
						return -1;
					}
					else
					{
						if (dd2 > dd1)
						{
							return 1;
						}
						else
						{
							if (dd2 < dd1)
							{
								return -1;
							}
						}
					}
				}
			}
			return 0;
		}
	}
	public static boolean isletter(String field)
	{
		int length = field.length();
		for (int j = 0; j < length; j++)
		{
			char ch = field.charAt(j);
			if (!Character.isLetter(ch))
			{
				return true; // error!
			}
		}
		return false;

	}
	public static boolean isAssYear(String field, String fileDate)
	{
		if (isInt(field))
		{
			return true;
		}
		else
		{
			int yy = Integer.parseInt(fileDate.substring(4, 6));
			int mm = Integer.parseInt(fileDate.substring(2, 4));
			int dd = Integer.parseInt(fileDate.substring(0, 2));
			int year;
			if (yy >= 50)
			{
				year = 1900 + yy;
			}
			else
			{
				year = 2000 + yy;
			}
			/*Changed for ass yr <4, Dated on 27-08-04 */
			if (mm >= 4)
			{
				year = year + 1;
			}
			if (Integer.parseInt(field) < 1961 || Integer.parseInt(field) > year)
			{
				return true;
			}
		}
		return false;
	}
	//function to validate the date format and ensure that the fromdate is less than todate
	public static boolean viewsDateVal(String fromDate, String toDate)
	{
		//for fromdate
		int ifdDay = 0;
		int ifdMonth = 0;
		int ifdYear = 0;
		boolean error = false;
		String fdDay = fromDate.substring(8, 10);

		String fdMonth = fromDate.substring(5, 7);

		String fdYear = fromDate.substring(0, 4);

		//for todate
		int itoDay = 0;
		int itoMonth = 0;
		int itoYear = 0;
		String toDay = toDate.substring(8, 10);

		String toMonth = toDate.substring(5, 7);

		String toYear = toDate.substring(0, 4);

		//for leap year
		int fromdleap = 0;
		int todleap = 0;
		//System.out.println(fromDate.charAt(7));
		if (fromDate.charAt(4) != '-' || fromDate.charAt(7) != '-' || toDate.charAt(4) != '-' || toDate.charAt(7) != '-')
		{
			error = true;
			return error;
		}

		if (isInt(fdDay) || isInt(fdMonth) || isInt(fdYear) || isInt(toDay) || isInt(toMonth) || isInt(toYear))
		{
			error = true;
			return error;
		}

		ifdDay = Integer.parseInt(fdDay);
		ifdMonth = Integer.parseInt(fdMonth);
		ifdYear = Integer.parseInt(fdYear);
		itoDay = Integer.parseInt(toDay);
		itoMonth = Integer.parseInt(toMonth);
		itoYear = Integer.parseInt(toYear);

		if ((ifdYear % 4 == 0) && (ifdYear % 100 != 0 || ifdYear % 400 == 0))
		{
			fromdleap = 1;
		}
		if ((ifdDay < 1) || (ifdDay > 31) || (ifdMonth < 1) || (ifdMonth > 12))
			error = true;
		if (fromdleap == 0 && (ifdMonth == 2) && (ifdDay > 28))
			error = true;
		if (fromdleap == 1 && (ifdMonth == 2) && (ifdDay > 29))
			error = true;
		if (((ifdMonth == 4) || (ifdMonth == 6) || (ifdMonth == 9) || (ifdMonth == 11)) && (ifdDay > 30))
			error = true;

		if ((itoYear % 4 == 0) && (itoYear % 100 != 0 || itoYear % 400 == 0))
		{
			todleap = 1;
		}
		if ((itoDay < 1) || (itoDay > 31) || (itoMonth < 1) || (itoMonth > 12))
			error = true;
		if (todleap == 0 && (itoMonth == 2) && (itoDay > 28))
			error = true;
		if (todleap == 1 && (itoMonth == 2) && (itoDay > 29))
			error = true;
		if (((itoMonth == 4) || (itoMonth == 6) || (itoMonth == 9) || (itoMonth == 11)) && (itoDay > 30))
			error = true;
		if (error)
		{
			return error;
		}

		int d1;
		int d2;
		d1 = Integer.parseInt(fdYear + fdMonth + fdDay);
		d2 = Integer.parseInt(toYear + toMonth + toDay);
		if (d2 < d1)
		{
			error = true;
			return error;
		}

		return error;
	}
}
