
package com.tin.framework.database;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Hashtable;

import javax.naming.Context;
import javax.naming.InitialContext;
import javax.sql.DataSource;

import com.tin.framework.common.logging.LoggingManager;


public class DbConnection {
	
	private String loggerClassName="DbConnection";
    
    
	 public String getLoggerClassName() {
		return loggerClassName;
	}


	public void setLoggerClassName(String loggerClassName) {
		this.loggerClassName = loggerClassName;
	}
	
	private static final String WAS_FACTORY="com.ibm.websphere.naming.WsnInitialContextFactory";
	public Connection getConnection(String datasourceName) {
		Connection con = null;
		try {
			DataSource ds;
			Hashtable parms = new Hashtable();
			parms.put(Context.INITIAL_CONTEXT_FACTORY,WAS_FACTORY);
			Context context = new InitialContext(parms);
			ds = (DataSource) context.lookup(datasourceName);
			con = ds.getConnection();
			return (con);
		} catch (Exception e) {
			try {
				if(!con.equals(null)&& !con.isClosed())
					{
						closeConnection(con);
					}
				LoggingManager.error(loggerClassName,"getConnection()","General Exception in DbConnection "+e.getMessage());
				e.printStackTrace();
			}
			catch (Exception e1) {
				LoggingManager.error(loggerClassName,"getConnection()","General Exception in DbConnection while closing the DataBase Connection "+e1.getMessage());
				e1.printStackTrace();
			}
		}
		return (con);
	}
	
	public void closeConnection(Connection con) {
		try
		{
			con.close();
		}
		catch(SQLException e) {
			LoggingManager.error(loggerClassName,"getConnection()","SQL Exception in DbConnection while closing the DataBase Connection "+e.getMessage());
			e.printStackTrace();
		}
		catch(Exception e){
			LoggingManager.error(loggerClassName,"getConnection()","General Exception in DbConnection while closing the DataBase Connection "+e.getMessage());
			e.printStackTrace();
		}
	
	}
}
