
package com.tin.framework.messaging
;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.QueueSender;
import javax.jms.QueueSession;
import javax.jms.Session;
import javax.jms.TextMessage;
import javax.naming.InitialContext;
import javax.naming.NamingException;

import com.tin.framework.common.logging.LoggingManager;


public class JmsConnection {
     private String loggerClassName="JmsConnection";
     
     
	 public String getLoggerClassName() {
		return loggerClassName;
	}


	public void setLoggerClassName(String loggerClassName) {
		this.loggerClassName = loggerClassName;
	}


	public void callQ(
		String Qname,
		String msg,
		String QConFac) {
			QueueSender sender = null;
			QueueSession qSession = null;
			QueueConnection qConnection = null;
		try {

			InitialContext context = null;
			context = new InitialContext();
			QueueConnectionFactory qConnectionFactory = null;
			qConnectionFactory =
				(QueueConnectionFactory) context.lookup(QConFac);

			Queue queue = null;
			LoggingManager.info(loggerClassName,"callQ","Context Lookup of Queue"+Qname);
			queue = (Queue) context.lookup(Qname);
			
			LoggingManager.info(loggerClassName,"callQ","Created QConnection Factory of Queue"+Qname);
			qConnection = qConnectionFactory.createQueueConnection();
			
			qSession =
				qConnection.createQueueSession(false, Session.AUTO_ACKNOWLEDGE);
				
			LoggingManager.info(loggerClassName,"callQ","QConnection and QSession are created");
			
			sender = qSession.createSender(queue);

			TextMessage message = null;
			message = qSession.createTextMessage();
			message.setText(msg);
		//	message.setStringProperty("MessageProperty", MessageProperty);
			sender.send(message);
			sender.close();			
			qSession.close();
			qConnection.close();
			LoggingManager.info(loggerClassName,"callQ","QSession QConnection are closed for "+Qname);


		} catch (NamingException e) {

			try {
		
				sender.close();
				qSession.close();
				qConnection.close();

				LoggingManager.error(loggerClassName,"callQ", "Naming Exception in JMS jmsConnectionClass"+e.getMessage());
				e.printStackTrace();
				} 
			catch (Exception e1) {
				
				LoggingManager.error(loggerClassName,"callQ","Naming Exception in JMS jmsConnectionClass while closing the JMSConnection "+e1.getMessage());
				e1.printStackTrace();
			}
			//System.out.println("Naming Exception in JMS jmsConnectionClass"+e.getMessage());

		} catch (Exception e) {

			try {
		
				sender.close();
				qSession.close();
				qConnection.close();

				LoggingManager.error(loggerClassName,"callQ","General Exception in JMS jmsConnectionClass"+e.getMessage());
				e.printStackTrace();
			}
			catch (Exception e1) {
				
				LoggingManager.error(loggerClassName,"callQ","General Exception in JMS jmsConnectionClass while closing the JMSConnection "+e1.getMessage());
				e1.printStackTrace();
			}
			//System.out.println("General Exception in JMS jmsConnectionClass"+e.getMessage());
			}
	}
}
