/**
 * Classname			:	Parameters.java
 * 
 * Version information  :	1
 * 
 * Date					:	September 16, 2011
 * 
 * Copyright notice		:	TCS
 */

package com.tin.tds.tanContact.util;

import java.io.File;
import java.io.FileInputStream;
import java.util.Properties;

//import com.tin.tds.util.Log;
import com.tin.tds.tanContact.util.Log;

public class Parameters
{
	private static String db_url = null; // database provider url
	private static String username = null; // database connection username
	private static String password = null; // database connection password

	private static String insertQuery=null;	
	//private static String checkTan=null;
	private static String updateQuery=null;
	private static String updateQueryForFileProc=null;
	private static String insertIntoAuditQuery=null;
	
	

	static {
		Properties prop_tin = new Properties();
		try
		{
			prop_tin.load(new FileInputStream(new File("/Websphere/AppServer/profiles/AppSrv01/tin_config/tanContactMstrPop.properties")));
			db_url = prop_tin.getProperty("DB_url");
			username = prop_tin.getProperty("DB_userid");
			password = prop_tin.getProperty("DB_password");
						
			
			insertQuery="INSERT INTO TDS.TDS_TAN_CONTACT_MASTER (TAN_PK,EMAIL_ID,ALT_EMAIL_ID,MOBILE_NO,RESP_PER_NAME,SRC_FLAG,UPDT_DATE) VALUES (?,?,?,?,?,?,?)";
			//checkTan="SELECT TAN_PK,SRC_FLAG,UPDT_DATE FROM TDS.TDS_TAN_CONTACT_MASTER WHERE TAN_PK = ? WITH UR";
			updateQuery="UPDATE TDS.TDS_TAN_CONTACT_MASTER SET EMAIL_ID=?,ALT_EMAIL_ID=?,MOBILE_NO=?,RESP_PER_NAME=?,SRC_FLAG=?,UPDT_DATE=? WHERE TAN_PK=?";
			updateQueryForFileProc="UPDATE TDS.TDS_TAN_CONTACT_MASTER SET EMAIL_ID=?,ALT_EMAIL_ID=?,MOBILE_NO=?,RESP_PER_NAME=?,SRC_FLAG=?,UPDT_DATE=? WHERE TAN_PK=? AND SRC_FLAG = 'FILE-PROC' AND UPDT_DATE<=?";
			insertIntoAuditQuery="INSERT INTO TDS.TDS_TAN_CONTACT_MASTER_A (TAN_PK,EMAIL_ID,ALT_EMAIL_ID,MOBILE_NO,RESP_PER_NAME,SRC_FLAG,UPDT_DATE,AUDIT_TMSTMP) SELECT TAN_PK,EMAIL_ID,ALT_EMAIL_ID,MOBILE_NO,RESP_PER_NAME,SRC_FLAG,UPDT_DATE,CURRENT TIMESTAMP from TDS.TDS_TAN_CONTACT_MASTER WHERE TAN_PK = ?";
			 
		}
		catch (Exception e)
		{
			//e.printStackTrace();
			Log.tds_log.error(
				"Parameters.java Exception .. Error Reading from Property file ..." , e);
		}
	}



	public static String getDb_url() {
		return db_url;
	}



	public static void setDb_url(String dbUrl) {
		db_url = dbUrl;
	}



	public static String getUsername() {
		return username;
	}



	public static void setUsername(String username) {
		Parameters.username = username;
	}



	public static String getPassword() {
		return password;
	}



	public static void setPassword(String password) {
		Parameters.password = password;
	}





	public static String getInsertQuery() {
		return insertQuery;
	}



	public static void setInsertQuery(String insertQuery) {
		Parameters.insertQuery = insertQuery;
	}




	public static String getUpdateQuery() {
		return updateQuery;
	}



	public static void setUpdateQuery(String updateQuery) {
		Parameters.updateQuery = updateQuery;
	}



	public static String getUpdateQueryForFileProc() {
		return updateQueryForFileProc;
	}



	public static void setUpdateQueryForFileProc(String updateQueryForFileProc) {
		Parameters.updateQueryForFileProc = updateQueryForFileProc;
	}



	public static String getInsertIntoAuditQuery() {
		return insertIntoAuditQuery;
	}



	public static void setInsertIntoAuditQuery(String insertIntoAuditQuery) {
		Parameters.insertIntoAuditQuery = insertIntoAuditQuery;
	}









			
}