package com.tin.common.log;

import java.util.ArrayList;

import org.apache.log4j.Logger;

import com.tin.common.resources.CommonConstants;
import com.tin.common.util.LoggingManagerUtils;

public class LoggingManager {
	private static boolean isDebugEnabled = false;

	private static boolean proceedFlag = false;

	
	public static void info(
	Logger logger,
	String ApplicationId,
	String ModuleName,
	String methodName,
	String message,
	Object[] objects) {

		
		if (logger.isInfoEnabled()) {

			logger.info(
			(new StringBuffer())
				.append(CommonConstants.LOG_MESSAGE_DELIMITER)
				.append(ApplicationId)
				.append(CommonConstants.LOG_MESSAGE_DELIMITER)
				.append(ModuleName)
				.append(CommonConstants.LOG_MESSAGE_DELIMITER)
				.append(methodName)
				.append(CommonConstants.LOG_MESSAGE_DELIMITER)
				.append(message)
				.append(
					LoggingManagerUtils.convertObjectArrayToString(
						objects))
				.toString());
		}
		//Health.getInstance().keepCounting("COMMON_LOGGING_4",
		//                System.currentTimeMillis() - startTime1);

	}

	public static void warn(
	Logger logger,
	String ApplicationId,
	String ModuleName,
	String methodName,
	String message,
	Object[] objects) {

		long startTime1 = System.currentTimeMillis();

		logger.warn(
		(new StringBuffer())
			.append(CommonConstants.LOG_MESSAGE_DELIMITER)
			.append(ApplicationId)
			.append(CommonConstants.LOG_MESSAGE_DELIMITER)
			.append(ModuleName)
			.append(CommonConstants.LOG_MESSAGE_DELIMITER)
			.append(methodName)
			.append(CommonConstants.LOG_MESSAGE_DELIMITER)
			.append(message)
			.append(
				LoggingManagerUtils.convertObjectArrayToString(
					objects))
			.toString());
		//Health.getInstance().keepCounting("COMMON_LOGGING_5",
		//                System.currentTimeMillis() - startTime1);
	}

	public static void error(
	Logger logger,
	String applicationId,
	String moduleName,
	String methodName,
	String message,
	Object[] objects) {

		long startTime1 = System.currentTimeMillis();
		logger.error(
		(new StringBuffer())
			.append(CommonConstants.LOG_MESSAGE_DELIMITER)
			.append(applicationId)
			.append(CommonConstants.LOG_MESSAGE_DELIMITER)
			.append(moduleName)
			.append(CommonConstants.LOG_MESSAGE_DELIMITER)
			.append(methodName)
			.append(CommonConstants.LOG_MESSAGE_DELIMITER)
			.append(message)
			.append(
				LoggingManagerUtils.convertObjectArrayToString(
					objects))
			.toString());
		//Health.getInstance().keepCounting("COMMON_LOGGING_6",
		//                System.currentTimeMillis() - startTime1);
	}

	public static void fatal(
	Logger logger,
	String applicationId,
	String moduleName,
	String methodName,
	String message,
	Object[] objects) {

		
		logger.fatal(
		(new StringBuffer())
			.append(CommonConstants.LOG_MESSAGE_DELIMITER)
			.append(applicationId)
			.append(CommonConstants.LOG_MESSAGE_DELIMITER)
			.append(moduleName)
			.append(CommonConstants.LOG_MESSAGE_DELIMITER)
			.append(methodName)
			.append(CommonConstants.LOG_MESSAGE_DELIMITER)
			.append(message)
			.append(
				LoggingManagerUtils.convertObjectArrayToString(
					objects))
			.toString());
		//Health.getInstance().keepCounting("COMMON_LOGGING_7",
		//                System.currentTimeMillis() - startTime1);
	}

	
	public static boolean isDebugEnabled(Logger logger) {
		//        long startTime1 = System.currentTimeMillis();
		if (!proceedFlag) {

			isDebugEnabled = logger.isDebugEnabled();
			System.out.println(
				">>>Inside isDebugEnabled and isDebugEnabled is:"
					+ isDebugEnabled);
			proceedFlag = true;

		}
		//Health.getInstance().keepCounting("COMMON_ENABLING_LOGGER", System.currentTimeMillis()-startTime1);
		return isDebugEnabled;

	}
	public static void debug(
		Logger logger,
		String ApplicationId,
		String ModuleName,
		String className,
		String methodName,
		String message,
		Object[] objects) {

		if (isDebugEnabled(logger)) {

			logger.debug(
				(new StringBuffer())
					.append(CommonConstants.LOG_MESSAGE_DELIMITER)
					.append(ApplicationId)
					.append(CommonConstants.LOG_MESSAGE_DELIMITER)
					.append(ModuleName)
			        .append(CommonConstants.LOG_MESSAGE_DELIMITER)
					.append("ClassName:")
					.append(className)
					.append(CommonConstants.LOG_MESSAGE_DELIMITER)
					.append("Method:")
					.append(methodName)
					.append(CommonConstants.LOG_MESSAGE_DELIMITER)
					.append(message)
					.append(
						LoggingManagerUtils.convertObjectArrayToString(
							objects))
					.toString());

		}
	}

	public static void main(String[] args) {

		ArrayList s = new ArrayList();
		s.add(0, "rahul");
		s.add(0, "rahul1");
		s.add(0, "rahul2");

		TestTO test = new TestTO();
		test.setFirstArg("ram");
		test.setSecondArg("rahim");
		test.setI(6);

		try {
			Object[] object =
				{ "size:", new Integer(9), "ArryList:", s, "testTO", test };
			//LoggingManager.debug(logger,"MINISTMNT","RT10","doSomething","Entering Method with Paramters:",object);
		} catch (Exception e) {
			e.printStackTrace();
		}

	}

}
