package com.tin.etabf.annexure2;

import java.awt.Component;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.text.DecimalFormat;
import java.util.EventObject;

import javax.swing.AbstractCellEditor;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingConstants;
import javax.swing.table.TableCellEditor;

import com.tin.etbaf.rpu.Chk_LengthOnly;
import com.tin.etbaf.rpu.GRPU;
import com.tin.etbaf.rpu.GrpuUtil;
import com.tin.etbaf.validations.SecondaryValidations;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
public class GRPUTableCellEditorGrossTotalIncmRepaidPIfromSA extends AbstractCellEditor
implements TableCellEditor{

	 /**
	 * 
	 */
	private static final long serialVersionUID = 1L;
	JComponent component;
	    int rowTable;
	    int colTable;
	
	    public GRPUTableCellEditorGrossTotalIncmRepaidPIfromSA(){

	        component = new JTextField();
	        component.addFocusListener(new FocusListener() {
				
				@Override
				public void focusLost(FocusEvent arg0) {
					JButton eventOwner;
					if(arg0.getOppositeComponent() instanceof JButton)
					{
						eventOwner =  (JButton) arg0.getOppositeComponent();
						if("Create File".equalsIgnoreCase(eventOwner.getText().trim()) ){
							GRPU.grpu.isCreateFileFocusOut = true;
						}					
					}
					else{
						GRPU.grpu.isCreateFileFocusOut = false;
					}
				}
				
				@Override
				public void focusGained(FocusEvent arg0) {
					// TODO Auto-generated method stub
					
				}
			});
	        rowTable = 0;
	        colTable = 0;
	    
	    }
	
	@Override
	public Object getCellEditorValue() {
		DecimalFormatSymbols sf = new DecimalFormatSymbols(Locale.ENGLISH);DecimalFormat df = new DecimalFormat("0.00",sf);
		df.setMaximumFractionDigits(2);
		Object tds = ((JTextField) component).getText().toString();

		if (!((JTextField) component).getText().toString().equals("")) {

			if (((JTextField) component).getText().toString().trim().length() <= 15) {
				if (GrpuUtil.isDecimalNonZero(((JTextField) component)
						.getText().toString().trim(), 2)) {

					GRPU.grpu
							.getMessage("Gross total income from superannuation fund should be valid.For e.g. 1000.00");
					GRPU.grpu.setErrorAt(rowTable, colTable);

					return "0.00";
				}

				if (!tds.toString().contains(".")) {

					if (tds.equals("0")) {
						String tdamount = tds.toString() + ".000.00";
						((JTextField) component).setText(tdamount);

					} else {
						String tdamount = tds.toString() + ".00";
						((JTextField) component).setText(tdamount);
					}

					if (((JTextField) component).getText().toString().length() > 15) {
						GRPU.grpu
								.getMessage("Length of Gross total income from superannuation fund should not exceed 15 digits");

						GRPU.grpu.setErrorAt(rowTable, colTable);
						//newly added for FRD1.6 by akansha
	   		            GRPU.grpu.setGrossTotalSA("0.00", rowTable, colTable);
						return "0.00";
					} else {
						GRPU.grpu.setNoErrorAt(rowTable, colTable);

//						GRPU.grpu.setIncmChargblHeadSal(
//								((JTextField) component).getText().trim()
//										.toString(), rowTable, colTable);
//
//						// new development for FRD1.3 by Akansha
//						GRPU.grpu.setGrossTotalIncome(((JTextField) component)
//								.getText().trim().toString(), rowTable,
//								colTable);
//						GRPU.grpu.settotalTaxIncm(((JTextField) component)
//								.getText().trim().toString(), rowTable,
//								colTable);
						 //newly added for FRD1.6 by akansha
	   		             GRPU.grpu.setGrossTotalSA(((JTextField) component).getText()
									.trim() + "0", rowTable, colTable);
						return df.format(Double
								.parseDouble(((JTextField) component).getText()
										.trim() + "0"));
					}

				} else {
					GRPU.grpu.setNoErrorAt(rowTable, colTable);
//
//					GRPU.grpu.setIncmChargblHeadSal(((JTextField) component)
//							.getText().trim().toString(), rowTable, colTable);
//					// new development for FRD1.3 by Akansha
//					GRPU.grpu.setGrossTotalIncome(((JTextField) component)
//							.getText().trim().toString(), rowTable, colTable);
//					GRPU.grpu.settotalTaxIncm(((JTextField) component)
//							.getText().trim().toString(), rowTable, colTable);
					 //newly added for FRD1.6 by akansha
		               GRPU.grpu.setGrossTotalSA("0.00", rowTable, colTable);
					return df.format(Double
							.parseDouble(((JTextField) component).getText()
									.trim() + "0"));
				}

			}

			else {
				GRPU.grpu
						.getMessage("Length of Gross total income from superannuation fund should not exceed 15 digits");
				GRPU.grpu.setErrorAt(rowTable, colTable);
				return "0.00";

			}

		}

		else {
			// GRPU.grpu.getMessage("Total amount of salary can not be blank for record number "+(rowTable-1)+" in Annexure II details.");
			GRPU.grpu.setErrorAt(rowTable, colTable);
//
//			GRPU.grpu.setIncmChargblHeadSal("0.00", rowTable, colTable);
//			// new development for FRD1.3 by Akansha
//			GRPU.grpu.setGrossTotalIncome("0.00", rowTable, colTable);
//			GRPU.grpu.settotalTaxIncm("0.00", rowTable, colTable);
			return "0.00";

		}

	}

	@Override
	public Component getTableCellEditorComponent(JTable arg0, Object value,
			boolean arg2, int rowIndex, int vColIndex) {

        ((JTextField)component).setDocument(new Chk_LengthOnly(20));
        //Added newly on 09/07/2015 ---- R&D by Akansha
        new SecondaryValidations().numericValidation(component,"Gross total income from superannuation fund should be valid.For e.g. 1000.00");
        if(value == null)
            ((JTextField)component).setText("0.00");
        else
            ((JTextField)component).setText(String.valueOf(value));
        
        ((JTextField)component).setHorizontalAlignment(SwingConstants.RIGHT);
        rowTable = rowIndex;
        colTable = vColIndex;
        return component;
    
	}
	
	public boolean isCellEditable(EventObject evt) {
		if (evt instanceof MouseEvent) {
            int clickCount = 2;
            return ((MouseEvent)evt).getClickCount() >= clickCount;
		} else {
            return true;
        }
    
    }  

}
