package com.tin.etabf.annexure2;
import java.awt.Component;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.text.DecimalFormat;
import java.util.EventObject;

import javax.swing.*;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.text.JTextComponent;

import com.tin.etbaf.rpu.*;
// Referenced classes of package com.tin.etbaf.rpu:
//            Chk_LengthOnly, GRPU, GrpuUtil
import com.tin.etbaf.validations.SecondaryValidations;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
public class GRPUTableCellEditorSection80TTA_Qua extends AbstractCellEditor
    implements TableCellEditor
{

    JComponent component;
    int rowTable;
    int colTable;

    public GRPUTableCellEditorSection80TTA_Qua()
    {
        component = new JTextField();
 component.addFocusListener(new FocusListener() {
			
			@Override
			public void focusLost(FocusEvent arg0) {
				JButton eventOwner;
				if(arg0.getOppositeComponent() instanceof JButton)
				{
					eventOwner =  (JButton) arg0.getOppositeComponent();
					if("Create File".equalsIgnoreCase(eventOwner.getText().trim()) ){
						GRPU.grpu.isCreateFileFocusOut = true;
					}					
				}
				else{
					GRPU.grpu.isCreateFileFocusOut = false;
				}
			}
			
			@Override
			public void focusGained(FocusEvent arg0) {
				// TODO Auto-generated method stub
				
			}
		});
        rowTable = 0;
        colTable = 0;
    }

    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int rowIndex, int vColIndex)
    {
    	
        ((JTextField)component).setDocument(new Chk_LengthOnly(15));
        new SecondaryValidations().numericValidation(component,"80TTA - Amount of deduction should be valid.For e.g. 1000.00");
        if(value == null  || value.equals(""))
            ((JTextField)component).setText("0.00");
        else
            ((JTextField)component).setText(String.valueOf(value));
        
        ((JTextField)component).setHorizontalAlignment(SwingConstants.RIGHT);
        rowTable = rowIndex;
        colTable = vColIndex;
        return component;
    }

    
    

    public Object getCellEditorValue()
    {
       
    	       Object tds=((JTextField)component).getText().toString();
    	       DecimalFormatSymbols sf = new DecimalFormatSymbols(Locale.ENGLISH);DecimalFormat df = new DecimalFormat("0.00",sf);
    			df.setMaximumFractionDigits(2);
    	     
    	       
    	       if(!((JTextField)component).getText().toString().equals(""))
    	       {
    	    	   
    	    	if(((JTextField)component).getText().toString().trim().length() <= 15)
		        {  
    	    	   if(GrpuUtil.isDecimalNonZero(((JTextField)component).getText().toString().trim(),2))
   		            {
   		            
    	    		   	GRPU.grpu.getMessage("80TTA - Amount of deduction should be valid.For e.g. 1000.00");
   		            	GRPU.grpu.setErrorAt(rowTable, colTable);
   		            	
   		            	return "0.00";
   		            }
    	    	       
    	    	   
    	    	   if(!tds.toString().contains("."))
    	           {
    	    		 
    	    		   if(tds.equals("0"))
    	    		     {
    	    		    	 String tdamount=tds.toString()+".000.00";
    	    	    		 ((JTextField)component).setText(tdamount); 
    	    		    	 
    	    		     }
    	    		     else
    	    		     { 
    	    		    	 String tdamount=tds.toString()+".00";
    	    		         ((JTextField)component).setText(tdamount);
    	    		     }
    	    		 
    	              if(((JTextField)component).getText().toString().length()> 15)
    	              { GRPU.grpu.getMessage("80TTA - Amount of deduction should not exceed 15 digits");
     		            GRPU.grpu.setErrorAt(rowTable, colTable);
       		            return "0.00";
    	              }
    	              else
    	              {
    	            	GRPU.grpu.setNoErrorAt(rowTable, colTable);
   	                 //   System.out.println("setting total tax value");
   	                 //   System.out.println("value is bhai"+((JTextField)component).getText().trim().toString());
   	                    //System.out.println("in tds calling setTotalTaxDepvalue");
   	                   // GRPU.grpu.setTotalDeductionSec16value( ((JTextField)component).getText().trim().toString(),rowTable,colTable);
   	                   // GRPU.grpu.setGrossTotalIncome(((JTextField)component).getText().trim().toString(),rowTable,colTable);
   	                    GRPU.grpu.setTotalAmntDedChapVIA(((JTextField)component).getText().trim().toString(),rowTable,colTable);
   	                    GRPU.grpu.settotalTaxIncm(((JTextField)component).getText().trim().toString(),rowTable,colTable);
   	                    
   	                    return df.format(Double.parseDouble(((JTextField)component).getText().trim()+"0" ));  
    	              }
    	           
    	           }
    	           else
    	        	   {
    	        		   GRPU.grpu.setNoErrorAt(rowTable, colTable);
    	        		  // GRPU.grpu.setTotalDeductionSec16value(  ((JTextField)component).getText().trim().toString(),rowTable,colTable);
    	        		   //GRPU.grpu.setGrossTotalIncome(((JTextField)component).getText().trim().toString(),rowTable,colTable);
    	        		   GRPU.grpu.setTotalAmntDedChapVIA(((JTextField)component).getText().trim().toString(),rowTable,colTable);
    	        		   GRPU.grpu.settotalTaxIncm(((JTextField)component).getText().trim().toString(),rowTable,colTable);
    	        		   return df.format(Double.parseDouble(((JTextField)component).getText().trim()+"0" ));
    	        	   }
    	           
    	        }
    	      
    	    	else
    	    	{  GRPU.grpu.getMessage("Length of 80TTA - Amount of deduction should not exceed 15 digits");
		           GRPU.grpu.setErrorAt(rowTable, colTable);
		           return "0.00";
    	    		
    	    	}
    	       
    	       
    	       }
    	
    	       else
    	       {
    	    	 //  GRPU.grpu.getMessage("<html>Aggregate amount of deductions under sections 80C, 80CCC and 80CCD (1) (Total to be limited to amount specified in Section 80CCE) <br> can not be blank for record number " + (rowTable -1) + " in Annexure II details.</html>");
		           GRPU.grpu.setErrorAt(rowTable, colTable);
		          // GRPU.grpu.setTotalDeductionSec16value(((JTextField)component).getText().trim().toString(),rowTable,colTable);
		          // GRPU.grpu.setGrossTotalIncome(((JTextField)component).getText().trim().toString(),rowTable,colTable);
		           GRPU.grpu.setTotalAmntDedChapVIA("0.00",rowTable,colTable);
		           GRPU.grpu.settotalTaxIncm("0.00",rowTable,colTable);
		           return "0.00";
    	    	   
    	       } 
     // return ((JTextField)component).getText().trim() ;  --- by akansha
    }
    public boolean isCellEditable(EventObject evt)
    {
        if(evt instanceof MouseEvent)
        {
            int clickCount = 2;
            return ((MouseEvent)evt).getClickCount() >= clickCount;
        } else
        {
            return true;
        }
    
    }  
}
