package com.tin.etabf.filecreator;


import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;

import javax.swing.JFileChooser;
import javax.swing.table.DefaultTableModel;

import com.tin.etbaf.rpu.GRPU;
import com.tin.etbaf.rpu.GrpuUtil;
import com.tin.etbaf.validations.Validations;

public class CreateFile_consolidatedBackup {
	
	private GRPU rpu = null;
	DefaultTableModel model = null;
	DefaultTableModel model1 = null;
	DefaultTableModel model2 = null;
	
	
	private void  initialize(){
		
		rpu.retrievedFormValues();
		rpu.retrievedChallanValues();
		rpu.retrievedAnnIValues();
		if(rpu.formNumber.equalsIgnoreCase("24Q"))
				rpu.retrievedAnnIIValues(); // --- form = 24Q and Q4
		
		
	}
	
	
	
	
	
	public CreateFile_consolidatedBackup(GRPU rpu, DefaultTableModel passedModel,DefaultTableModel passedModel1,DefaultTableModel passedModel2) {
		// TODO Auto-generated constructor stub
		this.rpu = rpu;
		model = passedModel;
		model1 = passedModel1;
		model2 = passedModel2;
		initialize();
	}
	
	public boolean createRegular()
	{
		boolean retFlag = false;
		
		StringBuilder sb = new StringBuilder();
		
		// Saving Values in BEAN -- FH //
		
			FHBean fh = new FHBean();
//			DateTimeFormatter dtf = DateTimeFormatter.ofPattern("ddMMyyyy");
//	        LocalDateTime local =LocalDateTime.now();
//	        System.out.println(dtf.format(local));
//	        String CreationDate = dtf.format(local);
//	        System.out.println(dtf.format(local));
//	        fh.setCreationDate("Creation Date"+CreationDate);
			fh.setCreationDate(new SimpleDateFormat("ddMMyyyy",Locale.ENGLISH).format(new Date()));
			fh.setEmployerTAN(rpu.tan);
			fh.setFileType("SL1");
			fh.setUploadType("R");
			fh.setSequenceNum(GenerateSequence()); 
			fh.setUploaderType("D");
			fh.setNo_of_Batches("1");
			// fh.setRPU_Name("");  -- ask
		
		// FH creation ENDS
		
		sb.append(fh);
		sb.append("\n");
		
		//System.out.println("Only FH String : "+sb);
		
		// Saving Values in BEAN -- BH == Start //
		
			BHBean bh = new BHBean();
			
			bh.setLineNumber(CountOccurence(sb.toString()));
			bh.setRecordType("BH");
			bh.setBatchNumber("1");
			bh.setCountofChallantransfervoucherRecords(rpu.ChallanCount);
			bh.setFormNumber(rpu.formNumber);
			bh.setOriginalTokenNumberofthestatement(rpu.orgtoken);
			bh.setTokennoofpreviousregularstatement(rpu.prevtoken);
			bh.setTANofDeductorEmployer(rpu.tan);
			bh.setPANofDeductorEmployer(rpu.pan);
			bh.setAssessmentYr(rpu.assyear);
			bh.setFinancialYr(rpu.finyear);
			bh.setPeriod(rpu.quarter);
			bh.setNameofEmployerDeductor(rpu.dedname);
			bh.setEmployerDeductorBranchDivision(rpu.dedbranch);
			bh.setEmployerDeductorAddress1(rpu.flatno);
			bh.setEmployerDeductorAddress2(rpu.area);
			bh.setEmployerDeductorAddress3(rpu.road);
			bh.setEmployerDeductorAddress4(rpu.dedbldgname);
			bh.setEmployerDeductorAddress5(rpu.dedtown);
			bh.setEmployerDeductorState(rpu.dedstateone);
			bh.setEmployerDeductorPIN(rpu.dedpin);
			bh.setEmployerDeductorEmailID(rpu.dedemail);
				
			if(rpu.dedtel != null && rpu.dedtel.length() == 0)
			{
					bh.setEmployerDeductorSTDcode(rpu.dedtelstd);
					bh.setEmployerDeductorTelPhoneNo(rpu.dedtel);
			}
			
			bh.setChangeofAddressofemployerDeductorsincelastReturn(rpu.hasaddchanged);
			bh.setDeductorType(rpu.typeofDD);
			bh.setNameofPersonresponsibleforpayingsalaryDeduction(rpu.rpname);
			bh.setDesignationofthePersonresponsibleforpayingsalaryDeduction(rpu.rpdesig);
			bh.setResponsiblePersonAddress1(rpu.rpflatno);
			bh.setResponsiblePersonAddress2(rpu.rparea);
			bh.setResponsiblePersonAddress3(rpu.rproad);
			bh.setResponsiblePersonAddress4(rpu.rpbuldg);
			bh.setResponsiblePersonAddress5(rpu.rptown);
			bh.setResponsiblePersonState(rpu.rpstate);
			bh.setResponsiblePersonPIN(rpu.rppin);
			bh.setResponsiblePersonEmailID(rpu.rpemail);
			
			bh.setMobilenumber(rpu.rpmobile);
			bh.setResponsiblePersonSTDCode(rpu.rptelnumstd);
			bh.setResponsiblePersonTelPhoneNo(rpu.rptelnum);
			bh.setChangeofAddressofResponsiblepersonsincelastReturn(rpu.rpisaddresschng);
			
				//Code for setting total Deposit amount  --  start 
			
				int count = new Integer(rpu.ChallanCount)+1;
				Double BatchTotal = 0.00;
				for(int i=2;i<= count;i++)
				{
					if(model.getValueAt(i, 10) != null && !model.getValueAt(i, 10).toString().equalsIgnoreCase(""))
					{
					Double temp =Double.parseDouble(model.getValueAt(i, 10).toString());
					BatchTotal = BatchTotal+temp;
					}
				}
				
				
				
				//Code for setting total Deposit amount -- End 
				
			bh.setBatchTotalofTotalofDepositAmountasperChallan(BatchTotal.toString()+"0");
			
				//Code for Setting Total Salary cound from annexure 2 -- Start
					
				if(rpu.formNumber.equalsIgnoreCase("24Q") && rpu.quarter.equalsIgnoreCase("Q4"))
					{
					
						Integer SalaryCount = (new Integer(model2.getRowCount()-2));
						
						bh.setCountofSalaryDetailsRecords(SalaryCount.toString());
						
						SalaryCount= SalaryCount +1;
						Double SalaryTotal = 0.00;
						Double temp=0.0;
						
						for(int i=2;i<= SalaryCount;i++)
						{
							if(model2.getValueAt(i, 10) != null && !model2.getValueAt(i, 10).toString().equalsIgnoreCase(""))
							{
								temp=Double.parseDouble(model2.getValueAt(i, 10).toString());
							}
							else
							{
								temp=0.0;
							}
							
							SalaryTotal = SalaryTotal+temp;
						} 
					
					
					
						bh.setBatchTotalofGrossTotalIncomeasperSalaryDetail(SalaryTotal+"0");
					
					}
				
				//Code for Setting Total Salary cound from annexure 2 -- END
				
			bh.setAOApproval("N");
			bh.setWhetherregularstatementforForm24Qfiledforearlierperiod(rpu.rpisregstatement);
			bh.setLastDeductorType(rpu.lastDD);
			bh.setStateName(rpu.dedstatetwo);
			bh.setPAOCode(rpu.paocode);
			bh.setDDOCode(rpu.ddocode);
			bh.setMinistryName(rpu.dedminstrydept);
			bh.setMinistryNameOther(rpu.dedminstrydeptothers);
			bh.setTANRegistrationNumber(rpu.tanregnm);
			bh.setPAORegistrationNo(rpu.paoregnm);
			bh.setDDORegistrationNo(rpu.ddoregnm);
			bh.setEmployerDeductorSTDcode_alt(rpu.dedalttelstd);
			bh.setEmployerDeductorTelPhoneNo_alt(rpu.dedalttel);
			bh.setEmployerDeductorEmailID_alt(rpu.dedemailalt);
			bh.setResponsiblePersonSTDCode_alt(rpu.rptelnumaltstd);
			bh.setResponsiblePersonTelPhoneNo_alt(rpu.rptelnumalt);
			bh.setResponsiblePersonEmailID_alt(rpu.rpemailalt);
			
			if(rpu.typeofDD.equalsIgnoreCase("A") || rpu.typeofDD.equalsIgnoreCase("S") )
			{
				bh.setAccountOfficeIdentificationNumber(rpu.dedain);
			}
			/***************************************************************/
			//For FRD2.1, added by Sadhana, append new four fillers.
			bh.setGstn(rpu.gstn);
			/*bh.setFiller71(rpu.filler71);
			bh.setFiller72(rpu.filler72);
			bh.setFiller73(rpu.filler73);*/
			/***************************************************************/
			// Saving Values in BEAN -- BH == END //
		
			//System.out.println("Only BH String : "+bh.toString());
			
			sb.append(bh);
			sb.append("\n");
			
			//System.out.println("\n Combined FH -- BH String : "+sb);

		
			// Generating Challan Details -- CD == Start //
			
			int challancount = new Integer(rpu.ChallanCount)+1;
			CDBean cd =null;
			
			for(int i=2;i<= challancount;i++)
			{
				cd = new CDBean();
				
				cd.setLineNumber(CountOccurence(sb.toString()));
				cd.setRecordType("CD");
				cd.setBatchNumber("1");
				cd.setChallanDetailRecordNumber(new Integer(i-1).toString());
				
						// For obtaining Deductee detail record Number //
				
					Integer DeducteeCount = (new Integer(model1.getRowCount()-2));
					
					List<Integer> li = deducteeDetails(DeducteeCount,i-1);
					
						
					
						// END //
					
				//cd.setCountofDeducteePartyRecords(DeducteeCount.toString());
					cd.setCountofDeducteePartyRecords(new Integer(li.size()).toString());
				
				
					if(model.getValueAt(i, 18).toString().equalsIgnoreCase("yes"))
					{
						if(model.getValueAt(i, 17) != null && !model.getValueAt(i, 17).toString().equals(""))
						{
						cd.setChallanSerialNo(model.getValueAt(i, 17).toString()); // column 17 for each row
						}
					}
					else
					{
						if(model.getValueAt(i, 17) != null && !model.getValueAt(i, 17).toString().equals(""))
						{
						cd.setDDOSerialNo(model.getValueAt(i, 17).toString());
						}
					}
				
				
				if(model.getValueAt(i, 13) != null && !model.getValueAt(i, 13).toString().equals(""))
				{
					cd.setBankBranchCode(model.getValueAt(i, 13).toString());
				}
				
				if(model.getValueAt(i, 15) != null && !model.getValueAt(i, 15).toString().equals(""))
				{
					cd.setDateofBankChallanTransferVoucher(model.getValueAt(i, 15).toString());
				}
				
				
				if(!model.getValueAt(i,2).toString().contains("Select"))
				{
					cd.setSection(model.getValueAt(i, 2).toString());
				}
				
				
					// Validating NIL Challan on basis of other values // 
					
					String TDS_Income_Tax = model.getValueAt(i, 3).toString();
					String TDS_SurCharge = model.getValueAt(i, 4).toString();
					String TDS_CESS = model.getValueAt(i, 5).toString();
					String TDS_Interest = model.getValueAt(i, 6).toString();
					String TDS_Others = model.getValueAt(i, 8).toString();
					String TDS_Fees = model.getValueAt(i, 7).toString();
					
					if(TDS_Income_Tax.equalsIgnoreCase("") && TDS_SurCharge.equalsIgnoreCase("") && TDS_CESS.equalsIgnoreCase("") && TDS_Interest.equalsIgnoreCase("") && TDS_Others.equalsIgnoreCase("") && TDS_Fees.equalsIgnoreCase("") )
					{
						cd.setNILChallanIndicator("N");  
					}
					else
					{
						cd.setNILChallanIndicator("Y");  
					}
					
				
				cd.setOltasTDSTCSIncomeTax(TDS_Income_Tax);
				cd.setOltasTDSTCSSurcharge(TDS_SurCharge);
				cd.setOltasTDSTCSCess(TDS_CESS);	
				cd.setOltasTDSTCSInterestAmount(TDS_Interest);
				cd.setOltasTDSTCSOthers(TDS_Others);
				if(model.getValueAt(i, 10) != null && !model.getValueAt(i, 10).toString().equals(""))
				{
				cd.setTotal_DepositAmount_ChallanTransferVoucherNumber(model.getValueAt(i, 10).toString());
				}
				
						Double TotalTaxDeposited = 0.0;
						Double temp;
		
						for(Integer j:li)
						{
							if(model1.getValueAt(j, 23) != null && !model1.getValueAt(j, 23).toString().equalsIgnoreCase(""))
							{
								temp=Double.parseDouble(model1.getValueAt(j, 23).toString());
							}
							else
							{
								temp=0.0;
							}
							
							TotalTaxDeposited = TotalTaxDeposited+temp;
						} 	
						
				//cd.setTDSTCSIncomeTax("");	
				//cd.setTDSTCSCess("");
				//cd.setTDSTCSSurcharge("");
						
				cd.setTotalTaxDepositAmountasperdeducteeannexure(TotalTaxDeposited.toString());	
				cd.setTDSTCSInterestAmount(TDS_Interest);
				cd.setTDSTCSOthers(TDS_Others);
				
				if(!(model.getValueAt(i,11) == null) && !(model.getValueAt(i,11).toString().equalsIgnoreCase("")))
				{
					cd.setChequeDDNo(model.getValueAt(i,12 ).toString());
				}
				
				
				if(!model.getValueAt(i,18).toString().contains("Select"))
				{
					cd.setByBookentryCash(model.getValueAt(i,18).toString());
				}
				
				
				cd.setFee(TDS_Fees);
				
				if(!model.getValueAt(i,21).toString().contains("Select"))
					{
					cd.setMinorHeadChallan(model.getValueAt(i,21).toString()); 
					}
				
			//	System.out.println("Only CD Strings : "+cd.toString());
				
				sb.append(cd);
				sb.append("\n");
				
				// Start of DD Record for a particular CD // 
				
				for(Integer inneri:li)
				{
					
				
						DDBean dd ;
						
						Integer DDCount = new Integer(model1.getRowCount()-2);
						
						DDCount = DDCount + 1;
						
						
							dd  = new DDBean();
						
							dd.setLine_Number(CountOccurence(sb.toString()));
							dd.setRecordType("DD");
							dd.setBatchNumber("1");
							
							if(!(model1.getValueAt(i, 1).toString().contains("Select")))
							{
								
								dd.setChallan_DetailRecordNumber(model1.getValueAt(inneri, 1).toString());
								
							}
							
							if(model1.getValueAt(inneri, 11)!=null && model1.getValueAt(inneri, 11).toString().length() != 0)
							{
							
								dd.setDeducteePartyDetailRecordNo(model1.getValueAt(inneri, 11).toString());
							
							}
							
							dd.setMode("O");
								
								/*if(model1.getValueAt(i, 2).toString().equalsIgnoreCase("ADD"))
								{
									dd.setMode("A");
								}
								
								if(model1.getValueAt(i, 2).toString().equalsIgnoreCase("UPDATE"))
								{
									dd.setMode("U");
								}*/
							if(model1.getValueAt(inneri, 12)!=null && model1.getValueAt(inneri, 12).toString().length() != 0 && fh.getFileType().equalsIgnoreCase("24Q"))
							{	
								dd.setEmployeeSerialNo(model1.getValueAt(inneri, 12).toString());	
							}
							
							
							if(!fh.getFileType().equalsIgnoreCase("24Q") && model1.getValueAt(inneri, 27)!=null && model1.getValueAt(inneri, 27).toString().length() != 0  && !(model1.getValueAt(inneri, 26).toString().contains("Select")))
							{
								dd.setDeducteePartyCode(model1.getValueAt(inneri, 27).toString());
							}
							
						
							if(model1.getValueAt(inneri, 14)!=null && model1.getValueAt(inneri, 14).toString().length() != 0)
							{
								dd.setEmployeePartyPAN(model1.getValueAt(inneri, 14).toString());
							}
							
							if(model1.getValueAt(inneri, 15)!=null && model1.getValueAt(inneri, 15).toString().length() != 0)
							{
								dd.setNameofEmployeeParty(model1.getValueAt(inneri, 15).toString());
							}
							
							if(model1.getValueAt(inneri, 18)!=null && model1.getValueAt(inneri, 18).toString().length() != 0)
							{
								dd.setTDSTCS_IncomeTaxfortheperiod(model1.getValueAt(inneri, 18).toString());
							}
							
							
							if(model1.getValueAt(inneri, 19)!=null && model1.getValueAt(inneri, 19).toString().length() != 0)
							{
								dd.setTDSTCS_Surchargefortheperiod(model1.getValueAt(inneri, 19).toString());
							}
							
							if(model1.getValueAt(inneri, 20)!=null && model1.getValueAt(inneri, 20).toString().length() != 0)
							{
								dd.setTDSTCS_Cess(model1.getValueAt(inneri, 20).toString());
							}
							
							if(model1.getValueAt(inneri, 21)!=null && model1.getValueAt(inneri, 21).toString().length() != 0)
							{
								dd.setTotalIncomeTaxDeductedatSource(model1.getValueAt(inneri, 21).toString());
							}
							
							if(model1.getValueAt(inneri, 23)!=null && model1.getValueAt(inneri, 23).toString().length() != 0)
							{
								dd.setTotalTaxDeposited(model1.getValueAt(inneri, 23).toString());
							}
							
							if(model1.getValueAt(inneri, 25)!=null && model1.getValueAt(inneri, 25).toString().length() != 0)
							{
								dd.setDateonwhichtaxDeducted(model1.getValueAt(inneri, 25).toString());
							}
							
/*NA For 26Q*/				if(fh.getFileType().equalsIgnoreCase("24Q") && model1.getValueAt(inneri, 4)!=null && model1.getValueAt(inneri, 4).toString().length() != 0)
							{
								dd.setDateofDeposit(model1.getValueAt(inneri, 4).toString());
							}

/*NA For 24Q*/				if(!fh.getFileType().equalsIgnoreCase("24Q") && model1.getValueAt(inneri, 28)!=null && model1.getValueAt(inneri, 28).toString().length() != 0)
							{
								dd.setRateatwhichTaxDeductedCollected(model1.getValueAt(inneri, 28).toString());
							}

/*NA For 26Q or 24Q*/		if(fh.getFileType().equalsIgnoreCase("27Q") && model1.getValueAt(inneri, 35)!=null && model1.getValueAt(inneri, 35).toString().length() != 0 && !(model1.getValueAt(inneri, 35).toString().contains("Select")))
							{
								dd.setGrossingupIndicator(model1.getValueAt(inneri, 35).toString());
							}

/*NA For 24Q*/				if(!fh.getFileType().equalsIgnoreCase("24Q") && model1.getValueAt(inneri, 29)!=null && model1.getValueAt(inneri, 29).toString().length() != 0 && !(model1.getValueAt(inneri, 29).toString().contains("Select")))
							{
								dd.setBookEntryCashIndicator(model1.getValueAt(inneri, 29).toString());
							}
								
								if(!(model1.getValueAt(inneri, 26).toString().contains("Select")))
								{
									dd.setRemarks1(model1.getValueAt(inneri, 26).toString());
								}
								
							if(model1.getValueAt(inneri, 6)!=null && model1.getValueAt(inneri, 6).toString().length() != 0)
							{	
								dd.setSectionCodePaymentMade(model1.getValueAt(inneri, 6).toString());
							}
							
		/*For 24Q*/				if(fh.getFileType().equalsIgnoreCase("24Q") && model1.getValueAt(inneri, 27)!=null && model1.getValueAt(inneri, 27).toString().length() != 0)
								{
									dd.setCertificateNumberAssessingOfficer(model1.getValueAt(inneri, 27).toString());
									//System.out.println("My VALUE IS : "+ model1.getValueAt(inneri, 27).toString());
								}
								
		/*For 26Q*/				if(!fh.getFileType().equalsIgnoreCase("24Q") && model1.getValueAt(inneri, 30)!=null && model1.getValueAt(inneri, 30).toString().length() != 0)
								{
									dd.setCertificateNumberAssessingOfficer(model1.getValueAt(inneri, 30).toString());
									//System.out.println("My VALUE IS : "+ model1.getValueAt(inneri, 27).toString());
								}
		//RPU 3.1 starts
					if(fh.getFileType().equalsIgnoreCase("26Q") && model1.getValueAt(inneri, 31)!=null && model1.getValueAt(inneri, 31).toString().length() != 0)
		/*For 26Q*/			{
			dd.setAmtOfCshWdrawInExcessOfRs1CrS194N(model1.getValueAt(inneri, 31).toString());
			System.out.println("My VALUE IS : 31st col createfile_conso"+ model1.getValueAt(inneri, 31).toString());
		}
		
		
		/*For 27Q*/			if(fh.getFileType().equalsIgnoreCase("27Q") && model1.getValueAt(inneri, 31)!=null && model1.getValueAt(inneri, 31).toString().length() != 0)
							{
								dd.setWhetherTDSrateisTDS_ITactandDTAA(model1.getValueAt(inneri, 31).toString());
							}
		
		/*For 27Q*/			if(fh.getFileType().equalsIgnoreCase("27Q") && model1.getValueAt(inneri, 32)!=null && model1.getValueAt(inneri, 32).toString().length() != 0)
							{
								dd.setNatureOfRemittance(model1.getValueAt(inneri, 32).toString());
							}
		
		/*For 27Q*/			if(fh.getFileType().equalsIgnoreCase("27Q") && model1.getValueAt(inneri, 33)!=null && model1.getValueAt(inneri, 33).toString().length() != 0)
							{
								dd.setUniqueAcknowledgementOfForm15CA(model1.getValueAt(inneri, 33).toString());
							}
		
		/*For 27Q*/			if(fh.getFileType().equalsIgnoreCase("27Q") && model1.getValueAt(inneri, 34)!=null && model1.getValueAt(inneri, 34).toString().length() != 0 &&!(model1.getValueAt(inneri, 29).toString().contains("Select")))
							{
								dd.setCountryofDeductee(model1.getValueAt(inneri, 34).toString());
							}
													
							
							System.out.println("Only DD Strings : "+dd.toString());
							
							sb.append(dd);
							sb.append("\n");
							
				//End of DD Record for a particular CD.	
				}					
				
			}
			
			// Generating Challan Details -- CD == END //
		
		/*	System.out.println("Only CD Strings : "+cd);*/
			
			/*sb.append(cd);
			sb.append("\n");*/
			
			
														
														
														/*// Generating Deductee Details -- DD == Start //
														
														DDBean dd ;
														
														Integer DDCount = new Integer(model1.getRowCount()-2);
														
														DDCount = DDCount + 1;
														
														for(int i=2;i<= DDCount;i++)
														{
															dd  = new DDBean();
														
															dd.setLine_Number(CountOccurence(sb.toString()));
															dd.setRecordType("DD");
															dd.setBatchNumber("1");
															
															if(!(model1.getValueAt(i, 1).toString().contains("Select")))
															{
																
																dd.setChallan_DetailRecordNumber(model1.getValueAt(i, 1).toString());
																
															}
															
															dd.setDeducteePartyDetailRecordNo(model1.getValueAt(i, 11).toString());
															dd.setMode("O");
																
																		if(model1.getValueAt(i, 2).toString().equalsIgnoreCase("ADD"))
																{
																	dd.setMode("A");
																}
																
																if(model1.getValueAt(i, 2).toString().equalsIgnoreCase("UPDATE"))
																{
																	dd.setMode("U");
																}
																
															dd.setEmployeeSerialNo(model1.getValueAt(i, 12).toString());	
															dd.setEmployeePartyPAN(model1.getValueAt(i, 14).toString());
															dd.setNameofEmployeeParty(model1.getValueAt(i, 15).toString());
															dd.setTDSTCS_IncomeTaxfortheperiod(model1.getValueAt(i, 18).toString());
															dd.setTDSTCS_Surchargefortheperiod(model1.getValueAt(i, 19).toString());
															dd.setTDSTCS_Cess(model1.getValueAt(i, 20).toString());
															dd.setTotalIncomeTaxDeductedatSource(model1.getValueAt(i, 21).toString());
															
															dd.setTotalTaxDeposited(model1.getValueAt(i, 23).toString());
															dd.setDateonwhichtaxDeducted(model1.getValueAt(i, 25).toString());
															dd.setDateofDeposit(model1.getValueAt(i, 4).toString());
																
																if(!(model1.getValueAt(i, 26).toString().contains("Select")))
																{
																dd.setRemarks1(model1.getValueAt(i, 26).toString());
																}
																
															dd.setSectionCodePaymentMade(model1.getValueAt(i, 6).toString());
															
															if(model1.getValueAt(i, 27)!=null && model1.getValueAt(i, 27).toString().length() != 0)
															{
																dd.setCertificateNumberAssessingOfficer(model1.getValueAt(i, 27).toString());
																System.out.println("My VALUE IS : "+ model1.getValueAt(i, 27).toString());
															}
																
															
															System.out.println("Only DD Strings : "+dd.toString());
															
															sb.append(dd);
															sb.append("\n");
															
														}	
														
													
														// Generating Deductee Details -- DD == END //
														*/
			
			// Generating Salary Details -- SD == START //
			
			
			if(rpu.formNumber.equalsIgnoreCase("24Q") && rpu.quarter.equalsIgnoreCase("Q4"))
			{
				
				SDBean sd = null;
				
				Integer SalaryCount = (new Integer(model2.getRowCount()-2));

				SalaryCount= SalaryCount +1;
				
				

				
				for(int i=2;i<= SalaryCount;i++)
				{
					
					sd = new SDBean(); 
					
					
					int S16Count = 0; 
					
					int c6ACount = 0;
					
					
					
						sd.setLineNumber(CountOccurence(sb.toString()));
						sd.setRecordType("SD");
						sd.setBatchNumber("1");
					
					if(model2.getValueAt(i, 1) != null && model2.getValueAt(i, 1).toString().length() != 0)
					{
						sd.setSalaryDetailsRecordNo(model2.getValueAt(i, 1).toString());
					}
					
					if(model2.getValueAt(i, 2) != null && model2.getValueAt(i, 2).toString().length() != 0)
					{
						sd.setMode(model2.getValueAt(i, 2).toString());
					}
					
					if(model2.getValueAt(i, 3) != null && model2.getValueAt(i, 3).toString().length() != 0)
					{
						sd.setEmployeePAN(model2.getValueAt(i, 3).toString());
					}
					
					if(model2.getValueAt(i, 4) != null && model2.getValueAt(i, 4).toString().length() != 0)
					{
						sd.setNameofEmployee(model2.getValueAt(i, 4).toString());
					}
					
					if(model2.getValueAt(i, 5) != null && model2.getValueAt(i, 5).toString().length() != 0)
					{
						sd.setCategoryofEmployee(model2.getValueAt(i, 5).toString());
					}
					
					if(model2.getValueAt(i, 6) != null && model2.getValueAt(i, 6).toString().length() != 0)
					{
						sd.setPeriodofEmploymentFromDate(model2.getValueAt(i, 6).toString());
					}
					
					if(model2.getValueAt(i, 7) != null && model2.getValueAt(i, 7).toString().length() != 0)
					{
						sd.setPeriodofEmploymentToDate(model2.getValueAt(i, 7).toString());
					}
					
					if(model2.getValueAt(i, 10) != null && model2.getValueAt(i, 10).toString().length() != 0)
					{
						sd.setTotalamountofsalary(model2.getValueAt(i, 10).toString());
					}
					
					
					
						if(model2.getValueAt(i, 11) != null && model2.getValueAt(i, 11).toString().length() != 0)
						{
							
							
							S16Count++;
									
						}
						
						if(model2.getValueAt(i, 12) != null && model2.getValueAt(i, 12).toString().length() != 0)
						{
							S16Count++;
									
						}
					
						sd.setCountofSalaryDetailsSection16DetailRecordsassociatedwiththisDeductee(new Integer(S16Count).toString());
					
					if(model2.getValueAt(i, 13) != null && model2.getValueAt(i, 13).toString().length() != 0)
					{
						sd.setGrossTotalofTotalDeductionundersection16underassociatedSalaryDetailsSection16Detail(model2.getValueAt(i, 13).toString());
					}
					
					if(model2.getValueAt(i, 14) != null && model2.getValueAt(i, 14).toString().length() != 0)
					{
						sd.setIncomechargeableundertheheadSalaries(model2.getValueAt(i, 14).toString());
					}
					
					if(model2.getValueAt(i, 15) != null && model2.getValueAt(i, 15).toString().length() != 0)
					{
						sd.setIncomeUnderanyheadotherthanincomeundertheheadSalariesofferedforTDS(model2.getValueAt(i, 15).toString());
					}
					
					if(model2.getValueAt(i, 16) != null && model2.getValueAt(i, 16).toString().length() != 0)
					{
						sd.setGrossTotalIncome(model2.getValueAt(i, 16).toString());
					}
					
						if(model2.getValueAt(i, 17) != null && model2.getValueAt(i, 17).toString().length() != 0) 						{
							c6ACount++;
									
						}
						
						if(model2.getValueAt(i, 18) != null && model2.getValueAt(i, 18).toString().length() != 0)
						{
							c6ACount++;
									
						}
						
						if(model2.getValueAt(i, 19) != null && model2.getValueAt(i, 19).toString().length() != 0)
						{
							c6ACount++;
									
						}
						
						if((model2.getValueAt(i, 70) != null && model2.getValueAt(i, 70).toString().length() != 0) 
								|| (model2.getValueAt(i, 71) != null && model2.getValueAt(i, 71).toString().length() != 0) )

						{
							c6ACount++;
									
						}
						

						if((model2.getValueAt(i, 72) != null && model2.getValueAt(i, 72).toString().length() != 0) 
								|| (model2.getValueAt(i, 73) != null && model2.getValueAt(i, 73).toString().length() != 0) )

						{
							c6ACount++;
									
						}
						

						if((model2.getValueAt(i, 74) != null && model2.getValueAt(i, 74).toString().length() != 0) 
								|| (model2.getValueAt(i, 75) != null && model2.getValueAt(i, 75).toString().length() != 0) )								
						{
							c6ACount++;
									
						}
						

						if((model2.getValueAt(i, 76) != null && model2.getValueAt(i, 76).toString().length() != 0) 
								|| (model2.getValueAt(i, 77) != null && model2.getValueAt(i, 77).toString().length() != 0) )
						{
							c6ACount++;
									
						}
						
						if((model2.getValueAt(i, 78) != null && model2.getValueAt(i, 78).toString().length() != 0) 
								|| (model2.getValueAt(i, 79) != null && model2.getValueAt(i, 79).toString().length() != 0) )
						{
							c6ACount++;
									
						}
						if((model2.getValueAt(i, 80) != null && model2.getValueAt(i, 80).toString().length() != 0) 
								|| (model2.getValueAt(i, 81) != null && model2.getValueAt(i, 81).toString().length() != 0) )
						{
							c6ACount++;
									
						}
						if((model2.getValueAt(i, 82) != null && model2.getValueAt(i, 82).toString().length() != 0) 
								|| (model2.getValueAt(i, 83) != null && model2.getValueAt(i, 83).toString().length() != 0) )
						{
							c6ACount++;
									
						}

						if((model2.getValueAt(i, 84) != null && model2.getValueAt(i, 84).toString().length() != 0) 
								|| (model2.getValueAt(i, 85) != null && model2.getValueAt(i, 85).toString().length() != 0) 
								|| (model2.getValueAt(i, 86) != null && model2.getValueAt(i, 86).toString().length() != 0))
						{
							c6ACount++;
									
						}
						
						if((model2.getValueAt(i, 87) != null && model2.getValueAt(i, 87).toString().length() != 0) 
								|| (model2.getValueAt(i, 88) != null && model2.getValueAt(i, 88).toString().length() != 0) 
								|| (model2.getValueAt(i, 89) != null && model2.getValueAt(i, 89).toString().length() != 0))

						{
							c6ACount++;
									
						}
					
						sd.setCountofSalaryDetails_ChapterVIA_Detail(new Integer(c6ACount).toString());
						
					if(model2.getValueAt(i, 21) != null && model2.getValueAt(i, 21).toString().length() != 0)
					{
						sd.setGrossTotalofAmountdeductibleunderprovisionsofchapterVI_A(model2.getValueAt(i, 21).toString());
					}
					
					if(model2.getValueAt(i, 22) != null && model2.getValueAt(i, 22).toString().length() != 0)
					{
						sd.setTotalTaxableIncome(model2.getValueAt(i, 22).toString());
					}
					
					if(model2.getValueAt(i, 23) != null && model2.getValueAt(i, 23).toString().length() != 0)
					{
						sd.setIncomeTaxonTotalIncome(model2.getValueAt(i, 23).toString());
					}
					
					if(model2.getValueAt(i, 24) != null && model2.getValueAt(i, 24).toString().length() != 0)
					{
						sd.setSurcharge(model2.getValueAt(i, 24).toString());
					}
					
					if(model2.getValueAt(i, 25) != null && model2.getValueAt(i, 25).toString().length() != 0)
					{
						sd.setEducationCess(model2.getValueAt(i, 25).toString());
					}
					
					if(model2.getValueAt(i, 26) != null && model2.getValueAt(i, 26).toString().length() != 0)
					{
						sd.setIncomeTaxRelief(model2.getValueAt(i, 26).toString());
					}
					
					if(model2.getValueAt(i, 27) != null && model2.getValueAt(i, 27).toString().length() != 0)
					{
						sd.setNetIncomeTaxpayable(model2.getValueAt(i, 27).toString());
					}
					
					if(model2.getValueAt(i, 30) != null && model2.getValueAt(i, 30).toString().length() != 0)
					{
						sd.setTotalamountoftaxdeductedatsourceforthewholeyear(model2.getValueAt(i, 30).toString());
					}
					
					if(model2.getValueAt(i, 31) != null && model2.getValueAt(i, 31).toString().length()!= 0)
					{
						sd.setShortfallintaxdeductionExcesstaxdeduction(model2.getValueAt(i, 31).toString());
					}
					
					if(model2.getValueAt(i, 8) != null && model2.getValueAt(i, 8).toString().length() != 0)
					{
						sd.setTaxableAmountonwhichtaxisdeductedbythecurrentemployer(model2.getValueAt(i, 8).toString());
					}
					
					if(model2.getValueAt(i, 9) != null && model2.getValueAt(i, 9).toString().length() != 0)
					{
						sd.setReportedTaxableAmountonwhichtaxisdeductedbypreviousemployer(model2.getValueAt(i, 9).toString());
					}
					
					if(model2.getValueAt(i, 28) != null && model2.getValueAt(i, 28).toString().length() != 0)
					{
						sd.setTotalAmountoftaxdeductedatsourcebythecurrentemployerforthewholeyear(model2.getValueAt(i, 28).toString());
					}
					
					if(model2.getValueAt(i, 29) != null && model2.getValueAt(i, 29).toString().length() != 0)
					{
						sd.setReportedamountofTaxdeductedatsourcebypreviousemployer(model2.getValueAt(i, 29).toString());
					}
					
					
					if(model2.getValueAt(i, 32) != null && model2.getValueAt(i, 32).toString().contains("Select"))
					{
						sd.setWhethertaxdeductedatHigherrate("");
					}
					else
					{
						sd.setWhethertaxdeductedatHigherrate(model2.getValueAt(i, 32).toString());
					}
					
					
					sb.append(sd);
					
					sb.append("\n");
					
			//		System.out.println("HI c6ACount is "+c6ACount);
			//		System.out.println("HI S16Count is "+S16Count);
					
						for(int inneri = 1; inneri<=S16Count;inneri++)
						{
							
							S16Bean s16 = new S16Bean();
							
							s16.setLineNumber(CountOccurence(sb.toString()));
							s16.setRecordType("S16");
							s16.setBatchNumber("1");
							s16.setSalaryDetailRecordNo(sd.getSalaryDetailsRecordNo());
							s16.setSalaryDetailSection16DetailsRecordNo(new Integer(inneri).toString());
							
							if(inneri == 1)
							{
								s16.setSection16sectionID("16(ii)");
							}
							else
							if(inneri == 2)
							{
								s16.setSection16sectionID("16(iii)");
							}
							
							if(model2.getValueAt(i, 10+inneri) != null && model2.getValueAt(i, 10+inneri).toString().length() != 0)
							{
								s16.setTotalDeductionunderSection16(model2.getValueAt(i, 10+inneri).toString());
							}
							
							
							
							sb.append(s16);
							
							sb.append("\n");
							
						}
						
						for(int inneri = 1; inneri<=c6ACount;inneri++)
						{
							C6ABean c6A= new C6ABean();
							
							c6A.setLineNumber(CountOccurence(sb.toString()));
							c6A.setRecordType("C6A");
							c6A.setBatchNumber("1");
							c6A.setSalaryDetailRecordNo(sd.getSalaryDetailsRecordNo());
							c6A.setSalaryDetailChapterVIADetailsRecordNo(new Integer(inneri).toString());
							
							if(inneri == 1)
							{
								c6A.setChapterVIASectionID("80CCE");
							}
							else
								if(inneri == 2)
								{
									c6A.setChapterVIASectionID("80CCF");
								}
								else
									if(inneri == 3)
									{
										c6A.setChapterVIASectionID("80CCG");
									}
									else
										if(inneri == 4)
										{
											c6A.setChapterVIASectionID("80CCE");
										}
							if(model2.getValueAt(i, 16+inneri) != null && model2.getValueAt(i, 16+inneri).toString().length() != 0)
							{
								//c6A.setTotalamountunderChapterVIA(model2.getValueAt(i, 16+inneri).toString());
							}
							
							sb.append(c6A);
							
							sb.append("\n");
						}
					
					
					
					
				}
				
			}
			
			// Generating Salary Details -- SD == END //
		
		Validations v = new Validations();
		showSaveFileDialog(sb);
		
		//System.out.println("Occurence is"+CountOccurence(sb.toString()));
		
		
		
		
		
		return retFlag;
	}
	
	
	
	public Boolean showSaveFileDialog(StringBuilder details) {
		Boolean status =  false;
		JFileChooser fileChooser = new JFileChooser();
		fileChooser.setDialogTitle("Specify a file to save");

		int userSelection = fileChooser.showSaveDialog(null);
		try {
			if (userSelection == JFileChooser.APPROVE_OPTION) {
				File fileToSave = fileChooser.getSelectedFile();
//				System.out.println("Save as file: "
//						+ fileToSave.getAbsolutePath());
				writeFile(fileToSave.getAbsolutePath() + "", details.toString());
				
				status =  true;

			}
		} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
			status =  false;
			
		}
		return false;
	}

	public static void writeFile(String canonicalFilename, String text)
			throws IOException {
		File file = new File(canonicalFilename);
		BufferedWriter out = new BufferedWriter(new FileWriter(file));
		out.write(text);
		out.close();
	}
	
	public String CountOccurence(String str)
	{
		int count=0;
		String findStr = "\n";
		int lastIndex = 0;
		

		while(lastIndex != -1){

		       lastIndex = str.indexOf(findStr,lastIndex);

		       if( lastIndex != -1){
		             count ++;
		             lastIndex+=findStr.length();
		      }
		}
		
		count = count+1;  // added to make it next line 
		
		return (new Integer(count).toString());
	}
	
	
	public String GenerateSequence()
	{
//		DateTimeFormatter dtf = DateTimeFormatter.ofPattern("ddMMyyyyHHmmss");
//        LocalDateTime local =LocalDateTime.now();
//       
//        String sequence = dtf.format(local);
       
        
		String sequence = new SimpleDateFormat("ddMMyyyyHHmmss",Locale.ENGLISH).format(new Date()).toString();
		System.out.println("Sequence"+ sequence);
		return sequence;
	}
	
	
	public ArrayList deducteeDetails(int deducteecount, Integer position)
	{
		ArrayList<Integer> li = new ArrayList();
		deducteecount++;
		
		for(int i=2;i<=deducteecount;i++)
		{
			if(model1.getValueAt(i, 1) != null && !(model1.getValueAt(i, 1).toString().equals("")))
			{
				if(model1.getValueAt(i, 1).toString().equals(position.toString()))
				{
					li.add(i);
				}
			}
		}
		
		
		return li;
		
	}

}
