package com.tin.etbaf.annexure1;

import java.awt.Component;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.EventObject;
import java.util.Locale;

import javax.swing.AbstractCellEditor;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingConstants;
import javax.swing.table.TableCellEditor;

import com.tin.etbaf.rpu.Chk_LengthOnly;
import com.tin.etbaf.rpu.GRPU;
import com.tin.etbaf.rpu.GrpuUtil;
import com.tin.etbaf.validations.SecondaryValidations;

//New Column class created by Khalid Khan

public class GRPUTableCellEditorAmtCshWdrawRs20lkhSbcleThrdProvsnSec194N_419E extends AbstractCellEditor
implements TableCellEditor {
	
	//rahul CR84532 26Q Column Addition 419E
	
	JComponent component;
    int rowTable;
    int colTable;
    String valueOfTypeOfStmt;
    public GRPUTableCellEditorAmtCshWdrawRs20lkhSbcleThrdProvsnSec194N_419E()
    {
		component = new JTextField();
		component.addFocusListener(new FocusListener() {

			@Override
			public void focusLost(FocusEvent arg0) {
				JButton eventOwner;
				if (arg0.getOppositeComponent() instanceof JButton) {
					eventOwner = (JButton) arg0.getOppositeComponent();
					if ("Create File".equalsIgnoreCase(eventOwner.getText()
							.trim())) {
						GRPU.grpu.isCreateFileFocusOut = true;
					}
				} else {
					GRPU.grpu.isCreateFileFocusOut = false;
				}
			}

			@Override
			public void focusGained(FocusEvent arg0) {
				// TODO Auto-generated method stub

			}
		});
		rowTable = 0;
		colTable = 0;
	}
    

    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int rowIndex, int vColIndex)
    {
        ((JTextField)component).setDocument(new Chk_LengthOnly(15));
        new SecondaryValidations().numericValidation(component,"<html>Amount of cash withdrawal which is in excess of Rs. 20 lakh but does not exceed Rs. 3 crore for cases covered by sub-clause (a) of clause (ii) <br>of first proviso read with third proviso to section 194N (in case of co-operative societies) should be valid.For e.g. 1000.00</html>");
        //System.out.println("is in?"+value.toString().length()+" check length "+value);
        if(value == null)
            ((JTextField)component).setText("0.00");
        else
            ((JTextField)component).setText((String)value);
        
        ((JTextField)component).setHorizontalAlignment(SwingConstants.RIGHT);
        rowTable = rowIndex;
        colTable = vColIndex;
         
        return component;
    }

    public Object getCellEditorValue()
    {
    	DecimalFormatSymbols sf = new DecimalFormatSymbols(Locale.ENGLISH);
    	DecimalFormat df = new DecimalFormat("0.00",sf);
		df.setMaximumFractionDigits(2);
	       Object tds=((JTextField)component).getText().toString();
	       System.out.println("class"+tds.toString());
	       if(!((JTextField)component).getText().toString().equals(""))
	       {
	    	   
	    	if(((JTextField)component).getText().toString().trim().length() < 16)
	        {  
	    	   if(GrpuUtil.isDecimalNonZero(((JTextField)component).getText().toString().trim(),2))
	            {
	            
	    		   	GRPU.grpu.getMessage("<html>Amount of cash withdrawal which is in excess of Rs. 20 lakh but does not exceed Rs. 3 crore for cases covered by sub-clause (a) of clause (ii) <br>of first proviso read with third proviso to section 194N (in case of co-operative societies) should be valid.For e.g. 1000.00</html>");
	            	GRPU.grpu.setErrorAt(rowTable, colTable);
	            	
	            	return "0.00";
	            }
	    	       
	    	   
	    	   
	    	   if(!tds.toString().contains("."))
	           {
	    		 
	    		   if(tds.equals("0"))
	    		     {
	    		    	 String amount=tds.toString()+".000.00";
	    	    		 ((JTextField)component).setText(amount); 
	    		    	 
	    		     }
	    		     else
	    		     { //appends .00 in the end
	    		    	// String tdamount=tds.toString()+".00";
	    		    	 String amount=tds.toString()+".00";
	    		         ((JTextField)component).setText(amount);
	    		     }
	    		   
	              if(((JTextField)component).getText().toString().length()> 15)
	              { GRPU.grpu.getMessage("<html>Amount of cash withdrawal which is in excess of Rs. 20 lakh but does not exceed Rs. 3 crore for cases covered by sub-clause (a) of clause (ii) <br>of first proviso read with third proviso to section 194N (in case of co-operative societies) should not exceed 15 digits</html>");
		            GRPU.grpu.setErrorAt(rowTable, colTable);
		            return "0.00";
	              }
	              else
	              {
	            	GRPU.grpu.setNoErrorAt(rowTable, colTable);
                  // System.out.println("setting Amount of cash withdrawal which is in excess of Rs. 1 crore for cases covered by sub-clause (b) of clause (ii) of first provision to section 194N");
                  // System.out.println("value is in setting total amount sub clause b"+((JTextField)component).getText().trim().toString());
                   
             //       GRPU.grpu.setAmtOfCshWdrawInExcessOfRs20lkhSbclause_b_194N( ((JTextField)component).getText().trim().toString(),rowTable,colTable);
                    //return (((JTextField)component).getText().trim() );  //RPU 3.5 Bug fix
  	              
                    return df.format(Double.parseDouble(((JTextField)component).getText().trim()+"0" ));  
	              }
	           
	           }
	           else
	        	   {
	        		   GRPU.grpu.setNoErrorAt(rowTable, colTable);
	        		 
	        	//	   GRPU.grpu.setAmtOfCshWdrawInExcessOfRs20lkhSbclause_b_194N(  ((JTextField)component).getText().trim().toString(),rowTable,colTable);
	        		   return df.format(Double.parseDouble(((JTextField)component).getText().trim() +"0"));  //RPU 3.5 Bug fix
		 	              
	        		  
	        	   }
	           
	        }
	      
	    	else
	    	{  GRPU.grpu.getMessage(" Length of Tax Amount should not exceed 15 digits");
	           GRPU.grpu.setErrorAt(rowTable, colTable);
	           return "0.00";
	    		
	    	}
	       
	       
	       }
	
	       else
	       {
	    	 //  GRPU.grpu.getMessage(" Tax Amount should be valid.For e.g. 1000.00");
	           GRPU.grpu.setErrorAt(rowTable, colTable);
	        //   GRPU.grpu.setAmtOfCshWdrawInExcessOfRs20lkhSbclause_b_194N( "0.00",rowTable,colTable);
	           return "0.00";
	    	   
	       }
    }

    public boolean isCellEditable(EventObject evt)
    {
        if(evt instanceof MouseEvent)
        {
            int clickCount = 2;
            return ((MouseEvent)evt).getClickCount() >= clickCount;
        } else
        {
            return true;
        }
    }
}
