package com.tin.etbaf.annexure1;

import java.awt.Component;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.util.EventObject;
import javax.swing.*;
import javax.swing.table.TableCellEditor;
import javax.swing.text.JTextComponent;

import com.tin.etbaf.rpu.Chk_LengthOnly;
import com.tin.etbaf.rpu.GRPU;
import com.tin.etbaf.rpu.GrpuUtil;

// Referenced classes of package com.tin.etbaf.rpu:
//            Chk_LengthOnly, GRPU

public class GRPUTableCellEditorCertNum extends AbstractCellEditor implements
		TableCellEditor {

	JComponent component;
	int rowTable;
	int colTable;

	public GRPUTableCellEditorCertNum() {
		component = new JTextField();
		component.addFocusListener(new FocusListener() {

			@Override
			public void focusLost(FocusEvent arg0) {
				JButton eventOwner;
				if (arg0.getOppositeComponent() instanceof JButton) {
					eventOwner = (JButton) arg0.getOppositeComponent();
					if ("Create File".equalsIgnoreCase(eventOwner.getText()
							.trim())) {
						GRPU.grpu.isCreateFileFocusOut = true;
					}
				} else {
					GRPU.grpu.isCreateFileFocusOut = false;
				}
			}

			@Override
			public void focusGained(FocusEvent arg0) {
				// TODO Auto-generated method stub

			}
		});
		rowTable = 0;
		colTable = 0;
	}

	public Component getTableCellEditorComponent(JTable table, Object value,
			boolean isSelected, int rowIndex, int vColIndex) {
		((JTextField) component).setDocument(new Chk_LengthOnly(10));
		if (value == null)
			((JTextField) component).setText("");
		else
			((JTextField) component).setText((String) value);
		System.out.println("Get table component value " + value );
		rowTable = rowIndex;
		colTable = vColIndex;
		return component;
	}

	public Object getCellEditorValue() {
		Object value = ((JTextField) component).getText();

		if (value != null) {

			if (((JTextField) component).getText().toString().trim().length() == 10) {
				if (!GrpuUtil.iscaret(value.toString())) {
					String message = "Certificate Number issued should not contain ^";
					GRPU.grpu.getMessage(message);
					GRPU.grpu.setErrorAt(rowTable, colTable);
					return "";

				} else if (!GrpuUtil.checkOneAlpah(value.toString())) {
					String message = "Special Characters not Allowed in Certificate Number";
					GRPU.grpu.getMessage(message);
					GRPU.grpu.setErrorAt(rowTable, colTable);
					return "";

				} else {
					GRPU.grpu.setNoErrorAt(rowTable, colTable);
					return ((JTextField) component).getText().toUpperCase();
				}

			} else {
				GRPU.grpu
						.getMessage("Length of the Certificate Number must be 10 digits");
				GRPU.grpu.setErrorAt(rowTable, colTable);
				return "";
			}

		}

		else {
			GRPU.grpu.setNoErrorAt(rowTable, colTable);
			return "";
		}

	}

	public boolean isCellEditable(EventObject evt) {
		if (evt instanceof MouseEvent) {
			int clickCount = 2;
			return ((MouseEvent) evt).getClickCount() >= clickCount;
		} else {
			return true;
		}
	}
}
