package com.tin.etbaf.annexure1;

import java.awt.Component;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.util.EventObject;
import javax.swing.*;
import javax.swing.table.TableCellEditor;
import javax.swing.text.JTextComponent;

import com.tin.etbaf.rpu.Chk_LengthOnly;
import com.tin.etbaf.rpu.GRPU;
import com.tin.etbaf.rpu.GrpuUtil;

// Referenced classes of package com.tin.etbaf.rpu:
//            Chk_LengthOnly, GRPU

public class GRPUTableCellEditorPAN extends AbstractCellEditor
    implements TableCellEditor
{

    JComponent component;
    int rowTable;
    int colTable;

    public GRPUTableCellEditorPAN() //13
    {
        component = new JTextField();
        component.addFocusListener(new FocusListener() {
			
			@Override
			public void focusLost(FocusEvent arg0) {
				JButton eventOwner;
				if(arg0.getOppositeComponent() instanceof JButton)
				{
					eventOwner =  (JButton) arg0.getOppositeComponent();
					if("Create File".equalsIgnoreCase(eventOwner.getText().trim()) ){
						GRPU.grpu.isCreateFileFocusOut = true;
					}					
				}
				else{
					GRPU.grpu.isCreateFileFocusOut = false;
				}
			}
			
			@Override
			public void focusGained(FocusEvent arg0) {
				// TODO Auto-generated method stub
				
			}
		});
        rowTable = 0;
        colTable = 0;
    }

    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int rowIndex, int vColIndex)
    {
    	
        ((JTextField)component).setDocument(new Chk_LengthOnly(10)); // Modified by Akansha
        if(value == null)
            ((JTextField)component).setText("");
        else
            ((JTextField)component).setText((String)value);
        rowTable = rowIndex;
        colTable = vColIndex;
        return component;
    }

    public Object getCellEditorValue()
    {
    	
    	
    	 Object value = ((JTextField)component).getText();
         
     	
         if(value != null)
         {
        	//rahul CR84532 26Q Section Code Addition 194BA-P  4AP start
        	 if("PANINVALID".equals(value.toString()) || "PANNOTAVBL".equals(value.toString())
        			 || "PANAPPLIED".equals(value.toString()))
        	 {
        		 if(GrpuUtil.checkPanDedNoValues_PANAPPLIED(value.toString(),rowTable,colTable))
                 {
                 	String message = "Invalid Pan of the Employee";
                 	GRPU.grpu.getMessage(message);
                 	GRPU.grpu.setErrorAt(rowTable, colTable);
                     return "";
                 	
                 }
                 
             	else
             	{    GRPU.grpu.setNoErrorAt(rowTable, colTable);
             		GRPU.grpu.panCheckValidDedCode(((JTextField)component).getText().trim().toString(),rowTable,colTable);
             		return ((JTextField)component).getText().toUpperCase();	
             	}	
        	 }
        	//rahul CR84532 26Q Section Code Addition 194BA-P  4AP end
        	 
        
        	 
        	 else 
        		
				if(GrpuUtil.checkPan(value.toString()))
             {
             	String message = "Invalid Pan of the Employee";
             	GRPU.grpu.getMessage(message);
             	GRPU.grpu.setErrorAt(rowTable, colTable);
                 return "";
             	
             }
             
         	else
         	{    GRPU.grpu.setNoErrorAt(rowTable, colTable);
         		GRPU.grpu.panCheckValidDedCode(((JTextField)component).getText().trim().toString(),rowTable,colTable);
         		return ((JTextField)component).getText().toUpperCase();	
         	}	
         		
         	
         }
         
         
         else
         {
        	 GRPU.grpu.setNoErrorAt(rowTable, colTable);
        	 return "";
         }
    }

    public boolean isCellEditable(EventObject evt)
    {
        if(evt instanceof MouseEvent)
        {
            int clickCount = 2;
            return ((MouseEvent)evt).getClickCount() >= clickCount;
        } else
        {
            return true;
        }
    }

	
	
}

